/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.BreakableService;
import org.apache.hadoop.service.BreakableStateChangeListener;
import org.apache.hadoop.service.LoggingStateChangeListener;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceAssert;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.apache.hadoop.service.ServiceStateException;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServiceLifecycle
extends ServiceAssert {
    private static final Logger LOG = LoggerFactory.getLogger(TestServiceLifecycle.class);

    @Test
    public void testWalkthrough() throws Throwable {
        BreakableService svc = new BreakableService();
        TestServiceLifecycle.assertServiceStateCreated((Service)svc);
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.NOTINITED, 1);
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.INITED, 0);
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.STARTED, 0);
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.STOPPED, 0);
        svc.init(new Configuration());
        TestServiceLifecycle.assertServiceStateInited((Service)svc);
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.INITED, 1);
        svc.start();
        TestServiceLifecycle.assertServiceStateStarted((Service)svc);
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.STARTED, 1);
        svc.stop();
        TestServiceLifecycle.assertServiceStateStopped((Service)svc);
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.STOPPED, 1);
    }

    @Test
    public void testInitTwice() throws Throwable {
        BreakableService svc = new BreakableService();
        Configuration conf = new Configuration();
        conf.set("test.init", "t");
        svc.init(conf);
        svc.init(new Configuration());
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.INITED, 1);
        TestServiceLifecycle.assertServiceConfigurationContains((Service)svc, "test.init");
    }

    @Test
    public void testStartTwice() throws Throwable {
        BreakableService svc = new BreakableService();
        svc.init(new Configuration());
        svc.start();
        svc.start();
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.STARTED, 1);
    }

    @Test
    public void testStopTwice() throws Throwable {
        BreakableService svc = new BreakableService();
        svc.init(new Configuration());
        svc.start();
        svc.stop();
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.STOPPED, 1);
        svc.stop();
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.STOPPED, 1);
    }

    @Test
    public void testStopFailedInit() throws Throwable {
        BreakableService svc = new BreakableService(true, false, false);
        TestServiceLifecycle.assertServiceStateCreated((Service)svc);
        try {
            svc.init(new Configuration());
            TestServiceLifecycle.fail((String)("Expected a failure, got " + (Object)((Object)svc)));
        }
        catch (BreakableService.BrokenLifecycleEvent brokenLifecycleEvent) {
            // empty catch block
        }
        TestServiceLifecycle.assertServiceStateStopped((Service)svc);
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.INITED, 1);
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.STOPPED, 1);
        svc.stop();
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.STOPPED, 1);
    }

    @Test
    public void testStopFailedStart() throws Throwable {
        BreakableService svc = new BreakableService(false, true, false);
        svc.init(new Configuration());
        TestServiceLifecycle.assertServiceStateInited((Service)svc);
        try {
            svc.start();
            TestServiceLifecycle.fail((String)("Expected a failure, got " + (Object)((Object)svc)));
        }
        catch (BreakableService.BrokenLifecycleEvent brokenLifecycleEvent) {
            // empty catch block
        }
        TestServiceLifecycle.assertServiceStateStopped((Service)svc);
    }

    @Test
    public void testFailingStop() throws Throwable {
        BreakableService svc = new BreakableService(false, false, true);
        svc.init(new Configuration());
        svc.start();
        try {
            svc.stop();
            TestServiceLifecycle.fail((String)("Expected a failure, got " + (Object)((Object)svc)));
        }
        catch (BreakableService.BrokenLifecycleEvent brokenLifecycleEvent) {
            // empty catch block
        }
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.STOPPED, 1);
    }

    @Test
    public void testStopUnstarted() throws Throwable {
        BreakableService svc = new BreakableService();
        svc.stop();
        TestServiceLifecycle.assertServiceStateStopped((Service)svc);
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.INITED, 0);
        TestServiceLifecycle.assertStateCount(svc, Service.STATE.STOPPED, 1);
    }

    @Test
    public void testStopFailingInitAndStop() throws Throwable {
        BreakableService svc = new BreakableService(true, false, true);
        svc.registerServiceListener((ServiceStateChangeListener)new LoggingStateChangeListener());
        try {
            svc.init(new Configuration());
            TestServiceLifecycle.fail((String)("Expected a failure, got " + (Object)((Object)svc)));
        }
        catch (BreakableService.BrokenLifecycleEvent e) {
            TestServiceLifecycle.assertEquals((Object)Service.STATE.INITED, (Object)e.state);
        }
        TestServiceLifecycle.assertServiceStateStopped((Service)svc);
        TestServiceLifecycle.assertEquals((Object)Service.STATE.INITED, (Object)svc.getFailureState());
        Throwable failureCause = svc.getFailureCause();
        TestServiceLifecycle.assertNotNull((String)("Null failure cause in " + (Object)((Object)svc)), (Object)failureCause);
        BreakableService.BrokenLifecycleEvent cause = (BreakableService.BrokenLifecycleEvent)failureCause;
        TestServiceLifecycle.assertNotNull((String)("null state in " + cause + " raised by " + (Object)((Object)svc)), (Object)cause.state);
        TestServiceLifecycle.assertEquals((Object)Service.STATE.INITED, (Object)cause.state);
    }

    @Test
    public void testInitNullConf() throws Throwable {
        BreakableService svc = new BreakableService(false, false, false);
        try {
            svc.init(null);
            LOG.warn("Null Configurations are permitted ");
        }
        catch (ServiceStateException serviceStateException) {
            // empty catch block
        }
    }

    @Test
    public void testServiceNotifications() throws Throwable {
        BreakableService svc = new BreakableService(false, false, false);
        BreakableStateChangeListener listener = new BreakableStateChangeListener();
        svc.registerServiceListener(listener);
        svc.init(new Configuration());
        this.assertEventCount(listener, 1);
        svc.start();
        this.assertEventCount(listener, 2);
        svc.stop();
        this.assertEventCount(listener, 3);
        svc.stop();
        this.assertEventCount(listener, 3);
    }

    @Test
    public void testServiceNotificationsStopOnceUnregistered() throws Throwable {
        BreakableService svc = new BreakableService(false, false, false);
        BreakableStateChangeListener listener = new BreakableStateChangeListener();
        svc.registerServiceListener(listener);
        svc.init(new Configuration());
        this.assertEventCount(listener, 1);
        svc.unregisterServiceListener(listener);
        svc.start();
        this.assertEventCount(listener, 1);
        svc.stop();
        this.assertEventCount(listener, 1);
        svc.stop();
    }

    @Test
    public void testServiceNotificationsUnregisterDuringCallback() throws Throwable {
        BreakableService svc = new BreakableService(false, false, false);
        SelfUnregisteringBreakableStateChangeListener listener = new SelfUnregisteringBreakableStateChangeListener();
        BreakableStateChangeListener l2 = new BreakableStateChangeListener();
        svc.registerServiceListener(listener);
        svc.registerServiceListener(l2);
        svc.init(new Configuration());
        this.assertEventCount(listener, 1);
        this.assertEventCount(l2, 1);
        svc.unregisterServiceListener(listener);
        svc.start();
        this.assertEventCount(listener, 1);
        this.assertEventCount(l2, 2);
        svc.stop();
        this.assertEventCount(listener, 1);
        svc.stop();
    }

    private void assertEventCount(BreakableStateChangeListener listener, int expected) {
        TestServiceLifecycle.assertEquals((String)listener.toString(), (long)expected, (long)listener.getEventCount());
    }

    @Test
    public void testServiceFailingNotifications() throws Throwable {
        BreakableService svc = new BreakableService(false, false, false);
        BreakableStateChangeListener listener = new BreakableStateChangeListener();
        listener.setFailingState(Service.STATE.STARTED);
        svc.registerServiceListener(listener);
        svc.init(new Configuration());
        this.assertEventCount(listener, 1);
        svc.start();
        this.assertEventCount(listener, 2);
        TestServiceLifecycle.assertEquals((long)1L, (long)listener.getFailureCount());
        svc.stop();
        this.assertEventCount(listener, 3);
        TestServiceLifecycle.assertEquals((long)1L, (long)listener.getFailureCount());
        svc.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListenerWithNotifications() throws Throwable {
        AsyncSelfTerminatingService service = new AsyncSelfTerminatingService(2000);
        NotifyingListener listener = new NotifyingListener();
        service.registerServiceListener(listener);
        service.init(new Configuration());
        service.start();
        TestServiceLifecycle.assertServiceInState((Service)service, Service.STATE.STARTED);
        long start = System.currentTimeMillis();
        NotifyingListener notifyingListener = listener;
        synchronized (notifyingListener) {
            listener.wait(20000L);
        }
        long duration = System.currentTimeMillis() - start;
        TestServiceLifecycle.assertEquals((Object)Service.STATE.STOPPED, (Object)listener.notifyingState);
        TestServiceLifecycle.assertServiceInState((Service)service, Service.STATE.STOPPED);
        TestServiceLifecycle.assertTrue((String)("Duration of " + duration + " too long"), (duration < 10000L ? 1 : 0) != 0);
    }

    @Test
    public void testSelfTerminatingService() throws Throwable {
        SelfTerminatingService service = new SelfTerminatingService();
        BreakableStateChangeListener listener = new BreakableStateChangeListener();
        service.registerServiceListener(listener);
        service.init(new Configuration());
        this.assertEventCount(listener, 1);
        service.start();
        this.assertEventCount(listener, 2);
    }

    @Test
    public void testStartInInitService() throws Throwable {
        StartInInitService service = new StartInInitService();
        BreakableStateChangeListener listener = new BreakableStateChangeListener();
        service.registerServiceListener(listener);
        service.init(new Configuration());
        TestServiceLifecycle.assertServiceInState((Service)service, Service.STATE.STARTED);
        this.assertEventCount(listener, 1);
    }

    @Test
    public void testStopInInitService() throws Throwable {
        StopInInitService service = new StopInInitService();
        BreakableStateChangeListener listener = new BreakableStateChangeListener();
        service.registerServiceListener(listener);
        service.init(new Configuration());
        TestServiceLifecycle.assertServiceInState((Service)service, Service.STATE.STOPPED);
        this.assertEventCount(listener, 1);
    }

    private static class StopInInitService
    extends AbstractService {
        private StopInInitService() {
            super("StopInInitService");
        }

        protected void serviceInit(Configuration conf) throws Exception {
            super.serviceInit(conf);
            this.stop();
        }
    }

    private static class StartInInitService
    extends AbstractService {
        private StartInInitService() {
            super("StartInInitService");
        }

        protected void serviceInit(Configuration conf) throws Exception {
            super.serviceInit(conf);
            this.start();
        }
    }

    private static class SelfTerminatingService
    extends AbstractService {
        private SelfTerminatingService() {
            super("SelfTerminatingService");
        }

        protected void serviceStart() throws Exception {
            super.serviceStart();
            this.stop();
        }
    }

    private static class AsyncSelfTerminatingService
    extends AbstractService
    implements Runnable {
        final int timeout;

        private AsyncSelfTerminatingService(int timeout) {
            super("AsyncSelfTerminatingService");
            this.timeout = timeout;
        }

        protected void serviceStart() throws Exception {
            new Thread(this).start();
            super.serviceStart();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.stop();
        }
    }

    private static class NotifyingListener
    implements ServiceStateChangeListener {
        public Service.STATE notifyingState = Service.STATE.NOTINITED;

        private NotifyingListener() {
        }

        public synchronized void stateChanged(Service service) {
            this.notifyingState = service.getServiceState();
            this.notifyAll();
        }
    }

    private static class SelfUnregisteringBreakableStateChangeListener
    extends BreakableStateChangeListener {
        private SelfUnregisteringBreakableStateChangeListener() {
        }

        @Override
        public synchronized void stateChanged(Service service) {
            super.stateChanged(service);
            service.unregisterServiceListener((ServiceStateChangeListener)this);
        }
    }
}

