/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDefaultStringifier {
    private static Configuration conf = new Configuration();
    private static final Logger LOG = LoggerFactory.getLogger(TestDefaultStringifier.class);
    private char[] alphabet = "abcdefghijklmnopqrstuvwxyz".toCharArray();

    @Test
    public void testWithWritable() throws Exception {
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.WritableSerialization");
        LOG.info("Testing DefaultStringifier with Text");
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            StringBuilder builder = new StringBuilder();
            int strLen = random.nextInt(40);
            for (int j = 0; j < strLen; ++j) {
                builder.append(this.alphabet[random.nextInt(this.alphabet.length)]);
            }
            Text text = new Text(builder.toString());
            DefaultStringifier stringifier = new DefaultStringifier(conf, Text.class);
            String str = stringifier.toString((Object)text);
            Text claimedText = (Text)stringifier.fromString(str);
            LOG.info("Object: " + text);
            LOG.info("String representation of the object: " + str);
            Assert.assertEquals((Object)text, (Object)claimedText);
        }
    }

    @Test
    public void testWithJavaSerialization() throws Exception {
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization");
        LOG.info("Testing DefaultStringifier with Serializable Integer");
        Integer testInt = 42;
        DefaultStringifier stringifier = new DefaultStringifier(conf, Integer.class);
        String str = stringifier.toString((Object)testInt);
        Integer claimedInt = (Integer)stringifier.fromString(str);
        LOG.info("String representation of the object: " + str);
        Assert.assertEquals((Object)testInt, (Object)claimedInt);
    }

    @Test
    public void testStoreLoad() throws IOException {
        LOG.info("Testing DefaultStringifier#store() and #load()");
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.WritableSerialization");
        Text text = new Text("uninteresting test string");
        String keyName = "test.defaultstringifier.key1";
        DefaultStringifier.store((Configuration)conf, (Object)text, (String)keyName);
        Text claimedText = (Text)DefaultStringifier.load((Configuration)conf, (String)keyName, Text.class);
        Assert.assertEquals((String)"DefaultStringifier#load() or #store() might be flawed", (Object)text, (Object)claimedText);
    }

    @Test
    public void testStoreLoadArray() throws Exception {
        LOG.info("Testing DefaultStringifier#storeArray() and #loadArray()");
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization");
        String keyName = "test.defaultstringifier.key2";
        Object[] array = new Integer[]{1, 2, 3, 4, 5};
        LambdaTestUtils.intercept(IndexOutOfBoundsException.class, () -> DefaultStringifier.storeArray((Configuration)conf, (Object[])new Integer[0], (String)keyName));
        DefaultStringifier.storeArray((Configuration)conf, (Object[])array, (String)keyName);
        Integer[] claimedArray = (Integer[])DefaultStringifier.loadArray((Configuration)conf, (String)keyName, Integer.class);
        for (int i = 0; i < array.length; ++i) {
            Assert.assertEquals((String)"two arrays are not equal", (Object)array[i], (Object)claimedArray[i]);
        }
    }
}

