/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl.prefetch;

import org.apache.hadoop.fs.impl.prefetch.BufferData;
import org.apache.hadoop.fs.impl.prefetch.BufferPool;
import org.apache.hadoop.fs.impl.prefetch.EmptyPrefetchingStatistics;
import org.apache.hadoop.fs.impl.prefetch.PrefetchingStatistics;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestBufferPool
extends AbstractHadoopTestBase {
    private static final int POOL_SIZE = 2;
    private static final int BUFFER_SIZE = 10;
    private final PrefetchingStatistics statistics = EmptyPrefetchingStatistics.getInstance();

    @Test
    public void testArgChecks() throws Exception {
        BufferPool pool = new BufferPool(2, 10, this.statistics);
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'size' must be a positive integer", () -> new BufferPool(0, 10, this.statistics));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'size' must be a positive integer", () -> new BufferPool(-1, 10, this.statistics));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'bufferSize' must be a positive integer", () -> new BufferPool(10, 0, this.statistics));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'bufferSize' must be a positive integer", () -> new BufferPool(1, -10, this.statistics));
        LambdaTestUtils.intercept(NullPointerException.class, () -> new BufferPool(1, 10, null));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockNumber' must not be negative", () -> pool.acquire(-1));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockNumber' must not be negative", () -> pool.tryAcquire(-1));
        LambdaTestUtils.intercept(NullPointerException.class, "data", () -> pool.release((BufferData)null));
    }

    @Test
    public void testGetAndRelease() {
        BufferPool pool = new BufferPool(2, 10, this.statistics);
        this.assertInitialState(pool, 2);
        int count = 0;
        for (BufferData data : pool.getAll()) {
            ++count;
        }
        Assert.assertEquals((long)0L, (long)count);
        BufferData data1 = this.acquire(pool, 1);
        BufferData data2 = this.acquire(pool, 2);
        BufferData data3 = pool.tryAcquire(3);
        Assert.assertNull((Object)data3);
        count = 0;
        for (BufferData data : pool.getAll()) {
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        Assert.assertEquals((long)2L, (long)pool.numCreated());
        Assert.assertEquals((long)0L, (long)pool.numAvailable());
        data1.updateState(BufferData.State.READY, new BufferData.State[]{BufferData.State.BLANK});
        pool.release(data1);
        Assert.assertEquals((long)2L, (long)pool.numCreated());
        Assert.assertEquals((long)1L, (long)pool.numAvailable());
        data2.updateState(BufferData.State.READY, new BufferData.State[]{BufferData.State.BLANK});
        pool.release(data2);
        Assert.assertEquals((long)2L, (long)pool.numCreated());
        Assert.assertEquals((long)2L, (long)pool.numAvailable());
    }

    @Test
    public void testRelease() throws Exception {
        this.testReleaseHelper(BufferData.State.BLANK, true);
        this.testReleaseHelper(BufferData.State.PREFETCHING, true);
        this.testReleaseHelper(BufferData.State.CACHING, true);
        this.testReleaseHelper(BufferData.State.READY, false);
    }

    private void testReleaseHelper(BufferData.State stateBeforeRelease, boolean expectThrow) throws Exception {
        BufferPool pool = new BufferPool(2, 10, this.statistics);
        this.assertInitialState(pool, 2);
        BufferData data = this.acquire(pool, 1);
        data.updateState(stateBeforeRelease, new BufferData.State[]{BufferData.State.BLANK});
        if (expectThrow) {
            LambdaTestUtils.intercept(IllegalArgumentException.class, "Unable to release buffer", () -> pool.release(data));
        } else {
            pool.release(data);
        }
    }

    private BufferData acquire(BufferPool pool, int blockNumber) {
        BufferData data = pool.acquire(blockNumber);
        Assert.assertNotNull((Object)data);
        Assert.assertSame((Object)data, (Object)pool.acquire(blockNumber));
        Assert.assertEquals((long)blockNumber, (long)data.getBlockNumber());
        return data;
    }

    private void assertInitialState(BufferPool pool, int poolSize) {
        Assert.assertEquals((long)poolSize, (long)pool.numAvailable());
        Assert.assertEquals((long)0L, (long)pool.numCreated());
    }
}

