/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.RandomDatum;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.serializer.avro.AvroReflectSerialization;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSequenceFile {
    private static final Logger LOG = LoggerFactory.getLogger(TestSequenceFile.class);
    private Configuration conf = new Configuration();

    @Test
    public void testZlibSequenceFile() throws Exception {
        LOG.info("Testing SequenceFile with DefaultCodec");
        this.compressedSeqFileTest((CompressionCodec)new DefaultCodec());
        LOG.info("Successfully tested SequenceFile with DefaultCodec");
    }

    public void testSorterProperties() throws IOException {
        Configuration config = new Configuration();
        Assert.assertNull((String)"The deprecated sort memory property io.sort.mb must not exist in any core-*.xml files.", (Object)config.get("io.sort.mb"));
        Assert.assertNull((String)"The deprecated sort factor property io.sort.factor must not exist in any core-*.xml files.", (Object)config.get("io.sort.factor"));
        config = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)config);
        config.setInt("io.sort.mb", 10);
        config.setInt("io.sort.factor", 10);
        config.setInt("seq.io.sort.mb", 20);
        config.setInt("seq.io.sort.factor", 20);
        SequenceFile.Sorter sorter = new SequenceFile.Sorter(fs, Text.class, Text.class, config);
        Assert.assertEquals((String)"Deprecated memory conf must be honored over newer property", (long)0xA00000L, (long)sorter.getMemory());
        Assert.assertEquals((String)"Deprecated factor conf must be honored over newer property", (long)10L, (long)sorter.getFactor());
        config = new Configuration();
        fs = FileSystem.get((Configuration)config);
        config.setInt("io.sort.mb", 10);
        config.setInt("io.sort.factor", 10);
        sorter = new SequenceFile.Sorter(fs, Text.class, Text.class, config);
        Assert.assertEquals((String)"Deprecated memory property io.sort.mb must get properly applied.", (long)0xA00000L, (long)sorter.getMemory());
        Assert.assertEquals((String)"Deprecated sort factor property io.sort.factor must get properly applied.", (long)10L, (long)sorter.getFactor());
        config = new Configuration();
        fs = FileSystem.get((Configuration)config);
        config.setInt("seq.io.sort.mb", 20);
        config.setInt("seq.io.sort.factor", 20);
        sorter = new SequenceFile.Sorter(fs, Text.class, Text.class, config);
        Assert.assertEquals((String)"Memory property seq.io.sort.mb must get properly applied if present.", (long)0x1400000L, (long)sorter.getMemory());
        Assert.assertEquals((String)"Merge factor property seq.io.sort.factor must get properly applied if present.", (long)20L, (long)sorter.getFactor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compressedSeqFileTest(CompressionCodec codec) throws Exception {
        int count = 10240;
        int megabytes = 1;
        int factor = 5;
        Path file = new Path(GenericTestUtils.getTempPath("test.seq"));
        Path recordCompressedFile = new Path(GenericTestUtils.getTempPath("test.rc.seq"));
        Path blockCompressedFile = new Path(GenericTestUtils.getTempPath("test.bc.seq"));
        int seed = new Random().nextInt();
        LOG.info("Seed = " + seed);
        try (LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);){
            this.writeTest((FileSystem)fs, count, seed, file, SequenceFile.CompressionType.NONE, null);
            this.readTest((FileSystem)fs, count, seed, file);
            this.sortTest((FileSystem)fs, count, megabytes, factor, false, file);
            this.checkSort((FileSystem)fs, count, seed, file);
            this.sortTest((FileSystem)fs, count, megabytes, factor, true, file);
            this.checkSort((FileSystem)fs, count, seed, file);
            this.mergeTest((FileSystem)fs, count, seed, file, SequenceFile.CompressionType.NONE, false, factor, megabytes);
            this.checkSort((FileSystem)fs, count, seed, file);
            this.mergeTest((FileSystem)fs, count, seed, file, SequenceFile.CompressionType.NONE, true, factor, megabytes);
            this.checkSort((FileSystem)fs, count, seed, file);
            this.writeTest((FileSystem)fs, count, seed, recordCompressedFile, SequenceFile.CompressionType.RECORD, codec);
            this.readTest((FileSystem)fs, count, seed, recordCompressedFile);
            this.sortTest((FileSystem)fs, count, megabytes, factor, false, recordCompressedFile);
            this.checkSort((FileSystem)fs, count, seed, recordCompressedFile);
            this.sortTest((FileSystem)fs, count, megabytes, factor, true, recordCompressedFile);
            this.checkSort((FileSystem)fs, count, seed, recordCompressedFile);
            this.mergeTest((FileSystem)fs, count, seed, recordCompressedFile, SequenceFile.CompressionType.RECORD, false, factor, megabytes);
            this.checkSort((FileSystem)fs, count, seed, recordCompressedFile);
            this.mergeTest((FileSystem)fs, count, seed, recordCompressedFile, SequenceFile.CompressionType.RECORD, true, factor, megabytes);
            this.checkSort((FileSystem)fs, count, seed, recordCompressedFile);
            this.writeTest((FileSystem)fs, count, seed, blockCompressedFile, SequenceFile.CompressionType.BLOCK, codec);
            this.readTest((FileSystem)fs, count, seed, blockCompressedFile);
            this.sortTest((FileSystem)fs, count, megabytes, factor, false, blockCompressedFile);
            this.checkSort((FileSystem)fs, count, seed, blockCompressedFile);
            this.sortTest((FileSystem)fs, count, megabytes, factor, true, blockCompressedFile);
            this.checkSort((FileSystem)fs, count, seed, blockCompressedFile);
            this.mergeTest((FileSystem)fs, count, seed, blockCompressedFile, SequenceFile.CompressionType.BLOCK, false, factor, megabytes);
            this.checkSort((FileSystem)fs, count, seed, blockCompressedFile);
            this.mergeTest((FileSystem)fs, count, seed, blockCompressedFile, SequenceFile.CompressionType.BLOCK, true, factor, megabytes);
            this.checkSort((FileSystem)fs, count, seed, blockCompressedFile);
        }
    }

    private void writeTest(FileSystem fs, int count, int seed, Path file, SequenceFile.CompressionType compressionType, CompressionCodec codec) throws IOException {
        fs.delete(file, true);
        LOG.info("creating " + count + " records with " + compressionType + " compression");
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)file, RandomDatum.class, RandomDatum.class, (SequenceFile.CompressionType)compressionType, (CompressionCodec)codec);
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            writer.append((Writable)key, (Writable)value);
        }
        writer.close();
    }

    private void readTest(FileSystem fs, int count, int seed, Path file) throws IOException {
        LOG.debug("reading " + count + " records");
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, file, this.conf);
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        RandomDatum k = new RandomDatum();
        RandomDatum v = new RandomDatum();
        DataOutputBuffer rawKey = new DataOutputBuffer();
        SequenceFile.ValueBytes rawValue = reader.createValueBytes();
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            try {
                if (i % 5 == 0) {
                    rawKey.reset();
                    reader.nextRaw(rawKey, rawValue);
                    continue;
                }
                if (i % 2 == 0) {
                    reader.next((Writable)k);
                    reader.getCurrentValue((Writable)v);
                } else {
                    reader.next((Writable)k, (Writable)v);
                }
                if (!k.equals(key)) {
                    throw new RuntimeException("wrong key at " + i);
                }
                if (v.equals(value)) continue;
                throw new RuntimeException("wrong value at " + i);
            }
            catch (IOException ioe) {
                LOG.info("Problem on row " + i);
                LOG.info("Expected key = " + key);
                LOG.info("Expected len = " + key.getLength());
                LOG.info("Actual key = " + k);
                LOG.info("Actual len = " + k.getLength());
                LOG.info("Expected value = " + value);
                LOG.info("Expected len = " + value.getLength());
                LOG.info("Actual value = " + v);
                LOG.info("Actual len = " + v.getLength());
                LOG.info("Key equals: " + k.equals(key));
                LOG.info("value equals: " + v.equals(value));
                throw ioe;
            }
        }
        reader.close();
    }

    private void sortTest(FileSystem fs, int count, int megabytes, int factor, boolean fast, Path file) throws IOException {
        fs.delete(new Path(file + ".sorted"), true);
        SequenceFile.Sorter sorter = this.newSorter(fs, fast, megabytes, factor);
        LOG.debug("sorting " + count + " records");
        sorter.sort(file, file.suffix(".sorted"));
        LOG.info("done sorting " + count + " debug");
    }

    private void checkSort(FileSystem fs, int count, int seed, Path file) throws IOException {
        LOG.info("sorting " + count + " records in memory for debug");
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        TreeMap<RandomDatum, RandomDatum> map = new TreeMap<RandomDatum, RandomDatum>();
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            map.put(key, value);
        }
        LOG.debug("checking order of " + count + " records");
        RandomDatum k = new RandomDatum();
        RandomDatum v = new RandomDatum();
        Iterator iterator = map.entrySet().iterator();
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, file.suffix(".sorted"), this.conf);
        for (int i = 0; i < count; ++i) {
            Map.Entry entry = iterator.next();
            RandomDatum key = (RandomDatum)entry.getKey();
            RandomDatum value = (RandomDatum)entry.getValue();
            reader.next((Writable)k, (Writable)v);
            if (!k.equals(key)) {
                throw new RuntimeException("wrong key at " + i);
            }
            if (v.equals(value)) continue;
            throw new RuntimeException("wrong value at " + i);
        }
        reader.close();
        LOG.debug("sucessfully checked " + count + " records");
    }

    private void mergeTest(FileSystem fs, int count, int seed, Path file, SequenceFile.CompressionType compressionType, boolean fast, int factor, int megabytes) throws IOException {
        int i;
        LOG.debug("creating " + factor + " files with " + count / factor + " records");
        SequenceFile.Writer[] writers = new SequenceFile.Writer[factor];
        Path[] names = new Path[factor];
        Path[] sortedNames = new Path[factor];
        for (int i2 = 0; i2 < factor; ++i2) {
            names[i2] = file.suffix("." + i2);
            sortedNames[i2] = names[i2].suffix(".sorted");
            fs.delete(names[i2], true);
            fs.delete(sortedNames[i2], true);
            writers[i2] = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)names[i2], RandomDatum.class, RandomDatum.class, (SequenceFile.CompressionType)compressionType);
        }
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        for (i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            writers[i % factor].append((Writable)key, (Writable)value);
        }
        for (i = 0; i < factor; ++i) {
            writers[i].close();
        }
        for (i = 0; i < factor; ++i) {
            LOG.debug("sorting file " + i + " with " + count / factor + " records");
            this.newSorter(fs, fast, megabytes, factor).sort(names[i], sortedNames[i]);
        }
        LOG.info("merging " + factor + " files with " + count / factor + " debug");
        fs.delete(new Path(file + ".sorted"), true);
        this.newSorter(fs, fast, megabytes, factor).merge(sortedNames, file.suffix(".sorted"));
    }

    private SequenceFile.Sorter newSorter(FileSystem fs, boolean fast, int megabytes, int factor) {
        SequenceFile.Sorter sorter = fast ? new SequenceFile.Sorter(fs, (RawComparator)new RandomDatum.Comparator(), RandomDatum.class, RandomDatum.class, this.conf) : new SequenceFile.Sorter(fs, RandomDatum.class, RandomDatum.class, this.conf);
        sorter.setMemory(megabytes * 1024 * 1024);
        sorter.setFactor(factor);
        return sorter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSequenceFileMetadata() throws Exception {
        LOG.info("Testing SequenceFile with metadata");
        int count = 10240;
        DefaultCodec codec = new DefaultCodec();
        Path file = new Path(GenericTestUtils.getTempPath("test.seq.metadata"));
        Path sortedFile = new Path(GenericTestUtils.getTempPath("test.sorted.seq.metadata"));
        Path recordCompressedFile = new Path(GenericTestUtils.getTempPath("test.rc.seq.metadata"));
        Path blockCompressedFile = new Path(GenericTestUtils.getTempPath("test.bc.seq.metadata"));
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        SequenceFile.Metadata theMetadata = new SequenceFile.Metadata();
        theMetadata.set(new Text("name_1"), new Text("value_1"));
        theMetadata.set(new Text("name_2"), new Text("value_2"));
        theMetadata.set(new Text("name_3"), new Text("value_3"));
        theMetadata.set(new Text("name_4"), new Text("value_4"));
        int seed = new Random().nextInt();
        try {
            this.writeMetadataTest((FileSystem)fs, count, seed, file, SequenceFile.CompressionType.NONE, null, theMetadata);
            SequenceFile.Metadata aMetadata = this.readMetadata((FileSystem)fs, file);
            if (!theMetadata.equals(aMetadata)) {
                LOG.info("The original metadata:\n" + theMetadata.toString());
                LOG.info("The retrieved metadata:\n" + aMetadata.toString());
                throw new RuntimeException("metadata not match:  1");
            }
            this.writeMetadataTest((FileSystem)fs, count, seed, recordCompressedFile, SequenceFile.CompressionType.RECORD, (CompressionCodec)codec, theMetadata);
            aMetadata = this.readMetadata((FileSystem)fs, recordCompressedFile);
            if (!theMetadata.equals(aMetadata)) {
                LOG.info("The original metadata:\n" + theMetadata.toString());
                LOG.info("The retrieved metadata:\n" + aMetadata.toString());
                throw new RuntimeException("metadata not match:  2");
            }
            this.writeMetadataTest((FileSystem)fs, count, seed, blockCompressedFile, SequenceFile.CompressionType.BLOCK, (CompressionCodec)codec, theMetadata);
            aMetadata = this.readMetadata((FileSystem)fs, blockCompressedFile);
            if (!theMetadata.equals(aMetadata)) {
                LOG.info("The original metadata:\n" + theMetadata.toString());
                LOG.info("The retrieved metadata:\n" + aMetadata.toString());
                throw new RuntimeException("metadata not match:  3");
            }
            this.sortMetadataTest((FileSystem)fs, file, sortedFile, theMetadata);
            aMetadata = this.readMetadata((FileSystem)fs, recordCompressedFile);
            if (!theMetadata.equals(aMetadata)) {
                LOG.info("The original metadata:\n" + theMetadata.toString());
                LOG.info("The retrieved metadata:\n" + aMetadata.toString());
                throw new RuntimeException("metadata not match:  4");
            }
        }
        finally {
            fs.close();
        }
        LOG.info("Successfully tested SequenceFile with metadata");
    }

    private SequenceFile.Metadata readMetadata(FileSystem fs, Path file) throws IOException {
        LOG.info("reading file: " + file.toString());
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, file, this.conf);
        SequenceFile.Metadata meta = reader.getMetadata();
        reader.close();
        return meta;
    }

    private void writeMetadataTest(FileSystem fs, int count, int seed, Path file, SequenceFile.CompressionType compressionType, CompressionCodec codec, SequenceFile.Metadata metadata) throws IOException {
        fs.delete(file, true);
        LOG.info("creating " + count + " records with metadata and with " + compressionType + " compression");
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)file, RandomDatum.class, RandomDatum.class, (SequenceFile.CompressionType)compressionType, (CompressionCodec)codec, null, (SequenceFile.Metadata)metadata);
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            writer.append((Writable)key, (Writable)value);
        }
        writer.close();
    }

    private void sortMetadataTest(FileSystem fs, Path unsortedFile, Path sortedFile, SequenceFile.Metadata metadata) throws IOException {
        fs.delete(sortedFile, true);
        LOG.info("sorting: " + unsortedFile + " to: " + sortedFile);
        WritableComparator comparator = WritableComparator.get(RandomDatum.class);
        SequenceFile.Sorter sorter = new SequenceFile.Sorter(fs, (RawComparator)comparator, RandomDatum.class, RandomDatum.class, this.conf, metadata);
        sorter.sort(new Path[]{unsortedFile}, sortedFile, false);
    }

    @Test
    public void testClose() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path path1 = new Path(GenericTestUtils.getTempPath("test1.seq"));
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path1, Text.class, NullWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        writer.append((Writable)new Text("file1-1"), (Writable)NullWritable.get());
        writer.append((Writable)new Text("file1-2"), (Writable)NullWritable.get());
        writer.close();
        Path path2 = new Path(GenericTestUtils.getTempPath("test2.seq"));
        writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path2, Text.class, NullWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        writer.append((Writable)new Text("file2-1"), (Writable)NullWritable.get());
        writer.append((Writable)new Text("file2-2"), (Writable)NullWritable.get());
        writer.close();
        SequenceFile.Reader reader = new SequenceFile.Reader((FileSystem)fs, path1, conf);
        reader.close();
        reader.close();
        SequenceFile.Reader reader1 = new SequenceFile.Reader((FileSystem)fs, path1, conf);
        Text text = new Text();
        reader1.next((Writable)text);
        Assert.assertEquals((Object)"file1-1", (Object)text.toString());
        SequenceFile.Reader reader2 = new SequenceFile.Reader((FileSystem)fs, path2, conf);
        reader2.next((Writable)text);
        Assert.assertEquals((Object)"file2-1", (Object)text.toString());
        reader1.next((Writable)text);
        Assert.assertEquals((Object)"file1-2", (Object)text.toString());
        reader2.next((Writable)text);
        Assert.assertEquals((Object)"file2-2", (Object)text.toString());
        Assert.assertFalse((boolean)reader1.next((Writable)text));
        Assert.assertFalse((boolean)reader2.next((Writable)text));
    }

    @Test
    public void testCreateUsesFsArg() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        FileSystem spyFs = (FileSystem)Mockito.spy((Object)fs);
        Path p = new Path(GenericTestUtils.getTempPath("testCreateUsesFSArg.seq"));
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)spyFs, (Configuration)this.conf, (Path)p, NullWritable.class, NullWritable.class);
        writer.close();
        ((FileSystem)Mockito.verify((Object)spyFs)).getDefaultReplication(p);
    }

    @Test
    public void testCloseForErroneousSequenceFile() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path path = new Path(GenericTestUtils.getTempPath("broken.seq"));
        fs.create(path).close();
        final TestFSDataInputStream[] openedFile = new TestFSDataInputStream[1];
        try {
            new SequenceFile.Reader((FileSystem)fs, path, conf){

                protected FSDataInputStream openFile(FileSystem fs, Path file, int bufferSize, long length) throws IOException {
                    FSDataInputStream in = super.openFile(fs, file, bufferSize, length);
                    openedFile[0] = new TestFSDataInputStream((InputStream)in);
                    return openedFile[0];
                }
            };
            Assert.fail((String)"IOException expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertNotNull((String)(path + " should have been opened."), (Object)((Object)openedFile[0]));
        Assert.assertTrue((String)("InputStream for " + path + " should have been closed."), (boolean)openedFile[0].isClosed());
    }

    @Test
    public void testInitZeroLengthSequenceFile() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path path = new Path(GenericTestUtils.getTempPath("zerolength.seq"));
        fs.create(path).close();
        try {
            new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)path)});
            Assert.fail((String)"IOException expected.");
        }
        catch (IOException expected) {
            Assert.assertTrue((boolean)(expected instanceof EOFException));
        }
    }

    @Test
    public void testCreateWriterOnExistingFile() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path name = new Path(new Path(GenericTestUtils.getTempPath("createWriterOnExistingFile")), "file");
        fs.create(name);
        SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)name, RandomDatum.class, RandomDatum.class, (int)512, (short)1, (long)4096L, (boolean)false, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE, null, (SequenceFile.Metadata)new SequenceFile.Metadata());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecursiveSeqFileCreate() throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        Path parentDir = new Path(GenericTestUtils.getTempPath("recursiveCreateDir"));
        Path name = new Path(parentDir, "file");
        boolean createParent = false;
        try {
            SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)name, RandomDatum.class, RandomDatum.class, (int)512, (short)1, (long)4096L, (boolean)createParent, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE, null, (SequenceFile.Metadata)new SequenceFile.Metadata());
            Assert.fail((String)"Expected an IOException due to missing parent");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            createParent = true;
            SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)name, RandomDatum.class, RandomDatum.class, (int)512, (short)1, (long)4096L, (boolean)createParent, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE, null, (SequenceFile.Metadata)new SequenceFile.Metadata());
        }
        finally {
            fs.deleteOnExit(parentDir);
            fs.close();
        }
    }

    @Test
    public void testSerializationAvailability() throws IOException {
        Configuration conf = new Configuration();
        Path path = new Path(GenericTestUtils.getTempPath("serializationAvailability"));
        try {
            SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)path), SequenceFile.Writer.keyClass(String.class), SequenceFile.Writer.valueClass(NullWritable.class)});
            Assert.fail((String)"Must throw IOException for missing serializer for the Key class");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Could not find a serializer for the Key class: '" + String.class.getName() + "'."));
        }
        try {
            SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)path), SequenceFile.Writer.keyClass(NullWritable.class), SequenceFile.Writer.valueClass(String.class)});
            Assert.fail((String)"Must throw IOException for missing serializer for the Value class");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Could not find a serializer for the Value class: '" + String.class.getName() + "'."));
        }
        this.writeTest(FileSystem.get((Configuration)conf), 1, 1, path, SequenceFile.CompressionType.NONE, null);
        conf.setStrings("io.serializations", new String[]{AvroReflectSerialization.class.getName()});
        try {
            new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)path)});
            Assert.fail((String)"Must throw IOException for missing deserializer for the Key class");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Could not find a deserializer for the Key class: '" + RandomDatum.class.getName() + "'."));
        }
    }

    @Test
    public void testSequenceFileWriter() throws Exception {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.getLocal((Configuration)conf).getRaw();
        Path p = new Path(GenericTestUtils.getTempPath("testSequenceFileWriter.seq"));
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)p, LongWritable.class, Text.class);){
            Assertions.assertThat((boolean)writer.hasCapability("hsync")).isEqualTo(true);
            Assertions.assertThat((boolean)writer.hasCapability("hflush")).isEqualTo(true);
            LongWritable key = new LongWritable();
            key.set(1L);
            Text value = new Text();
            value.set("somevalue");
            writer.append((Writable)key, (Writable)value);
            writer.flush();
            writer.hflush();
            writer.hsync();
            Assertions.assertThat((long)fs.getFileStatus(p).getLen()).isGreaterThan(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int count = 0x100000;
        int megabytes = 1;
        int factor = 10;
        boolean create = true;
        boolean rwonly = false;
        boolean check = false;
        boolean fast = false;
        boolean merge = false;
        String compressType = "NONE";
        String compressionCodec = "org.apache.hadoop.io.compress.DefaultCodec";
        Path file = null;
        int seed = new Random().nextInt();
        String usage = "Usage: testsequencefile [-count N] [-seed #] [-check] [-compressType <NONE|RECORD|BLOCK>] -codec <compressionCodec> [[-rwonly] | {[-megabytes M] [-factor F] [-nocreate] [-fast] [-merge]}]  file";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        try (FileSystem fs = null;){
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                if (args[i].equals("-count")) {
                    count = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-megabytes")) {
                    megabytes = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-factor")) {
                    factor = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-seed")) {
                    seed = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-rwonly")) {
                    rwonly = true;
                    continue;
                }
                if (args[i].equals("-nocreate")) {
                    create = false;
                    continue;
                }
                if (args[i].equals("-check")) {
                    check = true;
                    continue;
                }
                if (args[i].equals("-fast")) {
                    fast = true;
                    continue;
                }
                if (args[i].equals("-merge")) {
                    merge = true;
                    continue;
                }
                if (args[i].equals("-compressType")) {
                    compressType = args[++i];
                    continue;
                }
                if (args[i].equals("-codec")) {
                    compressionCodec = args[++i];
                    continue;
                }
                file = new Path(args[i]);
            }
            TestSequenceFile test = new TestSequenceFile();
            fs = file.getFileSystem(test.conf);
            LOG.info("count = " + count);
            LOG.info("megabytes = " + megabytes);
            LOG.info("factor = " + factor);
            LOG.info("create = " + create);
            LOG.info("seed = " + seed);
            LOG.info("rwonly = " + rwonly);
            LOG.info("check = " + check);
            LOG.info("fast = " + fast);
            LOG.info("merge = " + merge);
            LOG.info("compressType = " + compressType);
            LOG.info("compressionCodec = " + compressionCodec);
            LOG.info("file = " + file);
            if (rwonly && (!create || merge || fast)) {
                System.err.println(usage);
                System.exit(-1);
            }
            SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.valueOf((String)compressType);
            CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)test.conf.getClassByName(compressionCodec), (Configuration)test.conf);
            if (rwonly || create && !merge) {
                test.writeTest(fs, count, seed, file, compressionType, codec);
                test.readTest(fs, count, seed, file);
            }
            if (!rwonly) {
                if (merge) {
                    test.mergeTest(fs, count, seed, file, compressionType, fast, factor, megabytes);
                } else {
                    test.sortTest(fs, count, megabytes, factor, fast, file);
                }
            }
            if (check) {
                test.checkSort(fs, count, seed, file);
            }
        }
    }

    private static class TestFSDataInputStream
    extends FSDataInputStream {
        private boolean closed = false;

        private TestFSDataInputStream(InputStream in) throws IOException {
            super(in);
        }

        public void close() throws IOException {
            this.closed = true;
            super.close();
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

