/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http.lib;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.lib.StaticUserWebFilter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestStaticUserWebFilter {
    private FilterConfig mockConfig(String username) {
        FilterConfig mock = (FilterConfig)Mockito.mock(FilterConfig.class);
        ((FilterConfig)Mockito.doReturn((Object)username).when((Object)mock)).getInitParameter("hadoop.http.staticuser.user");
        return mock;
    }

    @Test
    public void testFilter() throws Exception {
        FilterConfig config = this.mockConfig("myuser");
        StaticUserWebFilter.StaticUserFilter suf = new StaticUserWebFilter.StaticUserFilter();
        suf.init(config);
        ArgumentCaptor wrapperArg = ArgumentCaptor.forClass(HttpServletRequestWrapper.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        suf.doFilter((ServletRequest)Mockito.mock(HttpServletRequest.class), (ServletResponse)Mockito.mock(ServletResponse.class), chain);
        ((FilterChain)Mockito.verify((Object)chain)).doFilter((ServletRequest)wrapperArg.capture(), (ServletResponse)ArgumentMatchers.any());
        HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)wrapperArg.getValue();
        Assert.assertEquals((Object)"myuser", (Object)wrapper.getUserPrincipal().getName());
        Assert.assertEquals((Object)"myuser", (Object)wrapper.getRemoteUser());
        suf.destroy();
    }

    @Test
    public void testOldStyleConfiguration() {
        Configuration conf = new Configuration();
        conf.set("dfs.web.ugi", "joe,group1,group2");
        Assert.assertEquals((Object)"joe", (Object)StaticUserWebFilter.getUsernameFromConf((Configuration)conf));
    }

    @Test
    public void testConfiguration() {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.staticuser.user", "joe");
        Assert.assertEquals((Object)"joe", (Object)StaticUserWebFilter.getUsernameFromConf((Configuration)conf));
    }
}

