/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract.localfs;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileRange;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractContractVectoredReadTest;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.contract.localfs.LocalFSContract;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestLocalFSContractVectoredRead
extends AbstractContractVectoredReadTest {
    public TestLocalFSContractVectoredRead(String bufferType) {
        super(bufferType);
    }

    @Override
    protected AbstractFSContract createContract(Configuration conf) {
        return new LocalFSContract(conf);
    }

    @Test
    public void testChecksumValidationDuringVectoredRead() throws Exception {
        Path testPath = this.path("big_range_checksum");
        LocalFileSystem localFs = (LocalFileSystem)this.getFileSystem();
        byte[] datasetCorrect = ContractTestUtils.dataset(65536, 97, 32);
        try (FSDataOutputStream out = localFs.create(testPath, true);){
            out.write(datasetCorrect);
        }
        Path checksumPath = localFs.getChecksumFile(testPath);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)localFs.exists(checksumPath)).describedAs("Checksum file should be present", new Object[0])).isTrue();
        CompletableFuture fis = localFs.openFile(testPath).build();
        ArrayList<FileRange> someRandomRanges = new ArrayList<FileRange>();
        someRandomRanges.add(FileRange.createFileRange((long)10L, (int)1024));
        someRandomRanges.add(FileRange.createFileRange((long)1025L, (int)1024));
        try (FSDataInputStream in = (FSDataInputStream)fis.get();){
            in.readVectored(someRandomRanges, this.getAllocate());
            ContractTestUtils.validateVectoredReadResult(someRandomRanges, datasetCorrect);
        }
        byte[] datasetCorrupted = ContractTestUtils.dataset(65536, 97, 64);
        try (FSDataOutputStream out = localFs.getRaw().create(testPath, true);){
            out.write(datasetCorrupted);
        }
        CompletableFuture fisN = localFs.openFile(testPath).build();
        try (FSDataInputStream in = (FSDataInputStream)fisN.get();){
            in.readVectored(someRandomRanges, this.getAllocate());
            LambdaTestUtils.intercept(ChecksumException.class, () -> ContractTestUtils.validateVectoredReadResult(someRandomRanges, datasetCorrupted));
        }
    }
}

