/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileRange;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.impl.FutureIOSupport;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.io.WeakReferencedElasticByteBufferPool;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public abstract class AbstractContractVectoredReadTest
extends AbstractFSContractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractContractVectoredReadTest.class);
    public static final int DATASET_LEN = 65536;
    protected static final byte[] DATASET = ContractTestUtils.dataset(65536, 97, 32);
    protected static final String VECTORED_READ_FILE_NAME = "vectored_file.txt";
    private final IntFunction<ByteBuffer> allocate;
    private final WeakReferencedElasticByteBufferPool pool = new WeakReferencedElasticByteBufferPool();
    private final String bufferType;

    @Parameterized.Parameters(name="Buffer type : {0}")
    public static List<String> params() {
        return Arrays.asList("direct", "array");
    }

    public AbstractContractVectoredReadTest(String bufferType) {
        this.bufferType = bufferType;
        this.allocate = value -> {
            boolean isDirect = !"array".equals(bufferType);
            return this.pool.getBuffer(isDirect, value);
        };
    }

    public IntFunction<ByteBuffer> getAllocate() {
        return this.allocate;
    }

    public WeakReferencedElasticByteBufferPool getPool() {
        return this.pool;
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        Path path = this.path(VECTORED_READ_FILE_NAME);
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.createFile(fs, path, true, DATASET);
    }

    @Override
    public void teardown() throws Exception {
        super.teardown();
        this.pool.release();
    }

    @Test
    public void testVectoredReadCapability() throws Exception {
        FileSystem fs = this.getFileSystem();
        String[] vectoredReadCapability = new String[]{"readvectored"};
        try (FSDataInputStream in = fs.open(this.path(VECTORED_READ_FILE_NAME));){
            ContractTestUtils.assertCapabilities(in, vectoredReadCapability, null);
        }
    }

    @Test
    public void testVectoredReadMultipleRanges() throws Exception {
        FileSystem fs = this.getFileSystem();
        ArrayList<FileRange> fileRanges = new ArrayList<FileRange>();
        for (int i = 0; i < 10; ++i) {
            FileRange fileRange = FileRange.createFileRange((long)(i * 100), (int)100);
            fileRanges.add(fileRange);
        }
        try (FSDataInputStream in = fs.open(this.path(VECTORED_READ_FILE_NAME));){
            in.readVectored(fileRanges, this.allocate);
            CompletableFuture[] completableFutures = new CompletableFuture[fileRanges.size()];
            int i = 0;
            for (FileRange res : fileRanges) {
                completableFutures[i++] = res.getData();
            }
            CompletableFuture<Void> combinedFuture = CompletableFuture.allOf(completableFutures);
            combinedFuture.get();
            ContractTestUtils.validateVectoredReadResult(fileRanges, DATASET);
            ContractTestUtils.returnBuffersToPoolPostRead(fileRanges, (ByteBufferPool)this.pool);
        }
    }

    @Test
    public void testVectoredReadAndReadFully() throws Exception {
        FileSystem fs = this.getFileSystem();
        ArrayList<FileRange> fileRanges = new ArrayList<FileRange>();
        fileRanges.add(FileRange.createFileRange((long)100L, (int)100));
        try (FSDataInputStream in = fs.open(this.path(VECTORED_READ_FILE_NAME));){
            in.readVectored(fileRanges, this.allocate);
            byte[] readFullRes = new byte[100];
            in.readFully(100L, readFullRes);
            ByteBuffer vecRes = (ByteBuffer)FutureIOSupport.awaitFuture((Future)((FileRange)fileRanges.get(0)).getData());
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)vecRes).describedAs("Result from vectored read and readFully must match", new Object[0])).isEqualByComparingTo((Comparable)ByteBuffer.wrap(readFullRes));
            ContractTestUtils.returnBuffersToPoolPostRead(fileRanges, (ByteBufferPool)this.pool);
        }
    }

    @Test
    public void testDisjointRanges() throws Exception {
        FileSystem fs = this.getFileSystem();
        ArrayList<FileRange> fileRanges = new ArrayList<FileRange>();
        fileRanges.add(FileRange.createFileRange((long)0L, (int)100));
        fileRanges.add(FileRange.createFileRange((long)4101L, (int)100));
        fileRanges.add(FileRange.createFileRange((long)16101L, (int)100));
        try (FSDataInputStream in = fs.open(this.path(VECTORED_READ_FILE_NAME));){
            in.readVectored(fileRanges, this.allocate);
            ContractTestUtils.validateVectoredReadResult(fileRanges, DATASET);
            ContractTestUtils.returnBuffersToPoolPostRead(fileRanges, (ByteBufferPool)this.pool);
        }
    }

    @Test
    public void testAllRangesMergedIntoOne() throws Exception {
        FileSystem fs = this.getFileSystem();
        ArrayList<FileRange> fileRanges = new ArrayList<FileRange>();
        fileRanges.add(FileRange.createFileRange((long)0L, (int)100));
        fileRanges.add(FileRange.createFileRange((long)3899L, (int)100));
        fileRanges.add(FileRange.createFileRange((long)7899L, (int)100));
        try (FSDataInputStream in = fs.open(this.path(VECTORED_READ_FILE_NAME));){
            in.readVectored(fileRanges, this.allocate);
            ContractTestUtils.validateVectoredReadResult(fileRanges, DATASET);
            ContractTestUtils.returnBuffersToPoolPostRead(fileRanges, (ByteBufferPool)this.pool);
        }
    }

    @Test
    public void testSomeRangesMergedSomeUnmerged() throws Exception {
        FileSystem fs = this.getFileSystem();
        ArrayList<FileRange> fileRanges = new ArrayList<FileRange>();
        fileRanges.add(FileRange.createFileRange((long)8192L, (int)100));
        fileRanges.add(FileRange.createFileRange((long)14336L, (int)100));
        fileRanges.add(FileRange.createFileRange((long)10240L, (int)100));
        fileRanges.add(FileRange.createFileRange((long)1947L, (int)100));
        fileRanges.add(FileRange.createFileRange((long)40960L, (int)1024));
        FileStatus fileStatus = fs.getFileStatus(this.path(VECTORED_READ_FILE_NAME));
        CompletableFuture builder = fs.openFile(this.path(VECTORED_READ_FILE_NAME)).withFileStatus(fileStatus).build();
        try (FSDataInputStream in = (FSDataInputStream)builder.get();){
            in.readVectored(fileRanges, this.allocate);
            ContractTestUtils.validateVectoredReadResult(fileRanges, DATASET);
            ContractTestUtils.returnBuffersToPoolPostRead(fileRanges, (ByteBufferPool)this.pool);
        }
    }

    @Test
    public void testOverlappingRanges() throws Exception {
        FileSystem fs = this.getFileSystem();
        List<FileRange> fileRanges = this.getSampleOverlappingRanges();
        FileStatus fileStatus = fs.getFileStatus(this.path(VECTORED_READ_FILE_NAME));
        CompletableFuture builder = fs.openFile(this.path(VECTORED_READ_FILE_NAME)).withFileStatus(fileStatus).build();
        try (FSDataInputStream in = (FSDataInputStream)builder.get();){
            in.readVectored(fileRanges, this.allocate);
            ContractTestUtils.validateVectoredReadResult(fileRanges, DATASET);
            ContractTestUtils.returnBuffersToPoolPostRead(fileRanges, (ByteBufferPool)this.pool);
        }
    }

    @Test
    public void testSameRanges() throws Exception {
        FileSystem fs = this.getFileSystem();
        List<FileRange> fileRanges = this.getSampleSameRanges();
        CompletableFuture builder = fs.openFile(this.path(VECTORED_READ_FILE_NAME)).build();
        try (FSDataInputStream in = (FSDataInputStream)builder.get();){
            in.readVectored(fileRanges, this.allocate);
            ContractTestUtils.validateVectoredReadResult(fileRanges, DATASET);
            ContractTestUtils.returnBuffersToPoolPostRead(fileRanges, (ByteBufferPool)this.pool);
        }
    }

    @Test
    public void testSomeRandomNonOverlappingRanges() throws Exception {
        FileSystem fs = this.getFileSystem();
        ArrayList<FileRange> fileRanges = new ArrayList<FileRange>();
        fileRanges.add(FileRange.createFileRange((long)500L, (int)100));
        fileRanges.add(FileRange.createFileRange((long)1000L, (int)200));
        fileRanges.add(FileRange.createFileRange((long)50L, (int)10));
        fileRanges.add(FileRange.createFileRange((long)10L, (int)5));
        try (FSDataInputStream in = fs.open(this.path(VECTORED_READ_FILE_NAME));){
            in.readVectored(fileRanges, this.allocate);
            ContractTestUtils.validateVectoredReadResult(fileRanges, DATASET);
            ContractTestUtils.returnBuffersToPoolPostRead(fileRanges, (ByteBufferPool)this.pool);
        }
    }

    @Test
    public void testConsecutiveRanges() throws Exception {
        FileSystem fs = this.getFileSystem();
        ArrayList<FileRange> fileRanges = new ArrayList<FileRange>();
        fileRanges.add(FileRange.createFileRange((long)500L, (int)100));
        fileRanges.add(FileRange.createFileRange((long)600L, (int)200));
        fileRanges.add(FileRange.createFileRange((long)800L, (int)100));
        try (FSDataInputStream in = fs.open(this.path(VECTORED_READ_FILE_NAME));){
            in.readVectored(fileRanges, this.allocate);
            ContractTestUtils.validateVectoredReadResult(fileRanges, DATASET);
            ContractTestUtils.returnBuffersToPoolPostRead(fileRanges, (ByteBufferPool)this.pool);
        }
    }

    @Test
    public void testEOFRanges() throws Exception {
        FileSystem fs = this.getFileSystem();
        ArrayList<FileRange> fileRanges = new ArrayList<FileRange>();
        fileRanges.add(FileRange.createFileRange((long)65536L, (int)100));
        try (FSDataInputStream in = fs.open(this.path(VECTORED_READ_FILE_NAME));){
            in.readVectored(fileRanges, this.allocate);
            for (FileRange res : fileRanges) {
                CompletableFuture data = res.getData();
                LambdaTestUtils.interceptFuture(EOFException.class, "", 300L, TimeUnit.SECONDS, data);
            }
        }
    }

    @Test
    public void testNegativeLengthRange() throws Exception {
        FileSystem fs = this.getFileSystem();
        ArrayList<FileRange> fileRanges = new ArrayList<FileRange>();
        fileRanges.add(FileRange.createFileRange((long)0L, (int)-50));
        this.verifyExceptionalVectoredRead(fs, fileRanges, IllegalArgumentException.class);
    }

    @Test
    public void testNegativeOffsetRange() throws Exception {
        FileSystem fs = this.getFileSystem();
        ArrayList<FileRange> fileRanges = new ArrayList<FileRange>();
        fileRanges.add(FileRange.createFileRange((long)-1L, (int)50));
        this.verifyExceptionalVectoredRead(fs, fileRanges, EOFException.class);
    }

    @Test
    public void testNormalReadAfterVectoredRead() throws Exception {
        FileSystem fs = this.getFileSystem();
        List<FileRange> fileRanges = this.createSampleNonOverlappingRanges();
        try (FSDataInputStream in = fs.open(this.path(VECTORED_READ_FILE_NAME));){
            in.readVectored(fileRanges, this.allocate);
            byte[] res = new byte[200];
            in.read(res, 0, 200);
            ByteBuffer buffer = ByteBuffer.wrap(res);
            ContractTestUtils.assertDatasetEquals(0, "normal_read", buffer, 200, DATASET);
            ((AbstractLongAssert)Assertions.assertThat((long)in.getPos()).describedAs("Vectored read shouldn't change file pointer.", new Object[0])).isEqualTo(200L);
            ContractTestUtils.validateVectoredReadResult(fileRanges, DATASET);
            ContractTestUtils.returnBuffersToPoolPostRead(fileRanges, (ByteBufferPool)this.pool);
        }
    }

    @Test
    public void testVectoredReadAfterNormalRead() throws Exception {
        FileSystem fs = this.getFileSystem();
        List<FileRange> fileRanges = this.createSampleNonOverlappingRanges();
        try (FSDataInputStream in = fs.open(this.path(VECTORED_READ_FILE_NAME));){
            byte[] res = new byte[200];
            in.read(res, 0, 200);
            ByteBuffer buffer = ByteBuffer.wrap(res);
            ContractTestUtils.assertDatasetEquals(0, "normal_read", buffer, 200, DATASET);
            ((AbstractLongAssert)Assertions.assertThat((long)in.getPos()).describedAs("Vectored read shouldn't change file pointer.", new Object[0])).isEqualTo(200L);
            in.readVectored(fileRanges, this.allocate);
            ContractTestUtils.validateVectoredReadResult(fileRanges, DATASET);
            ContractTestUtils.returnBuffersToPoolPostRead(fileRanges, (ByteBufferPool)this.pool);
        }
    }

    @Test
    public void testMultipleVectoredReads() throws Exception {
        FileSystem fs = this.getFileSystem();
        List<FileRange> fileRanges1 = this.createSampleNonOverlappingRanges();
        List<FileRange> fileRanges2 = this.createSampleNonOverlappingRanges();
        try (FSDataInputStream in = fs.open(this.path(VECTORED_READ_FILE_NAME));){
            in.readVectored(fileRanges1, this.allocate);
            in.readVectored(fileRanges2, this.allocate);
            ContractTestUtils.validateVectoredReadResult(fileRanges2, DATASET);
            ContractTestUtils.validateVectoredReadResult(fileRanges1, DATASET);
            ContractTestUtils.returnBuffersToPoolPostRead(fileRanges1, (ByteBufferPool)this.pool);
            ContractTestUtils.returnBuffersToPoolPostRead(fileRanges2, (ByteBufferPool)this.pool);
        }
    }

    protected List<FileRange> createSampleNonOverlappingRanges() {
        ArrayList<FileRange> fileRanges = new ArrayList<FileRange>();
        fileRanges.add(FileRange.createFileRange((long)0L, (int)100));
        fileRanges.add(FileRange.createFileRange((long)110L, (int)50));
        return fileRanges;
    }

    protected List<FileRange> getSampleSameRanges() {
        ArrayList<FileRange> fileRanges = new ArrayList<FileRange>();
        fileRanges.add(FileRange.createFileRange((long)8000L, (int)1000));
        fileRanges.add(FileRange.createFileRange((long)8000L, (int)1000));
        fileRanges.add(FileRange.createFileRange((long)8000L, (int)1000));
        return fileRanges;
    }

    protected List<FileRange> getSampleOverlappingRanges() {
        ArrayList<FileRange> fileRanges = new ArrayList<FileRange>();
        fileRanges.add(FileRange.createFileRange((long)100L, (int)500));
        fileRanges.add(FileRange.createFileRange((long)400L, (int)500));
        return fileRanges;
    }

    protected List<FileRange> getConsecutiveRanges() {
        ArrayList<FileRange> fileRanges = new ArrayList<FileRange>();
        fileRanges.add(FileRange.createFileRange((long)100L, (int)500));
        fileRanges.add(FileRange.createFileRange((long)600L, (int)500));
        return fileRanges;
    }

    protected <T extends Throwable> void verifyExceptionalVectoredRead(FileSystem fs, List<FileRange> fileRanges, Class<T> clazz) throws Exception {
        CompletableFuture builder = fs.openFile(this.path(VECTORED_READ_FILE_NAME)).build();
        try (FSDataInputStream in = (FSDataInputStream)builder.get();){
            LambdaTestUtils.intercept(clazz, () -> in.readVectored(fileRanges, this.allocate));
        }
    }
}

