/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestAuthenticationFilter {
    @Test
    public void testConfiguration() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.authentication.foo", "bar");
        conf.set("bind.address", "barhost");
        FilterContainer container = (FilterContainer)Mockito.mock(FilterContainer.class);
        ((FilterContainer)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] args = invocationOnMock.getArguments();
                Assert.assertEquals((Object)"authentication", (Object)args[0]);
                Assert.assertEquals((Object)AuthenticationFilter.class.getName(), (Object)args[1]);
                Map conf = (Map)args[2];
                Assert.assertEquals((Object)"/", conf.get("cookie.path"));
                Assert.assertEquals((Object)"simple", conf.get("type"));
                Assert.assertEquals((Object)"36000", conf.get("token.validity"));
                Assert.assertNull(conf.get("cookie.domain"));
                Assert.assertEquals((Object)"true", conf.get("simple.anonymous.allowed"));
                Assert.assertEquals((Object)"HTTP/barhost@LOCALHOST", conf.get("kerberos.principal"));
                Assert.assertEquals((Object)(System.getProperty("user.home") + "/hadoop.keytab"), conf.get("kerberos.keytab"));
                Assert.assertEquals((Object)"bar", conf.get("foo"));
                return null;
            }
        }).when((Object)container)).addFilter((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        new AuthenticationFilterInitializer().initFilter(container, conf);
    }
}

