/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.serializer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.event.Level;

public class TestSerializationFactory {
    static Configuration conf;
    static SerializationFactory factory;

    @BeforeClass
    public static void setup() throws Exception {
        conf = new Configuration();
        factory = new SerializationFactory(conf);
    }

    @Test
    public void testSerializationKeyIsEmpty() {
        Configuration conf = new Configuration();
        conf.set("io.serializations", "");
        SerializationFactory factory = new SerializationFactory(conf);
    }

    @Test
    public void testSerializationKeyIsUnset() {
        Configuration conf = new Configuration();
        conf.unset("io.serializations");
        SerializationFactory factory = new SerializationFactory(conf);
    }

    @Test
    public void testSerializationKeyIsInvalid() {
        Configuration conf = new Configuration();
        conf.set("io.serializations", "INVALID_KEY_XXX");
        SerializationFactory factory = new SerializationFactory(conf);
    }

    @Test
    public void testGetSerializer() {
        Assert.assertNotNull((String)"A valid class must be returned for default Writable SerDe", (Object)factory.getSerializer(Writable.class));
        Assert.assertNull((String)"A null should be returned if there are no serializers found.", (Object)factory.getSerializer(TestSerializationFactory.class));
    }

    @Test
    public void testGetDeserializer() {
        Assert.assertNotNull((String)"A valid class must be returned for default Writable SerDe", (Object)factory.getDeserializer(Writable.class));
        Assert.assertNull((String)"A null should be returned if there are no deserializers found", (Object)factory.getDeserializer(TestSerializationFactory.class));
    }

    @Test
    public void testSerializationKeyIsTrimmed() {
        Configuration conf = new Configuration();
        conf.set("io.serializations", " org.apache.hadoop.io.serializer.WritableSerialization ");
        SerializationFactory factory = new SerializationFactory(conf);
        Assert.assertNotNull((String)"Valid class must be returned", (Object)factory.getSerializer(LongWritable.class));
    }

    static {
        GenericTestUtils.setLogLevel(SerializationFactory.LOG, Level.TRACE);
    }
}

