/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.util.MapRCommonSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRCommonSecurityUtil {
    public static final String DEFAULT_INSTALL_LOCATION = "/opt/mapr";
    private static final String CLUSTER_CONFIG_LOCATION = "/conf/mapr-clusters.conf";
    private String currentClusterName;
    private static MapRCommonSecurityUtil s_instance;
    private boolean isClusterSecure = false;
    private boolean isClusterValid = false;
    private Set<String> clustersNamesList = new HashSet<String>();
    private static final Logger LOG;

    private MapRCommonSecurityUtil() {
        this.init();
    }

    public static MapRCommonSecurityUtil getInstance() {
        return s_instance;
    }

    public void init() {
        this.parseMaprClustersConf();
    }

    public String getUserTicketAndKeyFileLocation() throws MapRCommonSecurityException {
        String mapRFileNameSuffix_;
        String mapRDefaultKeyFileLocation_;
        String filePath = System.getenv("MAPR_TICKETFILE_LOCATION");
        if (filePath != null && !filePath.isEmpty()) {
            return filePath;
        }
        String osName = System.getProperty("os.name");
        if (osName.equalsIgnoreCase("Windows")) {
            mapRDefaultKeyFileLocation_ = System.getenv("TEMP");
            mapRFileNameSuffix_ = System.getProperty("user.name");
        } else {
            String euid_;
            mapRDefaultKeyFileLocation_ = "/tmp";
            String userName = System.getProperty("user.name");
            ArrayList<String> command = new ArrayList<String>();
            command.add("id");
            command.add("-u");
            command.add(userName);
            try {
                euid_ = this.executeCommandAndReturnOutput(command);
            }
            catch (IOException e) {
                LOG.error("Unable to obtain effective UID for user " + userName + ":" + e.getMessage());
                throw new MapRCommonSecurityException("Unable to obtain effective UID for user " + userName + ":" + e.getMessage());
            }
            catch (InterruptedException e) {
                LOG.error("Error executing command id -u " + userName + ": " + e.getMessage());
                throw new MapRCommonSecurityException("Error execuring command id -u " + userName + ": " + e.getMessage());
            }
            mapRFileNameSuffix_ = euid_;
        }
        filePath = mapRDefaultKeyFileLocation_ + File.separator + "maprticket_" + mapRFileNameSuffix_;
        return filePath;
    }

    private void parseMaprClustersConf() {
        String maprHomeDir = System.getenv("MAPR_HOME");
        String installDir = maprHomeDir != null ? (!maprHomeDir.isEmpty() ? maprHomeDir : DEFAULT_INSTALL_LOCATION) : DEFAULT_INSTALL_LOCATION;
        String clusterConfig = installDir + CLUSTER_CONFIG_LOCATION;
        try {
            String line;
            File file = new File(clusterConfig);
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            boolean firstLine = true;
            block2: while ((line = bufferedReader.readLine()) != null) {
                String[] elements = line.split(" ");
                String thisCluster = elements[0];
                if (firstLine) {
                    if (this.currentClusterName == null) {
                        this.currentClusterName = thisCluster;
                    }
                    firstLine = false;
                }
                this.clustersNamesList.add(thisCluster);
                if (!this.currentClusterName.equals(thisCluster)) continue;
                this.isClusterValid = true;
                for (int i = 1; i < elements.length; ++i) {
                    if (!elements[i].startsWith("secure=")) continue;
                    String[] secureSetting = elements[i].split("=");
                    this.isClusterSecure = false;
                    if (!secureSetting[1].equalsIgnoreCase("true")) continue block2;
                    this.isClusterSecure = true;
                    continue block2;
                }
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            LOG.error("Failed to parse mapr-clusters.conf: " + e.getMessage());
        }
    }

    private String executeCommandAndReturnOutput(ArrayList<String> command) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        StringBuilder processOutput = new StringBuilder();
        try (BufferedReader processOutputReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String readLine;
            while ((readLine = processOutputReader.readLine()) != null) {
                processOutput.append(readLine + System.lineSeparator());
            }
            process.waitFor();
        }
        return processOutput.toString().trim();
    }

    public boolean isSecurityEnabled() {
        return this.isClusterSecure;
    }

    public String getClusterName() {
        return this.currentClusterName;
    }

    public Set<String> getClustersNamesList() {
        return this.clustersNamesList;
    }

    static {
        LOG = LoggerFactory.getLogger(MapRCommonSecurityUtil.class);
        s_instance = new MapRCommonSecurityUtil();
    }
}

