/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Time;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDelegationToken {
    private static final Logger LOG = LoggerFactory.getLogger(TestDelegationToken.class);
    private static final Text KIND = new Text("MY KIND");

    @Test
    public void testSerialization() throws Exception {
        TestDelegationTokenIdentifier origToken = new TestDelegationTokenIdentifier(new Text("alice"), new Text("bob"), new Text("colin"));
        TestDelegationTokenIdentifier newToken = new TestDelegationTokenIdentifier();
        origToken.setIssueDate(123L);
        origToken.setMasterKeyId(321);
        origToken.setMaxDate(314L);
        origToken.setSequenceNumber(12345);
        DataInputBuffer inBuf = new DataInputBuffer();
        DataOutputBuffer outBuf = new DataOutputBuffer();
        origToken.write((DataOutput)outBuf);
        inBuf.reset(outBuf.getData(), 0, outBuf.getLength());
        newToken.readFields((DataInput)inBuf);
        Assert.assertEquals((Object)"alice", (Object)newToken.getUser().getUserName());
        Assert.assertEquals((Object)new Text("bob"), (Object)newToken.getRenewer());
        Assert.assertEquals((Object)"colin", (Object)newToken.getUser().getRealUser().getUserName());
        Assert.assertEquals((long)123L, (long)newToken.getIssueDate());
        Assert.assertEquals((long)321L, (long)newToken.getMasterKeyId());
        Assert.assertEquals((long)314L, (long)newToken.getMaxDate());
        Assert.assertEquals((long)12345L, (long)newToken.getSequenceNumber());
        Assert.assertEquals((Object)((Object)origToken), (Object)((Object)newToken));
    }

    private Token<TestDelegationTokenIdentifier> generateDelegationToken(TestDelegationTokenSecretManager dtSecretManager, String owner, String renewer) {
        TestDelegationTokenIdentifier dtId = new TestDelegationTokenIdentifier(new Text(owner), new Text(renewer), null);
        return new Token((TokenIdentifier)dtId, (SecretManager)dtSecretManager);
    }

    private void shouldThrow(PrivilegedExceptionAction<Object> action, Class<? extends Throwable> except) {
        try {
            action.run();
            Assert.fail((String)("action did not throw " + except));
        }
        catch (Throwable th) {
            LOG.info("Caught an exception: ", th);
            Assert.assertEquals((String)"action threw wrong exception", except, th.getClass());
        }
    }

    @Test
    public void testGetUserNullOwner() {
        TestDelegationTokenIdentifier ident = new TestDelegationTokenIdentifier(null, null, null);
        UserGroupInformation ugi = ident.getUser();
        Assert.assertNull((Object)ugi);
    }

    @Test
    public void testGetUserWithOwner() {
        TestDelegationTokenIdentifier ident = new TestDelegationTokenIdentifier(new Text("owner"), null, null);
        UserGroupInformation ugi = ident.getUser();
        Assert.assertNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)"owner", (Object)ugi.getUserName());
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.TOKEN, (Object)ugi.getAuthenticationMethod());
    }

    @Test
    public void testGetUserWithOwnerEqualsReal() {
        Text owner = new Text("owner");
        TestDelegationTokenIdentifier ident = new TestDelegationTokenIdentifier(owner, null, owner);
        UserGroupInformation ugi = ident.getUser();
        Assert.assertNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)"owner", (Object)ugi.getUserName());
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.TOKEN, (Object)ugi.getAuthenticationMethod());
    }

    @Test
    public void testGetUserWithOwnerAndReal() {
        Text owner = new Text("owner");
        Text realUser = new Text("realUser");
        TestDelegationTokenIdentifier ident = new TestDelegationTokenIdentifier(owner, null, realUser);
        UserGroupInformation ugi = ident.getUser();
        Assert.assertNotNull((Object)ugi.getRealUser());
        Assert.assertNull((Object)ugi.getRealUser().getRealUser());
        Assert.assertEquals((Object)"owner", (Object)ugi.getUserName());
        Assert.assertEquals((Object)"realUser", (Object)ugi.getRealUser().getUserName());
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.PROXY, (Object)ugi.getAuthenticationMethod());
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.TOKEN, (Object)ugi.getRealUser().getAuthenticationMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelegationTokenCount() throws Exception {
        TestDelegationTokenSecretManager dtSecretManager = new TestDelegationTokenSecretManager(86400000L, 3000L, 1000L, 3600000L);
        try {
            dtSecretManager.startThreads();
            Assertions.assertThat((long)dtSecretManager.getCurrentTokensSize()).isZero();
            Token<TestDelegationTokenIdentifier> token1 = this.generateDelegationToken(dtSecretManager, "SomeUser", "JobTracker");
            Assertions.assertThat((long)dtSecretManager.getCurrentTokensSize()).isOne();
            Token<TestDelegationTokenIdentifier> token2 = this.generateDelegationToken(dtSecretManager, "SomeUser", "JobTracker");
            Assertions.assertThat((long)dtSecretManager.getCurrentTokensSize()).isEqualTo(2L);
            dtSecretManager.cancelToken(token1, "JobTracker");
            Assertions.assertThat((long)dtSecretManager.getCurrentTokensSize()).isOne();
            dtSecretManager.cancelToken(token2, "JobTracker");
            Assertions.assertThat((long)dtSecretManager.getCurrentTokensSize()).isZero();
        }
        finally {
            dtSecretManager.stopThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelegationTokenSecretManager() throws Exception {
        final TestDelegationTokenSecretManager dtSecretManager = new TestDelegationTokenSecretManager(86400000L, 3000L, 1000L, 3600000L);
        try {
            dtSecretManager.startThreads();
            final Token<TestDelegationTokenIdentifier> token = this.generateDelegationToken(dtSecretManager, "SomeUser", "JobTracker");
            Assert.assertTrue((boolean)dtSecretManager.isStoreNewTokenCalled);
            this.shouldThrow(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    dtSecretManager.renewToken(token, "FakeRenewer");
                    return null;
                }
            }, AccessControlException.class);
            long time = dtSecretManager.renewToken(token, "JobTracker");
            Assert.assertTrue((boolean)dtSecretManager.isUpdateStoredTokenCalled);
            Assert.assertTrue((String)"renew time is in future", (time > Time.now() ? 1 : 0) != 0);
            TestDelegationTokenIdentifier identifier = new TestDelegationTokenIdentifier();
            byte[] tokenId = token.getIdentifier();
            identifier.readFields(new DataInputStream(new ByteArrayInputStream(tokenId)));
            Assert.assertTrue((null != dtSecretManager.retrievePassword(identifier) ? 1 : 0) != 0);
            LOG.info("Sleep to expire the token");
            Thread.sleep(2000L);
            try {
                dtSecretManager.retrievePassword(identifier);
                Assert.fail((String)"Token should have expired");
            }
            catch (SecretManager.InvalidToken invalidToken) {
                // empty catch block
            }
            dtSecretManager.renewToken(token, "JobTracker");
            LOG.info("Sleep beyond the max lifetime");
            Thread.sleep(2000L);
            this.shouldThrow(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    dtSecretManager.renewToken(token, "JobTracker");
                    return null;
                }
            }, SecretManager.InvalidToken.class);
        }
        finally {
            dtSecretManager.stopThreads();
        }
    }

    @Test
    public void testCancelDelegationToken() throws Exception {
        final TestDelegationTokenSecretManager dtSecretManager = new TestDelegationTokenSecretManager(86400000L, 10000L, 1000L, 3600000L);
        try {
            dtSecretManager.startThreads();
            final Token<TestDelegationTokenIdentifier> token = this.generateDelegationToken(dtSecretManager, "SomeUser", "JobTracker");
            this.shouldThrow(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    dtSecretManager.renewToken(token, "FakeCanceller");
                    return null;
                }
            }, AccessControlException.class);
            dtSecretManager.cancelToken(token, "JobTracker");
            Assert.assertTrue((boolean)dtSecretManager.isRemoveStoredTokenCalled);
            this.shouldThrow(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    dtSecretManager.renewToken(token, "JobTracker");
                    return null;
                }
            }, SecretManager.InvalidToken.class);
        }
        finally {
            dtSecretManager.stopThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testRollMasterKey() throws Exception {
        TestDelegationTokenSecretManager dtSecretManager = new TestDelegationTokenSecretManager(800L, 800L, 1000L, 3600000L);
        try {
            dtSecretManager.startThreads();
            Token<TestDelegationTokenIdentifier> token = this.generateDelegationToken(dtSecretManager, "SomeUser", "JobTracker");
            byte[] oldPasswd = token.getPassword();
            int prevNumKeys = dtSecretManager.getAllKeys().length;
            dtSecretManager.rollMasterKey();
            Assert.assertTrue((boolean)dtSecretManager.isStoreNewMasterKeyCalled);
            int currNumKeys = dtSecretManager.getAllKeys().length;
            Assertions.assertThat((int)(currNumKeys - prevNumKeys)).isGreaterThanOrEqualTo(1);
            ByteArrayInputStream bi = new ByteArrayInputStream(token.getIdentifier());
            TestDelegationTokenIdentifier identifier = dtSecretManager.createIdentifier();
            identifier.readFields(new DataInputStream(bi));
            byte[] newPasswd = dtSecretManager.retrievePassword(identifier);
            Assert.assertEquals((Object)oldPasswd, (Object)newPasswd);
            while (!dtSecretManager.isRemoveStoredMasterKeyCalled) {
                Thread.sleep(200L);
            }
        }
        finally {
            dtSecretManager.stopThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelegationTokenSelector() throws Exception {
        TestDelegationTokenSecretManager dtSecretManager = new TestDelegationTokenSecretManager(86400000L, 10000L, 1000L, 3600000L);
        try {
            dtSecretManager.startThreads();
            AbstractDelegationTokenSelector ds = new AbstractDelegationTokenSelector(KIND);
            Token<TestDelegationTokenIdentifier> token1 = this.generateDelegationToken(dtSecretManager, "SomeUser1", "JobTracker");
            token1.setService(new Text("MY-SERVICE1"));
            Token<TestDelegationTokenIdentifier> token2 = this.generateDelegationToken(dtSecretManager, "SomeUser2", "JobTracker");
            token2.setService(new Text("MY-SERVICE2"));
            ArrayList<Token<TestDelegationTokenIdentifier>> tokens = new ArrayList<Token<TestDelegationTokenIdentifier>>();
            tokens.add(token1);
            tokens.add(token2);
            Token t = ds.selectToken(new Text("MY-SERVICE1"), tokens);
            Assert.assertEquals((Object)t, token1);
        }
        finally {
            dtSecretManager.stopThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelDelegationTokenCreation() throws Exception {
        final TestDelegationTokenSecretManager dtSecretManager = new TestDelegationTokenSecretManager(2000L, 86400000L, 604800000L, 2000L);
        try {
            int i;
            dtSecretManager.startThreads();
            int numThreads = 100;
            int numTokensPerThread = 100;
            Thread[] issuers = new Thread[numThreads];
            for (i = 0; i < numThreads; ++i) {
                class TokenIssuerThread
                implements Runnable {
                    TokenIssuerThread() {
                    }

                    @Override
                    public void run() {
                        for (int i = 0; i < 100; ++i) {
                            TestDelegationToken.this.generateDelegationToken(dtSecretManager, "auser", "arenewer");
                            try {
                                Thread.sleep(250L);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                issuers[i] = new Daemon((Runnable)new TokenIssuerThread());
                issuers[i].start();
            }
            for (i = 0; i < numThreads; ++i) {
                issuers[i].join();
            }
            Map<TestDelegationTokenIdentifier, AbstractDelegationTokenSecretManager.DelegationTokenInformation> tokenCache = dtSecretManager.getAllTokens();
            Assert.assertEquals((long)(100 * numThreads), (long)tokenCache.size());
            for (TestDelegationTokenIdentifier id : tokenCache.keySet()) {
                AbstractDelegationTokenSecretManager.DelegationTokenInformation info = tokenCache.get((Object)id);
                Assert.assertTrue((info != null ? 1 : 0) != 0);
                DelegationKey key = dtSecretManager.getKey(id);
                Assert.assertTrue((key != null ? 1 : 0) != 0);
                byte[] storedPassword = dtSecretManager.retrievePassword(id);
                byte[] password = dtSecretManager.createPassword(id, key);
                Assert.assertTrue((boolean)Arrays.equals(password, storedPassword));
                dtSecretManager.verifyToken(id, password);
            }
        }
        finally {
            dtSecretManager.stopThreads();
        }
    }

    @Test
    public void testDelegationTokenNullRenewer() throws Exception {
        TestDelegationTokenSecretManager dtSecretManager = new TestDelegationTokenSecretManager(86400000L, 10000L, 1000L, 3600000L);
        dtSecretManager.startThreads();
        TestDelegationTokenIdentifier dtId = new TestDelegationTokenIdentifier(new Text("theuser"), null, null);
        Token token = new Token((TokenIdentifier)dtId, (SecretManager)dtSecretManager);
        Assert.assertTrue((token != null ? 1 : 0) != 0);
        try {
            dtSecretManager.renewToken(token, "");
            Assert.fail((String)"Renewal must not succeed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean testDelegationTokenIdentiferSerializationRoundTrip(Text owner, Text renewer, Text realUser) throws IOException {
        TestDelegationTokenIdentifier dtid = new TestDelegationTokenIdentifier(owner, renewer, realUser);
        DataOutputBuffer out = new DataOutputBuffer();
        dtid.writeImpl((DataOutput)out);
        DataInputBuffer in = new DataInputBuffer();
        in.reset(out.getData(), out.getLength());
        try {
            TestDelegationTokenIdentifier dtid2 = new TestDelegationTokenIdentifier();
            dtid2.readFields((DataInput)in);
            Assert.assertTrue((boolean)dtid.equals((Object)dtid2));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Test
    public void testSimpleDtidSerialization() throws IOException {
        Assert.assertTrue((boolean)this.testDelegationTokenIdentiferSerializationRoundTrip(new Text("owner"), new Text("renewer"), new Text("realUser")));
        Assert.assertTrue((boolean)this.testDelegationTokenIdentiferSerializationRoundTrip(new Text(""), new Text(""), new Text("")));
        Assert.assertTrue((boolean)this.testDelegationTokenIdentiferSerializationRoundTrip(new Text(""), new Text("b"), new Text("")));
    }

    @Test
    public void testOverlongDtidSerialization() throws IOException {
        byte[] bigBuf = new byte[0x100001];
        for (int i = 0; i < bigBuf.length; ++i) {
            bigBuf[i] = 0;
        }
        Assert.assertFalse((boolean)this.testDelegationTokenIdentiferSerializationRoundTrip(new Text(bigBuf), new Text("renewer"), new Text("realUser")));
        Assert.assertFalse((boolean)this.testDelegationTokenIdentiferSerializationRoundTrip(new Text("owner"), new Text(bigBuf), new Text("realUser")));
        Assert.assertFalse((boolean)this.testDelegationTokenIdentiferSerializationRoundTrip(new Text("owner"), new Text("renewer"), new Text(bigBuf)));
    }

    @Test
    public void testDelegationKeyEqualAndHash() {
        DelegationKey key1 = new DelegationKey(1111, 2222L, "keyBytes".getBytes());
        DelegationKey key2 = new DelegationKey(1111, 2222L, "keyBytes".getBytes());
        DelegationKey key3 = new DelegationKey(3333, 2222L, "keyBytes".getBytes());
        Assert.assertEquals((Object)key1, (Object)key2);
        Assert.assertFalse((boolean)key2.equals((Object)key3));
    }

    @Test
    public void testEmptyToken() throws IOException {
        Token token1 = new Token();
        Token token2 = new Token(new byte[0], new byte[0], new Text(), new Text());
        Assert.assertEquals((Object)token1, (Object)token2);
        Assert.assertEquals((Object)token1.encodeToUrlString(), (Object)token2.encodeToUrlString());
        token2 = new Token(null, null, null, null);
        Assert.assertEquals((Object)token1, (Object)token2);
        Assert.assertEquals((Object)token1.encodeToUrlString(), (Object)token2.encodeToUrlString());
    }

    public static class TokenSelector
    extends AbstractDelegationTokenSelector<TestDelegationTokenIdentifier> {
        protected TokenSelector() {
            super(KIND);
        }
    }

    public static class TestDelegationTokenSecretManager
    extends AbstractDelegationTokenSecretManager<TestDelegationTokenIdentifier> {
        public boolean isStoreNewMasterKeyCalled = false;
        public boolean isRemoveStoredMasterKeyCalled = false;
        public boolean isStoreNewTokenCalled = false;
        public boolean isRemoveStoredTokenCalled = false;
        public boolean isUpdateStoredTokenCalled = false;

        public TestDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval) {
            super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        }

        public TestDelegationTokenIdentifier createIdentifier() {
            return new TestDelegationTokenIdentifier();
        }

        protected byte[] createPassword(TestDelegationTokenIdentifier t) {
            return super.createPassword((AbstractDelegationTokenIdentifier)t);
        }

        protected void storeNewMasterKey(DelegationKey key) throws IOException {
            this.isStoreNewMasterKeyCalled = true;
            super.storeNewMasterKey(key);
        }

        protected void removeStoredMasterKey(DelegationKey key) {
            this.isRemoveStoredMasterKeyCalled = true;
            Assert.assertFalse((boolean)key.equals(this.allKeys.get(this.currentId)));
        }

        protected void storeNewToken(TestDelegationTokenIdentifier ident, long renewDate) throws IOException {
            super.storeNewToken((AbstractDelegationTokenIdentifier)ident, renewDate);
            this.isStoreNewTokenCalled = true;
        }

        protected void removeStoredToken(TestDelegationTokenIdentifier ident) throws IOException {
            super.removeStoredToken((AbstractDelegationTokenIdentifier)ident);
            this.isRemoveStoredTokenCalled = true;
        }

        protected void updateStoredToken(TestDelegationTokenIdentifier ident, long renewDate) throws IOException {
            super.updateStoredToken((AbstractDelegationTokenIdentifier)ident, renewDate);
            this.isUpdateStoredTokenCalled = true;
        }

        public byte[] createPassword(TestDelegationTokenIdentifier t, DelegationKey key) {
            return SecretManager.createPassword((byte[])t.getBytes(), (SecretKey)key.getKey());
        }

        public Map<TestDelegationTokenIdentifier, AbstractDelegationTokenSecretManager.DelegationTokenInformation> getAllTokens() {
            return this.currentTokens;
        }

        public DelegationKey getKey(TestDelegationTokenIdentifier id) {
            return (DelegationKey)this.allKeys.get(id.getMasterKeyId());
        }
    }

    public static class TestDelegationTokenIdentifier
    extends AbstractDelegationTokenIdentifier
    implements Writable {
        public TestDelegationTokenIdentifier() {
        }

        public TestDelegationTokenIdentifier(Text owner, Text renewer, Text realUser) {
            super(owner, renewer, realUser);
        }

        public Text getKind() {
            return KIND;
        }

        public void write(DataOutput out) throws IOException {
            super.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
        }
    }
}

