/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.fs.DFCachingGetSpaceUsed;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.GetSpaceUsed;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDFCachingGetSpaceUsed {
    private static final File DF_DIR = GenericTestUtils.getTestDir("testdfspace");
    public static final int FILE_SIZE = 1024;

    @Before
    public void setUp() {
        FileUtil.fullyDelete((File)DF_DIR);
        Assert.assertTrue((boolean)DF_DIR.mkdirs());
    }

    @After
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)DF_DIR);
    }

    @Test
    public void testCanBuildRun() throws Exception {
        File file = this.writeFile("testCanBuild");
        GetSpaceUsed instance = new GetSpaceUsed.Builder().setPath(file).setInterval(50060L).setKlass(DFCachingGetSpaceUsed.class).build();
        Assert.assertTrue((boolean)(instance instanceof DFCachingGetSpaceUsed));
        Assert.assertTrue((instance.getUsed() >= 1004L ? 1 : 0) != 0);
        ((DFCachingGetSpaceUsed)instance).close();
    }

    private File writeFile(String fileName) throws IOException {
        File f = new File(DF_DIR, fileName);
        Assert.assertTrue((boolean)f.createNewFile());
        RandomAccessFile randomAccessFile = new RandomAccessFile(f, "rws");
        randomAccessFile.writeUTF(RandomStringUtils.randomAlphabetic((int)1024));
        randomAccessFile.getFD().sync();
        randomAccessFile.close();
        return f;
    }
}

