/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.CommandWithDestination;
import org.apache.hadoop.fs.shell.CopyCommands;
import org.apache.hadoop.fs.shell.PathData;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestCopyFromLocal {
    private static final String FROM_DIR_NAME = "fromDir";
    private static final String TO_DIR_NAME = "toDir";
    private static FileSystem fs;
    private static Path testDir;
    private static Configuration conf;

    public static int initialize(Path dir) throws Exception {
        fs.mkdirs(dir);
        Path fromDirPath = new Path(dir, FROM_DIR_NAME);
        fs.mkdirs(fromDirPath);
        Path toDirPath = new Path(dir, TO_DIR_NAME);
        fs.mkdirs(toDirPath);
        int numTotalFiles = 0;
        int numDirs = RandomUtils.nextInt((int)0, (int)5);
        for (int dirCount = 0; dirCount < numDirs; ++dirCount) {
            Path subDirPath = new Path(fromDirPath, "subdir" + dirCount);
            fs.mkdirs(subDirPath);
            int numFiles = RandomUtils.nextInt((int)0, (int)10);
            for (int fileCount = 0; fileCount < numFiles; ++fileCount) {
                ++numTotalFiles;
                Path subFile = new Path(subDirPath, "file" + fileCount);
                fs.createNewFile(subFile);
                FSDataOutputStream output = fs.create(subFile, true);
                for (int i = 0; i < 100; ++i) {
                    output.writeInt(i);
                    output.writeChar(10);
                }
                output.close();
            }
        }
        return numTotalFiles;
    }

    @BeforeClass
    public static void init() throws Exception {
        conf = new Configuration(false);
        conf.set("fs.file.impl", LocalFileSystem.class.getName());
        fs = FileSystem.getLocal((Configuration)conf);
        testDir = new FileSystemTestHelper().getTestRootPath(fs);
        testDir = new Path(fs.makeQualified(testDir).toUri().getPath());
        FileSystem.setDefaultUri((Configuration)conf, (URI)fs.getUri());
        fs.setWorkingDirectory(testDir);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        fs.delete(testDir, true);
        fs.close();
    }

    private void run(CommandWithDestination cmd, String ... args) {
        cmd.setConf(conf);
        Assert.assertEquals((long)0L, (long)cmd.run(args));
    }

    @Test(timeout=10000L)
    public void testCopyFromLocal() throws Exception {
        Path dir = new Path("dir" + RandomStringUtils.randomNumeric((int)4));
        TestCopyFromLocal.initialize(dir);
        this.run((CommandWithDestination)new TestMultiThreadedCopy(1, 0), new Path(dir, FROM_DIR_NAME).toString(), new Path(dir, TO_DIR_NAME).toString());
    }

    @Test(timeout=10000L)
    public void testCopyFromLocalWithThreads() throws Exception {
        Path dir = new Path("dir" + RandomStringUtils.randomNumeric((int)4));
        int numFiles = TestCopyFromLocal.initialize(dir);
        int maxThreads = Runtime.getRuntime().availableProcessors() * 2;
        int randThreads = RandomUtils.nextInt((int)0, (int)(maxThreads - 1)) + 1;
        String numThreads = Integer.toString(randThreads);
        this.run((CommandWithDestination)new TestMultiThreadedCopy(randThreads, randThreads == 1 ? 0 : numFiles), "-t", numThreads, new Path(dir, FROM_DIR_NAME).toString(), new Path(dir, TO_DIR_NAME).toString());
    }

    @Test(timeout=10000L)
    public void testCopyFromLocalWithThreadWrong() throws Exception {
        Path dir = new Path("dir" + RandomStringUtils.randomNumeric((int)4));
        int numFiles = TestCopyFromLocal.initialize(dir);
        int maxThreads = Runtime.getRuntime().availableProcessors() * 2;
        String numThreads = Integer.toString(maxThreads * 2);
        this.run((CommandWithDestination)new TestMultiThreadedCopy(maxThreads, numFiles), "-t", numThreads, new Path(dir, FROM_DIR_NAME).toString(), new Path(dir, TO_DIR_NAME).toString());
    }

    @Test(timeout=10000L)
    public void testCopyFromLocalWithZeroThreads() throws Exception {
        Path dir = new Path("dir" + RandomStringUtils.randomNumeric((int)4));
        TestCopyFromLocal.initialize(dir);
        this.run((CommandWithDestination)new TestMultiThreadedCopy(1, 0), "-t", "0", new Path(dir, FROM_DIR_NAME).toString(), new Path(dir, TO_DIR_NAME).toString());
    }

    private class TestMultiThreadedCopy
    extends CopyCommands.CopyFromLocal {
        public static final String NAME = "testCopyFromLocal";
        private int expectedThreads;
        private int expectedCompletedTaskCount;

        TestMultiThreadedCopy(int expectedThreads, int expectedCompletedTaskCount) {
            this.expectedThreads = expectedThreads;
            this.expectedCompletedTaskCount = expectedCompletedTaskCount;
        }

        protected void processArguments(LinkedList<PathData> args) throws IOException {
            Assert.assertEquals((long)this.expectedThreads, (long)this.getNumThreads());
            super.processArguments(args);
            ThreadPoolExecutor executor = this.getExecutor();
            Assert.assertEquals((long)this.expectedCompletedTaskCount, (long)executor.getCompletedTaskCount());
            Assert.assertEquals((long)0L, (long)executor.getActiveCount());
            Assert.assertTrue((boolean)executor.isTerminated());
        }
    }
}

