/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.DtUtilShell;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDtUtilShell {
    private static byte[] IDENTIFIER = new byte[]{105, 100, 101, 110, 116, 105, 102, 105, 101, 114};
    private static byte[] PASSWORD = new byte[]{112, 97, 115, 115, 119, 111, 114, 100};
    private static Text KIND = new Text("testTokenKind");
    private static Text SERVICE = new Text("testTokenService");
    private static Text SERVICE2 = new Text("ecivreSnekoTtset");
    private static Configuration defaultConf = new Configuration();
    private static FileSystem localFs = null;
    private final String alias = "proxy_ip:1234";
    private final String getUrl = SERVICE_GET.toString() + "://localhost:9000/";
    private final String getUrl2 = "http://localhost:9000/";
    public static Text SERVICE_GET = new Text("testTokenServiceGet");
    public static Text KIND_GET = new Text("testTokenKindGet");
    public static Token<?> MOCK_TOKEN = new Token(IDENTIFIER, PASSWORD, KIND_GET, SERVICE_GET);
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final Path workDir = new Path(GenericTestUtils.getTestDir("TestDtUtilShell").getAbsolutePath());
    private final Path tokenFile = new Path(this.workDir, "testPrintTokenFile");
    private final Path tokenFile2 = new Path(this.workDir, "testPrintTokenFile2");
    private final Path tokenLegacyFile = new Path(this.workDir, "testPrintTokenFile3");
    private final Path tokenFileGet = new Path(this.workDir, "testGetTokenFile");
    private final String tokenFilename = this.tokenFile.toString();
    private final String tokenFilename2 = this.tokenFile2.toString();
    private final String tokenFilenameGet = this.tokenFileGet.toString();
    private String[] args = null;
    private DtUtilShell dt = null;
    private int rc = 0;

    @Before
    public void setup() throws Exception {
        localFs.mkdirs(localFs.makeQualified(this.workDir));
        this.makeTokenFile(this.tokenFile, false, null);
        this.makeTokenFile(this.tokenFile2, false, SERVICE2);
        this.makeTokenFile(this.tokenLegacyFile, true, null);
        this.dt = new DtUtilShell();
        this.dt.setConf(new Configuration());
        this.dt.setOut(new PrintStream(this.outContent));
        this.outContent.reset();
        this.rc = 0;
    }

    @After
    public void teardown() throws Exception {
        localFs.delete(localFs.makeQualified(this.workDir), true);
    }

    public void makeTokenFile(Path tokenPath, boolean legacy, Text service) throws IOException {
        if (service == null) {
            service = SERVICE;
        }
        Credentials creds = new Credentials();
        Token tok = new Token(IDENTIFIER, PASSWORD, KIND, service);
        creds.addToken(tok.getService(), tok);
        Credentials.SerializedFormat format = Credentials.SerializedFormat.PROTOBUF;
        if (legacy) {
            format = Credentials.SerializedFormat.WRITABLE;
        }
        creds.writeTokenStorageFile(tokenPath, defaultConf, format);
    }

    @Test
    public void testPrint() throws Exception {
        this.args = new String[]{"print", this.tokenFilename};
        this.rc = this.dt.run(this.args);
        Assert.assertEquals((String)"test simple print exit code", (long)0L, (long)this.rc);
        Assert.assertTrue((String)("test simple print output kind:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(KIND.toString()));
        Assert.assertTrue((String)("test simple print output service:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(SERVICE.toString()));
        this.outContent.reset();
        this.args = new String[]{"print", this.tokenLegacyFile.toString()};
        this.rc = this.dt.run(this.args);
        Assert.assertEquals((String)"test legacy print exit code", (long)0L, (long)this.rc);
        Assert.assertTrue((String)("test simple print output kind:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(KIND.toString()));
        Assert.assertTrue((String)("test simple print output service:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(SERVICE.toString()));
        this.outContent.reset();
        this.args = new String[]{"print", "-alias", SERVICE.toString(), this.tokenFilename};
        this.rc = this.dt.run(this.args);
        Assert.assertEquals((String)"test alias print exit code", (long)0L, (long)this.rc);
        Assert.assertTrue((String)("test simple print output kind:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(KIND.toString()));
        Assert.assertTrue((String)("test simple print output service:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(SERVICE.toString()));
        this.outContent.reset();
        this.args = new String[]{"print", "-alias", "not-a-serivce", this.tokenFilename};
        this.rc = this.dt.run(this.args);
        Assert.assertEquals((String)"test no alias print exit code", (long)0L, (long)this.rc);
        Assert.assertFalse((String)("test no alias print output kind:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(KIND.toString()));
        Assert.assertFalse((String)("test no alias print output service:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(SERVICE.toString()));
    }

    @Test
    public void testEdit() throws Exception {
        String oldService = SERVICE2.toString();
        String newAlias = "newName:12345";
        this.args = new String[]{"edit", "-service", oldService, "-alias", newAlias, this.tokenFilename2};
        this.rc = this.dt.run(this.args);
        Assert.assertEquals((String)"test simple edit exit code", (long)0L, (long)this.rc);
        this.args = new String[]{"print", "-alias", oldService, this.tokenFilename2};
        this.rc = this.dt.run(this.args);
        Assert.assertEquals((String)"test simple edit print old exit code", (long)0L, (long)this.rc);
        Assert.assertTrue((String)("test simple edit output kind old:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(KIND.toString()));
        Assert.assertTrue((String)("test simple edit output service old:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(oldService));
        this.args = new String[]{"print", "-alias", newAlias, this.tokenFilename2};
        this.rc = this.dt.run(this.args);
        Assert.assertEquals((String)"test simple edit print new exit code", (long)0L, (long)this.rc);
        Assert.assertTrue((String)("test simple edit output kind new:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(KIND.toString()));
        Assert.assertTrue((String)("test simple edit output service new:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(newAlias));
    }

    @Test
    public void testAppend() throws Exception {
        this.args = new String[]{"append", this.tokenFilename, this.tokenFilename2};
        this.rc = this.dt.run(this.args);
        Assert.assertEquals((String)"test simple append exit code", (long)0L, (long)this.rc);
        this.args = new String[]{"print", this.tokenFilename2};
        this.rc = this.dt.run(this.args);
        Assert.assertEquals((String)"test simple append print exit code", (long)0L, (long)this.rc);
        Assert.assertTrue((String)("test simple append output kind:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(KIND.toString()));
        Assert.assertTrue((String)("test simple append output service:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(SERVICE.toString()));
        Assert.assertTrue((String)("test simple append output service:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(SERVICE2.toString()));
    }

    @Test
    public void testRemove() throws Exception {
        this.args = new String[]{"remove", "-alias", SERVICE.toString(), this.tokenFilename};
        this.rc = this.dt.run(this.args);
        Assert.assertEquals((String)"test simple remove exit code", (long)0L, (long)this.rc);
        this.args = new String[]{"print", this.tokenFilename};
        this.rc = this.dt.run(this.args);
        Assert.assertEquals((String)"test simple remove print exit code", (long)0L, (long)this.rc);
        Assert.assertFalse((String)("test simple remove output kind:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(KIND.toString()));
        Assert.assertFalse((String)("test simple remove output service:\n" + this.outContent.toString()), (boolean)this.outContent.toString().contains(SERVICE.toString()));
    }

    @Test
    public void testGet() throws Exception {
        this.args = new String[]{"get", this.getUrl, this.tokenFilenameGet};
        this.rc = this.dt.run(this.args);
        Assert.assertEquals((String)"test mocked get exit code", (long)0L, (long)this.rc);
        this.args = new String[]{"print", this.tokenFilenameGet};
        this.rc = this.dt.run(this.args);
        String oc = this.outContent.toString();
        Assert.assertEquals((String)"test print after get exit code", (long)0L, (long)this.rc);
        Assert.assertTrue((String)("test print after get output kind:\n" + oc), (boolean)oc.contains(KIND_GET.toString()));
        Assert.assertTrue((String)("test print after get output service:\n" + oc), (boolean)oc.contains(SERVICE_GET.toString()));
    }

    @Test
    public void testGetWithServiceFlag() throws Exception {
        this.args = new String[]{"get", "http://localhost:9000/", "-service", SERVICE_GET.toString(), this.tokenFilenameGet};
        this.rc = this.dt.run(this.args);
        Assert.assertEquals((String)"test mocked get with service flag exit code", (long)0L, (long)this.rc);
        this.args = new String[]{"print", this.tokenFilenameGet};
        this.rc = this.dt.run(this.args);
        String oc = this.outContent.toString();
        Assert.assertEquals((String)"test print after get with service flag exit code", (long)0L, (long)this.rc);
        Assert.assertTrue((String)("test print after get with service flag output kind:\n" + oc), (boolean)oc.contains(KIND_GET.toString()));
        Assert.assertTrue((String)("test print after get with service flag output service:\n" + oc), (boolean)oc.contains(SERVICE_GET.toString()));
    }

    @Test
    public void testGetWithAliasFlag() throws Exception {
        this.args = new String[]{"get", this.getUrl, "-alias", "proxy_ip:1234", this.tokenFilenameGet};
        this.rc = this.dt.run(this.args);
        Assert.assertEquals((String)"test mocked get with alias flag exit code", (long)0L, (long)this.rc);
        this.args = new String[]{"print", this.tokenFilenameGet};
        this.rc = this.dt.run(this.args);
        String oc = this.outContent.toString();
        Assert.assertEquals((String)"test print after get with alias flag exit code", (long)0L, (long)this.rc);
        Assert.assertTrue((String)("test print after get with alias flag output kind:\n" + oc), (boolean)oc.contains(KIND_GET.toString()));
        Assert.assertTrue((String)("test print after get with alias flag output alias:\n" + oc), (boolean)oc.contains("proxy_ip:1234"));
        Assert.assertFalse((String)("test print after get with alias flag output old service:\n" + oc), (boolean)oc.contains(SERVICE_GET.toString()));
    }

    @Test
    public void testFormatJavaFlag() throws Exception {
        this.args = new String[]{"get", this.getUrl, "-format", "java", this.tokenFilenameGet};
        this.rc = this.dt.run(this.args);
        Assert.assertEquals((String)"test mocked get with java format flag exit code", (long)0L, (long)this.rc);
        Credentials creds = new Credentials();
        Credentials spyCreds = (Credentials)Mockito.spy((Object)creds);
        DataInputStream in = new DataInputStream(new FileInputStream(this.tokenFilenameGet));
        spyCreds.readTokenStorageStream(in);
        ((Credentials)Mockito.verify((Object)spyCreds)).readFields((DataInput)in);
    }

    @Test
    public void testFormatProtoFlag() throws Exception {
        this.args = new String[]{"get", this.getUrl, "-format", "protobuf", this.tokenFilenameGet};
        this.rc = this.dt.run(this.args);
        Assert.assertEquals((String)"test mocked get with protobuf format flag exit code", (long)0L, (long)this.rc);
        Credentials creds = new Credentials();
        Credentials spyCreds = (Credentials)Mockito.spy((Object)creds);
        DataInputStream in = new DataInputStream(new FileInputStream(this.tokenFilenameGet));
        spyCreds.readTokenStorageStream(in);
        ((Credentials)Mockito.verify((Object)spyCreds, (VerificationMode)Mockito.never())).readFields((DataInput)in);
    }

    static {
        try {
            defaultConf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
    }
}

