/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import java.io.IOException;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.TestCoderBase;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.Test;

public abstract class TestRawCoderBase
extends TestCoderBase {
    protected Class<? extends RawErasureCoderFactory> encoderFactoryClass;
    protected Class<? extends RawErasureCoderFactory> decoderFactoryClass;
    protected RawErasureEncoder encoder;
    protected RawErasureDecoder decoder;

    protected void testCodingDoMixAndTwice() {
        this.testCodingDoMixed();
        this.testCodingDoMixed();
    }

    protected void testCodingDoMixed() {
        this.testCoding(true);
        this.testCoding(false);
    }

    protected void testCoding(boolean usingDirectBuffer) {
        this.usingDirectBuffer = usingDirectBuffer;
        this.prepareCoders(true);
        this.performTestCoding(this.baseChunkSize, true, false, false, false);
        this.performTestCoding(this.baseChunkSize - 17, false, false, false, true);
        this.performTestCoding(this.baseChunkSize + 16, true, false, false, false);
    }

    protected void testCodingWithBadInput(boolean usingDirectBuffer) {
        this.usingDirectBuffer = usingDirectBuffer;
        this.prepareCoders(true);
        try {
            this.performTestCoding(this.baseChunkSize, false, true, false, true);
            Assert.fail((String)"Encoding test with bad input should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void testCodingWithBadOutput(boolean usingDirectBuffer) {
        this.usingDirectBuffer = usingDirectBuffer;
        this.prepareCoders(true);
        try {
            this.performTestCoding(this.baseChunkSize, false, false, true, true);
            Assert.fail((String)"Decoding test with bad output should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void testAfterRelease() throws Exception {
        this.prepareCoders(true);
        this.prepareBufferAllocator(true);
        this.encoder.release();
        ECChunk[] data = this.prepareDataChunksForEncoding();
        ECChunk[] parity = this.prepareParityChunksForEncoding();
        LambdaTestUtils.intercept(IOException.class, "closed", () -> this.encoder.encode(data, parity));
        this.decoder.release();
        ECChunk[] in = this.prepareInputChunksForDecoding(data, parity);
        ECChunk[] out = this.prepareOutputChunksForDecoding();
        LambdaTestUtils.intercept(IOException.class, "closed", () -> this.decoder.decode(in, this.getErasedIndexesForDecoding(), out));
    }

    @Test
    public void testCodingWithErasingTooMany() {
        try {
            this.testCoding(true);
            Assert.fail((String)"Decoding test erasing too many should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.testCoding(false);
            Assert.fail((String)"Decoding test erasing too many should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testIdempotentReleases() {
        this.prepareCoders(true);
        for (int i = 0; i < 3; ++i) {
            this.encoder.release();
            this.decoder.release();
        }
    }

    private void performTestCoding(int chunkSize, boolean usingSlicedBuffer, boolean useBadInput, boolean useBadOutput, boolean allowChangeInputs) {
        this.setChunkSize(chunkSize);
        this.prepareBufferAllocator(usingSlicedBuffer);
        this.setAllowChangeInputs(allowChangeInputs);
        this.dumpSetting();
        ECChunk[] dataChunks = this.prepareDataChunksForEncoding();
        if (useBadInput) {
            this.corruptSomeChunk(dataChunks);
        }
        this.dumpChunks("Testing data chunks", dataChunks);
        ECChunk[] parityChunks = this.prepareParityChunksForEncoding();
        ECChunk[] clonedDataChunks = this.cloneChunksWithData(dataChunks);
        this.markChunks(dataChunks);
        try {
            this.encoder.encode(dataChunks, parityChunks);
        }
        catch (IOException e) {
            Assert.fail((String)("Should not get IOException: " + e.getMessage()));
        }
        this.dumpChunks("Encoded parity chunks", parityChunks);
        if (!allowChangeInputs) {
            this.restoreChunksFromMark(dataChunks);
            this.compareAndVerify(clonedDataChunks, dataChunks);
        }
        ECChunk[] backupChunks = this.backupAndEraseChunks(clonedDataChunks, parityChunks);
        ECChunk[] inputChunks = this.prepareInputChunksForDecoding(clonedDataChunks, parityChunks);
        this.ensureOnlyLeastRequiredChunks(inputChunks);
        ECChunk[] recoveredChunks = this.prepareOutputChunksForDecoding();
        if (useBadOutput) {
            this.corruptSomeChunk(recoveredChunks);
        }
        ECChunk[] clonedInputChunks = null;
        if (!allowChangeInputs) {
            this.markChunks(inputChunks);
            clonedInputChunks = this.cloneChunksWithData(inputChunks);
        }
        this.dumpChunks("Decoding input chunks", inputChunks);
        try {
            this.decoder.decode(inputChunks, this.getErasedIndexesForDecoding(), recoveredChunks);
        }
        catch (IOException e) {
            Assert.fail((String)("Should not get IOException: " + e.getMessage()));
        }
        this.dumpChunks("Decoded/recovered chunks", recoveredChunks);
        if (!allowChangeInputs) {
            this.restoreChunksFromMark(inputChunks);
            this.compareAndVerify(clonedInputChunks, inputChunks);
        }
        this.compareAndVerify(backupChunks, recoveredChunks);
    }

    protected void setAllowChangeInputs(boolean allowChangeInputs) {
        this.allowChangeInputs = allowChangeInputs;
    }

    protected void setAllowDump(boolean allowDump) {
        this.allowDump = allowDump;
    }

    protected void prepareCoders(boolean recreate) {
        if (this.encoder == null || recreate) {
            this.encoder = this.createEncoder();
        }
        if (this.decoder == null || recreate) {
            this.decoder = this.createDecoder();
        }
    }

    protected void ensureOnlyLeastRequiredChunks(ECChunk[] inputChunks) {
        int leastRequiredNum = this.numDataUnits;
        int erasedNum = this.erasedDataIndexes.length + this.erasedParityIndexes.length;
        int goodNum = inputChunks.length - erasedNum;
        int redundantNum = goodNum - leastRequiredNum;
        for (int i = 0; i < inputChunks.length && redundantNum > 0; ++i) {
            if (inputChunks[i] == null) continue;
            inputChunks[i] = null;
            --redundantNum;
        }
    }

    protected RawErasureEncoder createEncoder() {
        ErasureCoderOptions coderConf = new ErasureCoderOptions(this.numDataUnits, this.numParityUnits, this.allowChangeInputs, this.allowDump);
        try {
            RawErasureCoderFactory factory = this.encoderFactoryClass.newInstance();
            return factory.createEncoder(coderConf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create encoder", e);
        }
    }

    protected RawErasureDecoder createDecoder() {
        ErasureCoderOptions coderConf = new ErasureCoderOptions(this.numDataUnits, this.numParityUnits, this.allowChangeInputs, this.allowDump);
        try {
            RawErasureCoderFactory factory = this.encoderFactoryClass.newInstance();
            return factory.createDecoder(coderConf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create decoder", e);
        }
    }

    protected void testInputPosition(boolean usingDirectBuffer) {
        this.usingDirectBuffer = usingDirectBuffer;
        this.prepareCoders(true);
        this.prepareBufferAllocator(false);
        ECChunk[] dataChunks = this.prepareDataChunksForEncoding();
        ECChunk[] parityChunks = this.prepareParityChunksForEncoding();
        ECChunk[] clonedDataChunks = this.cloneChunksWithData(dataChunks);
        try {
            this.encoder.encode(dataChunks, parityChunks);
        }
        catch (IOException e) {
            Assert.fail((String)("Should not get IOException: " + e.getMessage()));
        }
        this.verifyBufferPositionAtEnd(dataChunks);
        this.backupAndEraseChunks(clonedDataChunks, parityChunks);
        ECChunk[] inputChunks = this.prepareInputChunksForDecoding(clonedDataChunks, parityChunks);
        this.ensureOnlyLeastRequiredChunks(inputChunks);
        ECChunk[] recoveredChunks = this.prepareOutputChunksForDecoding();
        try {
            this.decoder.decode(inputChunks, this.getErasedIndexesForDecoding(), recoveredChunks);
        }
        catch (IOException e) {
            Assert.fail((String)("Should not get IOException: " + e.getMessage()));
        }
        this.verifyBufferPositionAtEnd(inputChunks);
    }

    private void verifyBufferPositionAtEnd(ECChunk[] inputChunks) {
        for (ECChunk chunk : inputChunks) {
            if (chunk == null) continue;
            Assert.assertEquals((long)0L, (long)chunk.getBuffer().remaining());
        }
    }
}

