/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestShutdownHookManager {
    static final Logger LOG = LoggerFactory.getLogger((String)TestShutdownHookManager.class.getName());

    @Test
    public void shutdownHookManager() {
        ShutdownHookManager mgr = ShutdownHookManager.get();
        Assert.assertNotNull((Object)mgr);
        Assert.assertEquals((long)0L, (long)mgr.getShutdownHooksInOrder().size());
        Runnable hook1 = new Runnable(){

            @Override
            public void run() {
                LOG.info("Shutdown hook1 complete.");
            }
        };
        Runnable hook2 = new Runnable(){

            @Override
            public void run() {
                LOG.info("Shutdown hook2 complete.");
            }
        };
        Runnable hook3 = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                    LOG.info("Shutdown hook3 complete.");
                }
                catch (InterruptedException ex) {
                    LOG.info("Shutdown hook3 interrupted exception:", (Object)ExceptionUtils.getStackTrace((Throwable)ex));
                    Assert.fail((String)"Hook 3 should not timeout.");
                }
            }
        };
        Runnable hook4 = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3500L);
                    LOG.info("Shutdown hook4 complete.");
                    Assert.fail((String)"Hook 4 should timeout");
                }
                catch (InterruptedException ex) {
                    LOG.info("Shutdown hook4 interrupted exception:", (Object)ExceptionUtils.getStackTrace((Throwable)ex));
                }
            }
        };
        mgr.addShutdownHook(hook1, 0);
        Assert.assertTrue((boolean)mgr.hasShutdownHook(hook1));
        Assert.assertEquals((long)1L, (long)mgr.getShutdownHooksInOrder().size());
        Assert.assertEquals((Object)hook1, (Object)((ShutdownHookManager.HookEntry)mgr.getShutdownHooksInOrder().get(0)).getHook());
        mgr.removeShutdownHook(hook1);
        Assert.assertFalse((boolean)mgr.hasShutdownHook(hook1));
        mgr.addShutdownHook(hook1, 0);
        Assert.assertTrue((boolean)mgr.hasShutdownHook(hook1));
        Assert.assertEquals((long)1L, (long)mgr.getShutdownHooksInOrder().size());
        Assert.assertTrue((boolean)mgr.hasShutdownHook(hook1));
        Assert.assertEquals((long)1L, (long)mgr.getShutdownHooksInOrder().size());
        mgr.addShutdownHook(hook2, 1);
        Assert.assertTrue((boolean)mgr.hasShutdownHook(hook1));
        Assert.assertTrue((boolean)mgr.hasShutdownHook(hook2));
        Assert.assertEquals((long)2L, (long)mgr.getShutdownHooksInOrder().size());
        Assert.assertEquals((Object)hook2, (Object)((ShutdownHookManager.HookEntry)mgr.getShutdownHooksInOrder().get(0)).getHook());
        Assert.assertEquals((Object)hook1, (Object)((ShutdownHookManager.HookEntry)mgr.getShutdownHooksInOrder().get(1)).getHook());
        mgr.addShutdownHook(hook3, 2, 4L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)mgr.hasShutdownHook(hook3));
        Assert.assertEquals((Object)hook3, (Object)((ShutdownHookManager.HookEntry)mgr.getShutdownHooksInOrder().get(0)).getHook());
        Assert.assertEquals((long)4L, (long)((ShutdownHookManager.HookEntry)mgr.getShutdownHooksInOrder().get(0)).getTimeout());
        mgr.addShutdownHook(hook4, 3, 2L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)mgr.hasShutdownHook(hook4));
        Assert.assertEquals((Object)hook4, (Object)((ShutdownHookManager.HookEntry)mgr.getShutdownHooksInOrder().get(0)).getHook());
        Assert.assertEquals((long)2L, (long)((ShutdownHookManager.HookEntry)mgr.getShutdownHooksInOrder().get(0)).getTimeout());
        LOG.info("Shutdown starts here");
    }
}

