/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RetriableException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestDefaultRetryPolicy {
    @Rule
    public Timeout timeout = new Timeout(30000);

    @Test
    public void testRetryDecisionOrdering() throws Exception {
        Assert.assertTrue((RetryPolicy.RetryAction.RetryDecision.FAIL.compareTo((Enum)RetryPolicy.RetryAction.RetryDecision.RETRY) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((RetryPolicy.RetryAction.RetryDecision.RETRY.compareTo((Enum)RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((RetryPolicy.RetryAction.RetryDecision.FAIL.compareTo((Enum)RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWithRetriable() throws Exception {
        Configuration conf = new Configuration();
        RetryPolicy policy = RetryUtils.getDefaultRetryPolicy((Configuration)conf, (String)"Test.No.Such.Key", (boolean)true, (String)"Test.No.Such.Key", (String)"10000,6", null);
        RetryPolicy.RetryAction action = policy.shouldRetry((Exception)new RetriableException("Dummy exception"), 0, 0, true);
        Assert.assertThat((Object)action.action, (Matcher)Is.is((Object)RetryPolicy.RetryAction.RetryDecision.RETRY));
    }

    @Test
    public void testWithWrappedRetriable() throws Exception {
        Configuration conf = new Configuration();
        RetryPolicy policy = RetryUtils.getDefaultRetryPolicy((Configuration)conf, (String)"Test.No.Such.Key", (boolean)true, (String)"Test.No.Such.Key", (String)"10000,6", null);
        RetryPolicy.RetryAction action = policy.shouldRetry((Exception)((Object)new RemoteException(RetriableException.class.getName(), "Dummy exception")), 0, 0, true);
        Assert.assertThat((Object)action.action, (Matcher)Is.is((Object)RetryPolicy.RetryAction.RetryDecision.RETRY));
    }

    @Test
    public void testWithRetriableAndRetryDisabled() throws Exception {
        Configuration conf = new Configuration();
        RetryPolicy policy = RetryUtils.getDefaultRetryPolicy((Configuration)conf, (String)"Test.No.Such.Key", (boolean)false, (String)"Test.No.Such.Key", (String)"10000,6", null);
        RetryPolicy.RetryAction action = policy.shouldRetry((Exception)new RetriableException("Dummy exception"), 0, 0, true);
        Assert.assertThat((Object)action.action, (Matcher)Is.is((Object)RetryPolicy.RetryAction.RetryDecision.FAIL));
    }
}

