/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.RandomDatum;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.zlib.ZlibCompressor;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestCompressionStreamReuse {
    private static final Log LOG = LogFactory.getLog(TestCompressionStreamReuse.class);
    private Configuration conf = new Configuration();
    private int count = 10000;
    private int seed = new Random().nextInt();

    @Test
    public void testBZip2Codec() throws IOException {
        this.resetStateTest(this.conf, this.seed, this.count, "org.apache.hadoop.io.compress.BZip2Codec");
    }

    @Test
    public void testGzipCompressStreamReuse() throws IOException {
        this.resetStateTest(this.conf, this.seed, this.count, "org.apache.hadoop.io.compress.GzipCodec");
    }

    @Test
    public void testGzipCompressStreamReuseWithParam() throws IOException {
        Configuration conf = new Configuration(this.conf);
        ZlibFactory.setCompressionLevel((Configuration)conf, (ZlibCompressor.CompressionLevel)ZlibCompressor.CompressionLevel.BEST_COMPRESSION);
        ZlibFactory.setCompressionStrategy((Configuration)conf, (ZlibCompressor.CompressionStrategy)ZlibCompressor.CompressionStrategy.HUFFMAN_ONLY);
        this.resetStateTest(conf, this.seed, this.count, "org.apache.hadoop.io.compress.GzipCodec");
    }

    private void resetStateTest(Configuration conf, int seed, int count, String codecClass) throws IOException {
        CompressionCodec codec = null;
        try {
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)conf.getClassByName(codecClass), (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal codec!");
        }
        LOG.info((Object)("Created a Codec object of type: " + codecClass));
        DataOutputBuffer data = new DataOutputBuffer();
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            key.write((DataOutput)data);
            value.write((DataOutput)data);
        }
        LOG.info((Object)("Generated " + count + " records"));
        DataOutputBuffer compressedDataBuffer = new DataOutputBuffer();
        DataOutputStream deflateOut = new DataOutputStream(new BufferedOutputStream((OutputStream)compressedDataBuffer));
        CompressionOutputStream deflateFilter = codec.createOutputStream((OutputStream)deflateOut);
        deflateFilter.write(data.getData(), 0, data.getLength());
        deflateFilter.finish();
        deflateFilter.flush();
        LOG.info((Object)"Finished compressing data");
        deflateFilter.resetState();
        LOG.info((Object)"Finished reseting deflator");
        data.reset();
        generator = new RandomDatum.Generator(seed);
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            key.write((DataOutput)data);
            value.write((DataOutput)data);
        }
        DataInputBuffer originalData = new DataInputBuffer();
        DataInputStream originalIn = new DataInputStream(new BufferedInputStream((InputStream)originalData));
        originalData.reset(data.getData(), 0, data.getLength());
        compressedDataBuffer.reset();
        deflateOut = new DataOutputStream(new BufferedOutputStream((OutputStream)compressedDataBuffer));
        deflateFilter = codec.createOutputStream((OutputStream)deflateOut);
        deflateFilter.write(data.getData(), 0, data.getLength());
        deflateFilter.finish();
        deflateFilter.flush();
        LOG.info((Object)"Finished re-compressing data");
        DataInputBuffer deCompressedDataBuffer = new DataInputBuffer();
        deCompressedDataBuffer.reset(compressedDataBuffer.getData(), 0, compressedDataBuffer.getLength());
        CompressionInputStream inflateFilter = codec.createInputStream((InputStream)deCompressedDataBuffer);
        DataInputStream inflateIn = new DataInputStream(new BufferedInputStream((InputStream)inflateFilter));
        for (int i = 0; i < count; ++i) {
            RandomDatum k1 = new RandomDatum();
            RandomDatum v1 = new RandomDatum();
            k1.readFields(originalIn);
            v1.readFields(originalIn);
            RandomDatum k2 = new RandomDatum();
            RandomDatum v2 = new RandomDatum();
            k2.readFields(inflateIn);
            v2.readFields(inflateIn);
            Assert.assertTrue((String)"original and compressed-then-decompressed-output not equal", (k1.equals(k2) && v1.equals(v2) ? 1 : 0) != 0);
        }
        LOG.info((Object)("SUCCESS! Completed checking " + count + " records"));
    }
}

