/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import com.google.common.collect.Lists;
import com.google.protobuf.BlockingService;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.DummySharedResource;
import org.apache.hadoop.ha.FenceMethod;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.NodeFencer;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ha.ZKFCProtocol;
import org.apache.hadoop.ha.proto.HAServiceProtocolProtos;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolPB;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolServerSideTranslatorPB;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.mockito.Mockito;

class DummyHAService
extends HAServiceTarget {
    public static final Log LOG = LogFactory.getLog(DummyHAService.class);
    private static final String DUMMY_FENCE_KEY = "dummy.fence.key";
    volatile HAServiceProtocol.HAServiceState state;
    HAServiceProtocol proxy;
    HAServiceProtocol healthMonitorProxy;
    ZKFCProtocol zkfcProxy = null;
    NodeFencer fencer;
    InetSocketAddress address;
    InetSocketAddress healthMonitorAddress;
    boolean isHealthy = true;
    boolean actUnreachable = false;
    boolean failToBecomeActive;
    boolean failToBecomeStandby;
    boolean failToFence;
    DummySharedResource sharedResource;
    public int fenceCount = 0;
    public int activeTransitionCount = 0;
    boolean testWithProtoBufRPC = false;
    static ArrayList<DummyHAService> instances = Lists.newArrayList();
    int index;

    DummyHAService(HAServiceProtocol.HAServiceState state, InetSocketAddress address) {
        this(state, address, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DummyHAService(HAServiceProtocol.HAServiceState state, InetSocketAddress address, boolean testWithProtoBufRPC) {
        this.state = state;
        this.testWithProtoBufRPC = testWithProtoBufRPC;
        this.address = testWithProtoBufRPC ? this.startAndGetRPCServerAddress(address) : address;
        Configuration conf = new Configuration();
        this.proxy = this.makeMock(conf, 45000);
        this.healthMonitorProxy = this.makeHealthMonitorMock(conf, 45000);
        try {
            conf.set(DUMMY_FENCE_KEY, DummyFencer.class.getName());
            this.fencer = (NodeFencer)Mockito.spy((Object)NodeFencer.create((Configuration)conf, (String)DUMMY_FENCE_KEY));
        }
        catch (BadFencingConfigurationException e) {
            throw new RuntimeException(e);
        }
        ArrayList<DummyHAService> arrayList = instances;
        synchronized (arrayList) {
            instances.add(this);
            this.index = instances.size();
        }
    }

    DummyHAService(HAServiceProtocol.HAServiceState state, InetSocketAddress address, InetSocketAddress healthMonitorAddress, boolean testWithProtoBufRPC) {
        this(state, address, testWithProtoBufRPC);
        this.healthMonitorAddress = testWithProtoBufRPC ? this.startAndGetRPCServerAddress(healthMonitorAddress) : healthMonitorAddress;
    }

    public void setSharedResource(DummySharedResource rsrc) {
        this.sharedResource = rsrc;
    }

    private InetSocketAddress startAndGetRPCServerAddress(InetSocketAddress serverAddress) {
        Configuration conf = new Configuration();
        try {
            RPC.setProtocolEngine((Configuration)conf, HAServiceProtocolPB.class, ProtobufRpcEngine.class);
            HAServiceProtocolServerSideTranslatorPB haServiceProtocolXlator = new HAServiceProtocolServerSideTranslatorPB((HAServiceProtocol)new MockHAProtocolImpl());
            BlockingService haPbService = HAServiceProtocolProtos.HAServiceProtocolService.newReflectiveBlockingService((HAServiceProtocolProtos.HAServiceProtocolService.BlockingInterface)haServiceProtocolXlator);
            RPC.Server server = new RPC.Builder(conf).setProtocol(HAServiceProtocolPB.class).setInstance((Object)haPbService).setBindAddress(serverAddress.getHostName()).setPort(serverAddress.getPort()).build();
            server.start();
            return NetUtils.getConnectAddress((Server)server);
        }
        catch (IOException e) {
            return null;
        }
    }

    private HAServiceProtocol makeMock(Configuration conf, int timeoutMs) {
        MockHAProtocolImpl service;
        if (!this.testWithProtoBufRPC) {
            service = new MockHAProtocolImpl();
        } else {
            try {
                service = super.getProxy(conf, timeoutMs);
            }
            catch (IOException e) {
                return null;
            }
        }
        return (HAServiceProtocol)Mockito.spy((Object)service);
    }

    private HAServiceProtocol makeHealthMonitorMock(Configuration conf, int timeoutMs) {
        MockHAProtocolImpl service;
        if (!this.testWithProtoBufRPC) {
            service = new MockHAProtocolImpl();
        } else {
            try {
                service = super.getHealthMonitorProxy(conf, timeoutMs);
            }
            catch (IOException e) {
                return null;
            }
        }
        return (HAServiceProtocol)Mockito.spy((Object)service);
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public InetSocketAddress getHealthMonitorAddress() {
        return this.healthMonitorAddress;
    }

    public InetSocketAddress getZKFCAddress() {
        return null;
    }

    public HAServiceProtocol getProxy(Configuration conf, int timeout) throws IOException {
        if (this.testWithProtoBufRPC) {
            this.proxy = this.makeMock(conf, timeout);
        }
        return this.proxy;
    }

    public HAServiceProtocol getHealthMonitorProxy(Configuration conf, int timeout) throws IOException {
        if (this.testWithProtoBufRPC) {
            this.proxy = this.makeHealthMonitorMock(conf, timeout);
        }
        return this.proxy;
    }

    public ZKFCProtocol getZKFCProxy(Configuration conf, int timeout) throws IOException {
        assert (this.zkfcProxy != null);
        return this.zkfcProxy;
    }

    public NodeFencer getFencer() {
        return this.fencer;
    }

    public void checkFencingConfigured() throws BadFencingConfigurationException {
    }

    public boolean isAutoFailoverEnabled() {
        return true;
    }

    public String toString() {
        return "DummyHAService #" + this.index;
    }

    public static HAServiceTarget getInstance(int serial) {
        return instances.get(serial - 1);
    }

    public static class DummyFencer
    implements FenceMethod {
        public void checkArgs(String args) throws BadFencingConfigurationException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryFence(HAServiceTarget target, String args) throws BadFencingConfigurationException {
            DummyHAService svc;
            LOG.info((Object)("tryFence(" + target + ")"));
            DummyHAService dummyHAService = svc = (DummyHAService)target;
            synchronized (dummyHAService) {
                ++svc.fenceCount;
            }
            if (svc.failToFence) {
                LOG.info((Object)"Injected failure to fence");
                return false;
            }
            svc.sharedResource.release(svc);
            return true;
        }
    }

    private class MockHAProtocolImpl
    implements HAServiceProtocol,
    Closeable {
        private MockHAProtocolImpl() {
        }

        public void monitorHealth() throws HealthCheckFailedException, AccessControlException, IOException {
            this.checkUnreachable();
            if (!DummyHAService.this.isHealthy) {
                throw new HealthCheckFailedException("not healthy");
            }
        }

        public void transitionToActive(HAServiceProtocol.StateChangeRequestInfo req) throws ServiceFailedException, AccessControlException, IOException {
            ++DummyHAService.this.activeTransitionCount;
            this.checkUnreachable();
            if (DummyHAService.this.failToBecomeActive) {
                throw new ServiceFailedException("injected failure");
            }
            if (DummyHAService.this.sharedResource != null) {
                DummyHAService.this.sharedResource.take(DummyHAService.this);
            }
            DummyHAService.this.state = HAServiceProtocol.HAServiceState.ACTIVE;
        }

        public void transitionToStandby(HAServiceProtocol.StateChangeRequestInfo req) throws ServiceFailedException, AccessControlException, IOException {
            this.checkUnreachable();
            if (DummyHAService.this.failToBecomeStandby) {
                throw new ServiceFailedException("injected failure");
            }
            if (DummyHAService.this.sharedResource != null) {
                DummyHAService.this.sharedResource.release(DummyHAService.this);
            }
            DummyHAService.this.state = HAServiceProtocol.HAServiceState.STANDBY;
        }

        public HAServiceStatus getServiceStatus() throws IOException {
            this.checkUnreachable();
            HAServiceStatus ret = new HAServiceStatus(DummyHAService.this.state);
            if (DummyHAService.this.state == HAServiceProtocol.HAServiceState.STANDBY || DummyHAService.this.state == HAServiceProtocol.HAServiceState.ACTIVE) {
                ret.setReadyToBecomeActive();
            }
            return ret;
        }

        private void checkUnreachable() throws IOException {
            if (DummyHAService.this.actUnreachable) {
                throw new IOException("Connection refused (fake)");
            }
        }

        @Override
        public void close() throws IOException {
        }
    }
}

