/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingService;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.ServiceException;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ClientCache;
import org.apache.hadoop.ipc.ProtocolMetaInfoPB;
import org.apache.hadoop.ipc.ProtocolProxy;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.ResponseBuffer;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.ipc.RpcEngine;
import org.apache.hadoop.ipc.RpcInvocationHandler;
import org.apache.hadoop.ipc.RpcNoSuchMethodException;
import org.apache.hadoop.ipc.RpcNoSuchProtocolException;
import org.apache.hadoop.ipc.RpcServerException;
import org.apache.hadoop.ipc.RpcWritable;
import org.apache.hadoop.ipc.protobuf.ProtobufRpcEngineProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.concurrent.AsyncGet;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

@InterfaceStability.Evolving
public class ProtobufRpcEngine
implements RpcEngine {
    public static final Log LOG = LogFactory.getLog(ProtobufRpcEngine.class);
    private static final ThreadLocal<AsyncGet<Message, Exception>> ASYNC_RETURN_MESSAGE = new ThreadLocal();
    private static final ClientCache CLIENTS;

    @InterfaceStability.Unstable
    public static AsyncGet<Message, Exception> getAsyncReturnMessage() {
        return ASYNC_RETURN_MESSAGE.get();
    }

    public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
        return this.getProxy(protocol, clientVersion, addr, ticket, conf, factory, rpcTimeout, null);
    }

    @Override
    public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, RetryPolicy connectionRetryPolicy) throws IOException {
        return this.getProxy(protocol, clientVersion, addr, ticket, conf, factory, rpcTimeout, connectionRetryPolicy, null);
    }

    @Override
    public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, RetryPolicy connectionRetryPolicy, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        Invoker invoker = new Invoker(protocol, addr, ticket, conf, factory, rpcTimeout, connectionRetryPolicy, fallbackToSimpleAuth);
        return new ProtocolProxy<Object>(protocol, Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)invoker), false);
    }

    @Override
    public ProtocolProxy<ProtocolMetaInfoPB> getProtocolMetaInfoProxy(Client.ConnectionId connId, Configuration conf, SocketFactory factory) throws IOException {
        Class<ProtocolMetaInfoPB> protocol = ProtocolMetaInfoPB.class;
        return new ProtocolProxy<ProtocolMetaInfoPB>(protocol, (ProtocolMetaInfoPB)Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new Invoker(protocol, connId, conf, factory)), false);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    static Client getClient(Configuration conf) {
        return CLIENTS.getClient(conf, SocketFactory.getDefault(), RpcWritable.Buffer.class);
    }

    @Override
    public RPC.Server getServer(Class<?> protocol, Object protocolImpl, String bindAddress, int port, int numHandlers, int numReaders, int queueSizePerHandler, boolean verbose, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, String portRangeConfig) throws IOException {
        return new Server(protocol, protocolImpl, conf, bindAddress, port, numHandlers, numReaders, queueSizePerHandler, verbose, secretManager, portRangeConfig);
    }

    static {
        org.apache.hadoop.ipc.Server.registerProtocolEngine(RPC.RpcKind.RPC_PROTOCOL_BUFFER, RpcProtobufRequest.class, new Server.ProtoBufRpcInvoker());
        CLIENTS = new ClientCache();
    }

    static class RpcProtobufRequest
    extends RpcWritable.Buffer {
        private volatile ProtobufRpcEngineProtos.RequestHeaderProto requestHeader;
        private Message payload;

        public RpcProtobufRequest() {
        }

        RpcProtobufRequest(ProtobufRpcEngineProtos.RequestHeaderProto header, Message payload) {
            this.requestHeader = header;
            this.payload = payload;
        }

        ProtobufRpcEngineProtos.RequestHeaderProto getRequestHeader() throws IOException {
            if (this.getByteBuffer() != null && this.requestHeader == null) {
                this.requestHeader = this.getValue(ProtobufRpcEngineProtos.RequestHeaderProto.getDefaultInstance());
            }
            return this.requestHeader;
        }

        @Override
        public void writeTo(ResponseBuffer out) throws IOException {
            this.requestHeader.writeDelimitedTo(out);
            if (this.payload != null) {
                this.payload.writeDelimitedTo((OutputStream)out);
            }
        }

        public String toString() {
            try {
                ProtobufRpcEngineProtos.RequestHeaderProto header = this.getRequestHeader();
                return header.getDeclaringClassProtocolName() + "." + header.getMethodName();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static class Server
    extends RPC.Server {
        public Server(Class<?> protocolClass, Object protocolImpl, Configuration conf, String bindAddress, int port, int numHandlers, int numReaders, int queueSizePerHandler, boolean verbose, SecretManager<? extends TokenIdentifier> secretManager, String portRangeConfig) throws IOException {
            super(bindAddress, port, null, numHandlers, numReaders, queueSizePerHandler, conf, Server.classNameBase(protocolImpl.getClass().getName()), secretManager, portRangeConfig);
            this.verbose = verbose;
            this.registerProtocolAndImpl(RPC.RpcKind.RPC_PROTOCOL_BUFFER, protocolClass, protocolImpl);
        }

        static class ProtoBufRpcInvoker
        implements RPC.RpcInvoker {
            ProtoBufRpcInvoker() {
            }

            private static RPC.Server.ProtoClassProtoImpl getProtocolImpl(RPC.Server server, String protoName, long clientVersion) throws RpcServerException {
                RPC.Server.ProtoNameVer pv = new RPC.Server.ProtoNameVer(protoName, clientVersion);
                RPC.Server.ProtoClassProtoImpl impl = server.getProtocolImplMap(RPC.RpcKind.RPC_PROTOCOL_BUFFER).get(pv);
                if (impl == null) {
                    RPC.Server.VerProtocolImpl highest = server.getHighestSupportedProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, protoName);
                    if (highest == null) {
                        throw new RpcNoSuchProtocolException("Unknown protocol: " + protoName);
                    }
                    throw new RPC.VersionMismatch(protoName, clientVersion, highest.version);
                }
                return impl;
            }

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Writable call(RPC.Server server, String protocol, Writable writableRequest, long receiveTime) throws Exception {
                Message result;
                RpcProtobufRequest request = (RpcProtobufRequest)writableRequest;
                ProtobufRpcEngineProtos.RequestHeaderProto rpcRequest = request.getRequestHeader();
                String methodName = rpcRequest.getMethodName();
                String protoName = rpcRequest.getDeclaringClassProtocolName();
                long clientVersion = rpcRequest.getClientProtocolVersion();
                if (server.verbose) {
                    org.apache.hadoop.ipc.Server.LOG.info((Object)("Call: protocol=" + protocol + ", method=" + methodName));
                }
                RPC.Server.ProtoClassProtoImpl protocolImpl = ProtoBufRpcInvoker.getProtocolImpl(server, protoName, clientVersion);
                BlockingService service = (BlockingService)protocolImpl.protocolImpl;
                Descriptors.MethodDescriptor methodDescriptor = service.getDescriptorForType().findMethodByName(methodName);
                if (methodDescriptor == null) {
                    String msg = "Unknown method " + methodName + " called on " + protocol + " protocol.";
                    org.apache.hadoop.ipc.Server.LOG.warn((Object)msg);
                    throw new RpcNoSuchMethodException(msg);
                }
                Message prototype = service.getRequestPrototype(methodDescriptor);
                Message param = request.getValue(prototype);
                long startTime = Time.now();
                int qTime = (int)(startTime - receiveTime);
                Exception exception = null;
                try {
                    server.rpcDetailedMetrics.init(protocolImpl.protocolClass);
                    result = service.callBlockingMethod(methodDescriptor, null, param);
                }
                catch (ServiceException e) {
                    try {
                        exception = (Exception)e.getCause();
                        throw (Exception)e.getCause();
                        catch (Exception e2) {
                            exception = e2;
                            throw e2;
                        }
                    }
                    catch (Throwable throwable) {
                        int processingTime = (int)(Time.now() - startTime);
                        if (org.apache.hadoop.ipc.Server.LOG.isDebugEnabled()) {
                            String msg = "Served: " + methodName + " queueTime= " + qTime + " procesingTime= " + processingTime;
                            if (exception != null) {
                                msg = msg + " exception= " + exception.getClass().getSimpleName();
                            }
                            org.apache.hadoop.ipc.Server.LOG.debug((Object)msg);
                        }
                        String detailedMetricsName = exception == null ? methodName : exception.getClass().getSimpleName();
                        server.updateMetrics(detailedMetricsName, qTime, processingTime);
                        throw throwable;
                    }
                }
                int processingTime = (int)(Time.now() - startTime);
                if (org.apache.hadoop.ipc.Server.LOG.isDebugEnabled()) {
                    String msg = "Served: " + methodName + " queueTime= " + qTime + " procesingTime= " + processingTime;
                    if (exception != null) {
                        msg = msg + " exception= " + exception.getClass().getSimpleName();
                    }
                    org.apache.hadoop.ipc.Server.LOG.debug((Object)msg);
                }
                String detailedMetricsName = exception == null ? methodName : exception.getClass().getSimpleName();
                server.updateMetrics(detailedMetricsName, qTime, processingTime);
                return RpcWritable.wrap(result);
            }
        }
    }

    private static class Invoker
    implements RpcInvocationHandler {
        private final Map<String, Message> returnTypes = new ConcurrentHashMap<String, Message>();
        private boolean isClosed = false;
        private final Client.ConnectionId remoteId;
        private final Client client;
        private final long clientProtocolVersion;
        private final String protocolName;
        private AtomicBoolean fallbackToSimpleAuth;

        private Invoker(Class<?> protocol, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, RetryPolicy connectionRetryPolicy, AtomicBoolean fallbackToSimpleAuth) throws IOException {
            this(protocol, Client.ConnectionId.getConnectionId(addr, protocol, ticket, rpcTimeout, connectionRetryPolicy, conf), conf, factory);
            this.fallbackToSimpleAuth = fallbackToSimpleAuth;
        }

        private Invoker(Class<?> protocol, Client.ConnectionId connId, Configuration conf, SocketFactory factory) {
            this.remoteId = connId;
            this.client = CLIENTS.getClient(conf, factory, RpcWritable.Buffer.class);
            this.protocolName = RPC.getProtocolName(protocol);
            this.clientProtocolVersion = RPC.getProtocolVersion(protocol);
        }

        private ProtobufRpcEngineProtos.RequestHeaderProto constructRpcRequestHeader(Method method) {
            ProtobufRpcEngineProtos.RequestHeaderProto.Builder builder = ProtobufRpcEngineProtos.RequestHeaderProto.newBuilder();
            builder.setMethodName(method.getName());
            builder.setDeclaringClassProtocolName(this.protocolName);
            builder.setClientProtocolVersion(this.clientProtocolVersion);
            return builder.build();
        }

        public Message invoke(Object proxy, final Method method, Object[] args) throws ServiceException {
            RpcWritable.Buffer val;
            long startTime = 0L;
            if (LOG.isDebugEnabled()) {
                startTime = Time.now();
            }
            if (args.length != 2) {
                throw new ServiceException("Too many parameters for request. Method: [" + method.getName() + "], Expected: 2, Actual: " + args.length);
            }
            if (args[1] == null) {
                throw new ServiceException("null param while calling Method: [" + method.getName() + "]");
            }
            Tracer tracer = Tracer.curThreadTracer();
            TraceScope traceScope = null;
            if (tracer != null) {
                traceScope = tracer.newScope(RpcClientUtil.methodToTraceString(method));
            }
            ProtobufRpcEngineProtos.RequestHeaderProto rpcRequestHeader = this.constructRpcRequestHeader(method);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(Thread.currentThread().getId() + ": Call -> " + this.remoteId + ": " + method.getName() + " {" + TextFormat.shortDebugString((MessageOrBuilder)((Message)args[1])) + "}"));
            }
            Message theRequest = (Message)args[1];
            try {
                val = (RpcWritable.Buffer)this.client.call(RPC.RpcKind.RPC_PROTOCOL_BUFFER, new RpcProtobufRequest(rpcRequestHeader, theRequest), this.remoteId, this.fallbackToSimpleAuth);
            }
            catch (Throwable e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(Thread.currentThread().getId() + ": Exception <- " + this.remoteId + ": " + method.getName() + " {" + e + "}"));
                }
                if (traceScope != null) {
                    traceScope.addTimelineAnnotation("Call got exception: " + e.toString());
                }
                throw new ServiceException(e);
            }
            finally {
                if (traceScope != null) {
                    traceScope.close();
                }
            }
            if (LOG.isDebugEnabled()) {
                long callTime = Time.now() - startTime;
                LOG.debug((Object)("Call: " + method.getName() + " took " + callTime + "ms"));
            }
            if (Client.isAsynchronousMode()) {
                final AsyncGet arr = Client.getAsyncRpcResponse();
                AsyncGet<Message, Exception> asyncGet = new AsyncGet<Message, Exception>(){

                    @Override
                    public Message get(long timeout, TimeUnit unit) throws Exception {
                        return Invoker.this.getReturnMessage(method, (RpcWritable.Buffer)arr.get(timeout, unit));
                    }

                    @Override
                    public boolean isDone() {
                        return arr.isDone();
                    }
                };
                ASYNC_RETURN_MESSAGE.set(asyncGet);
                return null;
            }
            return this.getReturnMessage(method, val);
        }

        private Message getReturnMessage(Method method, RpcWritable.Buffer buf) throws ServiceException {
            Message returnMessage;
            Message prototype = null;
            try {
                prototype = this.getReturnProtoType(method);
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
            try {
                returnMessage = buf.getValue(prototype.getDefaultInstanceForType());
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(Thread.currentThread().getId() + ": Response <- " + this.remoteId + ": " + method.getName() + " {" + TextFormat.shortDebugString((MessageOrBuilder)returnMessage) + "}"));
                }
            }
            catch (Throwable e) {
                throw new ServiceException(e);
            }
            return returnMessage;
        }

        @Override
        public void close() throws IOException {
            if (!this.isClosed) {
                this.isClosed = true;
                CLIENTS.stopClient(this.client);
            }
        }

        private Message getReturnProtoType(Method method) throws Exception {
            if (this.returnTypes.containsKey(method.getName())) {
                return this.returnTypes.get(method.getName());
            }
            Class<?> returnType = method.getReturnType();
            Method newInstMethod = returnType.getMethod("getDefaultInstance", new Class[0]);
            newInstMethod.setAccessible(true);
            Message prototype = (Message)newInstMethod.invoke(null, (Object[])null);
            this.returnTypes.put(method.getName(), prototype);
            return prototype;
        }

        @Override
        public Client.ConnectionId getConnectionId() {
            return this.remoteId;
        }
    }
}

