/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.ssl.SSLFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class ReloadingX509TrustManager
implements X509TrustManager,
Runnable {
    @VisibleForTesting
    static final Log LOG = LogFactory.getLog(ReloadingX509TrustManager.class);
    @VisibleForTesting
    static final String RELOAD_ERROR_MESSAGE = "Could not load truststore (keep using existing one) : ";
    private String type;
    private File file;
    private String password;
    private long lastLoaded;
    private long reloadInterval;
    private AtomicReference<X509TrustManager> trustManagerRef;
    private volatile boolean running;
    private Thread reloader;
    private static final X509Certificate[] EMPTY = new X509Certificate[0];

    public ReloadingX509TrustManager(String type, String location, String password, long reloadInterval) throws IOException, GeneralSecurityException {
        this.type = type;
        this.file = new File(location);
        this.password = password;
        this.trustManagerRef = new AtomicReference();
        this.trustManagerRef.set(this.loadTrustManager());
        this.reloadInterval = reloadInterval;
    }

    public void init() {
        this.reloader = new Thread((Runnable)this, "Truststore reloader thread");
        this.reloader.setDaemon(true);
        this.running = true;
        this.reloader.start();
    }

    public void destroy() {
        this.running = false;
        this.reloader.interrupt();
    }

    public long getReloadInterval() {
        return this.reloadInterval;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509TrustManager tm = this.trustManagerRef.get();
        if (tm == null) {
            throw new CertificateException("Unknown client chain certificate: " + chain[0].toString());
        }
        tm.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509TrustManager tm = this.trustManagerRef.get();
        if (tm == null) {
            throw new CertificateException("Unknown server chain certificate: " + chain[0].toString());
        }
        tm.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] issuers = EMPTY;
        X509TrustManager tm = this.trustManagerRef.get();
        if (tm != null) {
            issuers = tm.getAcceptedIssuers();
        }
        return issuers;
    }

    boolean needsReload() {
        boolean reload = true;
        if (this.file.exists()) {
            if (this.file.lastModified() == this.lastLoaded) {
                reload = false;
            }
        } else {
            this.lastLoaded = 0L;
        }
        return reload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    X509TrustManager loadTrustManager() throws IOException, GeneralSecurityException {
        TrustManager[] trustManagers;
        X509TrustManager trustManager = null;
        KeyStore ks = KeyStore.getInstance(this.type);
        try (FileInputStream in = new FileInputStream(this.file);){
            ks.load(in, this.password.toCharArray());
            this.lastLoaded = this.file.lastModified();
            LOG.debug((Object)("Loaded truststore '" + this.file + "'"));
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(SSLFactory.SSLCERTIFICATE);
        trustManagerFactory.init(ks);
        for (TrustManager trustManager1 : trustManagers = trustManagerFactory.getTrustManagers()) {
            if (!(trustManager1 instanceof X509TrustManager)) continue;
            trustManager = (X509TrustManager)trustManager1;
            break;
        }
        return trustManager;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(this.reloadInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.running || !this.needsReload()) continue;
            try {
                this.trustManagerRef.set(this.loadTrustManager());
            }
            catch (Exception ex) {
                LOG.warn((Object)(RELOAD_ERROR_MESSAGE + ex.toString()), (Throwable)ex);
            }
        }
    }
}

