/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.crypto.key.kms.ValueQueue;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestValueQueue {
    Logger LOG = LoggerFactory.getLogger(TestValueQueue.class);

    @Test(timeout=30000L)
    public void testInitFill() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.1f, 300L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        Assert.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assert.assertEquals((long)1L, (long)filler.getTop().num);
        vq.shutdown();
    }

    @Test(timeout=30000L)
    public void testWarmUp() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.5f, 300L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        vq.initializeQueuesForKeys(new String[]{"k1", "k2", "k3"});
        FillInfo[] fillInfos = new FillInfo[]{filler.getTop(), filler.getTop(), filler.getTop()};
        Assert.assertEquals((long)5L, (long)fillInfos[0].num);
        Assert.assertEquals((long)5L, (long)fillInfos[1].num);
        Assert.assertEquals((long)5L, (long)fillInfos[2].num);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"k1", "k2", "k3"}), (Object)Sets.newHashSet((Object[])new String[]{fillInfos[0].key, fillInfos[1].key, fillInfos[2].key}));
        vq.shutdown();
    }

    @Test(timeout=30000L)
    public void testRefill() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.1f, 300L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        Assert.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assert.assertEquals((long)1L, (long)filler.getTop().num);
        vq.getNext("k1");
        Assert.assertEquals((long)1L, (long)filler.getTop().num);
        Assert.assertEquals((long)10L, (long)filler.getTop().num);
        vq.shutdown();
    }

    @Test(timeout=30000L)
    public void testNoRefill() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.5f, 300L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        Assert.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assert.assertEquals((long)5L, (long)filler.getTop().num);
        Assert.assertEquals(null, (Object)filler.getTop());
        vq.shutdown();
    }

    @Test(timeout=30000L)
    public void testgetAtMostPolicyALL() throws Exception {
        MockFiller filler = new MockFiller();
        final ValueQueue vq = new ValueQueue(10, 0.1f, 300L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        Assert.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assert.assertEquals((long)1L, (long)filler.getTop().num);
        Assert.assertEquals((String)"Failed in sync call.", (long)10L, (long)vq.getAtMost("k1", 10).size());
        Assert.assertEquals((String)"Sync call filler got wrong number.", (long)10L, (long)filler.getTop().num);
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    int size = vq.getSize("k1");
                    if (size != 10) {
                        TestValueQueue.this.LOG.info("Current ValueQueue size is " + size);
                        return false;
                    }
                    return true;
                }
                catch (ExecutionException e) {
                    TestValueQueue.this.LOG.error("Exception when getSize.", (Throwable)e);
                    return false;
                }
            }
        }, 100, 3000);
        Assert.assertEquals((String)"Failed in async call.", (long)10L, (long)filler.getTop().num);
        Assert.assertEquals((String)"Failed to drain completely after async.", (long)10L, (long)vq.getAtMost("k1", 10).size());
        Assert.assertEquals((String)"Failed to get all 19.", (long)19L, (long)vq.getAtMost("k1", 19).size());
        Assert.assertEquals((String)"Failed in sync call.", (long)19L, (long)filler.getTop().num);
        vq.shutdown();
    }

    @Test(timeout=30000L)
    public void testgetAtMostPolicyATLEAST_ONE() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.3f, 300L, 1, ValueQueue.SyncGenerationPolicy.ATLEAST_ONE, (ValueQueue.QueueRefiller)filler);
        Assert.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assert.assertEquals((long)3L, (long)filler.getTop().num);
        Assert.assertEquals((long)2L, (long)vq.getAtMost("k1", 10).size());
        Assert.assertEquals((long)10L, (long)filler.getTop().num);
        vq.shutdown();
    }

    @Test(timeout=30000L)
    public void testgetAtMostPolicyLOW_WATERMARK() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.3f, 300L, 1, ValueQueue.SyncGenerationPolicy.LOW_WATERMARK, (ValueQueue.QueueRefiller)filler);
        Assert.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assert.assertEquals((long)3L, (long)filler.getTop().num);
        Assert.assertEquals((long)3L, (long)vq.getAtMost("k1", 10).size());
        Assert.assertEquals((long)1L, (long)filler.getTop().num);
        Assert.assertEquals((long)10L, (long)filler.getTop().num);
        vq.shutdown();
    }

    @Test(timeout=30000L)
    public void testDrain() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.1f, 300L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        Assert.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assert.assertEquals((long)1L, (long)filler.getTop().num);
        vq.drain("k1");
        Assert.assertNull((Object)filler.getTop());
        vq.shutdown();
    }

    private static class MockFiller
    implements ValueQueue.QueueRefiller<String> {
        final LinkedBlockingQueue<FillInfo> fillCalls = new LinkedBlockingQueue();

        private MockFiller() {
        }

        public void fillQueueForKey(String keyName, Queue<String> keyQueue, int numValues) throws IOException {
            this.fillCalls.add(new FillInfo(numValues, keyName));
            for (int i = 0; i < numValues; ++i) {
                keyQueue.add("test");
            }
        }

        public FillInfo getTop() throws InterruptedException {
            return this.fillCalls.poll(500L, TimeUnit.MILLISECONDS);
        }
    }

    private static class FillInfo {
        final int num;
        final String key;

        FillInfo(int num, String key) {
            this.num = num;
            this.key = key;
        }
    }
}

