/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderDelegationTokenExtension;
import org.apache.hadoop.crypto.key.UserProvider;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestKeyProviderDelegationTokenExtension {
    @Test
    public void testCreateExtension() throws Exception {
        Configuration conf = new Configuration();
        Credentials credentials = new Credentials();
        KeyProvider kp = new UserProvider.Factory().createProvider(new URI("user:///"), conf);
        KeyProviderDelegationTokenExtension kpDTE1 = KeyProviderDelegationTokenExtension.createKeyProviderDelegationTokenExtension((KeyProvider)kp);
        Assert.assertNotNull((Object)kpDTE1);
        Assert.assertNull((Object)kpDTE1.addDelegationTokens("user", credentials));
        MockKeyProvider mock = (MockKeyProvider)((Object)Mockito.mock(MockKeyProvider.class));
        Mockito.when((Object)mock.getConf()).thenReturn((Object)new Configuration());
        Mockito.when((Object)mock.addDelegationTokens("renewer", credentials)).thenReturn((Object)new Token[]{new Token(null, null, new Text("kind"), new Text("service"))});
        KeyProviderDelegationTokenExtension kpDTE2 = KeyProviderDelegationTokenExtension.createKeyProviderDelegationTokenExtension((KeyProvider)mock);
        Token[] tokens = kpDTE2.addDelegationTokens("renewer", credentials);
        Assert.assertNotNull((Object)tokens);
        Assert.assertEquals((Object)"kind", (Object)tokens[0].getKind().toString());
    }

    public static abstract class MockKeyProvider
    extends KeyProvider
    implements KeyProviderDelegationTokenExtension.DelegationTokenExtension {
        public MockKeyProvider() {
            super(new Configuration(false));
        }
    }
}

