/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.GenericsUtil;

public class TestGenericsUtil
extends TestCase {
    public void testToArray() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            list.add(i);
        }
        Integer[] arr = (Integer[])GenericsUtil.toArray(list);
        for (int i = 0; i < arr.length; ++i) {
            TestGenericsUtil.assertEquals((String)"Array has identical elements as input list", list.get(i), (Object)arr[i]);
        }
    }

    public void testWithEmptyList() {
        try {
            ArrayList list = new ArrayList();
            String[] arr = (String[])GenericsUtil.toArray(list);
            TestGenericsUtil.fail((String)"Empty array should throw exception");
            System.out.println(arr);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testWithEmptyList2() {
        ArrayList list = new ArrayList();
        String[] arr = (String[])GenericsUtil.toArray(String.class, list);
        TestGenericsUtil.assertEquals((String)"Assert list creation w/ no elements results in length 0", (int)0, (int)arr.length);
    }

    public void testWithGenericClass() {
        GenericClass<String> testSubject = new GenericClass<String>();
        testSubject.add("test1");
        testSubject.add("test2");
        try {
            String[] arr = (String[])testSubject.funcThatUsesToArray();
            TestGenericsUtil.assertEquals((String)"test1", (String)arr[0]);
            TestGenericsUtil.assertEquals((String)"test2", (String)arr[1]);
        }
        catch (ClassCastException ex) {
            TestGenericsUtil.fail((String)"GenericsUtil#toArray() is not working for generic classes");
        }
    }

    public void testGenericOptionsParser() throws Exception {
        GenericOptionsParser parser = new GenericOptionsParser(new Configuration(), new String[]{"-jt"});
        TestGenericsUtil.assertEquals((int)0, (int)parser.getRemainingArgs().length);
        parser = new GenericOptionsParser(new Configuration(), new String[]{"-Dx=y=z"});
        TestGenericsUtil.assertEquals((String)"Options parser gets entire ='s expresion", (String)"y=z", (String)parser.getConfiguration().get("x"));
    }

    public void testGetClass() {
        Integer x = new Integer(42);
        Class c = GenericsUtil.getClass((Object)x);
        TestGenericsUtil.assertEquals((String)"Correct generic type is acquired from object", Integer.class, (Object)c);
        GenericClass testSubject = new GenericClass();
        Class c2 = GenericsUtil.getClass(testSubject);
        TestGenericsUtil.assertEquals((String)"Inner generics are acquired from object.", GenericClass.class, (Object)c2);
    }

    private class GenericClass<T> {
        T dummy;
        List<T> list = new ArrayList<T>();

        private GenericClass() {
        }

        void add(T item) {
            this.list.add(item);
        }

        T[] funcThatUsesToArray() {
            Object[] arr = GenericsUtil.toArray(this.list);
            return arr;
        }
    }
}

