/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.TestRPC;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.junit.Assert;
import org.junit.Test;

public class TestServiceAuthorization {
    private static final String ACL_CONFIG = "test.protocol.acl";
    private static final String ACL_CONFIG1 = "test.protocol1.acl";

    @Test
    public void testDefaultAcl() {
        ServiceAuthorizationManager serviceAuthorizationManager = new ServiceAuthorizationManager();
        Configuration conf = new Configuration();
        conf.set(ACL_CONFIG, "user1 group1");
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        AccessControlList acl = serviceAuthorizationManager.getProtocolsAcls(TestRPC.TestProtocol.class);
        Assert.assertEquals((Object)"user1 group1", (Object)acl.getAclString());
        acl = serviceAuthorizationManager.getProtocolsAcls(TestProtocol1.class);
        Assert.assertEquals((Object)"*", (Object)acl.getAclString());
        conf.set("security.service.authorization.default.acl", "user2 group2");
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        acl = serviceAuthorizationManager.getProtocolsAcls(TestRPC.TestProtocol.class);
        Assert.assertEquals((Object)"user1 group1", (Object)acl.getAclString());
        acl = serviceAuthorizationManager.getProtocolsAcls(TestProtocol1.class);
        Assert.assertEquals((Object)"user2 group2", (Object)acl.getAclString());
    }

    private static class TestPolicyProvider
    extends PolicyProvider {
        private TestPolicyProvider() {
        }

        public Service[] getServices() {
            return new Service[]{new Service(TestServiceAuthorization.ACL_CONFIG, TestRPC.TestProtocol.class), new Service(TestServiceAuthorization.ACL_CONFIG1, TestProtocol1.class)};
        }
    }

    public static interface TestProtocol1
    extends TestRPC.TestProtocol {
    }
}

