/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCredentials {
    private static final String DEFAULT_HMAC_ALGORITHM = "HmacSHA1";
    private static final File tmpDir = new File(System.getProperty("test.build.data", "/tmp"), "mapred");
    static Text[] secret = new Text[]{new Text("secret1"), new Text("secret2"), new Text("secret3"), new Text("secret4")};
    static Text[] service = new Text[]{new Text("service1"), new Text("service2"), new Text("service3"), new Text("service4")};
    static Token<?>[] token = new Token[]{new Token(), new Token(), new Token(), new Token()};

    @Before
    public void setUp() {
        tmpDir.mkdir();
    }

    @After
    public void tearDown() {
        tmpDir.delete();
    }

    @Test
    public <T extends TokenIdentifier> void testReadWriteStorage() throws IOException, NoSuchAlgorithmException {
        Credentials ts = new Credentials();
        Token token1 = new Token();
        Token token2 = new Token();
        Text service1 = new Text("service1");
        Text service2 = new Text("service2");
        ArrayList<Text> services = new ArrayList<Text>();
        services.add(service1);
        services.add(service2);
        token1.setService(service1);
        token2.setService(service2);
        ts.addToken(new Text("sometoken1"), token1);
        ts.addToken(new Text("sometoken2"), token2);
        KeyGenerator kg = KeyGenerator.getInstance(DEFAULT_HMAC_ALGORITHM);
        String alias = "alias";
        HashMap<Text, byte[]> m = new HashMap<Text, byte[]>(10);
        for (int i = 0; i < 10; ++i) {
            SecretKey key = kg.generateKey();
            m.put(new Text(alias + i), key.getEncoded());
            ts.addSecretKey(new Text(alias + i), key.getEncoded());
        }
        File tmpFileName = new File(tmpDir, "tokenStorageTest");
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(tmpFileName));
        ts.write((DataOutput)dos);
        dos.close();
        DataInputStream dis = new DataInputStream(new FileInputStream(tmpFileName));
        ts = new Credentials();
        ts.readFields((DataInput)dis);
        dis.close();
        Collection list = ts.getAllTokens();
        Assert.assertEquals((String)"getAllTokens should return collection of size 2", (long)list.size(), (long)2L);
        boolean foundFirst = false;
        boolean foundSecond = false;
        for (Token token : list) {
            if (token.getService().equals((Object)service1)) {
                foundFirst = true;
            }
            if (!token.getService().equals((Object)service2)) continue;
            foundSecond = true;
        }
        Assert.assertTrue((String)"Tokens for services service1 and service2 must be present", (foundFirst && foundSecond ? 1 : 0) != 0);
        int mapLen = m.size();
        Assert.assertEquals((String)"wrong number of keys in the Storage", (long)mapLen, (long)ts.numberOfSecretKeys());
        for (Text a : m.keySet()) {
            byte[] kTS = ts.getSecretKey(a);
            byte[] kLocal = (byte[])m.get(a);
            Assert.assertTrue((String)("keys don't match for " + a), (WritableComparator.compareBytes((byte[])kTS, (int)0, (int)kTS.length, (byte[])kLocal, (int)0, (int)kLocal.length) == 0 ? 1 : 0) != 0);
        }
        tmpFileName.delete();
    }

    @Test
    public void addAll() {
        Credentials creds = new Credentials();
        creds.addToken(service[0], token[0]);
        creds.addToken(service[1], token[1]);
        creds.addSecretKey(secret[0], secret[0].getBytes());
        creds.addSecretKey(secret[1], secret[1].getBytes());
        Credentials credsToAdd = new Credentials();
        credsToAdd.addToken(service[0], token[3]);
        credsToAdd.addToken(service[2], token[2]);
        credsToAdd.addSecretKey(secret[0], secret[3].getBytes());
        credsToAdd.addSecretKey(secret[2], secret[2].getBytes());
        creds.addAll(credsToAdd);
        Assert.assertEquals((long)3L, (long)creds.numberOfTokens());
        Assert.assertEquals((long)3L, (long)creds.numberOfSecretKeys());
        Assert.assertEquals(token[3], (Object)creds.getToken(service[0]));
        Assert.assertEquals((Object)secret[3], (Object)new Text(creds.getSecretKey(secret[0])));
        Assert.assertEquals(token[1], (Object)creds.getToken(service[1]));
        Assert.assertEquals((Object)secret[1], (Object)new Text(creds.getSecretKey(secret[1])));
        Assert.assertEquals(token[2], (Object)creds.getToken(service[2]));
        Assert.assertEquals((Object)secret[2], (Object)new Text(creds.getSecretKey(secret[2])));
    }

    @Test
    public void mergeAll() {
        Credentials creds = new Credentials();
        creds.addToken(service[0], token[0]);
        creds.addToken(service[1], token[1]);
        creds.addSecretKey(secret[0], secret[0].getBytes());
        creds.addSecretKey(secret[1], secret[1].getBytes());
        Credentials credsToAdd = new Credentials();
        credsToAdd.addToken(service[0], token[3]);
        credsToAdd.addToken(service[2], token[2]);
        credsToAdd.addSecretKey(secret[0], secret[3].getBytes());
        credsToAdd.addSecretKey(secret[2], secret[2].getBytes());
        creds.mergeAll(credsToAdd);
        Assert.assertEquals((long)3L, (long)creds.numberOfTokens());
        Assert.assertEquals((long)3L, (long)creds.numberOfSecretKeys());
        Assert.assertEquals(token[0], (Object)creds.getToken(service[0]));
        Assert.assertEquals((Object)secret[0], (Object)new Text(creds.getSecretKey(secret[0])));
        Assert.assertEquals(token[1], (Object)creds.getToken(service[1]));
        Assert.assertEquals((Object)secret[1], (Object)new Text(creds.getSecretKey(secret[1])));
        Assert.assertEquals(token[2], (Object)creds.getToken(service[2]));
        Assert.assertEquals((Object)secret[2], (Object)new Text(creds.getSecretKey(secret[2])));
    }

    @Test
    public void testAddTokensToUGI() {
        int i;
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"someone");
        Credentials creds = new Credentials();
        for (i = 0; i < service.length; ++i) {
            creds.addToken(service[i], token[i]);
        }
        ugi.addCredentials(creds);
        creds = ugi.getCredentials();
        for (i = 0; i < service.length; ++i) {
            Assert.assertSame(token[i], (Object)creds.getToken(service[i]));
        }
        Assert.assertEquals((long)service.length, (long)creds.numberOfTokens());
    }
}

