/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolInfo;
import org.apache.hadoop.ipc.ProtocolProxy;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestProtoBufRpc;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.ipc.protobuf.TestRpcServiceProtos;
import org.apache.hadoop.net.NetUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMultipleProtocolServer {
    private static final String ADDRESS = "0.0.0.0";
    private static InetSocketAddress addr;
    private static RPC.Server server;
    private static Configuration conf;

    @Before
    public void setUp() throws Exception {
        server = new RPC.Builder(conf).setProtocol(Foo0.class).setInstance((Object)new Foo0Impl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        server.addProtocol(RPC.RpcKind.RPC_WRITABLE, Foo1.class, (Object)new Foo1Impl());
        server.addProtocol(RPC.RpcKind.RPC_WRITABLE, Bar.class, (Object)new BarImpl());
        server.addProtocol(RPC.RpcKind.RPC_WRITABLE, Mixin.class, (Object)new BarImpl());
        TestProtoBufRpc.PBServerImpl pbServerImpl = new TestProtoBufRpc.PBServerImpl();
        BlockingService service = TestRpcServiceProtos.TestProtobufRpcProto.newReflectiveBlockingService(pbServerImpl);
        server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, TestProtoBufRpc.TestRpcService.class, (Object)service);
        server.start();
        addr = NetUtils.getConnectAddress((Server)server);
    }

    @After
    public void tearDown() throws Exception {
        server.stop();
    }

    @Test
    public void test1() throws IOException {
        ProtocolProxy proxy = RPC.getProtocolProxy(Foo0.class, (long)0L, (InetSocketAddress)addr, (Configuration)conf);
        Foo0 foo0 = (Foo0)proxy.getProxy();
        Assert.assertEquals((Object)"Foo0", (Object)foo0.ping());
        proxy = RPC.getProtocolProxy(Foo1.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
        Foo1 foo1 = (Foo1)proxy.getProxy();
        Assert.assertEquals((Object)"Foo1", (Object)foo1.ping());
        Assert.assertEquals((Object)"Foo1", (Object)foo1.ping());
        proxy = RPC.getProtocolProxy(Bar.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
        Bar bar = (Bar)proxy.getProxy();
        Assert.assertEquals((long)99L, (long)bar.echo(99));
        Bar mixin = bar;
        mixin.hello();
    }

    @Test(expected=IOException.class)
    public void testNonExistingProtocol() throws IOException {
        ProtocolProxy proxy = RPC.getProtocolProxy(FooUnimplemented.class, (long)2L, (InetSocketAddress)addr, (Configuration)conf);
        FooUnimplemented foo = (FooUnimplemented)proxy.getProxy();
        foo.ping();
    }

    @Test
    public void testNonExistingProtocol2() throws IOException {
        ProtocolProxy proxy = RPC.getProtocolProxy(FooUnimplemented.class, (long)2L, (InetSocketAddress)addr, (Configuration)conf);
        FooUnimplemented foo = (FooUnimplemented)proxy.getProxy();
        Assert.assertEquals((long)1L, (long)foo.getProtocolVersion(RPC.getProtocolName(FooUnimplemented.class), 2L));
        foo.getProtocolSignature(RPC.getProtocolName(FooUnimplemented.class), 2L, 0);
    }

    @Test(expected=IOException.class)
    public void testIncorrectServerCreation() throws IOException {
        new RPC.Builder(conf).setProtocol(Foo1.class).setInstance((Object)new Foo0Impl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
    }

    @Test
    public void testPBService() throws Exception {
        Configuration conf2 = new Configuration();
        RPC.setProtocolEngine((Configuration)conf2, TestProtoBufRpc.TestRpcService.class, ProtobufRpcEngine.class);
        TestProtoBufRpc.TestRpcService client = (TestProtoBufRpc.TestRpcService)RPC.getProxy(TestProtoBufRpc.TestRpcService.class, (long)0L, (InetSocketAddress)addr, (Configuration)conf2);
        TestProtoBufRpc.testProtoBufRpc(client);
    }

    static {
        conf = new Configuration();
    }

    class BarImpl
    implements Bar {
        BarImpl() {
        }

        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 0L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            Class inter;
            try {
                inter = (Class)this.getClass().getGenericInterfaces()[0];
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            return ProtocolSignature.getProtocolSignature((int)clientMethodsHash, (long)this.getProtocolVersion(protocol, clientVersion), (Class)inter);
        }

        @Override
        public int echo(int i) {
            return i;
        }

        @Override
        public void hello() {
        }
    }

    class Foo1Impl
    implements Foo1 {
        Foo1Impl() {
        }

        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 1L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            Class inter;
            try {
                inter = (Class)this.getClass().getGenericInterfaces()[0];
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            return ProtocolSignature.getProtocolSignature((int)clientMethodsHash, (long)this.getProtocolVersion(protocol, clientVersion), (Class)inter);
        }

        @Override
        public String ping() {
            return "Foo1";
        }

        @Override
        public String ping2() {
            return "Foo1";
        }
    }

    class Foo0Impl
    implements Foo0 {
        Foo0Impl() {
        }

        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 0L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            Class inter;
            try {
                inter = (Class)this.getClass().getGenericInterfaces()[0];
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            return ProtocolSignature.getProtocolSignature((int)clientMethodsHash, (long)this.getProtocolVersion(protocol, clientVersion), (Class)inter);
        }

        @Override
        public String ping() {
            return "Foo0";
        }
    }

    static interface Bar
    extends Mixin {
        public static final long versionID = 0L;

        public int echo(int var1) throws IOException;
    }

    static interface Mixin
    extends VersionedProtocol {
        public static final long versionID = 0L;

        public void hello() throws IOException;
    }

    @ProtocolInfo(protocolName="Foo")
    static interface FooUnimplemented
    extends VersionedProtocol {
        public static final long versionID = 2L;

        public String ping() throws IOException;
    }

    @ProtocolInfo(protocolName="Foo")
    static interface Foo1
    extends VersionedProtocol {
        public static final long versionID = 1L;

        public String ping() throws IOException;

        public String ping2() throws IOException;
    }

    @ProtocolInfo(protocolName="Foo")
    static interface Foo0
    extends VersionedProtocol {
        public static final long versionID = 0L;

        public String ping() throws IOException;
    }
}

