/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DeflateCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.Lz4Codec;
import org.apache.hadoop.io.compress.SnappyCodec;

public class TestCodecFactory
extends TestCase {
    private static CompressionCodecFactory setClasses(Class[] classes) {
        Configuration conf = new Configuration();
        CompressionCodecFactory.setCodecClasses((Configuration)conf, Arrays.asList(classes));
        return new CompressionCodecFactory(conf);
    }

    private static void checkCodec(String msg, Class expected, CompressionCodec actual) {
        TestCodecFactory.assertEquals((String)(msg + " unexpected codec found"), (String)expected.getName(), (String)actual.getClass().getName());
    }

    public static void testFinding() {
        CompressionCodecFactory factory = new CompressionCodecFactory(new Configuration());
        CompressionCodec codec = factory.getCodec(new Path("/tmp/foo.bar"));
        TestCodecFactory.assertEquals((String)"default factory foo codec", null, (Object)codec);
        codec = factory.getCodecByClassName(BarCodec.class.getCanonicalName());
        TestCodecFactory.assertEquals((String)"default factory foo codec", null, (Object)codec);
        codec = factory.getCodec(new Path("/tmp/foo.gz"));
        TestCodecFactory.checkCodec("default factory for .gz", GzipCodec.class, codec);
        codec = factory.getCodecByClassName(GzipCodec.class.getCanonicalName());
        TestCodecFactory.checkCodec("default factory for gzip codec", GzipCodec.class, codec);
        codec = factory.getCodecByName("gzip");
        TestCodecFactory.checkCodec("default factory for gzip codec", GzipCodec.class, codec);
        codec = factory.getCodecByName("GZIP");
        TestCodecFactory.checkCodec("default factory for gzip codec", GzipCodec.class, codec);
        codec = factory.getCodecByName("GZIPCodec");
        TestCodecFactory.checkCodec("default factory for gzip codec", GzipCodec.class, codec);
        codec = factory.getCodecByName("gzipcodec");
        TestCodecFactory.checkCodec("default factory for gzip codec", GzipCodec.class, codec);
        Class klass = factory.getCodecClassByName("gzipcodec");
        TestCodecFactory.assertEquals(GzipCodec.class, (Object)klass);
        codec = factory.getCodec(new Path("/tmp/foo.bz2"));
        TestCodecFactory.checkCodec("default factory for .bz2", BZip2Codec.class, codec);
        codec = factory.getCodecByClassName(BZip2Codec.class.getCanonicalName());
        TestCodecFactory.checkCodec("default factory for bzip2 codec", BZip2Codec.class, codec);
        codec = factory.getCodecByName("bzip2");
        TestCodecFactory.checkCodec("default factory for bzip2 codec", BZip2Codec.class, codec);
        codec = factory.getCodecByName("bzip2codec");
        TestCodecFactory.checkCodec("default factory for bzip2 codec", BZip2Codec.class, codec);
        codec = factory.getCodecByName("BZIP2");
        TestCodecFactory.checkCodec("default factory for bzip2 codec", BZip2Codec.class, codec);
        codec = factory.getCodecByName("BZIP2CODEC");
        TestCodecFactory.checkCodec("default factory for bzip2 codec", BZip2Codec.class, codec);
        codec = factory.getCodecByClassName(DeflateCodec.class.getCanonicalName());
        TestCodecFactory.checkCodec("default factory for deflate codec", DeflateCodec.class, codec);
        codec = factory.getCodecByName("deflate");
        TestCodecFactory.checkCodec("default factory for deflate codec", DeflateCodec.class, codec);
        codec = factory.getCodecByName("deflatecodec");
        TestCodecFactory.checkCodec("default factory for deflate codec", DeflateCodec.class, codec);
        codec = factory.getCodecByName("DEFLATE");
        TestCodecFactory.checkCodec("default factory for deflate codec", DeflateCodec.class, codec);
        codec = factory.getCodecByName("DEFLATECODEC");
        TestCodecFactory.checkCodec("default factory for deflate codec", DeflateCodec.class, codec);
        factory = TestCodecFactory.setClasses(new Class[0]);
        codec = factory.getCodec(new Path("/tmp/foo.bar"));
        TestCodecFactory.assertEquals((String)"empty factory bar codec", null, (Object)codec);
        codec = factory.getCodecByClassName(BarCodec.class.getCanonicalName());
        TestCodecFactory.assertEquals((String)"empty factory bar codec", null, (Object)codec);
        codec = factory.getCodec(new Path("/tmp/foo.gz"));
        TestCodecFactory.checkCodec("empty factory gz codec", GzipCodec.class, codec);
        codec = factory.getCodecByClassName(GzipCodec.class.getCanonicalName());
        TestCodecFactory.checkCodec("empty factory gz codec", GzipCodec.class, codec);
        codec = factory.getCodec(new Path("/tmp/foo.bz2"));
        TestCodecFactory.checkCodec("empty factory for .bz2", BZip2Codec.class, codec);
        codec = factory.getCodecByClassName(BZip2Codec.class.getCanonicalName());
        TestCodecFactory.checkCodec("empty factory for bzip2 codec", BZip2Codec.class, codec);
        codec = factory.getCodec(new Path("/tmp/foo.snappy"));
        TestCodecFactory.checkCodec("empty factory snappy codec", SnappyCodec.class, codec);
        codec = factory.getCodecByClassName(SnappyCodec.class.getCanonicalName());
        TestCodecFactory.checkCodec("empty factory snappy codec", SnappyCodec.class, codec);
        codec = factory.getCodec(new Path("/tmp/foo.lz4"));
        TestCodecFactory.checkCodec("empty factory lz4 codec", Lz4Codec.class, codec);
        codec = factory.getCodecByClassName(Lz4Codec.class.getCanonicalName());
        TestCodecFactory.checkCodec("empty factory lz4 codec", Lz4Codec.class, codec);
        factory = TestCodecFactory.setClasses(new Class[]{BarCodec.class, FooCodec.class, FooBarCodec.class});
        codec = factory.getCodec(new Path("/tmp/.foo.bar.gz"));
        TestCodecFactory.checkCodec("full factory gz codec", GzipCodec.class, codec);
        codec = factory.getCodecByClassName(GzipCodec.class.getCanonicalName());
        TestCodecFactory.checkCodec("full codec gz codec", GzipCodec.class, codec);
        codec = factory.getCodec(new Path("/tmp/foo.bz2"));
        TestCodecFactory.checkCodec("full factory for .bz2", BZip2Codec.class, codec);
        codec = factory.getCodecByClassName(BZip2Codec.class.getCanonicalName());
        TestCodecFactory.checkCodec("full codec bzip2 codec", BZip2Codec.class, codec);
        codec = factory.getCodec(new Path("/tmp/foo.bar"));
        TestCodecFactory.checkCodec("full factory bar codec", BarCodec.class, codec);
        codec = factory.getCodecByClassName(BarCodec.class.getCanonicalName());
        TestCodecFactory.checkCodec("full factory bar codec", BarCodec.class, codec);
        codec = factory.getCodecByName("bar");
        TestCodecFactory.checkCodec("full factory bar codec", BarCodec.class, codec);
        codec = factory.getCodecByName("BAR");
        TestCodecFactory.checkCodec("full factory bar codec", BarCodec.class, codec);
        codec = factory.getCodec(new Path("/tmp/foo/baz.foo.bar"));
        TestCodecFactory.checkCodec("full factory foo bar codec", FooBarCodec.class, codec);
        codec = factory.getCodecByClassName(FooBarCodec.class.getCanonicalName());
        TestCodecFactory.checkCodec("full factory foo bar codec", FooBarCodec.class, codec);
        codec = factory.getCodecByName("foobar");
        TestCodecFactory.checkCodec("full factory foo bar codec", FooBarCodec.class, codec);
        codec = factory.getCodecByName("FOOBAR");
        TestCodecFactory.checkCodec("full factory foo bar codec", FooBarCodec.class, codec);
        codec = factory.getCodec(new Path("/tmp/foo.foo"));
        TestCodecFactory.checkCodec("full factory foo codec", FooCodec.class, codec);
        codec = factory.getCodecByClassName(FooCodec.class.getCanonicalName());
        TestCodecFactory.checkCodec("full factory foo codec", FooCodec.class, codec);
        codec = factory.getCodecByName("foo");
        TestCodecFactory.checkCodec("full factory foo codec", FooCodec.class, codec);
        codec = factory.getCodecByName("FOO");
        TestCodecFactory.checkCodec("full factory foo codec", FooCodec.class, codec);
        factory = TestCodecFactory.setClasses(new Class[]{NewGzipCodec.class});
        codec = factory.getCodec(new Path("/tmp/foo.gz"));
        TestCodecFactory.checkCodec("overridden factory for .gz", NewGzipCodec.class, codec);
        codec = factory.getCodecByClassName(NewGzipCodec.class.getCanonicalName());
        TestCodecFactory.checkCodec("overridden factory for gzip codec", NewGzipCodec.class, codec);
        Configuration conf = new Configuration();
        conf.set("io.compression.codecs", "   org.apache.hadoop.io.compress.GzipCodec   ,     org.apache.hadoop.io.compress.DefaultCodec  ,  org.apache.hadoop.io.compress.BZip2Codec   ");
        try {
            CompressionCodecFactory.getCodecClasses((Configuration)conf);
        }
        catch (IllegalArgumentException e) {
            TestCodecFactory.fail((String)"IllegalArgumentException is unexpected");
        }
    }

    private static class NewGzipCodec
    extends BaseCodec {
        private NewGzipCodec() {
        }

        @Override
        public String getDefaultExtension() {
            return ".gz";
        }
    }

    private static class FooCodec
    extends BaseCodec {
        private FooCodec() {
        }

        @Override
        public String getDefaultExtension() {
            return ".foo";
        }
    }

    private static class FooBarCodec
    extends BaseCodec {
        private FooBarCodec() {
        }

        @Override
        public String getDefaultExtension() {
            return ".foo.bar";
        }
    }

    private static class BarCodec
    extends BaseCodec {
        private BarCodec() {
        }

        @Override
        public String getDefaultExtension() {
            return "bar";
        }
    }

    private static class BaseCodec
    implements CompressionCodec {
        private Configuration conf;

        private BaseCodec() {
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        public Configuration getConf() {
            return this.conf;
        }

        public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
            return null;
        }

        public Class<? extends Compressor> getCompressorType() {
            return null;
        }

        public Compressor createCompressor() {
            return null;
        }

        public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
            return null;
        }

        public CompressionInputStream createInputStream(InputStream in) throws IOException {
            return null;
        }

        public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
            return null;
        }

        public Class<? extends Decompressor> getDecompressorType() {
            return null;
        }

        public Decompressor createDecompressor() {
            return null;
        }

        public String getDefaultExtension() {
            return ".base";
        }
    }
}

