/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.apache.hadoop.net.NetUtils;
import org.junit.Test;

public class TestPathFilter
extends HttpServerFunctionalTest {
    static final Log LOG = LogFactory.getLog(HttpServer2.class);
    static final Set<String> RECORDS = new TreeSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void access(String urlstring) throws IOException {
        LOG.warn((Object)("access " + urlstring));
        URL url = new URL(urlstring);
        URLConnection connection = url.openConnection();
        connection.connect();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            try {
                while (in.readLine() != null) {
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)("urlstring=" + urlstring), (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPathSpecFilters() throws Exception {
        int i;
        Configuration conf = new Configuration();
        conf.set("hadoop.http.filter.initializers", RecordingFilter.Initializer.class.getName());
        String[] pathSpecs = new String[]{"/path", "/path/*"};
        HttpServer2 http = TestPathFilter.createTestServer(conf, pathSpecs);
        http.start();
        String baseURL = "/path";
        String baseSlashURL = "/path/";
        String addedURL = "/path/nodes";
        String addedSlashURL = "/path/nodes/";
        String longURL = "/path/nodes/foo/job";
        String rootURL = "/";
        String allURL = "/*";
        String[] filteredUrls = new String[]{"/path", "/path/", "/path/nodes", "/path/nodes/", "/path/nodes/foo/job"};
        String[] notFilteredUrls = new String[]{"/", "/*"};
        String prefix = "http://" + NetUtils.getHostPortString((InetSocketAddress)http.getConnectorAddress(0));
        try {
            for (i = 0; i < filteredUrls.length; ++i) {
                TestPathFilter.access(prefix + filteredUrls[i]);
            }
            for (i = 0; i < notFilteredUrls.length; ++i) {
                TestPathFilter.access(prefix + notFilteredUrls[i]);
            }
        }
        finally {
            http.stop();
        }
        LOG.info((Object)("RECORDS = " + RECORDS));
        for (i = 0; i < filteredUrls.length; ++i) {
            TestPathFilter.assertTrue((boolean)RECORDS.remove(filteredUrls[i]));
        }
        TestPathFilter.assertTrue((boolean)RECORDS.isEmpty());
    }

    public static class RecordingFilter
    implements Filter {
        private FilterConfig filterConfig = null;

        public void init(FilterConfig filterConfig) {
            this.filterConfig = filterConfig;
        }

        public void destroy() {
            this.filterConfig = null;
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (this.filterConfig == null) {
                return;
            }
            String uri = ((HttpServletRequest)request).getRequestURI();
            LOG.info((Object)("filtering " + uri));
            RECORDS.add(uri);
            chain.doFilter(request, response);
        }

        public static class Initializer
        extends FilterInitializer {
            public void initFilter(FilterContainer container, Configuration conf) {
                container.addFilter("recording", RecordingFilter.class.getName(), null);
            }
        }
    }
}

