/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.ClientHandlerException;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.UniformInterfaceException;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.ws.rs.WebApplicationException;
import org.apache.hadoop.shaded.javax.ws.rs.core.GenericEntity;
import org.apache.hadoop.shaded.javax.ws.rs.core.Response;
import org.apache.hadoop.shaded.javax.ws.rs.core.StreamingOutput;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONException;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.logaggregation.ContainerLogAggregationType;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.server.webapp.AppInfoProvider;
import org.apache.hadoop.yarn.server.webapp.BasicAppInfo;
import org.apache.hadoop.yarn.server.webapp.LogWebServiceUtils;
import org.apache.hadoop.yarn.server.webapp.WrappedLogMetaRequest;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerLogsInfo;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogServlet
extends Configured {
    private static final Logger LOG = LoggerFactory.getLogger(LogServlet.class);
    private static final Joiner JOINER = Joiner.on((String)"");
    private static final String NM_DOWNLOAD_URI_STR = "/ws/v1/node/containers";
    private LogAggregationFileControllerFactory factoryInstance = null;
    private final AppInfoProvider appInfoProvider;

    public LogServlet(Configuration conf, AppInfoProvider appInfoProvider) {
        super(conf);
        this.appInfoProvider = appInfoProvider;
    }

    private LogAggregationFileControllerFactory getOrCreateFactory() {
        if (this.factoryInstance != null) {
            return this.factoryInstance;
        }
        this.factoryInstance = new LogAggregationFileControllerFactory(this.getConf());
        return this.factoryInstance;
    }

    @VisibleForTesting
    public String getNMWebAddressFromRM(String nodeId) throws ClientHandlerException, UniformInterfaceException, JSONException {
        return LogWebServiceUtils.getNMWebAddressFromRM(this.getConf(), nodeId);
    }

    private static List<ContainerLogsInfo> convertToContainerLogsInfo(List<ContainerLogMeta> containerLogMetas, boolean emptyLocalContainerLogMeta) {
        ArrayList<ContainerLogsInfo> containersLogsInfo = new ArrayList<ContainerLogsInfo>();
        for (ContainerLogMeta meta : containerLogMetas) {
            ContainerLogsInfo logInfo = new ContainerLogsInfo(meta, ContainerLogAggregationType.AGGREGATED);
            containersLogsInfo.add(logInfo);
            if (!emptyLocalContainerLogMeta) continue;
            ContainerLogMeta emptyMeta = new ContainerLogMeta(logInfo.getContainerId(), logInfo.getNodeId() == null ? "N/A" : logInfo.getNodeId());
            ContainerLogsInfo empty = new ContainerLogsInfo(emptyMeta, ContainerLogAggregationType.LOCAL);
            containersLogsInfo.add(empty);
        }
        return containersLogsInfo;
    }

    private static Response getContainerLogMeta(WrappedLogMetaRequest request, boolean emptyLocalContainerLogMeta) {
        try {
            List<ContainerLogMeta> containerLogMeta = request.getContainerLogMetas();
            if (containerLogMeta.isEmpty()) {
                throw new NotFoundException("Can not get log meta for request.");
            }
            List<ContainerLogsInfo> containersLogsInfo = LogServlet.convertToContainerLogsInfo(containerLogMeta, emptyLocalContainerLogMeta);
            GenericEntity<List<ContainerLogsInfo>> meta = new GenericEntity<List<ContainerLogsInfo>>(containersLogsInfo){};
            Response.ResponseBuilder response = Response.ok((Object)meta);
            response.header("X-Content-Type-Options", (Object)"nosniff");
            return response.build();
        }
        catch (Exception ex) {
            LOG.debug("Exception during request", (Throwable)ex);
            throw new WebApplicationException((Throwable)ex);
        }
    }

    private void validateUserInput(ApplicationId applicationId, ApplicationAttemptId applicationAttemptId, ContainerId containerId) {
        if (applicationId == null && applicationAttemptId == null && containerId == null) {
            throw new IllegalArgumentException("Should set application id, application attempt id or container id.");
        }
        if (containerId != null) {
            if (applicationAttemptId != null && !applicationAttemptId.equals((Object)containerId.getApplicationAttemptId())) {
                throw new IllegalArgumentException(String.format("Container %s does not belong to application attempt %s!", containerId, applicationAttemptId));
            }
            if (applicationId != null && !applicationId.equals((Object)containerId.getApplicationAttemptId().getApplicationId())) {
                throw new IllegalArgumentException(String.format("Container %s does not belong to application %s!", containerId, applicationId));
            }
        }
        if (applicationAttemptId != null && applicationId != null && !applicationId.equals((Object)applicationAttemptId.getApplicationId())) {
            throw new IllegalArgumentException(String.format("Application attempt %s does not belong to application %s!", applicationAttemptId, applicationId));
        }
    }

    public Response getLogsInfo(HttpServletRequest hsr, String appIdStr, String appAttemptIdStr, String containerIdStr, String nmId, boolean redirectedFromNode, boolean manualRedirection) {
        ApplicationId appId = null;
        if (appIdStr != null) {
            try {
                appId = ApplicationId.fromString((String)appIdStr);
            }
            catch (IllegalArgumentException iae) {
                throw new BadRequestException((Throwable)iae);
            }
        }
        ApplicationAttemptId appAttemptId = null;
        if (appAttemptIdStr != null) {
            try {
                appAttemptId = ApplicationAttemptId.fromString((String)appAttemptIdStr);
            }
            catch (IllegalArgumentException iae) {
                throw new BadRequestException((Throwable)iae);
            }
        }
        ContainerId containerId = null;
        if (containerIdStr != null) {
            try {
                containerId = ContainerId.fromString((String)containerIdStr);
            }
            catch (IllegalArgumentException iae) {
                throw new BadRequestException((Throwable)iae);
            }
        }
        this.validateUserInput(appId, appAttemptId, containerId);
        WrappedLogMetaRequest.Builder logMetaRequestBuilder = WrappedLogMetaRequest.builder().setApplicationId(appId).setApplicationAttemptId(appAttemptId).setContainerId(containerIdStr);
        return this.getContainerLogsInfo(hsr, logMetaRequestBuilder, nmId, redirectedFromNode, null, manualRedirection);
    }

    public Response getContainerLogsInfo(HttpServletRequest req, WrappedLogMetaRequest.Builder builder, String nmId, boolean redirectedFromNode, String clusterId, boolean manualRedirection) {
        BasicAppInfo appInfo;
        builder.setFactory(this.getOrCreateFactory());
        try {
            appInfo = this.appInfoProvider.getApp(req, builder.getAppId(), clusterId);
        }
        catch (Exception ex) {
            LOG.warn("Could not obtain appInfo object from provider.", (Throwable)ex);
            return LogServlet.getContainerLogMeta(builder.build(), false);
        }
        if (Apps.isApplicationFinalState((YarnApplicationState)appInfo.getAppState())) {
            return LogServlet.getContainerLogMeta(builder.build(), false);
        }
        if (LogWebServiceUtils.isRunningState(appInfo.getAppState())) {
            ContainerId containerId;
            String appOwner = appInfo.getUser();
            builder.setAppOwner(appOwner);
            WrappedLogMetaRequest request = builder.build();
            String nodeHttpAddress = null;
            if (nmId != null && !nmId.isEmpty()) {
                try {
                    nodeHttpAddress = this.getNMWebAddressFromRM(nmId);
                }
                catch (Exception ex) {
                    LOG.info("Exception during getting NM web address.", (Throwable)ex);
                }
            }
            if (nodeHttpAddress == null || nodeHttpAddress.isEmpty()) {
                if (request.getContainerId() != null) {
                    try {
                        nodeHttpAddress = this.appInfoProvider.getNodeHttpAddress(req, request.getAppId(), request.getAppAttemptId(), request.getContainerId().toString(), clusterId);
                    }
                    catch (Exception ex) {
                        LOG.warn("Could not obtain node HTTP address from provider.", (Throwable)ex);
                        return LogServlet.getContainerLogMeta(request, true);
                    }
                }
                if (nodeHttpAddress == null || nodeHttpAddress.isEmpty() || redirectedFromNode) {
                    return LogServlet.getContainerLogMeta(request, true);
                }
            }
            if ((containerId = request.getContainerId()) == null) {
                throw new WebApplicationException((Throwable)new Exception("Could not redirect to node, as app attempt or application logs are requested."));
            }
            String uri = "/" + containerId.toString() + "/logs";
            String resURI = JOINER.join((Object)LogWebServiceUtils.getAbsoluteNMWebAddress(this.getConf(), nodeHttpAddress), (Object)NM_DOWNLOAD_URI_STR, new Object[]{uri});
            String query = req.getQueryString();
            if (query != null && !query.isEmpty()) {
                resURI = resURI + "?" + query;
            }
            if (manualRedirection) {
                return LogServlet.createLocationResponse(resURI, LogServlet.createEmptyLogsInfo());
            }
            Response.ResponseBuilder response = Response.status((int)307);
            response.header("Location", (Object)resURI);
            return response.build();
        }
        throw new NotFoundException("The application is not at Running or Finished State.");
    }

    private static <T> Response createLocationResponse(String uri, T emptyPayload) {
        Response.ResponseBuilder response = Response.status((int)200).entity(emptyPayload);
        response.header("Location", (Object)uri);
        response.header("Access-Control-Expose-Headers", (Object)"Location");
        return response.build();
    }

    private static GenericEntity<List<ContainerLogsInfo>> createEmptyLogsInfo() {
        return new GenericEntity((Object)Collections.EMPTY_LIST, List.class);
    }

    private static StreamingOutput createEmptyStream() {
        return outputStream -> outputStream.write("".getBytes(StandardCharsets.UTF_8));
    }

    public Response getLogFile(HttpServletRequest req, String containerIdStr, String filename, String format, String size, String nmId, boolean redirectedFromNode, String clusterId, boolean manualRedirection) {
        BasicAppInfo appInfo;
        ContainerId containerId;
        try {
            containerId = ContainerId.fromString((String)containerIdStr);
        }
        catch (IllegalArgumentException ex) {
            return LogWebServiceUtils.createBadResponse(Response.Status.NOT_FOUND, "Invalid ContainerId: " + containerIdStr);
        }
        LogAggregationFileControllerFactory factory = this.getOrCreateFactory();
        long length = LogWebServiceUtils.parseLongParam(size);
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        try {
            appInfo = this.appInfoProvider.getApp(req, appId.toString(), clusterId);
        }
        catch (Exception ex) {
            LOG.warn("Could not obtain appInfo object from provider.", (Throwable)ex);
            return LogWebServiceUtils.sendStreamOutputResponse(factory, appId, null, null, containerIdStr, filename, format, length, false);
        }
        String appOwner = appInfo.getUser();
        if (Apps.isApplicationFinalState((YarnApplicationState)appInfo.getAppState())) {
            return LogWebServiceUtils.sendStreamOutputResponse(factory, appId, appOwner, null, containerIdStr, filename, format, length, false);
        }
        if (LogWebServiceUtils.isRunningState(appInfo.getAppState())) {
            String nodeHttpAddress = null;
            if (nmId != null && !nmId.isEmpty()) {
                try {
                    nodeHttpAddress = this.getNMWebAddressFromRM(nmId);
                }
                catch (Exception ex) {
                    LOG.debug("Exception happened during obtaining NM web address from RM.", (Throwable)ex);
                }
            }
            if (nodeHttpAddress == null || nodeHttpAddress.isEmpty()) {
                try {
                    nodeHttpAddress = this.appInfoProvider.getNodeHttpAddress(req, appId.toString(), containerId.getApplicationAttemptId().toString(), containerId.toString(), clusterId);
                }
                catch (Exception ex) {
                    LOG.warn("Could not obtain node HTTP address from provider.", (Throwable)ex);
                    return LogWebServiceUtils.sendStreamOutputResponse(factory, appId, appOwner, null, containerIdStr, filename, format, length, true);
                }
                if (nodeHttpAddress == null || nodeHttpAddress.isEmpty() || redirectedFromNode) {
                    return LogWebServiceUtils.sendStreamOutputResponse(factory, appId, appOwner, null, containerIdStr, filename, format, length, true);
                }
            }
            String uri = "/" + containerId.toString() + "/logs/" + filename;
            String resURI = JOINER.join((Object)LogWebServiceUtils.getAbsoluteNMWebAddress(this.getConf(), nodeHttpAddress), (Object)NM_DOWNLOAD_URI_STR, new Object[]{uri});
            String query = req.getQueryString();
            if (query != null && !query.isEmpty()) {
                resURI = resURI + "?" + query;
            }
            if (manualRedirection) {
                return LogServlet.createLocationResponse(resURI, LogServlet.createEmptyStream());
            }
            Response.ResponseBuilder response = Response.status((int)307);
            response.header("Location", (Object)resURI);
            return response.build();
        }
        return LogWebServiceUtils.createBadResponse(Response.Status.NOT_FOUND, "The application is not at Running or Finished State.");
    }

    public static WrappedLogMetaRequest.Builder createRequestFromContainerId(String containerIdStr) {
        WrappedLogMetaRequest.Builder logMetaRequestBuilder = WrappedLogMetaRequest.builder();
        try {
            logMetaRequestBuilder.setContainerId(containerIdStr);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid container id: " + containerIdStr);
        }
        return logMetaRequestBuilder;
    }
}

