/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.shaded.org.codehaus.jackson.JsonNode;
import org.apache.hadoop.shaded.org.codehaus.jackson.map.ObjectMapper;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntimeConstants;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.OCIContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.runc.ImageManifest;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.runc.RuncContainerExecutorConfig;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.runc.RuncImageTagToManifestPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.runc.RuncManifestToResourcesPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourceRequest;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalizedResource;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ResourceLocalizationService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.volume.csi.ContainerVolumePublisher;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerExecContext;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RuncContainerRuntime
extends OCIContainerRuntime {
    private static final Log LOG = LogFactory.getLog(RuncContainerRuntime.class);
    @InterfaceAudience.Private
    private static final String RUNTIME_TYPE = "RUNC";
    @InterfaceAudience.Private
    public static final String ENV_RUNC_CONTAINER_IMAGE = "YARN_CONTAINER_RUNTIME_RUNC_IMAGE";
    @InterfaceAudience.Private
    public static final String ENV_RUNC_CONTAINER_MOUNTS = "YARN_CONTAINER_RUNTIME_RUNC_MOUNTS";
    @InterfaceAudience.Private
    public static final String ENV_RUNC_CONTAINER_HOSTNAME = "YARN_CONTAINER_RUNTIME_RUNC_CONTAINER_HOSTNAME";
    @InterfaceAudience.Private
    public static final String ENV_RUNC_CONTAINER_PID_NAMESPACE = RuncContainerRuntime.formatOciEnvKey("RUNC", "CONTAINER_PID_NAMESPACE");
    @InterfaceAudience.Private
    public static final String ENV_RUNC_CONTAINER_RUN_PRIVILEGED_CONTAINER = RuncContainerRuntime.formatOciEnvKey("RUNC", "RUN_PRIVILEGED_CONTAINER");
    private Configuration conf;
    private Context nmContext;
    private PrivilegedOperationExecutor privilegedOperationExecutor;
    private CGroupsHandler cGroupsHandler;
    private RuncImageTagToManifestPlugin imageTagToManifestPlugin;
    private RuncManifestToResourcesPlugin manifestToResourcesPlugin;
    private ObjectMapper mapper;
    private String seccomp;
    private int layersToKeep;
    private String defaultRuncImage;
    private ScheduledExecutorService exec;
    private String seccompProfile;
    private Set<String> defaultROMounts = new HashSet<String>();
    private Set<String> defaultRWMounts = new HashSet<String>();
    private Set<String> allowedNetworks = new HashSet<String>();
    private Set<String> allowedRuntimes = new HashSet<String>();
    private AccessControlList privilegedContainersAcl;

    public RuncContainerRuntime(PrivilegedOperationExecutor privilegedOperationExecutor) {
        this(privilegedOperationExecutor, ResourceHandlerModule.getCGroupsHandler());
    }

    @VisibleForTesting
    public RuncContainerRuntime(PrivilegedOperationExecutor privilegedOperationExecutor, CGroupsHandler cGroupsHandler) {
        super(privilegedOperationExecutor, cGroupsHandler);
        this.privilegedOperationExecutor = privilegedOperationExecutor;
        if (cGroupsHandler == null) {
            LOG.info((Object)"cGroupsHandler is null - cgroups not in use.");
        } else {
            this.cGroupsHandler = cGroupsHandler;
        }
    }

    @Override
    public void initialize(Configuration configuration, Context nmCtx) throws ContainerExecutionException {
        super.initialize(configuration, nmCtx);
        this.conf = configuration;
        this.nmContext = nmCtx;
        this.imageTagToManifestPlugin = this.chooseImageTagToManifestPlugin();
        this.imageTagToManifestPlugin.init(this.conf);
        this.manifestToResourcesPlugin = this.chooseManifestToResourcesPlugin();
        this.manifestToResourcesPlugin.init(this.conf);
        this.mapper = new ObjectMapper();
        this.defaultRuncImage = this.conf.get("yarn.nodemanager.runtime.linux.runc.image-name");
        this.allowedNetworks.clear();
        this.allowedRuntimes.clear();
        this.allowedNetworks.addAll(Arrays.asList(this.conf.getTrimmedStrings("yarn.nodemanager.runtime.linux.runc.allowed-container-networks", YarnConfiguration.DEFAULT_NM_RUNC_ALLOWED_CONTAINER_NETWORKS)));
        this.allowedRuntimes.addAll(Arrays.asList(this.conf.getTrimmedStrings("yarn.nodemanager.runtime.linux.runc.allowed-container-runtimes", YarnConfiguration.DEFAULT_NM_RUNC_ALLOWED_CONTAINER_RUNTIMES)));
        this.privilegedContainersAcl = new AccessControlList(this.conf.getTrimmed("yarn.nodemanager.runtime.linux.runc.privileged-containers.acl", ""));
        this.seccompProfile = this.conf.get("yarn.nodemanager.runtime.linux.runc.seccomp-profile");
        this.defaultROMounts.addAll(Arrays.asList(this.conf.getTrimmedStrings("yarn.nodemanager.runtime.linux.runc.default-ro-mounts")));
        this.defaultRWMounts.addAll(Arrays.asList(this.conf.getTrimmedStrings("yarn.nodemanager.runtime.linux.runc.default-rw-mounts")));
        try {
            if (this.seccompProfile != null) {
                this.seccomp = new String(Files.readAllBytes(Paths.get(this.seccompProfile, new String[0])), StandardCharsets.UTF_8);
            }
        }
        catch (IOException ioe) {
            throw new ContainerExecutionException(ioe);
        }
        this.layersToKeep = this.conf.getInt("yarn.nodemanager.runtime.linux.runc.layer-mounts-to-keep", 100);
    }

    @Override
    public void start() {
        int reapRuncLayerMountsInterval = this.conf.getInt("yarn.nodemanager.runtime.linux.runc.layer-mounts-interval-secs", 600);
        this.exec = HadoopExecutors.newScheduledThreadPool((int)1);
        this.exec.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    PrivilegedOperation launchOp = new PrivilegedOperation(PrivilegedOperation.OperationType.REAP_RUNC_LAYER_MOUNTS);
                    launchOp.appendArgs(Integer.toString(RuncContainerRuntime.this.layersToKeep));
                    try {
                        String stdout = RuncContainerRuntime.this.privilegedOperationExecutor.executePrivilegedOperation(null, launchOp, null, null, false, false);
                        if (stdout != null) {
                            LOG.info((Object)("Reap layer mounts thread: " + stdout));
                        }
                    }
                    catch (PrivilegedOperationException e) {
                        LOG.warn((Object)"Failed to reap old runc layer mounts", (Throwable)((Object)e));
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)"Reap layer mount thread caught an exception: ", (Throwable)e);
                }
            }
        }, 0L, reapRuncLayerMountsInterval, TimeUnit.SECONDS);
        this.imageTagToManifestPlugin.start();
        this.manifestToResourcesPlugin.start();
    }

    @Override
    public void stop() {
        this.exec.shutdownNow();
        this.imageTagToManifestPlugin.stop();
        this.manifestToResourcesPlugin.stop();
    }

    @Override
    public void launchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        ArrayList<String> env = new ArrayList<String>();
        Container container = ctx.getContainer();
        String runAsUser = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER);
        String user = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER);
        ContainerId containerId = container.getContainerId();
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        Map environment = container.getLaunchContext().getEnvironment();
        ArrayList<RuncContainerExecutorConfig.OCIRuntimeConfig.OCIMount> mounts = new ArrayList<RuncContainerExecutorConfig.OCIRuntimeConfig.OCIMount>();
        ArrayList<RuncContainerExecutorConfig.OCILayer> layers = new ArrayList<RuncContainerExecutorConfig.OCILayer>();
        String hostname = (String)environment.get(ENV_RUNC_CONTAINER_HOSTNAME);
        RuncContainerRuntime.validateHostname(hostname);
        String containerIdStr = containerId.toString();
        String applicationId = appId.toString();
        Path containerWorkDir = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_WORK_DIR);
        RuncRuntimeObject runcRuntimeObject = container.getContainerRuntimeData(RuncRuntimeObject.class);
        List<LocalResource> layerResources = runcRuntimeObject.getOCILayers();
        ResourceLocalizationService localizationService = this.nmContext.getContainerManager().getResourceLocalizationService();
        ArrayList<String> args = new ArrayList<String>();
        try {
            try {
                List<String> entrypoint;
                LocalResource rsrc = runcRuntimeObject.getConfig();
                LocalResourceRequest req = new LocalResourceRequest(rsrc);
                LocalizedResource localRsrc = localizationService.getLocalizedResource(req, user, appId);
                if (localRsrc == null) {
                    throw new ContainerExecutionException("Could not successfully localize layers. rsrc: " + rsrc.getResource().getFile());
                }
                File file = new File(localRsrc.getLocalPath().toString());
                List<String> imageEnv = this.extractImageEnv(file);
                if (imageEnv != null && !imageEnv.isEmpty()) {
                    env.addAll(imageEnv);
                }
                if ((entrypoint = this.extractImageEntrypoint(file)) != null && !entrypoint.isEmpty()) {
                    args.addAll(entrypoint);
                }
            }
            catch (IOException ioe) {
                throw new ContainerExecutionException(ioe);
            }
            for (LocalResource rsrc : layerResources) {
                LocalResourceRequest req = new LocalResourceRequest(rsrc);
                LocalizedResource localRsrc = localizationService.getLocalizedResource(req, user, appId);
                RuncContainerExecutorConfig.OCILayer layer = new RuncContainerExecutorConfig.OCILayer("application/vnd.squashfs", localRsrc.getLocalPath().toString());
                layers.add(layer);
            }
        }
        catch (URISyntaxException e) {
            throw new ContainerExecutionException(e);
        }
        this.setContainerMounts(mounts, ctx, containerWorkDir, environment);
        String resourcesOpts = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RESOURCES_OPTIONS);
        Path nmPrivateContainerScriptPath = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_CONTAINER_SCRIPT_PATH);
        Path nmPrivateTokensPath = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_TOKENS_PATH);
        int cpuShares = container.getResource().getVirtualCores();
        if (cpuShares < 2) {
            cpuShares = 2;
        }
        Path launchDst = new Path(containerWorkDir, ContainerLaunch.CONTAINER_SCRIPT);
        args.add("bash");
        args.add(launchDst.toUri().getPath());
        String cgroupPath = this.getCgroupPath(resourcesOpts, "runc-" + containerIdStr);
        String pidFile = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID_FILE_PATH).toString();
        List localDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOCAL_DIRS);
        List logDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOG_DIRS);
        Path keystorePath = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_KEYSTORE_PATH);
        Path truststorePath = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_TRUSTSTORE_PATH);
        int https = 0;
        String keystore = null;
        String truststore = null;
        if (keystorePath != null && truststorePath != null) {
            https = 1;
            keystore = keystorePath.toUri().getPath();
            truststore = truststorePath.toUri().getPath();
        }
        RuncContainerExecutorConfig.OCIRuntimeConfig.OCIProcessConfig processConfig = this.createOCIProcessConfig(containerWorkDir.toString(), env, args);
        RuncContainerExecutorConfig.OCIRuntimeConfig.OCILinuxConfig linuxConfig = this.createOCILinuxConfig(cpuShares, cgroupPath, this.seccomp);
        RuncContainerExecutorConfig.OCIRuntimeConfig ociRuntimeConfig = new RuncContainerExecutorConfig.OCIRuntimeConfig(null, mounts, processConfig, hostname, null, null, linuxConfig);
        RuncContainerExecutorConfig runcContainerExecutorConfig = this.createRuncContainerExecutorConfig(runAsUser, user, containerIdStr, applicationId, pidFile, nmPrivateContainerScriptPath.toString(), nmPrivateTokensPath.toString(), https, keystore, truststore, localDirs, logDirs, layers, ociRuntimeConfig);
        String commandFile = this.writeCommandToFile(runcContainerExecutorConfig, container);
        PrivilegedOperation launchOp = new PrivilegedOperation(PrivilegedOperation.OperationType.RUN_RUNC_CONTAINER);
        launchOp.appendArgs(commandFile);
        try {
            this.privilegedOperationExecutor.executePrivilegedOperation(null, launchOp, null, null, false, false);
        }
        catch (PrivilegedOperationException e) {
            LOG.info((Object)"Launch container failed: ", (Throwable)((Object)e));
            try {
                LOG.debug((Object)("config.json used: " + this.mapper.writeValueAsString((Object)runcContainerExecutorConfig)));
            }
            catch (IOException ioe) {
                LOG.info((Object)"Json Generation Exception", (Throwable)ioe);
            }
            throw new ContainerExecutionException("Launch container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    private String getCgroupPath(String resourcesOptions, String containerIdStr) {
        if (this.cGroupsHandler == null) {
            LOG.debug((Object)"cGroupsHandler is null. cgroups are not in use. nothing to do.");
            return null;
        }
        if (!resourcesOptions.equals("cgroups=none")) {
            LOG.debug((Object)"using runc's cgroups options");
            String cGroupPath = "/" + this.cGroupsHandler.getRelativePathForCGroup(containerIdStr);
            LOG.debug((Object)("using cgroup parent: " + cGroupPath));
            return cGroupPath;
        }
        LOG.debug((Object)"no resource restrictions specified. not using runc's cgroup options");
        return null;
    }

    private void addUserMounts(List<RuncContainerExecutorConfig.OCIRuntimeConfig.OCIMount> mounts, Map<String, String> environment, Map<Path, List<String>> localizedResources) throws ContainerExecutionException {
        if (environment.containsKey(ENV_RUNC_CONTAINER_MOUNTS)) {
            Matcher parsedMounts = USER_MOUNT_PATTERN.matcher(environment.get(ENV_RUNC_CONTAINER_MOUNTS));
            if (!parsedMounts.find()) {
                throw new ContainerExecutionException("Unable to parse user supplied mount list: " + environment.get(ENV_RUNC_CONTAINER_MOUNTS));
            }
            parsedMounts.reset();
            long mountCount = 0L;
            while (parsedMounts.find()) {
                boolean isReadWrite;
                ++mountCount;
                String src = parsedMounts.group(1);
                java.nio.file.Path srcPath = Paths.get(src, new String[0]);
                if (!srcPath.isAbsolute()) {
                    src = this.mountReadOnlyPath(src, localizedResources);
                }
                String dst = parsedMounts.group(2);
                String mode = parsedMounts.group(4);
                if (mode == null) {
                    isReadWrite = true;
                } else if (mode.equals("rw")) {
                    isReadWrite = true;
                } else if (mode.equals("ro")) {
                    isReadWrite = false;
                } else {
                    throw new ContainerExecutionException("Unable to parse mode of some mounts in user supplied mount list: " + environment.get(ENV_RUNC_CONTAINER_MOUNTS));
                }
                this.addRuncMountLocation(mounts, src, dst, false, isReadWrite);
            }
            long commaCount = environment.get(ENV_RUNC_CONTAINER_MOUNTS).chars().filter(c -> c == 44).count();
            if (mountCount != commaCount + 1L) {
                throw new ContainerExecutionException("Unable to parse some mounts in user supplied mount list: " + environment.get(ENV_RUNC_CONTAINER_MOUNTS));
            }
        }
    }

    private void addDefaultMountLocation(List<RuncContainerExecutorConfig.OCIRuntimeConfig.OCIMount> mounts, Set<String> defaultMounts, boolean createSource, boolean isReadWrite) throws ContainerExecutionException {
        if (defaultMounts != null && !defaultMounts.isEmpty()) {
            for (String mount : defaultMounts) {
                String[] dir = StringUtils.split((String)mount, (char)':');
                if (dir.length != 2) {
                    throw new ContainerExecutionException("Invalid mount : " + mount);
                }
                String src = dir[0];
                String dst = dir[1];
                this.addRuncMountLocation(mounts, src, dst, createSource, isReadWrite);
            }
        }
    }

    private void addRuncMountLocation(List<RuncContainerExecutorConfig.OCIRuntimeConfig.OCIMount> mounts, String srcPath, String dstPath, boolean createSource, boolean isReadWrite) {
        boolean sourceExists;
        if (!createSource && !(sourceExists = new File(srcPath).exists())) {
            return;
        }
        ArrayList<String> options = new ArrayList<String>();
        if (isReadWrite) {
            options.add("rw");
        } else {
            options.add("ro");
        }
        options.add("rbind");
        options.add("rprivate");
        mounts.add(new RuncContainerExecutorConfig.OCIRuntimeConfig.OCIMount(dstPath, "bind", srcPath, options));
    }

    private void addAllRuncMountLocations(List<RuncContainerExecutorConfig.OCIRuntimeConfig.OCIMount> mounts, List<String> paths, boolean createSource, boolean isReadWrite) {
        for (String dir : paths) {
            this.addRuncMountLocation(mounts, dir, dir, createSource, isReadWrite);
        }
    }

    @Override
    public Map<String, LocalResource> getLocalResources(Container container) throws IOException {
        Map containerLocalRsrc = container.getLaunchContext().getLocalResources();
        long layerCount = 0L;
        Map environment = container.getLaunchContext().getEnvironment();
        String imageName = (String)environment.get(ENV_RUNC_CONTAINER_IMAGE);
        if (imageName == null || imageName.isEmpty()) {
            environment.put(ENV_RUNC_CONTAINER_IMAGE, this.defaultRuncImage);
            imageName = this.defaultRuncImage;
        }
        ImageManifest manifest = this.imageTagToManifestPlugin.getManifestFromImageTag(imageName);
        LocalResource config = this.manifestToResourcesPlugin.getConfigResource(manifest);
        List<LocalResource> layers = this.manifestToResourcesPlugin.getLayerResources(manifest);
        RuncRuntimeObject runcRuntimeObject = new RuncRuntimeObject(config, layers);
        container.setContainerRuntimeData(runcRuntimeObject);
        for (LocalResource localRsrc : layers) {
            while (containerLocalRsrc.putIfAbsent("runc-layer" + Long.toString(layerCount), localRsrc) != null) {
                ++layerCount;
            }
        }
        while (containerLocalRsrc.putIfAbsent("runc-config" + Long.toString(layerCount), config) != null) {
            ++layerCount;
        }
        return containerLocalRsrc;
    }

    protected RuncImageTagToManifestPlugin chooseImageTagToManifestPlugin() throws ContainerExecutionException {
        RuncImageTagToManifestPlugin runcImageTagToManifestPlugin;
        String pluginName = this.conf.get("yarn.nodemanager.runtime.linux.runc.image-tag-to-manifest-plugin", "org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.runc.ImageTagToManifestPlugin");
        try {
            Class<?> clazz = Class.forName(pluginName);
            runcImageTagToManifestPlugin = (RuncImageTagToManifestPlugin)clazz.newInstance();
        }
        catch (Exception e) {
            throw new ContainerExecutionException(e);
        }
        return runcImageTagToManifestPlugin;
    }

    protected RuncManifestToResourcesPlugin chooseManifestToResourcesPlugin() throws ContainerExecutionException {
        RuncManifestToResourcesPlugin runcManifestToResourcesPlugin;
        String pluginName = this.conf.get("yarn.nodemanager.runtime.linux.runc.manifest-to-resources-plugin", "org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.runc.HdfsManifestToResourcesPlugin");
        LOG.info((Object)("pluginName = " + pluginName));
        try {
            Class<?> clazz = Class.forName(pluginName);
            runcManifestToResourcesPlugin = (RuncManifestToResourcesPlugin)clazz.newInstance();
        }
        catch (Exception e) {
            throw new ContainerExecutionException(e);
        }
        return runcManifestToResourcesPlugin;
    }

    protected List<String> extractImageEnv(File config) throws IOException {
        JsonNode node = this.mapper.readTree(config);
        JsonNode envNode = node.path("config").path("Env");
        if (envNode.isMissingNode()) {
            return null;
        }
        return (List)this.mapper.readValue(envNode, List.class);
    }

    protected List<String> extractImageEntrypoint(File config) throws IOException {
        JsonNode node = this.mapper.readTree(config);
        JsonNode entrypointNode = node.path("config").path("Entrypoint");
        if (entrypointNode.isMissingNode()) {
            return null;
        }
        return (List)this.mapper.readValue(entrypointNode, List.class);
    }

    private RuncContainerExecutorConfig createRuncContainerExecutorConfig(String runAsUser, String username, String containerId, String applicationId, String pidFile, String containerScriptPath, String containerCredentialsPath, int https, String keystorePath, String truststorePath, List<String> localDirs, List<String> logDirs, List<RuncContainerExecutorConfig.OCILayer> layers, RuncContainerExecutorConfig.OCIRuntimeConfig ociRuntimeConfig) {
        return new RuncContainerExecutorConfig(runAsUser, username, containerId, applicationId, pidFile, containerScriptPath, containerCredentialsPath, https, keystorePath, truststorePath, localDirs, logDirs, layers, this.layersToKeep, ociRuntimeConfig);
    }

    private RuncContainerExecutorConfig.OCIRuntimeConfig.OCIProcessConfig createOCIProcessConfig(String cwd, List<String> env, List<String> args) {
        return new RuncContainerExecutorConfig.OCIRuntimeConfig.OCIProcessConfig(false, null, cwd, env, args, null, null, null, false, 0, null, null);
    }

    private RuncContainerExecutorConfig.OCIRuntimeConfig.OCILinuxConfig createOCILinuxConfig(long cpuShares, String cgroupsPath, String seccompProf) {
        RuncContainerExecutorConfig.OCIRuntimeConfig.OCILinuxConfig.Resources.CPU cgroupCPU = new RuncContainerExecutorConfig.OCIRuntimeConfig.OCILinuxConfig.Resources.CPU(cpuShares, 0L, 0L, 0L, 0L, null, null);
        RuncContainerExecutorConfig.OCIRuntimeConfig.OCILinuxConfig.Resources cgroupResources = new RuncContainerExecutorConfig.OCIRuntimeConfig.OCILinuxConfig.Resources(null, null, cgroupCPU, null, null, null, null, null);
        return new RuncContainerExecutorConfig.OCIRuntimeConfig.OCILinuxConfig(null, null, null, null, cgroupsPath, cgroupResources, null, null, seccompProf, null, null, null, null);
    }

    private void setContainerMounts(ArrayList<RuncContainerExecutorConfig.OCIRuntimeConfig.OCIMount> mounts, ContainerRuntimeContext ctx, Path containerWorkDir, Map<String, String> environment) throws ContainerExecutionException {
        List filecacheDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.FILECACHE_DIRS);
        List containerLogDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_LOG_DIRS);
        List userFilecacheDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER_FILECACHE_DIRS);
        List applicationLocalDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.APPLICATION_LOCAL_DIRS);
        Map localizedResources = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOCALIZED_RESOURCES);
        this.addRuncMountLocation(mounts, containerWorkDir.toString() + "/private_slash_tmp", "/tmp", true, true);
        this.addRuncMountLocation(mounts, containerWorkDir.toString() + "/private_var_slash_tmp", "/var/tmp", true, true);
        this.addAllRuncMountLocations(mounts, containerLogDirs, true, true);
        this.addAllRuncMountLocations(mounts, applicationLocalDirs, true, true);
        this.addAllRuncMountLocations(mounts, filecacheDirs, false, false);
        this.addAllRuncMountLocations(mounts, userFilecacheDirs, false, false);
        this.addDefaultMountLocation(mounts, this.defaultROMounts, false, false);
        this.addDefaultMountLocation(mounts, this.defaultRWMounts, false, true);
        this.addUserMounts(mounts, environment, localizedResources);
    }

    public String writeCommandToFile(RuncContainerExecutorConfig runcContainerExecutorConfig, Container container) throws ContainerExecutionException {
        ContainerId containerId = container.getContainerId();
        String filePrefix = containerId.toString();
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        try {
            String cmdDirStr;
            File cmdDir = null;
            if (this.nmContext != null && this.nmContext.getLocalDirsHandler() != null && !(cmdDir = new File(cmdDirStr = this.nmContext.getLocalDirsHandler().getLocalPathForWrite("nmPrivate/" + appId + "/" + filePrefix + "/").toString())).mkdirs() && !cmdDir.exists()) {
                throw new IOException("Cannot create container private directory " + cmdDir);
            }
            File commandFile = new File(cmdDir + "/runc-config.json");
            try {
                this.mapper.writeValue(commandFile, (Object)runcContainerExecutorConfig);
            }
            catch (IOException ioe) {
                throw new ContainerExecutionException(ioe);
            }
            return commandFile.getAbsolutePath();
        }
        catch (IOException e) {
            LOG.warn((Object)"Unable to write runc config.json to temporary file!");
            throw new ContainerExecutionException(e);
        }
    }

    @Override
    public String getExposedPorts(Container container) {
        return null;
    }

    @Override
    public String[] getIpAndHost(Container container) {
        return null;
    }

    @Override
    public IOStreamPair execContainer(ContainerExecContext ctx) throws ContainerExecutionException {
        return null;
    }

    @Override
    public void reapContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
    }

    @Override
    public void relaunchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
    }

    public static boolean isRuncContainerRequested(Configuration daemonConf, Map<String, String> env) {
        String type;
        String string = type = env == null ? null : env.get("YARN_CONTAINER_RUNTIME_TYPE");
        if (type == null) {
            type = daemonConf.get("yarn.nodemanager.runtime.linux.type");
        }
        return type != null && type.equals("runc");
    }

    @Override
    public boolean isRuntimeRequested(Map<String, String> env) {
        return RuncContainerRuntime.isRuncContainerRequested(this.conf, env);
    }

    @Override
    public void signalContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        ContainerExecutor.Signal signal = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.SIGNAL);
        Container container = ctx.getContainer();
        if (signal == ContainerExecutor.Signal.KILL || signal == ContainerExecutor.Signal.TERM) {
            ContainerVolumePublisher publisher = new ContainerVolumePublisher(container, container.getCsiVolumesRootDir(), this);
            try {
                publisher.unpublishVolumes();
            }
            catch (IOException | YarnException e) {
                throw new ContainerExecutionException(e);
            }
        }
        PrivilegedOperation signalOp = new PrivilegedOperation(PrivilegedOperation.OperationType.SIGNAL_CONTAINER);
        signalOp.appendArgs(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER), Integer.toString(PrivilegedOperation.RunAsUserCommand.SIGNAL_CONTAINER.getValue()), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID), Integer.toString(signal.getValue()));
        signalOp.disableFailureLogging();
        try {
            PrivilegedOperationExecutor executor = PrivilegedOperationExecutor.getInstance(this.conf);
            executor.executePrivilegedOperation(null, signalOp, null, null, false, false);
        }
        catch (PrivilegedOperationException e) {
            throw new ContainerExecutionException("Signal container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    @Override
    boolean getHostPidNamespaceEnabled() {
        return this.conf.getBoolean("yarn.nodemanager.runtime.linux.runc.host-pid-namespace.allowed", false);
    }

    @Override
    boolean getPrivilegedContainersEnabledOnCluster() {
        return this.conf.getBoolean("yarn.nodemanager.runtime.linux.runc.privileged-containers.allowed", false);
    }

    @Override
    Set<String> getAllowedNetworks() {
        return this.allowedNetworks;
    }

    @Override
    Set<String> getAllowedRuntimes() {
        return this.allowedRuntimes;
    }

    @Override
    AccessControlList getPrivilegedContainersAcl() {
        return this.privilegedContainersAcl;
    }

    @Override
    String getEnvOciContainerPidNamespace() {
        return ENV_RUNC_CONTAINER_PID_NAMESPACE;
    }

    @Override
    String getEnvOciContainerRunPrivilegedContainer() {
        return ENV_RUNC_CONTAINER_RUN_PRIVILEGED_CONTAINER;
    }

    @InterfaceStability.Unstable
    static class RuncRuntimeObject {
        private final List<LocalResource> layers;
        private final LocalResource config;

        RuncRuntimeObject(LocalResource config, List<LocalResource> layers) {
            this.config = config;
            this.layers = layers;
        }

        public LocalResource getConfig() {
            return this.config;
        }

        public List<LocalResource> getOCILayers() {
            return this.layers;
        }
    }
}

