/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.manager;

import java.nio.ByteBuffer;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.LocalityMulticastAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.manager.AbstractPolicyManager;
import org.apache.hadoop.yarn.server.federation.policies.router.LocalityRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;

public class WeightedLocalityPolicyManager
extends AbstractPolicyManager {
    private WeightedPolicyInfo weightedPolicyInfo;

    public WeightedLocalityPolicyManager() {
        this.routerFederationPolicy = LocalityRouterPolicy.class;
        this.amrmProxyFederationPolicy = LocalityMulticastAMRMProxyPolicy.class;
        this.weightedPolicyInfo = new WeightedPolicyInfo();
    }

    @Override
    public SubClusterPolicyConfiguration serializeConf() throws FederationPolicyInitializationException {
        ByteBuffer buf = this.weightedPolicyInfo.toByteBuffer();
        return SubClusterPolicyConfiguration.newInstance(this.getQueue(), this.getClass().getCanonicalName(), buf);
    }

    @VisibleForTesting
    public WeightedPolicyInfo getWeightedPolicyInfo() {
        return this.weightedPolicyInfo;
    }

    @VisibleForTesting
    public void setWeightedPolicyInfo(WeightedPolicyInfo weightedPolicyInfo) {
        this.weightedPolicyInfo = weightedPolicyInfo;
    }
}

