/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.strategies;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Connection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.IOEvent;
import org.apache.hadoop.shaded.org.glassfish.grizzly.IOEventProcessingHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.NIOConnection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.SelectorRunner;
import org.apache.hadoop.shaded.org.glassfish.grizzly.strategies.AbstractIOStrategy;

public final class LeaderFollowerNIOStrategy
extends AbstractIOStrategy {
    private static final LeaderFollowerNIOStrategy INSTANCE = new LeaderFollowerNIOStrategy();
    private static final Logger logger = Grizzly.logger(LeaderFollowerNIOStrategy.class);

    private LeaderFollowerNIOStrategy() {
    }

    public static LeaderFollowerNIOStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean executeIoEvent(Connection connection, IOEvent ioEvent, boolean isIoEventEnabled) throws IOException {
        NIOConnection nioConnection = (NIOConnection)connection;
        IOEventProcessingHandler ph = null;
        if (LeaderFollowerNIOStrategy.isReadWrite(ioEvent)) {
            if (isIoEventEnabled) {
                connection.disableIOEvent(ioEvent);
            }
            ph = ENABLE_INTEREST_PROCESSING_HANDLER;
        }
        if (LeaderFollowerNIOStrategy.isExecuteInWorkerThread(ioEvent)) {
            SelectorRunner runner = nioConnection.getSelectorRunner();
            runner.postpone();
            LeaderFollowerNIOStrategy.getWorkerThreadPool(connection).execute(runner);
            LeaderFollowerNIOStrategy.fireIOEvent(connection, ioEvent, ph, logger);
            return false;
        }
        LeaderFollowerNIOStrategy.fireIOEvent(connection, ioEvent, ph, logger);
        return true;
    }
}

