/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.jsr107;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.shaded.javax.cache.CacheException;

class MultiCacheException
extends CacheException {
    private static final long serialVersionUID = -6839700789356356261L;
    private final List<Throwable> throwables = new ArrayList<Throwable>();

    MultiCacheException() {
    }

    MultiCacheException(Throwable t) {
        this.addThrowable(t);
    }

    void addThrowable(Throwable t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (t == this) {
            throw new IllegalArgumentException("cannot add to self");
        }
        if (t instanceof MultiCacheException) {
            for (Throwable t2 : ((MultiCacheException)t).getThrowables()) {
                this.throwables.add(t2);
            }
        } else {
            this.throwables.add(t);
        }
    }

    private List<Throwable> getThrowables() {
        return Collections.unmodifiableList(this.throwables);
    }

    @Override
    public String getMessage() {
        List<Throwable> ts = this.getThrowables();
        if (ts.isEmpty()) {
            return super.getMessage();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ts.size(); ++i) {
            sb.append("[Exception ").append(i).append("] ").append(ts.get(i).getMessage()).append("\n");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    MultiCacheException addFirstThrowable(Throwable t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (t == this) {
            throw new IllegalArgumentException("cannot add to self");
        }
        if (t instanceof MultiCacheException) {
            MultiCacheException mce = (MultiCacheException)t;
            this.throwables.addAll(0, mce.getThrowables());
        }
        this.throwables.add(0, t);
        return this;
    }

    @Override
    public Throwable initCause(Throwable cause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Throwable getCause() {
        return null;
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        for (int i = 0; i < this.throwables.size(); ++i) {
            System.err.print("  [Exception " + i + "] ");
            this.throwables.get(i).printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
        for (int i = 0; i < this.throwables.size(); ++i) {
            ps.print("  [Exception " + i + "] ");
            this.throwables.get(i).printStackTrace(ps);
        }
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
        for (int i = 0; i < this.throwables.size(); ++i) {
            pw.print("  [Exception " + i + "] ");
            this.throwables.get(i).printStackTrace(pw);
        }
    }

    void throwIfNotEmpty() {
        if (!this.throwables.isEmpty()) {
            Throwable t;
            if (this.throwables.size() == 1 && (t = this.throwables.get(0)) instanceof CacheException) {
                throw (CacheException)t;
            }
            throw this;
        }
    }
}

