/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.spi;

import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.inject.Binder;
import org.apache.hadoop.shaded.com.google.inject.internal.Errors;
import org.apache.hadoop.shaded.com.google.inject.spi.Element;
import org.apache.hadoop.shaded.com.google.inject.spi.ElementVisitor;
import org.apache.hadoop.shaded.com.google.inject.spi.ModuleAnnotatedMethodScanner;

public final class ModuleAnnotatedMethodScannerBinding
implements Element {
    private final Object source;
    private final ModuleAnnotatedMethodScanner scanner;

    public ModuleAnnotatedMethodScannerBinding(Object source, ModuleAnnotatedMethodScanner scanner) {
        this.source = Preconditions.checkNotNull((Object)source, (Object)"source");
        this.scanner = (ModuleAnnotatedMethodScanner)Preconditions.checkNotNull((Object)scanner, (Object)"scanner");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public ModuleAnnotatedMethodScanner getScanner() {
        return this.scanner;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).scanModulesForAnnotatedMethods(this.scanner);
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.scanner));
        String string2 = String.valueOf(String.valueOf(this.scanner.annotationClasses()));
        String string3 = String.valueOf(String.valueOf(Errors.convert(this.source)));
        return new StringBuilder(29 + string.length() + string2.length() + string3.length()).append(string).append(" which scans for ").append(string2).append(" (bound at ").append(string3).append(")").toString();
    }
}

