/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class TimelineEntityFilters {
    private final long limit;
    private long createdTimeBegin;
    private long createdTimeEnd;
    private final TimelineFilterList relatesTo;
    private final TimelineFilterList isRelatedTo;
    private final TimelineFilterList infoFilters;
    private final TimelineFilterList configFilters;
    private final TimelineFilterList metricFilters;
    private final TimelineFilterList eventFilters;
    private final String fromId;
    private static final long DEFAULT_BEGIN_TIME = 0L;
    private static final long DEFAULT_END_TIME = Long.MAX_VALUE;
    public static final long DEFAULT_LIMIT = 100L;

    private TimelineEntityFilters(Long entityLimit, Long timeBegin, Long timeEnd, TimelineFilterList entityRelatesTo, TimelineFilterList entityIsRelatedTo, TimelineFilterList entityInfoFilters, TimelineFilterList entityConfigFilters, TimelineFilterList entityMetricFilters, TimelineFilterList entityEventFilters, String fromId) {
        this.limit = entityLimit == null || entityLimit < 0L ? 100L : entityLimit;
        this.createdTimeBegin = timeBegin == null || timeBegin < 0L ? 0L : timeBegin;
        this.createdTimeEnd = timeEnd == null || timeEnd < 0L ? Long.MAX_VALUE : timeEnd;
        this.relatesTo = entityRelatesTo;
        this.isRelatedTo = entityIsRelatedTo;
        this.infoFilters = entityInfoFilters;
        this.configFilters = entityConfigFilters;
        this.metricFilters = entityMetricFilters;
        this.eventFilters = entityEventFilters;
        this.fromId = fromId;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getCreatedTimeBegin() {
        return this.createdTimeBegin;
    }

    public long getCreatedTimeEnd() {
        return this.createdTimeEnd;
    }

    public TimelineFilterList getRelatesTo() {
        return this.relatesTo;
    }

    public TimelineFilterList getIsRelatedTo() {
        return this.isRelatedTo;
    }

    public TimelineFilterList getInfoFilters() {
        return this.infoFilters;
    }

    public TimelineFilterList getConfigFilters() {
        return this.configFilters;
    }

    public TimelineFilterList getMetricFilters() {
        return this.metricFilters;
    }

    public TimelineFilterList getEventFilters() {
        return this.eventFilters;
    }

    public String getFromId() {
        return this.fromId;
    }

    public static class Builder {
        private Long entityLimit;
        private Long createdTimeBegin;
        private Long createdTimeEnd;
        private TimelineFilterList relatesToFilters;
        private TimelineFilterList isRelatedToFilters;
        private TimelineFilterList entityInfoFilters;
        private TimelineFilterList entityConfigFilters;
        private TimelineFilterList entityMetricFilters;
        private TimelineFilterList entityEventFilters;
        private String entityFromId;

        public Builder entityLimit(Long limit) {
            this.entityLimit = limit;
            return this;
        }

        public Builder createdTimeBegin(Long timeBegin) {
            this.createdTimeBegin = timeBegin;
            return this;
        }

        public Builder createTimeEnd(Long timeEnd) {
            this.createdTimeEnd = timeEnd;
            return this;
        }

        public Builder relatesTo(TimelineFilterList relatesTo) {
            this.relatesToFilters = relatesTo;
            return this;
        }

        public Builder isRelatedTo(TimelineFilterList isRelatedTo) {
            this.isRelatedToFilters = isRelatedTo;
            return this;
        }

        public Builder infoFilters(TimelineFilterList infoFilters) {
            this.entityInfoFilters = infoFilters;
            return this;
        }

        public Builder configFilters(TimelineFilterList configFilters) {
            this.entityConfigFilters = configFilters;
            return this;
        }

        public Builder metricFilters(TimelineFilterList metricFilters) {
            this.entityMetricFilters = metricFilters;
            return this;
        }

        public Builder eventFilters(TimelineFilterList eventFilters) {
            this.entityEventFilters = eventFilters;
            return this;
        }

        public Builder fromId(String fromId) {
            this.entityFromId = fromId;
            return this;
        }

        public TimelineEntityFilters build() {
            return new TimelineEntityFilters(this.entityLimit, this.createdTimeBegin, this.createdTimeEnd, this.relatesToFilters, this.isRelatedToFilters, this.entityInfoFilters, this.entityConfigFilters, this.entityMetricFilters, this.entityEventFilters, this.entityFromId);
        }
    }
}

