/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.volume.csi.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceContext;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceProcessor;
import org.apache.hadoop.yarn.api.CsiAdaptorProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.VolumeManager;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.lifecycle.Volume;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.lifecycle.VolumeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.provisioner.VolumeProvisioningResults;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.provisioner.VolumeProvisioningTask;
import org.apache.hadoop.yarn.server.volume.csi.VolumeMetaData;
import org.apache.hadoop.yarn.server.volume.csi.exception.InvalidVolumeException;
import org.apache.hadoop.yarn.server.volume.csi.exception.VolumeException;
import org.apache.hadoop.yarn.server.volume.csi.exception.VolumeProvisioningException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeAMSProcessor
implements ApplicationMasterServiceProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(VolumeAMSProcessor.class);
    private ApplicationMasterServiceProcessor nextAMSProcessor;
    private VolumeManager volumeManager;

    public void init(ApplicationMasterServiceContext amsContext, ApplicationMasterServiceProcessor nextProcessor) {
        LOG.info("Initializing CSI volume processor");
        this.nextAMSProcessor = nextProcessor;
        this.volumeManager = ((RMContext)amsContext).getVolumeManager();
    }

    public void registerApplicationMaster(ApplicationAttemptId applicationAttemptId, RegisterApplicationMasterRequest request, RegisterApplicationMasterResponse response) throws IOException, YarnException {
        this.nextAMSProcessor.registerApplicationMaster(applicationAttemptId, request, response);
    }

    public void allocate(ApplicationAttemptId appAttemptId, AllocateRequest request, AllocateResponse response) throws YarnException {
        List<Volume> volumes = this.aggregateVolumesFrom(request);
        if (volumes != null && volumes.size() > 0) {
            ScheduledFuture<VolumeProvisioningResults> result = this.volumeManager.schedule(new VolumeProvisioningTask(volumes), 0);
            try {
                VolumeProvisioningResults volumeResult = (VolumeProvisioningResults)result.get(3L, TimeUnit.SECONDS);
                if (!volumeResult.isSuccess()) {
                    throw new VolumeProvisioningException("Volume provisioning failed, result details: " + volumeResult.getBriefMessage());
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOG.warn("Volume provisioning task failed", (Throwable)e);
                throw new VolumeException("Volume provisioning task failed", e);
            }
        }
        this.nextAMSProcessor.allocate(appAttemptId, request, response);
    }

    private List<Volume> aggregateVolumesFrom(AllocateRequest request) throws VolumeException {
        ArrayList<Volume> volumeList = new ArrayList<Volume>();
        List requests = request.getSchedulingRequests();
        if (requests != null) {
            for (SchedulingRequest req : requests) {
                Resource totalResource = req.getResourceSizing().getResources();
                List resourceList = totalResource.getAllResourcesListCopy();
                for (ResourceInformation resourceInformation : resourceList) {
                    List<VolumeMetaData> volumes = VolumeMetaData.fromResource(resourceInformation);
                    for (VolumeMetaData vs : volumes) {
                        if (vs.getVolumeCapabilityRange().getMinCapacity() <= 0L) continue;
                        if (vs.isProvisionedVolume()) {
                            volumeList.add(this.checkAndGetVolume(vs));
                            continue;
                        }
                        throw new InvalidVolumeException("Only pre-provisioned volume is supported now, volumeID must exist.");
                    }
                }
            }
        }
        return volumeList;
    }

    private Volume checkAndGetVolume(VolumeMetaData metaData) throws InvalidVolumeException {
        VolumeImpl toAdd = new VolumeImpl(metaData);
        CsiAdaptorProtocol adaptor = this.volumeManager.getAdaptorByDriverName(metaData.getDriverName());
        if (adaptor == null) {
            throw new InvalidVolumeException("It seems for the driver name specified in the volume " + metaData.getDriverName() + " ,there is no matched driver-adaptor can be found. Is the driver probably registered? Please check if adaptors service addresses defined in " + "yarn.nodemanager.csi-driver-adaptor.addresses" + " are correct and services are started.");
        }
        toAdd.setClient(adaptor);
        return this.volumeManager.addOrGetVolume(toAdd);
    }

    public void finishApplicationMaster(ApplicationAttemptId applicationAttemptId, FinishApplicationMasterRequest request, FinishApplicationMasterResponse response) {
        this.nextAMSProcessor.finishApplicationMaster(applicationAttemptId, request, response);
    }
}

