/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMapping;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueuePlacementRuleUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppNameMappingPlacementRule
extends PlacementRule {
    private static final Logger LOG = LoggerFactory.getLogger(AppNameMappingPlacementRule.class);
    public static final String CURRENT_APP_MAPPING = "%application";
    private static final String QUEUE_MAPPING_NAME = "app-name";
    private boolean overrideWithQueueMappings = false;
    private List<QueueMapping> mappings = null;
    protected CapacitySchedulerQueueManager queueManager;

    public AppNameMappingPlacementRule() {
        this(false, null);
    }

    public AppNameMappingPlacementRule(boolean overrideWithQueueMappings, List<QueueMapping> newMappings) {
        this.overrideWithQueueMappings = overrideWithQueueMappings;
        this.mappings = newMappings;
    }

    @Override
    public boolean initialize(ResourceScheduler scheduler) throws IOException {
        if (!(scheduler instanceof CapacityScheduler)) {
            throw new IOException("AppNameMappingPlacementRule can be configured only for CapacityScheduler");
        }
        CapacitySchedulerContext schedulerContext = (CapacitySchedulerContext)((Object)scheduler);
        CapacitySchedulerConfiguration conf = schedulerContext.getConfiguration();
        boolean overrideWithQueueMappings = conf.getOverrideWithQueueMappings();
        LOG.info("Initialized App Name queue mappings, override: " + overrideWithQueueMappings);
        List<QueueMapping> queueMappings = conf.getQueueMappingEntity(QUEUE_MAPPING_NAME);
        ArrayList<QueueMapping> newMappings = new ArrayList<QueueMapping>();
        this.queueManager = schedulerContext.getCapacitySchedulerQueueManager();
        for (QueueMapping mapping : queueMappings) {
            if (QueuePlacementRuleUtils.isStaticQueueMapping(mapping)) {
                QueueMapping newMapping;
                CSQueue queue = this.queueManager.getQueue(mapping.getFullPath());
                if (AppNameMappingPlacementRule.ifQueueDoesNotExist(queue)) {
                    if (this.queueManager.isAmbiguous(mapping.getFullPath())) {
                        throw new IOException("mapping contains ambiguous leaf queue reference " + mapping.getFullPath());
                    }
                    newMapping = QueuePlacementRuleUtils.validateAndGetAutoCreatedQueueMapping(this.queueManager, mapping);
                    if (newMapping == null) {
                        throw new IOException("mapping contains invalid or non-leaf queue " + mapping.getQueue());
                    }
                    newMappings.add(newMapping);
                    continue;
                }
                newMapping = QueuePlacementRuleUtils.validateAndGetQueueMapping(this.queueManager, queue, mapping);
                newMappings.add(newMapping);
                continue;
            }
            QueueMapping newMapping = QueuePlacementRuleUtils.validateAndGetAutoCreatedQueueMapping(this.queueManager, mapping);
            if (newMapping != null) {
                newMappings.add(newMapping);
                continue;
            }
            newMappings.add(mapping);
        }
        if (newMappings.size() > 0) {
            this.mappings = newMappings;
            this.overrideWithQueueMappings = overrideWithQueueMappings;
            LOG.info("get valid queue mapping from app name config: " + ((Object)newMappings).toString() + ", override: " + overrideWithQueueMappings);
            return true;
        }
        return false;
    }

    private static boolean ifQueueDoesNotExist(CSQueue queue) {
        return queue == null;
    }

    private ApplicationPlacementContext getAppPlacementContext(String user, String applicationName) throws IOException {
        for (QueueMapping mapping : this.mappings) {
            if (mapping.getSource().equals(CURRENT_APP_MAPPING)) {
                if (mapping.getQueue().equals(CURRENT_APP_MAPPING)) {
                    return QueuePlacementRuleUtils.getPlacementContext(mapping, applicationName, this.queueManager);
                }
                return QueuePlacementRuleUtils.getPlacementContext(mapping, this.queueManager);
            }
            if (!mapping.getSource().equals(applicationName)) continue;
            return QueuePlacementRuleUtils.getPlacementContext(mapping, this.queueManager);
        }
        return null;
    }

    @Override
    public ApplicationPlacementContext getPlacementForApp(ApplicationSubmissionContext asc, String user) throws YarnException {
        String queueName = asc.getQueue();
        String applicationName = asc.getApplicationName();
        if (this.mappings != null && this.mappings.size() > 0) {
            try {
                ApplicationPlacementContext mappedQueue = this.getAppPlacementContext(user, applicationName);
                if (mappedQueue != null && (queueName.equals("default") || queueName.equals(mappedQueue.getQueue()) || this.overrideWithQueueMappings)) {
                    LOG.info("Application {} mapping [{}] to [{}] override {}", new Object[]{applicationName, queueName, mappedQueue.getQueue(), this.overrideWithQueueMappings});
                    return mappedQueue;
                }
            }
            catch (IOException ioex) {
                String message = "Failed to submit application " + applicationName + " reason: " + ioex.getMessage();
                throw new YarnException(message);
            }
        }
        return null;
    }
}

