/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.fpga;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.FpgaDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FpgaResourceAllocator {
    static final Logger LOG = LoggerFactory.getLogger(FpgaResourceAllocator.class);
    private List<FpgaDevice> allowedFpgas = new LinkedList<FpgaDevice>();
    private Map<String, List<FpgaDevice>> availableFpgas = new HashMap<String, List<FpgaDevice>>();
    private Map<String, List<FpgaDevice>> containerToFpgaMapping = new HashMap<String, List<FpgaDevice>>();
    private Context nmContext;

    @VisibleForTesting
    Map<String, List<FpgaDevice>> getAvailableFpga() {
        return this.availableFpgas;
    }

    @VisibleForTesting
    List<FpgaDevice> getAllowedFpga() {
        return this.allowedFpgas;
    }

    public FpgaResourceAllocator(Context ctx) {
        this.nmContext = ctx;
    }

    @VisibleForTesting
    int getAvailableFpgaCount() {
        int count = 0;
        count = this.availableFpgas.values().stream().mapToInt(i -> i.size()).sum();
        return count;
    }

    @VisibleForTesting
    Map<String, List<FpgaDevice>> getUsedFpga() {
        return this.containerToFpgaMapping;
    }

    @VisibleForTesting
    int getUsedFpgaCount() {
        int count = 0;
        count = this.containerToFpgaMapping.values().stream().mapToInt(i -> i.size()).sum();
        return count;
    }

    public synchronized void addFpgaDevices(String type, List<FpgaDevice> list) {
        this.availableFpgas.putIfAbsent(type, new LinkedList());
        LinkedList<FpgaDevice> fpgaDevices = new LinkedList<FpgaDevice>();
        for (FpgaDevice device : list) {
            if (!this.allowedFpgas.contains(device)) {
                fpgaDevices.add(device);
                this.availableFpgas.get(type).add(device);
                continue;
            }
            LOG.warn("Duplicate device found: " + device + ". Ignored");
        }
        this.allowedFpgas = ImmutableList.copyOf(fpgaDevices);
        LOG.info("Added a list of FPGA Devices: " + this.allowedFpgas);
    }

    public synchronized void updateFpga(String requestor, FpgaDevice device, String newIPID, String newHash) {
        device.setIPID(newIPID);
        device.setAocxHash(newHash);
        LOG.info("Update IPID to " + newIPID + " for this allocated device: " + device);
        LOG.info("Update IP hash to " + newHash);
    }

    public synchronized FpgaAllocation assignFpga(String type, long count, Container container, String ipidHash) throws ResourceHandlerException {
        List<FpgaDevice> currentAvailableFpga = this.availableFpgas.get(type);
        String requestor = container.getContainerId().toString();
        if (null == currentAvailableFpga) {
            throw new ResourceHandlerException("No such type of FPGA resource available: " + type);
        }
        if (count < 0L || count > (long)currentAvailableFpga.size()) {
            throw new ResourceHandlerException("Invalid FPGA request count or not enough, requested:" + count + ", available:" + this.getAvailableFpgaCount());
        }
        if (count > 0L) {
            LinkedList<FpgaDevice> assignedFpgas = new LinkedList<FpgaDevice>();
            int matchIPCount = 0;
            for (int i = 0; i < currentAvailableFpga.size(); ++i) {
                String deviceIPIDhash = currentAvailableFpga.get(i).getAocxHash();
                if (deviceIPIDhash == null || !deviceIPIDhash.equalsIgnoreCase(ipidHash)) continue;
                assignedFpgas.add(currentAvailableFpga.get(i));
                currentAvailableFpga.remove(i);
                ++matchIPCount;
            }
            for (int remaining = (int)count - matchIPCount; remaining > 0; --remaining) {
                assignedFpgas.add(currentAvailableFpga.remove(0));
            }
            if (!assignedFpgas.isEmpty()) {
                try {
                    this.nmContext.getNMStateStore().storeAssignedResources(container, "yarn.io/fpga", new LinkedList<Serializable>(assignedFpgas));
                }
                catch (IOException e) {
                    currentAvailableFpga.addAll(assignedFpgas);
                    throw new ResourceHandlerException(e);
                }
                this.containerToFpgaMapping.putIfAbsent(requestor, new LinkedList());
                this.containerToFpgaMapping.get(requestor).addAll(assignedFpgas);
            }
            return new FpgaAllocation(assignedFpgas, currentAvailableFpga);
        }
        return new FpgaAllocation(null, this.allowedFpgas);
    }

    public synchronized void recoverAssignedFpgas(ContainerId containerId) throws ResourceHandlerException {
        Container c = (Container)this.nmContext.getContainers().get(containerId);
        if (null == c) {
            throw new ResourceHandlerException("This shouldn't happen, cannot find container with id=" + containerId);
        }
        for (Serializable fpgaDevice : c.getResourceMappings().getAssignedResources("yarn.io/fpga")) {
            if (!(fpgaDevice instanceof FpgaDevice)) {
                throw new ResourceHandlerException("Trying to recover allocated FPGA devices, however it is not FpgaDevice type, this shouldn't happen");
            }
            if (!this.allowedFpgas.contains(fpgaDevice)) {
                throw new ResourceHandlerException("Try to recover FpgaDevice = " + fpgaDevice + " however it is not in allowed device list:" + StringUtils.join((CharSequence)";", this.allowedFpgas));
            }
            Iterator<Map.Entry<String, List<FpgaDevice>>> iterator = this.getUsedFpga().entrySet().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getValue().contains(fpgaDevice)) continue;
                throw new ResourceHandlerException("Try to recover FpgaDevice = " + fpgaDevice + " however it is already assigned to others");
            }
            this.getUsedFpga().putIfAbsent(containerId.toString(), new LinkedList());
            this.getUsedFpga().get(containerId.toString()).add((FpgaDevice)fpgaDevice);
            this.getAvailableFpga().get(((FpgaDevice)fpgaDevice).getType()).remove(fpgaDevice);
        }
    }

    public synchronized void cleanupAssignFpgas(String requestor) {
        List<FpgaDevice> usedFpgas = this.containerToFpgaMapping.get(requestor);
        if (usedFpgas != null) {
            for (FpgaDevice device : usedFpgas) {
                this.availableFpgas.get(device.getType()).add(device);
            }
            this.containerToFpgaMapping.remove(requestor);
        }
    }

    public static class FpgaAllocation {
        private List<FpgaDevice> allowed = Collections.emptyList();
        private List<FpgaDevice> denied = Collections.emptyList();

        FpgaAllocation(List<FpgaDevice> allowed, List<FpgaDevice> denied) {
            if (allowed != null) {
                this.allowed = ImmutableList.copyOf(allowed);
            }
            if (denied != null) {
                this.denied = ImmutableList.copyOf(denied);
            }
        }

        public List<FpgaDevice> getAllowed() {
            return this.allowed;
        }

        public List<FpgaDevice> getDenied() {
            return this.denied;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\nFpgaAllocation\n\tAllowed:\n");
            for (FpgaDevice device : this.allowed) {
                sb.append("\t\t");
                sb.append(device + "\n");
            }
            sb.append("\tDenied\n");
            for (FpgaDevice device : this.denied) {
                sb.append("\t\t");
                sb.append(device + "\n");
            }
            return sb.toString();
        }
    }
}

