/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.configuration.plugins;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.hadoop.shaded.org.mockito.internal.configuration.plugins.DefaultMockitoPlugins;
import org.apache.hadoop.shaded.org.mockito.internal.configuration.plugins.PluginFinder;
import org.apache.hadoop.shaded.org.mockito.internal.util.collections.Iterables;
import org.apache.hadoop.shaded.org.mockito.plugins.PluginSwitch;

class PluginInitializer {
    private final PluginSwitch pluginSwitch;
    private final String alias;
    private final DefaultMockitoPlugins plugins;

    PluginInitializer(PluginSwitch pluginSwitch, String alias, DefaultMockitoPlugins plugins) {
        this.pluginSwitch = pluginSwitch;
        this.alias = alias;
        this.plugins = plugins;
    }

    public <T> T loadImpl(Class<T> service) {
        Enumeration<URL> resources;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            resources = loader.getResources("mockito-extensions/" + service.getName());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load " + service, e);
        }
        try {
            String classOrAlias = new PluginFinder(this.pluginSwitch).findPluginClass(Iterables.toIterable(resources));
            if (classOrAlias != null) {
                if (classOrAlias.equals(this.alias)) {
                    classOrAlias = this.plugins.getDefaultPluginClass(this.alias);
                }
                Class<?> pluginClass = loader.loadClass(classOrAlias);
                Object plugin = pluginClass.newInstance();
                return service.cast(plugin);
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load " + service + " implementation declared in " + resources, e);
        }
    }
}

