/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.configuration.injection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import org.apache.hadoop.shaded.org.mockito.internal.configuration.injection.MockInjectionStrategy;
import org.apache.hadoop.shaded.org.mockito.internal.configuration.injection.filter.MockCandidateFilter;
import org.apache.hadoop.shaded.org.mockito.internal.configuration.injection.filter.NameBasedCandidateFilter;
import org.apache.hadoop.shaded.org.mockito.internal.configuration.injection.filter.TerminalMockCandidateFilter;
import org.apache.hadoop.shaded.org.mockito.internal.configuration.injection.filter.TypeBasedCandidateFilter;
import org.apache.hadoop.shaded.org.mockito.internal.exceptions.Reporter;
import org.apache.hadoop.shaded.org.mockito.internal.util.collections.ListUtil;
import org.apache.hadoop.shaded.org.mockito.internal.util.collections.Sets;
import org.apache.hadoop.shaded.org.mockito.internal.util.reflection.FieldInitializationReport;
import org.apache.hadoop.shaded.org.mockito.internal.util.reflection.FieldInitializer;
import org.apache.hadoop.shaded.org.mockito.internal.util.reflection.SuperTypesLastSorter;

public class PropertyAndSetterInjection
extends MockInjectionStrategy {
    private final MockCandidateFilter mockCandidateFilter = new TypeBasedCandidateFilter(new NameBasedCandidateFilter(new TerminalMockCandidateFilter()));
    private final ListUtil.Filter<Field> notFinalOrStatic = new ListUtil.Filter<Field>(){

        @Override
        public boolean isOut(Field object) {
            return Modifier.isFinal(object.getModifiers()) || Modifier.isStatic(object.getModifiers());
        }
    };

    @Override
    public boolean processInjection(Field injectMocksField, Object injectMocksFieldOwner, Set<Object> mockCandidates) {
        FieldInitializationReport report = this.initializeInjectMocksField(injectMocksField, injectMocksFieldOwner);
        boolean injectionOccurred = false;
        Object fieldInstanceNeedingInjection = report.fieldInstance();
        for (Class<?> fieldClass = report.fieldClass(); fieldClass != Object.class; fieldClass = fieldClass.getSuperclass()) {
            injectionOccurred |= this.injectMockCandidates(fieldClass, fieldInstanceNeedingInjection, Sets.newMockSafeHashSet(mockCandidates));
        }
        return injectionOccurred;
    }

    private FieldInitializationReport initializeInjectMocksField(Field field, Object fieldOwner) {
        try {
            return new FieldInitializer(fieldOwner, field).initialize();
        }
        catch (MockitoException e) {
            if (e.getCause() instanceof InvocationTargetException) {
                Throwable realCause = e.getCause().getCause();
                throw Reporter.fieldInitialisationThrewException(field, realCause);
            }
            throw Reporter.cannotInitializeForInjectMocksAnnotation(field.getName(), e.getMessage());
        }
    }

    private boolean injectMockCandidates(Class<?> awaitingInjectionClazz, Object injectee, Set<Object> mocks) {
        List<Field> orderedCandidateInjecteeFields = this.orderedInstanceFieldsFrom(awaitingInjectionClazz);
        boolean injectionOccurred = this.injectMockCandidatesOnFields(mocks, injectee, false, orderedCandidateInjecteeFields);
        injectionOccurred |= this.injectMockCandidatesOnFields(mocks, injectee, injectionOccurred, orderedCandidateInjecteeFields);
        return injectionOccurred;
    }

    private boolean injectMockCandidatesOnFields(Set<Object> mocks, Object injectee, boolean injectionOccurred, List<Field> orderedCandidateInjecteeFields) {
        Iterator<Field> it = orderedCandidateInjecteeFields.iterator();
        while (it.hasNext()) {
            Field candidateField = it.next();
            Object injected = this.mockCandidateFilter.filterCandidate(mocks, candidateField, orderedCandidateInjecteeFields, injectee).thenInject();
            if (injected == null) continue;
            injectionOccurred |= true;
            mocks.remove(injected);
            it.remove();
        }
        return injectionOccurred;
    }

    private List<Field> orderedInstanceFieldsFrom(Class<?> awaitingInjectionClazz) {
        List<Field> declaredFields = Arrays.asList(awaitingInjectionClazz.getDeclaredFields());
        declaredFields = ListUtil.filter(declaredFields, this.notFinalOrStatic);
        return SuperTypesLastSorter.sortSuperTypesLast(declaredFields);
    }
}

