/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.jsr107;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.shaded.javax.cache.Cache;
import org.apache.hadoop.shaded.javax.cache.event.CacheEntryCreatedListener;
import org.apache.hadoop.shaded.javax.cache.event.CacheEntryEventFilter;
import org.apache.hadoop.shaded.javax.cache.event.CacheEntryExpiredListener;
import org.apache.hadoop.shaded.javax.cache.event.CacheEntryListener;
import org.apache.hadoop.shaded.javax.cache.event.CacheEntryRemovedListener;
import org.apache.hadoop.shaded.javax.cache.event.CacheEntryUpdatedListener;
import org.apache.hadoop.shaded.org.ehcache.event.CacheEvent;
import org.apache.hadoop.shaded.org.ehcache.event.CacheEventListener;
import org.apache.hadoop.shaded.org.ehcache.event.EventType;
import org.apache.hadoop.shaded.org.ehcache.jsr107.Eh107CacheEntryEvent;

class EventListenerAdaptors {
    static <K, V> List<EventListenerAdaptor<K, V>> ehListenersFor(CacheEntryListener<? super K, ? super V> listener, CacheEntryEventFilter<? super K, ? super V> filter, Cache<K, V> source, boolean requestsOld) {
        ArrayList<EventListenerAdaptor<K, V>> rv = new ArrayList<EventListenerAdaptor<K, V>>();
        if (listener instanceof CacheEntryUpdatedListener) {
            rv.add(new UpdatedAdaptor<K, V>(source, (CacheEntryUpdatedListener)listener, filter, requestsOld));
        }
        if (listener instanceof CacheEntryCreatedListener) {
            rv.add(new CreatedAdaptor<K, V>(source, (CacheEntryCreatedListener)listener, filter, requestsOld));
        }
        if (listener instanceof CacheEntryRemovedListener) {
            rv.add(new RemovedAdaptor<K, V>(source, (CacheEntryRemovedListener)listener, filter, requestsOld));
        }
        if (listener instanceof CacheEntryExpiredListener) {
            rv.add(new ExpiredAdaptor<K, V>(source, (CacheEntryExpiredListener)listener, filter, requestsOld));
        }
        return rv;
    }

    private EventListenerAdaptors() {
    }

    static class CreatedAdaptor<K, V>
    extends EventListenerAdaptor<K, V> {
        private final CacheEntryCreatedListener<K, V> listener;

        CreatedAdaptor(Cache<K, V> source, CacheEntryCreatedListener<K, V> listener, CacheEntryEventFilter<K, V> filter, boolean requestsOld) {
            super(source, filter, requestsOld);
            this.listener = listener;
        }

        @Override
        EventType getEhcacheEventType() {
            return EventType.CREATED;
        }

        @Override
        public void onEvent(CacheEvent<? extends K, ? extends V> ehEvent) {
            Eh107CacheEntryEvent.NormalEvent<? extends K, ? extends V> event = new Eh107CacheEntryEvent.NormalEvent<K, V>(this.source, org.apache.hadoop.shaded.javax.cache.event.EventType.CREATED, ehEvent, this.requestsOld);
            if (this.filter.evaluate(event)) {
                Set events = Collections.singleton(event);
                this.listener.onCreated(events);
            }
        }
    }

    static class ExpiredAdaptor<K, V>
    extends EventListenerAdaptor<K, V> {
        private final CacheEntryExpiredListener<K, V> listener;

        ExpiredAdaptor(Cache<K, V> source, CacheEntryExpiredListener<K, V> listener, CacheEntryEventFilter<K, V> filter, boolean requestsOld) {
            super(source, filter, requestsOld);
            this.listener = listener;
        }

        @Override
        EventType getEhcacheEventType() {
            return EventType.EXPIRED;
        }

        @Override
        public void onEvent(CacheEvent<? extends K, ? extends V> ehEvent) {
            Eh107CacheEntryEvent.RemovingEvent<? extends K, ? extends V> event = new Eh107CacheEntryEvent.RemovingEvent<K, V>(this.source, org.apache.hadoop.shaded.javax.cache.event.EventType.EXPIRED, ehEvent, this.requestsOld);
            if (this.filter.evaluate(event)) {
                Set events = Collections.singleton(event);
                this.listener.onExpired(events);
            }
        }
    }

    static class RemovedAdaptor<K, V>
    extends EventListenerAdaptor<K, V> {
        private final CacheEntryRemovedListener<K, V> listener;

        RemovedAdaptor(Cache<K, V> source, CacheEntryRemovedListener<K, V> listener, CacheEntryEventFilter<K, V> filter, boolean requestsOld) {
            super(source, filter, requestsOld);
            this.listener = listener;
        }

        @Override
        EventType getEhcacheEventType() {
            return EventType.REMOVED;
        }

        @Override
        public void onEvent(CacheEvent<? extends K, ? extends V> ehEvent) {
            Eh107CacheEntryEvent.RemovingEvent<? extends K, ? extends V> event = new Eh107CacheEntryEvent.RemovingEvent<K, V>(this.source, org.apache.hadoop.shaded.javax.cache.event.EventType.REMOVED, ehEvent, this.requestsOld);
            if (this.filter.evaluate(event)) {
                Set events = Collections.singleton(event);
                this.listener.onRemoved(events);
            }
        }
    }

    static class UpdatedAdaptor<K, V>
    extends EventListenerAdaptor<K, V> {
        private final CacheEntryUpdatedListener<K, V> listener;

        UpdatedAdaptor(Cache<K, V> source, CacheEntryUpdatedListener<K, V> listener, CacheEntryEventFilter<K, V> filter, boolean requestsOld) {
            super(source, filter, requestsOld);
            this.listener = listener;
        }

        @Override
        EventType getEhcacheEventType() {
            return EventType.UPDATED;
        }

        @Override
        public void onEvent(CacheEvent<? extends K, ? extends V> ehEvent) {
            Eh107CacheEntryEvent.NormalEvent<? extends K, ? extends V> event = new Eh107CacheEntryEvent.NormalEvent<K, V>(this.source, org.apache.hadoop.shaded.javax.cache.event.EventType.UPDATED, ehEvent, this.requestsOld);
            if (this.filter.evaluate(event)) {
                Set events = Collections.singleton(event);
                this.listener.onUpdated(events);
            }
        }
    }

    static abstract class EventListenerAdaptor<K, V>
    implements CacheEventListener<K, V> {
        final CacheEntryEventFilter<K, V> filter;
        final Cache<K, V> source;
        final boolean requestsOld;

        EventListenerAdaptor(Cache<K, V> source, CacheEntryEventFilter<K, V> filter, boolean requestsOld) {
            this.source = source;
            this.filter = filter;
            this.requestsOld = requestsOld;
        }

        abstract EventType getEhcacheEventType();
    }
}

