/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.decoders;

import org.apache.hadoop.shaded.javax.websocket.DecodeException;
import org.apache.hadoop.shaded.javax.websocket.Decoder;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.decoders.AbstractDecoder;

public class LongDecoder
extends AbstractDecoder
implements Decoder.Text<Long> {
    public static final LongDecoder INSTANCE = new LongDecoder();

    @Override
    public Long decode(String s) throws DecodeException {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s, "Unable to parse Long", (Throwable)e);
        }
    }

    @Override
    public boolean willDecode(String s) {
        if (s == null) {
            return false;
        }
        try {
            Long.parseLong(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

