/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.decoders;

import org.apache.hadoop.shaded.javax.websocket.DecodeException;
import org.apache.hadoop.shaded.javax.websocket.Decoder;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.decoders.AbstractDecoder;

public class FloatDecoder
extends AbstractDecoder
implements Decoder.Text<Float> {
    public static final FloatDecoder INSTANCE = new FloatDecoder();

    @Override
    public Float decode(String s) throws DecodeException {
        try {
            Float val = Float.valueOf(Float.parseFloat(s));
            if (val.isNaN()) {
                throw new DecodeException(s, "NaN");
            }
            return val;
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s, "Unable to parse float", (Throwable)e);
        }
    }

    @Override
    public boolean willDecode(String s) {
        if (s == null) {
            return false;
        }
        try {
            Float val = Float.valueOf(Float.parseFloat(s));
            return !val.isNaN();
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

