/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.sun.jersey.api.container.filter;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.hadoop.shaded.com.sun.jersey.api.container.ContainerException;
import org.apache.hadoop.shaded.com.sun.jersey.spi.container.ContainerRequest;
import org.apache.hadoop.shaded.com.sun.jersey.spi.container.ContainerRequestFilter;
import org.apache.hadoop.shaded.com.sun.jersey.spi.container.ContainerResponse;
import org.apache.hadoop.shaded.com.sun.jersey.spi.container.ContainerResponseFilter;
import org.apache.hadoop.shaded.com.sun.jersey.spi.container.ContainerResponseWriter;
import org.apache.hadoop.shaded.javax.ws.rs.core.EntityTag;

public class GZIPContentEncodingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String ENTITY_TAG_GZIP_SUFFIX_VALUE = "-gzip";
    private static final String ENTITY_TAG_GZIP_SUFFIX_HEADER_VALUE = "-gzip\"";

    @Override
    public ContainerRequest filter(ContainerRequest request) {
        String contentEncoding = (String)request.getRequestHeaders().getFirst((Object)"Content-Encoding");
        if (contentEncoding != null && contentEncoding.trim().equals("gzip")) {
            request.getRequestHeaders().remove((Object)"Content-Encoding");
            try {
                request.setEntityInputStream(new GZIPInputStream(request.getEntityInputStream()));
            }
            catch (IOException ex) {
                throw new ContainerException(ex);
            }
        }
        String acceptEncoding = (String)request.getRequestHeaders().getFirst((Object)"Accept-Encoding");
        String entityTag = (String)request.getRequestHeaders().getFirst((Object)"If-None-Match");
        if (acceptEncoding != null && acceptEncoding.contains("gzip") && entityTag != null) {
            if (entityTag.endsWith(ENTITY_TAG_GZIP_SUFFIX_HEADER_VALUE)) {
                int gzipsuffixbeginIndex = entityTag.lastIndexOf(ENTITY_TAG_GZIP_SUFFIX_HEADER_VALUE);
                StringBuilder sb = new StringBuilder();
                sb.append(entityTag.substring(0, gzipsuffixbeginIndex));
                sb.append('\"');
                request.getRequestHeaders().putSingle((Object)"If-None-Match", (Object)sb.toString());
            } else {
                request.getRequestHeaders().remove((Object)"If-None-Match");
            }
        }
        return request;
    }

    @Override
    public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
        response.getHttpHeaders().add((Object)"Vary", (Object)"Accept-Encoding");
        String acceptEncoding = (String)request.getRequestHeaders().getFirst((Object)"Accept-Encoding");
        String contentEncoding = (String)response.getHttpHeaders().getFirst((Object)"Content-Encoding");
        if (acceptEncoding != null && contentEncoding == null && acceptEncoding.contains("gzip")) {
            EntityTag entityTag;
            if (response.getHttpHeaders().containsKey((Object)"ETag") && (entityTag = (EntityTag)response.getHttpHeaders().getFirst((Object)"ETag")) != null) {
                response.getHttpHeaders().putSingle((Object)"ETag", (Object)new EntityTag(entityTag.getValue() + ENTITY_TAG_GZIP_SUFFIX_VALUE, entityTag.isWeak()));
            }
            if (response.getEntity() != null) {
                response.getHttpHeaders().add((Object)"Content-Encoding", (Object)"gzip");
                response.setContainerResponseWriter(new Adapter(response.getContainerResponseWriter()));
            }
        }
        return response;
    }

    private static final class Adapter
    implements ContainerResponseWriter {
        private final ContainerResponseWriter crw;
        private GZIPOutputStream gos;

        Adapter(ContainerResponseWriter crw) {
            this.crw = crw;
        }

        @Override
        public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse response) throws IOException {
            this.gos = new GZIPOutputStream(this.crw.writeStatusAndHeaders(-1L, response));
            return this.gos;
        }

        @Override
        public void finish() throws IOException {
            this.gos.finish();
            this.crw.finish();
        }
    }
}

