/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public abstract class HAState {
    protected final HAServiceProtocol.HAServiceState state;
    private long lastHATransitionTime;

    public HAState(HAServiceProtocol.HAServiceState state) {
        this.state = state;
    }

    public HAServiceProtocol.HAServiceState getServiceState() {
        return this.state;
    }

    protected final void setStateInternal(HAContext context, HAState s) throws ServiceFailedException {
        this.prepareToExitState(context);
        s.prepareToEnterState(context);
        context.writeLock();
        try {
            this.exitState(context);
            context.setState(s);
            s.enterState(context);
            s.updateLastHATransitionTime();
        }
        finally {
            context.writeUnlock();
        }
    }

    public long getLastHATransitionTime() {
        return this.lastHATransitionTime;
    }

    private void updateLastHATransitionTime() {
        this.lastHATransitionTime = Time.now();
    }

    public void prepareToEnterState(HAContext context) throws ServiceFailedException {
    }

    public abstract void enterState(HAContext var1) throws ServiceFailedException;

    public void prepareToExitState(HAContext context) throws ServiceFailedException {
    }

    public abstract void exitState(HAContext var1) throws ServiceFailedException;

    public void setState(HAContext context, HAState s) throws ServiceFailedException {
        if (this == s) {
            return;
        }
        throw new ServiceFailedException("Transition from state " + this + " to " + s + " is not allowed.");
    }

    public abstract void checkOperation(HAContext var1, NameNode.OperationCategory var2) throws StandbyException;

    public abstract boolean shouldPopulateReplQueues();

    public String toString() {
        return this.state.toString();
    }
}

