/**
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in org.apache.hadoop.shaded.com.liance
* with the License.  You may obtain a copy of the License at
*
*     http://www.apache.org.apache.hadoop.shaded.org.licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// Generated by HamletGen. Do NOT edit!
package org.apache.hadoop.shaded.org.apache.hadoop.yarn.webapp.hamlet2;
import static java.util.EnumSet.of;
import static org.apache.hadoop.shaded.org.apache.hadoop.yarn.webapp.hamlet2.HamletImpl.EOpt.ENDTAG;
import static org.apache.hadoop.shaded.org.apache.hadoop.yarn.webapp.hamlet2.HamletImpl.EOpt.INLINE;
import static org.apache.hadoop.shaded.org.apache.hadoop.yarn.webapp.hamlet2.HamletImpl.EOpt.PRE;

import java.org.apache.hadoop.shaded.io.PrintWriter;
import java.util.EnumSet;

import org.apache.hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.shaded.org.apache.hadoop.yarn.webapp.SubView;

@InterfaceAudience.LimitedPrivate({"YARN", "MapReduce"})
public class Hamlet extends HamletImpl implements HamletSpec._Html {
  public Hamlet(PrintWriter out, int nestLevel, boolean wasInline) {
    super(out, nestLevel, wasInline);
  }

  static EnumSet<EOpt> opt(boolean endTag, boolean inline, boolean pre) {
    EnumSet<EOpt> opts = of(ENDTAG);
    if (!endTag) opts.remove(ENDTAG);
    if (inline) opts.add(INLINE);
    if (pre) opts.add(PRE);
    return opts;
  }

  public class HTML<T extends __> extends EImp<T> implements HamletSpec.HTML {
    public HTML(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public HTML<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public HTML<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public HEAD<HTML<T>> head() {
      closeAttrs();
      return head_(this, false);
    }

    @Override
    public BODY<HTML<T>> body() {
      closeAttrs();
      return body_(this, false);
    }

    @Override
    public BODY<HTML<T>> body(String selector) {
      return setSelector(body(), selector);
    }

    @Override
    public BASE<HTML<T>> base() {
      closeAttrs();
      return base_(this, false);
    }

    @Override
    public HTML<T> base(String href) {
      return base().$href(href).__();
    }

    @Override
    public TITLE<HTML<T>> title() {
      closeAttrs();
      return title_(this, false);
    }

    @Override
    public HTML<T> title(String cdata) {
      return title().__(cdata).__();
    }

    @Override
    public STYLE<HTML<T>> style() {
      closeAttrs();
      return style_(this, false);
    }

    @Override
    public HTML<T> style(Object... lines) {
      return style().$type("text/css").__(lines).__();
    }

    @Override
    public LINK<HTML<T>> link() {
      closeAttrs();
      return link_(this, false);
    }

    @Override
    public HTML<T> link(String href) {
      return setLinkHref(link(), href).__();
    }

    @Override
    public META<HTML<T>> meta() {
      closeAttrs();
      return meta_(this, false);
    }

    @Override
    public HTML<T> meta(String name, String content) {
      return meta().$name(name).$content(content).__();
    }

    @Override
    public HTML<T> meta_http(String header, String content) {
      return meta().$http_equiv(header).$content(content).__();
    }

    @Override
    public SCRIPT<HTML<T>> script() {
      closeAttrs();
      return script_(this, false);
    }

    @Override
    public HTML<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public OBJECT<HTML<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<HTML<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public TABLE<HTML<T>> table() {
      closeAttrs();
      return table_(this, false);
    }

    @Override
    public TABLE<HTML<T>> table(String selector) {
      return setSelector(table(), selector);
    }

    @Override
    public HTML<T> address(String cdata) {
      return address().__(cdata).__();
    }

    @Override
    public ADDRESS<HTML<T>> address() {
      closeAttrs();
      return address_(this, false);
    }

    @Override
    public P<HTML<T>> p(String selector) {
      return setSelector(p(), selector);
    }

    @Override
    public P<HTML<T>> p() {
      closeAttrs();
      return p_(this, false);
    }

    @Override
    public HTML<T> __(Class<? extends SubView> cls) {
      _v(cls);
      return this;
    }

    @Override
    public HR<HTML<T>> hr() {
      closeAttrs();
      return hr_(this, false);
    }

    @Override
    public HTML<T> hr(String selector) {
      return setSelector(hr(), selector).__();
    }

    @Override
    public DL<HTML<T>> dl(String selector) {
      return setSelector(dl(), selector);
    }

    @Override
    public DL<HTML<T>> dl() {
      closeAttrs();
      return dl_(this, false);
    }

    @Override
    public DIV<HTML<T>> div(String selector) {
      return setSelector(div(), selector);
    }

    @Override
    public DIV<HTML<T>> div() {
      closeAttrs();
      return div_(this, false);
    }

    @Override
    public BLOCKQUOTE<HTML<T>> blockquote() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BLOCKQUOTE<HTML<T>> bq() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public HTML<T> h1(String cdata) {
      return h1().__(cdata).__();
    }

    @Override
    public H1<HTML<T>> h1() {
      closeAttrs();
      return h1_(this, false);
    }

    @Override
    public HTML<T> h1(String selector, String cdata) {
      return setSelector(h1(), selector).__(cdata).__();
    }

    @Override
    public HTML<T> h2(String cdata) {
      return h2().__(cdata).__();
    }

    @Override
    public H2<HTML<T>> h2() {
      closeAttrs();
      return h2_(this, false);
    }

    @Override
    public HTML<T> h2(String selector, String cdata) {
      return setSelector(h2(), selector).__(cdata).__();
    }

    @Override
    public H3<HTML<T>> h3() {
      closeAttrs();
      return h3_(this, false);
    }

    @Override
    public HTML<T> h3(String cdata) {
      return h3().__(cdata).__();
    }

    @Override
    public HTML<T> h3(String selector, String cdata) {
      return setSelector(h3(), selector).__(cdata).__();
    }

    @Override
    public H4<HTML<T>> h4() {
      closeAttrs();
      return h4_(this, false);
    }

    @Override
    public HTML<T> h4(String cdata) {
      return h4().__(cdata).__();
    }

    @Override
    public HTML<T> h4(String selector, String cdata) {
      return setSelector(h4(), selector).__(cdata).__();
    }

    @Override
    public H5<HTML<T>> h5() {
      closeAttrs();
      return h5_(this, false);
    }

    @Override
    public HTML<T> h5(String cdata) {
      return h5().__(cdata).__();
    }

    @Override
    public HTML<T> h5(String selector, String cdata) {
      return setSelector(h5(), selector).__(cdata).__();
    }

    @Override
    public H6<HTML<T>> h6() {
      closeAttrs();
      return h6_(this, false);
    }

    @Override
    public HTML<T> h6(String cdata) {
      return h6().__(cdata).__();
    }

    @Override
    public HTML<T> h6(String selector, String cdata) {
      return setSelector(h6(), selector).__(cdata).__();
    }

    @Override
    public UL<HTML<T>> ul() {
      closeAttrs();
      return ul_(this, false);
    }

    @Override
    public UL<HTML<T>> ul(String selector) {
      return setSelector(ul(), selector);
    }

    @Override
    public OL<HTML<T>> ol() {
      closeAttrs();
      return ol_(this, false);
    }

    @Override
    public OL<HTML<T>> ol(String selector) {
      return setSelector(ol(), selector);
    }

    @Override
    public PRE<HTML<T>> pre() {
      closeAttrs();
      return pre_(this, false);
    }

    @Override
    public PRE<HTML<T>> pre(String selector) {
      return setSelector(pre(), selector);
    }

    @Override
    public FORM<HTML<T>> form() {
      closeAttrs();
      return form_(this, false);
    }

    @Override
    public FORM<HTML<T>> form(String selector) {
      return setSelector(form(), selector);
    }

    @Override
    public FIELDSET<HTML<T>> fieldset() {
      closeAttrs();
      return fieldset_(this, false);
    }

    @Override
    public FIELDSET<HTML<T>> fieldset(String selector) {
      return setSelector(fieldset(), selector);
    }

    @Override
    public INS<HTML<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public HTML<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<HTML<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public HTML<T> del(String cdata) {
      return del().__(cdata).__();
    }
  }

  private <T extends __> HEAD<T> head_(T e, boolean inline) {
    return new HEAD<T>("head", e, opt(true, inline, false)); }

  private <T extends __> BODY<T> body_(T e, boolean inline) {
    return new BODY<T>("body", e, opt(true, inline, false)); }

  public class SCRIPT<T extends __> extends EImp<T> implements HamletSpec.SCRIPT {
    public SCRIPT(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public SCRIPT<T> $type(String value) {
      addAttr("type", value);
      return this;
    }

    @Override
    public SCRIPT<T> $src(String value) {
      addAttr("src", value);
      return this;
    }

    @Override
    public SCRIPT<T> $charset(String value) {
      addAttr("charset", value);
      return this;
    }

    @Override
    public SCRIPT<T> $defer(String value) {
      addAttr("defer", value);
      return this;
    }

    @Override
    public SCRIPT<T> __(Object... lines) {
      _p(false, lines);
      return this;
    }
  }

  public class STYLE<T extends __> extends EImp<T> implements HamletSpec.STYLE {
    public STYLE(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public STYLE<T> $type(String value) {
      addAttr("type", value);
      return this;
    }

    @Override
    public STYLE<T> $media(EnumSet<Media> value) {
      addMediaAttr("media", value);
      return this;
    }

    @Override
    public STYLE<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public STYLE<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public STYLE<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public STYLE<T> __(Object... lines) {
      _p(false, lines);
      return this;
    }
  }

  public class META<T extends __> extends EImp<T> implements HamletSpec.META {
    public META(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public META<T> $http_equiv(String value) {
      addAttr("http-equiv", value);
      return this;
    }

    @Override
    public META<T> $name(String value) {
      addAttr("name", value);
      return this;
    }

    @Override
    public META<T> $content(String value) {
      addAttr("content", value);
      return this;
    }

    @Override
    public META<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public META<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }
  }

  public class BASE<T extends __> extends EImp<T> implements HamletSpec.BASE {
    public BASE(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public BASE<T> $href(String value) {
      addAttr("href", value);
      return this;
    }
  }

  public class TITLE<T extends __> extends EImp<T> implements HamletSpec.TITLE {
    public TITLE(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public TITLE<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public TITLE<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public TITLE<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public TITLE<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }
  }

  public class HEAD<T extends __> extends EImp<T> implements HamletSpec.HEAD {
    public HEAD(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public HEAD<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public HEAD<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public BASE<HEAD<T>> base() {
      closeAttrs();
      return base_(this, false);
    }

    @Override
    public HEAD<T> base(String href) {
      return base().$href(href).__();
    }

    @Override
    public TITLE<HEAD<T>> title() {
      closeAttrs();
      return title_(this, false);
    }

    @Override
    public HEAD<T> title(String cdata) {
      return title().__(cdata).__();
    }

    @Override
    public STYLE<HEAD<T>> style() {
      closeAttrs();
      return style_(this, false);
    }

    @Override
    public HEAD<T> style(Object... lines) {
      return style().$type("text/css").__(lines).__();
    }

    @Override
    public LINK<HEAD<T>> link() {
      closeAttrs();
      return link_(this, false);
    }

    @Override
    public HEAD<T> link(String href) {
      return setLinkHref(link(), href).__();
    }

    @Override
    public META<HEAD<T>> meta() {
      closeAttrs();
      return meta_(this, false);
    }

    @Override
    public HEAD<T> meta(String name, String content) {
      return meta().$name(name).$content(content).__();
    }

    @Override
    public HEAD<T> meta_http(String header, String content) {
      return meta().$http_equiv(header).$content(content).__();
    }

    @Override
    public SCRIPT<HEAD<T>> script() {
      closeAttrs();
      return script_(this, false);
    }

    @Override
    public HEAD<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public OBJECT<HEAD<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<HEAD<T>> object(String selector) {
      return setSelector(object(), selector);
    }
  }

  private <T extends __> BASE<T> base_(T e, boolean inline) {
    return new BASE<T>("base", e, opt(false, inline, false)); }

  private <T extends __> TITLE<T> title_(T e, boolean inline) {
    return new TITLE<T>("title", e, opt(true, inline, false)); }

  public class TD<T extends __> extends EImp<T> implements HamletSpec.TD {
    public TD(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public TD<T> $headers(String value) {
      addAttr("headers", value);
      return this;
    }

    @Override
    public TD<T> $scope(Scope value) {
      addAttr("scope", value);
      return this;
    }

    @Override
    public TD<T> $rowspan(int value) {
      addAttr("rowspan", value);
      return this;
    }

    @Override
    public TD<T> $colspan(int value) {
      addAttr("colspan", value);
      return this;
    }

    @Override
    public TD<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public TD<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public TD<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public TD<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public TD<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public TD<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public TD<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public TD<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public TD<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public TD<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public TD<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public TD<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public TD<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public TD<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public TD<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public TD<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public TABLE<TD<T>> table() {
      closeAttrs();
      return table_(this, false);
    }

    @Override
    public TABLE<TD<T>> table(String selector) {
      return setSelector(table(), selector);
    }

    @Override
    public TD<T> address(String cdata) {
      return address().__(cdata).__();
    }

    @Override
    public ADDRESS<TD<T>> address() {
      closeAttrs();
      return address_(this, false);
    }

    @Override
    public P<TD<T>> p(String selector) {
      return setSelector(p(), selector);
    }

    @Override
    public P<TD<T>> p() {
      closeAttrs();
      return p_(this, false);
    }

    @Override
    public TD<T> __(Class<? extends SubView> cls) {
      _v(cls);
      return this;
    }

    @Override
    public HR<TD<T>> hr() {
      closeAttrs();
      return hr_(this, false);
    }

    @Override
    public TD<T> hr(String selector) {
      return setSelector(hr(), selector).__();
    }

    @Override
    public DL<TD<T>> dl(String selector) {
      return setSelector(dl(), selector);
    }

    @Override
    public DL<TD<T>> dl() {
      closeAttrs();
      return dl_(this, false);
    }

    @Override
    public DIV<TD<T>> div(String selector) {
      return setSelector(div(), selector);
    }

    @Override
    public DIV<TD<T>> div() {
      closeAttrs();
      return div_(this, false);
    }

    @Override
    public BLOCKQUOTE<TD<T>> blockquote() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BLOCKQUOTE<TD<T>> bq() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public TD<T> h1(String cdata) {
      return h1().__(cdata).__();
    }

    @Override
    public H1<TD<T>> h1() {
      closeAttrs();
      return h1_(this, false);
    }

    @Override
    public TD<T> h1(String selector, String cdata) {
      return setSelector(h1(), selector).__(cdata).__();
    }

    @Override
    public TD<T> h2(String cdata) {
      return h2().__(cdata).__();
    }

    @Override
    public H2<TD<T>> h2() {
      closeAttrs();
      return h2_(this, false);
    }

    @Override
    public TD<T> h2(String selector, String cdata) {
      return setSelector(h2(), selector).__(cdata).__();
    }

    @Override
    public H3<TD<T>> h3() {
      closeAttrs();
      return h3_(this, false);
    }

    @Override
    public TD<T> h3(String cdata) {
      return h3().__(cdata).__();
    }

    @Override
    public TD<T> h3(String selector, String cdata) {
      return setSelector(h3(), selector).__(cdata).__();
    }

    @Override
    public H4<TD<T>> h4() {
      closeAttrs();
      return h4_(this, false);
    }

    @Override
    public TD<T> h4(String cdata) {
      return h4().__(cdata).__();
    }

    @Override
    public TD<T> h4(String selector, String cdata) {
      return setSelector(h4(), selector).__(cdata).__();
    }

    @Override
    public H5<TD<T>> h5() {
      closeAttrs();
      return h5_(this, false);
    }

    @Override
    public TD<T> h5(String cdata) {
      return h5().__(cdata).__();
    }

    @Override
    public TD<T> h5(String selector, String cdata) {
      return setSelector(h5(), selector).__(cdata).__();
    }

    @Override
    public H6<TD<T>> h6() {
      closeAttrs();
      return h6_(this, false);
    }

    @Override
    public TD<T> h6(String cdata) {
      return h6().__(cdata).__();
    }

    @Override
    public TD<T> h6(String selector, String cdata) {
      return setSelector(h6(), selector).__(cdata).__();
    }

    @Override
    public UL<TD<T>> ul() {
      closeAttrs();
      return ul_(this, false);
    }

    @Override
    public UL<TD<T>> ul(String selector) {
      return setSelector(ul(), selector);
    }

    @Override
    public OL<TD<T>> ol() {
      closeAttrs();
      return ol_(this, false);
    }

    @Override
    public OL<TD<T>> ol(String selector) {
      return setSelector(ol(), selector);
    }

    @Override
    public PRE<TD<T>> pre() {
      closeAttrs();
      return pre_(this, false);
    }

    @Override
    public PRE<TD<T>> pre(String selector) {
      return setSelector(pre(), selector);
    }

    @Override
    public FORM<TD<T>> form() {
      closeAttrs();
      return form_(this, false);
    }

    @Override
    public FORM<TD<T>> form(String selector) {
      return setSelector(form(), selector);
    }

    @Override
    public FIELDSET<TD<T>> fieldset() {
      closeAttrs();
      return fieldset_(this, false);
    }

    @Override
    public FIELDSET<TD<T>> fieldset(String selector) {
      return setSelector(fieldset(), selector);
    }

    @Override
    public TD<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public TD<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<TD<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public TD<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public TD<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<TD<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public TD<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public TD<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<TD<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public TD<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public TD<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public TD<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<TD<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public TD<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<TD<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public TD<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public TD<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<TD<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public TD<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public TD<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<TD<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public TD<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public TD<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public TD<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<TD<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public TD<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<TD<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public TD<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public TD<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<TD<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public TD<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public TD<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<TD<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public TD<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public TD<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<TD<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public TD<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public TD<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<TD<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<TD<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public TD<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public TD<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<TD<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public TD<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<TD<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<TD<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<TD<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public TD<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public TD<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<TD<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public TD<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public TD<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<TD<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<TD<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public TD<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public TD<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<TD<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<TD<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public TD<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<TD<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public TD<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<TD<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public TD<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public TD<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<TD<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public TD<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<TD<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public TD<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<TD<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public TD<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<TD<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public TD<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<TD<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<TD<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<TD<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<TD<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<TD<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<TD<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public TD<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<TD<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<TD<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public TD<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class TH<T extends __> extends EImp<T> implements HamletSpec.TH {
    public TH(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public TH<T> $headers(String value) {
      addAttr("headers", value);
      return this;
    }

    @Override
    public TH<T> $scope(Scope value) {
      addAttr("scope", value);
      return this;
    }

    @Override
    public TH<T> $rowspan(int value) {
      addAttr("rowspan", value);
      return this;
    }

    @Override
    public TH<T> $colspan(int value) {
      addAttr("colspan", value);
      return this;
    }

    @Override
    public TH<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public TH<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public TH<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public TH<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public TH<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public TH<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public TH<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public TH<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public TH<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public TH<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public TH<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public TH<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public TH<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public TH<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public TH<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public TH<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public TABLE<TH<T>> table() {
      closeAttrs();
      return table_(this, false);
    }

    @Override
    public TABLE<TH<T>> table(String selector) {
      return setSelector(table(), selector);
    }

    @Override
    public TH<T> address(String cdata) {
      return address().__(cdata).__();
    }

    @Override
    public ADDRESS<TH<T>> address() {
      closeAttrs();
      return address_(this, false);
    }

    @Override
    public P<TH<T>> p(String selector) {
      return setSelector(p(), selector);
    }

    @Override
    public P<TH<T>> p() {
      closeAttrs();
      return p_(this, false);
    }

    @Override
    public TH<T> __(Class<? extends SubView> cls) {
      _v(cls);
      return this;
    }

    @Override
    public HR<TH<T>> hr() {
      closeAttrs();
      return hr_(this, false);
    }

    @Override
    public TH<T> hr(String selector) {
      return setSelector(hr(), selector).__();
    }

    @Override
    public DL<TH<T>> dl(String selector) {
      return setSelector(dl(), selector);
    }

    @Override
    public DL<TH<T>> dl() {
      closeAttrs();
      return dl_(this, false);
    }

    @Override
    public DIV<TH<T>> div(String selector) {
      return setSelector(div(), selector);
    }

    @Override
    public DIV<TH<T>> div() {
      closeAttrs();
      return div_(this, false);
    }

    @Override
    public BLOCKQUOTE<TH<T>> blockquote() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BLOCKQUOTE<TH<T>> bq() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public TH<T> h1(String cdata) {
      return h1().__(cdata).__();
    }

    @Override
    public H1<TH<T>> h1() {
      closeAttrs();
      return h1_(this, false);
    }

    @Override
    public TH<T> h1(String selector, String cdata) {
      return setSelector(h1(), selector).__(cdata).__();
    }

    @Override
    public TH<T> h2(String cdata) {
      return h2().__(cdata).__();
    }

    @Override
    public H2<TH<T>> h2() {
      closeAttrs();
      return h2_(this, false);
    }

    @Override
    public TH<T> h2(String selector, String cdata) {
      return setSelector(h2(), selector).__(cdata).__();
    }

    @Override
    public H3<TH<T>> h3() {
      closeAttrs();
      return h3_(this, false);
    }

    @Override
    public TH<T> h3(String cdata) {
      return h3().__(cdata).__();
    }

    @Override
    public TH<T> h3(String selector, String cdata) {
      return setSelector(h3(), selector).__(cdata).__();
    }

    @Override
    public H4<TH<T>> h4() {
      closeAttrs();
      return h4_(this, false);
    }

    @Override
    public TH<T> h4(String cdata) {
      return h4().__(cdata).__();
    }

    @Override
    public TH<T> h4(String selector, String cdata) {
      return setSelector(h4(), selector).__(cdata).__();
    }

    @Override
    public H5<TH<T>> h5() {
      closeAttrs();
      return h5_(this, false);
    }

    @Override
    public TH<T> h5(String cdata) {
      return h5().__(cdata).__();
    }

    @Override
    public TH<T> h5(String selector, String cdata) {
      return setSelector(h5(), selector).__(cdata).__();
    }

    @Override
    public H6<TH<T>> h6() {
      closeAttrs();
      return h6_(this, false);
    }

    @Override
    public TH<T> h6(String cdata) {
      return h6().__(cdata).__();
    }

    @Override
    public TH<T> h6(String selector, String cdata) {
      return setSelector(h6(), selector).__(cdata).__();
    }

    @Override
    public UL<TH<T>> ul() {
      closeAttrs();
      return ul_(this, false);
    }

    @Override
    public UL<TH<T>> ul(String selector) {
      return setSelector(ul(), selector);
    }

    @Override
    public OL<TH<T>> ol() {
      closeAttrs();
      return ol_(this, false);
    }

    @Override
    public OL<TH<T>> ol(String selector) {
      return setSelector(ol(), selector);
    }

    @Override
    public PRE<TH<T>> pre() {
      closeAttrs();
      return pre_(this, false);
    }

    @Override
    public PRE<TH<T>> pre(String selector) {
      return setSelector(pre(), selector);
    }

    @Override
    public FORM<TH<T>> form() {
      closeAttrs();
      return form_(this, false);
    }

    @Override
    public FORM<TH<T>> form(String selector) {
      return setSelector(form(), selector);
    }

    @Override
    public FIELDSET<TH<T>> fieldset() {
      closeAttrs();
      return fieldset_(this, false);
    }

    @Override
    public FIELDSET<TH<T>> fieldset(String selector) {
      return setSelector(fieldset(), selector);
    }

    @Override
    public TH<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public TH<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<TH<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public TH<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public TH<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<TH<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public TH<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public TH<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<TH<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public TH<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public TH<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public TH<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<TH<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public TH<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<TH<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public TH<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public TH<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<TH<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public TH<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public TH<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<TH<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public TH<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public TH<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public TH<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<TH<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public TH<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<TH<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public TH<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public TH<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<TH<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public TH<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public TH<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<TH<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public TH<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public TH<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<TH<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public TH<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public TH<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<TH<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<TH<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public TH<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public TH<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<TH<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public TH<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<TH<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<TH<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<TH<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public TH<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public TH<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<TH<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public TH<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public TH<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<TH<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<TH<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public TH<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public TH<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<TH<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<TH<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public TH<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<TH<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public TH<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<TH<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public TH<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public TH<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<TH<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public TH<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<TH<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public TH<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<TH<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public TH<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<TH<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public TH<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<TH<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<TH<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<TH<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<TH<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<TH<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<TH<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public TH<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<TH<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<TH<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public TH<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class TR<T extends __> extends EImp<T> implements HamletSpec.TR {
    public TR(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public TR<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public TR<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public TR<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public TR<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public TR<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public TR<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public TR<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public TR<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public TR<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public TR<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public TR<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public TR<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public TR<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public TR<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public TR<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public TR<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public TH<TR<T>> th() {
      closeAttrs();
      return th_(this, false);
    }

    @Override
    public TR<T> th(String cdata) {
      return th().__(cdata).__();
    }

    @Override
    public TR<T> th(String selector, String cdata) {
      return setSelector(th(), selector).__(cdata).__();
    }

    public TR<T> th(String selector, String title, String cdata) {
      return setSelector(th(), selector).$title(title).__(cdata).__();
    }

    @Override
    public TD<TR<T>> td() {
      closeAttrs();
      return td_(this, false);
    }

    @Override
    public TR<T> td(String cdata) {
      return td().__(cdata).__();
    }

    @Override
    public TR<T> td(String selector, String cdata) {
      return setSelector(td(), selector).__(cdata).__();
    }
  }

  private <T extends __> TH<T> th_(T e, boolean inline) {
    return new TH<T>("th", e, opt(true, inline, false)); }

  private <T extends __> TD<T> td_(T e, boolean inline) {
    return new TD<T>("td", e, opt(true, inline, false)); }

  public class COL<T extends __> extends EImp<T> implements HamletSpec.COL {
    public COL(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public COL<T> $span(int value) {
      addAttr("span", value);
      return this;
    }

    @Override
    public COL<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public COL<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public COL<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public COL<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public COL<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public COL<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public COL<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public COL<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public COL<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public COL<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public COL<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public COL<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public COL<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public COL<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public COL<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public COL<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }
  }

  public class COLGROUP<T extends __> extends EImp<T> implements HamletSpec.COLGROUP {
    public COLGROUP(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public COLGROUP<T> $span(int value) {
      addAttr("span", value);
      return this;
    }

    @Override
    public COLGROUP<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public COLGROUP<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public COLGROUP<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public COLGROUP<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public COLGROUP<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public COLGROUP<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public COLGROUP<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public COLGROUP<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public COLGROUP<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public COLGROUP<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public COLGROUP<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public COLGROUP<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public COLGROUP<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public COLGROUP<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public COLGROUP<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public COLGROUP<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public COL<COLGROUP<T>> col() {
      closeAttrs();
      return col_(this, false);
    }

    @Override
    public COLGROUP<T> col(String selector) {
      return setSelector(col(), selector).__();
    }
  }

  public class TBODY<T extends __> extends EImp<T> implements HamletSpec.TBODY {
    public TBODY(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public TBODY<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public TBODY<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public TBODY<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public TBODY<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public TBODY<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public TBODY<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public TBODY<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public TBODY<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public TBODY<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public TBODY<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public TBODY<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public TBODY<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public TBODY<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public TBODY<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public TBODY<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public TBODY<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public TR<TBODY<T>> tr() {
      closeAttrs();
      return tr_(this, false);
    }

    @Override
    public TR<TBODY<T>> tr(String selector) {
      return setSelector(tr(), selector);
    }
  }

  public class TFOOT<T extends __> extends EImp<T> implements HamletSpec.TFOOT {
    public TFOOT(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public TFOOT<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public TFOOT<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public TFOOT<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public TFOOT<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public TFOOT<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public TFOOT<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public TFOOT<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public TFOOT<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public TFOOT<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public TFOOT<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public TFOOT<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public TFOOT<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public TFOOT<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public TFOOT<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public TFOOT<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public TFOOT<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public TR<TFOOT<T>> tr() {
      closeAttrs();
      return tr_(this, false);
    }

    @Override
    public TR<TFOOT<T>> tr(String selector) {
      return setSelector(tr(), selector);
    }
  }

  public class THEAD<T extends __> extends EImp<T> implements HamletSpec.THEAD {
    public THEAD(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public THEAD<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public THEAD<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public THEAD<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public THEAD<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public THEAD<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public THEAD<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public THEAD<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public THEAD<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public THEAD<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public THEAD<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public THEAD<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public THEAD<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public THEAD<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public THEAD<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public THEAD<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public THEAD<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public TR<THEAD<T>> tr() {
      closeAttrs();
      return tr_(this, false);
    }

    @Override
    public TR<THEAD<T>> tr(String selector) {
      return setSelector(tr(), selector);
    }
  }

  public class CAPTION<T extends __> extends EImp<T> implements HamletSpec.CAPTION {
    public CAPTION(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public CAPTION<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public CAPTION<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public CAPTION<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public CAPTION<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public CAPTION<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public CAPTION<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public CAPTION<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public CAPTION<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public CAPTION<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public CAPTION<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public CAPTION<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public CAPTION<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public CAPTION<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public CAPTION<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public CAPTION<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public CAPTION<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public CAPTION<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public CAPTION<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<CAPTION<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public CAPTION<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public CAPTION<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<CAPTION<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public CAPTION<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public CAPTION<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<CAPTION<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public CAPTION<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public CAPTION<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public CAPTION<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<CAPTION<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public CAPTION<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<CAPTION<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public CAPTION<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public CAPTION<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<CAPTION<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public CAPTION<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public CAPTION<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<CAPTION<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public CAPTION<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public CAPTION<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public CAPTION<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<CAPTION<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public CAPTION<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<CAPTION<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public CAPTION<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public CAPTION<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<CAPTION<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public CAPTION<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public CAPTION<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<CAPTION<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public CAPTION<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public CAPTION<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<CAPTION<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public CAPTION<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public CAPTION<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<CAPTION<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<CAPTION<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public CAPTION<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public CAPTION<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<CAPTION<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public CAPTION<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<CAPTION<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<CAPTION<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<CAPTION<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public CAPTION<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public CAPTION<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<CAPTION<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public CAPTION<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public CAPTION<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<CAPTION<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<CAPTION<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public CAPTION<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public CAPTION<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<CAPTION<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<CAPTION<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public CAPTION<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<CAPTION<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public CAPTION<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<CAPTION<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public CAPTION<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public CAPTION<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<CAPTION<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public CAPTION<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<CAPTION<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public CAPTION<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<CAPTION<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public CAPTION<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<CAPTION<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public CAPTION<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<CAPTION<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<CAPTION<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<CAPTION<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<CAPTION<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<CAPTION<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<CAPTION<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public CAPTION<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<CAPTION<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<CAPTION<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public CAPTION<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class TABLE<T extends __> extends EImp<T> implements HamletSpec.TABLE {
    public TABLE(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public TABLE<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public TABLE<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public TABLE<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public TABLE<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public TABLE<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public TABLE<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public TABLE<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public TABLE<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public TABLE<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public TABLE<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public TABLE<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public TABLE<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public TABLE<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public TABLE<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public TABLE<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public TABLE<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public TABLE<T> caption(String cdata) {
      return caption().__(cdata).__();
    }

    @Override
    public CAPTION<TABLE<T>> caption() {
      closeAttrs();
      return caption_(this, false);
    }

    @Override
    public COLGROUP<TABLE<T>> colgroup() {
      closeAttrs();
      return colgroup_(this, false);
    }

    @Override
    public THEAD<TABLE<T>> thead(String selector) {
      return setSelector(thead(), selector);
    }

    @Override
    public THEAD<TABLE<T>> thead() {
      closeAttrs();
      return thead_(this, false);
    }

    @Override
    public TFOOT<TABLE<T>> tfoot() {
      closeAttrs();
      return tfoot_(this, false);
    }

    @Override
    public TFOOT<TABLE<T>> tfoot(String selector) {
      return setSelector(tfoot(), selector);
    }

    @Override
    public TBODY<TABLE<T>> tbody() {
      closeAttrs();
      return tbody_(this, false);
    }

    @Override
    public TBODY<TABLE<T>> tbody(String selector) {
      return setSelector(tbody(), selector);
    }

    @Override
    public TR<TABLE<T>> tr() {
      closeAttrs();
      return tr_(this, false);
    }

    @Override
    public TR<TABLE<T>> tr(String selector) {
      return setSelector(tr(), selector);
    }

    @Override
    public COL<TABLE<T>> col() {
      closeAttrs();
      return col_(this, false);
    }

    @Override
    public TABLE<T> col(String selector) {
      return setSelector(col(), selector).__();
    }
  }

  private <T extends __> CAPTION<T> caption_(T e, boolean inline) {
    return new CAPTION<T>("caption", e, opt(true, inline, false)); }

  private <T extends __> COLGROUP<T> colgroup_(T e, boolean inline) {
    return new COLGROUP<T>("colgroup", e, opt(false, inline, false)); }

  private <T extends __> THEAD<T> thead_(T e, boolean inline) {
    return new THEAD<T>("thead", e, opt(true, inline, false)); }

  private <T extends __> TFOOT<T> tfoot_(T e, boolean inline) {
    return new TFOOT<T>("tfoot", e, opt(true, inline, false)); }

  private <T extends __> TBODY<T> tbody_(T e, boolean inline) {
    return new TBODY<T>("tbody", e, opt(true, inline, false)); }

  private <T extends __> COL<T> col_(T e, boolean inline) {
    return new COL<T>("col", e, opt(false, inline, false)); }

  private <T extends __> TR<T> tr_(T e, boolean inline) {
    return new TR<T>("tr", e, opt(true, inline, false)); }

  public class BUTTON<T extends __> extends EImp<T> implements HamletSpec.BUTTON {
    public BUTTON(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public BUTTON<T> $type(ButtonType value) {
      addAttr("type", value);
      return this;
    }

    @Override
    public BUTTON<T> $name(String value) {
      addAttr("name", value);
      return this;
    }

    @Override
    public BUTTON<T> $value(String value) {
      addAttr("value", value);
      return this;
    }

    @Override
    public BUTTON<T> $disabled() {
      addAttr("disabled", null);
      return this;
    }

    @Override
    public BUTTON<T> $tabindex(int value) {
      addAttr("tabindex", value);
      return this;
    }

    @Override
    public BUTTON<T> $accesskey(String value) {
      addAttr("accesskey", value);
      return this;
    }

    @Override
    public BUTTON<T> $onfocus(String value) {
      addAttr("onfocus", value);
      return this;
    }

    @Override
    public BUTTON<T> $onblur(String value) {
      addAttr("onblur", value);
      return this;
    }

    @Override
    public TABLE<BUTTON<T>> table() {
      closeAttrs();
      return table_(this, false);
    }

    @Override
    public TABLE<BUTTON<T>> table(String selector) {
      return setSelector(table(), selector);
    }

    @Override
    public BUTTON<T> address(String cdata) {
      return address().__(cdata).__();
    }

    @Override
    public ADDRESS<BUTTON<T>> address() {
      closeAttrs();
      return address_(this, false);
    }

    @Override
    public P<BUTTON<T>> p(String selector) {
      return setSelector(p(), selector);
    }

    @Override
    public P<BUTTON<T>> p() {
      closeAttrs();
      return p_(this, false);
    }

    @Override
    public BUTTON<T> __(Class<? extends SubView> cls) {
      _v(cls);
      return this;
    }

    @Override
    public HR<BUTTON<T>> hr() {
      closeAttrs();
      return hr_(this, false);
    }

    @Override
    public BUTTON<T> hr(String selector) {
      return setSelector(hr(), selector).__();
    }

    @Override
    public DL<BUTTON<T>> dl(String selector) {
      return setSelector(dl(), selector);
    }

    @Override
    public DL<BUTTON<T>> dl() {
      closeAttrs();
      return dl_(this, false);
    }

    @Override
    public DIV<BUTTON<T>> div(String selector) {
      return setSelector(div(), selector);
    }

    @Override
    public DIV<BUTTON<T>> div() {
      closeAttrs();
      return div_(this, false);
    }

    @Override
    public BLOCKQUOTE<BUTTON<T>> blockquote() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BLOCKQUOTE<BUTTON<T>> bq() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BUTTON<T> h1(String cdata) {
      return h1().__(cdata).__();
    }

    @Override
    public H1<BUTTON<T>> h1() {
      closeAttrs();
      return h1_(this, false);
    }

    @Override
    public BUTTON<T> h1(String selector, String cdata) {
      return setSelector(h1(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<T> h2(String cdata) {
      return h2().__(cdata).__();
    }

    @Override
    public H2<BUTTON<T>> h2() {
      closeAttrs();
      return h2_(this, false);
    }

    @Override
    public BUTTON<T> h2(String selector, String cdata) {
      return setSelector(h2(), selector).__(cdata).__();
    }

    @Override
    public H3<BUTTON<T>> h3() {
      closeAttrs();
      return h3_(this, false);
    }

    @Override
    public BUTTON<T> h3(String cdata) {
      return h3().__(cdata).__();
    }

    @Override
    public BUTTON<T> h3(String selector, String cdata) {
      return setSelector(h3(), selector).__(cdata).__();
    }

    @Override
    public H4<BUTTON<T>> h4() {
      closeAttrs();
      return h4_(this, false);
    }

    @Override
    public BUTTON<T> h4(String cdata) {
      return h4().__(cdata).__();
    }

    @Override
    public BUTTON<T> h4(String selector, String cdata) {
      return setSelector(h4(), selector).__(cdata).__();
    }

    @Override
    public H5<BUTTON<T>> h5() {
      closeAttrs();
      return h5_(this, false);
    }

    @Override
    public BUTTON<T> h5(String cdata) {
      return h5().__(cdata).__();
    }

    @Override
    public BUTTON<T> h5(String selector, String cdata) {
      return setSelector(h5(), selector).__(cdata).__();
    }

    @Override
    public H6<BUTTON<T>> h6() {
      closeAttrs();
      return h6_(this, false);
    }

    @Override
    public BUTTON<T> h6(String cdata) {
      return h6().__(cdata).__();
    }

    @Override
    public BUTTON<T> h6(String selector, String cdata) {
      return setSelector(h6(), selector).__(cdata).__();
    }

    @Override
    public UL<BUTTON<T>> ul() {
      closeAttrs();
      return ul_(this, false);
    }

    @Override
    public UL<BUTTON<T>> ul(String selector) {
      return setSelector(ul(), selector);
    }

    @Override
    public OL<BUTTON<T>> ol() {
      closeAttrs();
      return ol_(this, false);
    }

    @Override
    public OL<BUTTON<T>> ol(String selector) {
      return setSelector(ol(), selector);
    }

    @Override
    public PRE<BUTTON<T>> pre() {
      closeAttrs();
      return pre_(this, false);
    }

    @Override
    public PRE<BUTTON<T>> pre(String selector) {
      return setSelector(pre(), selector);
    }

    @Override
    public BUTTON<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public BUTTON<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<BUTTON<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public BUTTON<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public BUTTON<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<BUTTON<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public BUTTON<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public BUTTON<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<BUTTON<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public BUTTON<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public BUTTON<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<BUTTON<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public BUTTON<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<BUTTON<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public BUTTON<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public BUTTON<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<BUTTON<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public BUTTON<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public BUTTON<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<BUTTON<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public BUTTON<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public BUTTON<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<BUTTON<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public BUTTON<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<BUTTON<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public BUTTON<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public BUTTON<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<BUTTON<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public BUTTON<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public BUTTON<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<BUTTON<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public BUTTON<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public BUTTON<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<BUTTON<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public BUTTON<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public BUTTON<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public MAP<BUTTON<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<BUTTON<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public BUTTON<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public BUTTON<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<BUTTON<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<BUTTON<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public BUTTON<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<BUTTON<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public BUTTON<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<BUTTON<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public BUTTON<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public BUTTON<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<BUTTON<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public BUTTON<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<BUTTON<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public BUTTON<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<BUTTON<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public BUTTON<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public IMG<BUTTON<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public BUTTON<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<BUTTON<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<BUTTON<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<BUTTON<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public BUTTON<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public BUTTON<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<BUTTON<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public BUTTON<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public BUTTON<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public BUTTON<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public BUTTON<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public BUTTON<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public BUTTON<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public BUTTON<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public BUTTON<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public BUTTON<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public BUTTON<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public BUTTON<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public BUTTON<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public BUTTON<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public BUTTON<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public BUTTON<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public BUTTON<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public BUTTON<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }
  }

  public class LEGEND<T extends __> extends EImp<T> implements HamletSpec.LEGEND {
    public LEGEND(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public LEGEND<T> $accesskey(String value) {
      addAttr("accesskey", value);
      return this;
    }

    @Override
    public LEGEND<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public LEGEND<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public LEGEND<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public LEGEND<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public LEGEND<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public LEGEND<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public LEGEND<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public LEGEND<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public LEGEND<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public LEGEND<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public LEGEND<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public LEGEND<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public LEGEND<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public LEGEND<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public LEGEND<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public LEGEND<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public LEGEND<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public LEGEND<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<LEGEND<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public LEGEND<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public LEGEND<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<LEGEND<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public LEGEND<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public LEGEND<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<LEGEND<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public LEGEND<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public LEGEND<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public LEGEND<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<LEGEND<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public LEGEND<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<LEGEND<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public LEGEND<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public LEGEND<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<LEGEND<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public LEGEND<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public LEGEND<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<LEGEND<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public LEGEND<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public LEGEND<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public LEGEND<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<LEGEND<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public LEGEND<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<LEGEND<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public LEGEND<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public LEGEND<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<LEGEND<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public LEGEND<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public LEGEND<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<LEGEND<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public LEGEND<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public LEGEND<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<LEGEND<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public LEGEND<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public LEGEND<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<LEGEND<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<LEGEND<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public LEGEND<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public LEGEND<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<LEGEND<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public LEGEND<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<LEGEND<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<LEGEND<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<LEGEND<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public LEGEND<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public LEGEND<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<LEGEND<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public LEGEND<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public LEGEND<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<LEGEND<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<LEGEND<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public LEGEND<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public LEGEND<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<LEGEND<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<LEGEND<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public LEGEND<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<LEGEND<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public LEGEND<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<LEGEND<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public LEGEND<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public LEGEND<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<LEGEND<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public LEGEND<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<LEGEND<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public LEGEND<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<LEGEND<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public LEGEND<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<LEGEND<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public LEGEND<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<LEGEND<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<LEGEND<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<LEGEND<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<LEGEND<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<LEGEND<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<LEGEND<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public LEGEND<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<LEGEND<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<LEGEND<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public LEGEND<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class FIELDSET<T extends __> extends EImp<T> implements HamletSpec.FIELDSET {
    public FIELDSET(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public FIELDSET<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public FIELDSET<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public FIELDSET<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public FIELDSET<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public FIELDSET<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public FIELDSET<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public FIELDSET<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public FIELDSET<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public FIELDSET<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public FIELDSET<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public FIELDSET<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public FIELDSET<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public FIELDSET<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public FIELDSET<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public FIELDSET<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public FIELDSET<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public LEGEND<FIELDSET<T>> legend() {
      closeAttrs();
      return legend_(this, false);
    }

    @Override
    public FIELDSET<T> legend(String cdata) {
      return legend().__(cdata).__();
    }

    @Override
    public FIELDSET<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public FIELDSET<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public TABLE<FIELDSET<T>> table() {
      closeAttrs();
      return table_(this, false);
    }

    @Override
    public TABLE<FIELDSET<T>> table(String selector) {
      return setSelector(table(), selector);
    }

    @Override
    public FIELDSET<T> address(String cdata) {
      return address().__(cdata).__();
    }

    @Override
    public ADDRESS<FIELDSET<T>> address() {
      closeAttrs();
      return address_(this, false);
    }

    @Override
    public P<FIELDSET<T>> p(String selector) {
      return setSelector(p(), selector);
    }

    @Override
    public P<FIELDSET<T>> p() {
      closeAttrs();
      return p_(this, false);
    }

    @Override
    public FIELDSET<T> __(Class<? extends SubView> cls) {
      _v(cls);
      return this;
    }

    @Override
    public HR<FIELDSET<T>> hr() {
      closeAttrs();
      return hr_(this, false);
    }

    @Override
    public FIELDSET<T> hr(String selector) {
      return setSelector(hr(), selector).__();
    }

    @Override
    public DL<FIELDSET<T>> dl(String selector) {
      return setSelector(dl(), selector);
    }

    @Override
    public DL<FIELDSET<T>> dl() {
      closeAttrs();
      return dl_(this, false);
    }

    @Override
    public DIV<FIELDSET<T>> div(String selector) {
      return setSelector(div(), selector);
    }

    @Override
    public DIV<FIELDSET<T>> div() {
      closeAttrs();
      return div_(this, false);
    }

    @Override
    public BLOCKQUOTE<FIELDSET<T>> blockquote() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BLOCKQUOTE<FIELDSET<T>> bq() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public FIELDSET<T> h1(String cdata) {
      return h1().__(cdata).__();
    }

    @Override
    public H1<FIELDSET<T>> h1() {
      closeAttrs();
      return h1_(this, false);
    }

    @Override
    public FIELDSET<T> h1(String selector, String cdata) {
      return setSelector(h1(), selector).__(cdata).__();
    }

    @Override
    public FIELDSET<T> h2(String cdata) {
      return h2().__(cdata).__();
    }

    @Override
    public H2<FIELDSET<T>> h2() {
      closeAttrs();
      return h2_(this, false);
    }

    @Override
    public FIELDSET<T> h2(String selector, String cdata) {
      return setSelector(h2(), selector).__(cdata).__();
    }

    @Override
    public H3<FIELDSET<T>> h3() {
      closeAttrs();
      return h3_(this, false);
    }

    @Override
    public FIELDSET<T> h3(String cdata) {
      return h3().__(cdata).__();
    }

    @Override
    public FIELDSET<T> h3(String selector, String cdata) {
      return setSelector(h3(), selector).__(cdata).__();
    }

    @Override
    public H4<FIELDSET<T>> h4() {
      closeAttrs();
      return h4_(this, false);
    }

    @Override
    public FIELDSET<T> h4(String cdata) {
      return h4().__(cdata).__();
    }

    @Override
    public FIELDSET<T> h4(String selector, String cdata) {
      return setSelector(h4(), selector).__(cdata).__();
    }

    @Override
    public H5<FIELDSET<T>> h5() {
      closeAttrs();
      return h5_(this, false);
    }

    @Override
    public FIELDSET<T> h5(String cdata) {
      return h5().__(cdata).__();
    }

    @Override
    public FIELDSET<T> h5(String selector, String cdata) {
      return setSelector(h5(), selector).__(cdata).__();
    }

    @Override
    public H6<FIELDSET<T>> h6() {
      closeAttrs();
      return h6_(this, false);
    }

    @Override
    public FIELDSET<T> h6(String cdata) {
      return h6().__(cdata).__();
    }

    @Override
    public FIELDSET<T> h6(String selector, String cdata) {
      return setSelector(h6(), selector).__(cdata).__();
    }

    @Override
    public UL<FIELDSET<T>> ul() {
      closeAttrs();
      return ul_(this, false);
    }

    @Override
    public UL<FIELDSET<T>> ul(String selector) {
      return setSelector(ul(), selector);
    }

    @Override
    public OL<FIELDSET<T>> ol() {
      closeAttrs();
      return ol_(this, false);
    }

    @Override
    public OL<FIELDSET<T>> ol(String selector) {
      return setSelector(ol(), selector);
    }

    @Override
    public PRE<FIELDSET<T>> pre() {
      closeAttrs();
      return pre_(this, false);
    }

    @Override
    public PRE<FIELDSET<T>> pre(String selector) {
      return setSelector(pre(), selector);
    }

    @Override
    public FORM<FIELDSET<T>> form() {
      closeAttrs();
      return form_(this, false);
    }

    @Override
    public FORM<FIELDSET<T>> form(String selector) {
      return setSelector(form(), selector);
    }

    @Override
    public FIELDSET<FIELDSET<T>> fieldset() {
      closeAttrs();
      return fieldset_(this, false);
    }

    @Override
    public FIELDSET<FIELDSET<T>> fieldset(String selector) {
      return setSelector(fieldset(), selector);
    }

    @Override
    public B<FIELDSET<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public FIELDSET<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public FIELDSET<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<FIELDSET<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public FIELDSET<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public FIELDSET<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<FIELDSET<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public FIELDSET<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public FIELDSET<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public FIELDSET<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<FIELDSET<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public FIELDSET<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<FIELDSET<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public FIELDSET<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public FIELDSET<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<FIELDSET<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public FIELDSET<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public FIELDSET<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<FIELDSET<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public FIELDSET<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public FIELDSET<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public FIELDSET<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<FIELDSET<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public FIELDSET<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<FIELDSET<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public FIELDSET<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public FIELDSET<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<FIELDSET<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public FIELDSET<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public FIELDSET<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<FIELDSET<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public FIELDSET<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public FIELDSET<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<FIELDSET<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public FIELDSET<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public FIELDSET<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<FIELDSET<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<FIELDSET<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public FIELDSET<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public FIELDSET<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<FIELDSET<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public FIELDSET<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<FIELDSET<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<FIELDSET<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<FIELDSET<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public FIELDSET<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public FIELDSET<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<FIELDSET<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public FIELDSET<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public FIELDSET<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<FIELDSET<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<FIELDSET<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public FIELDSET<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public FIELDSET<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<FIELDSET<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<FIELDSET<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public FIELDSET<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<FIELDSET<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public FIELDSET<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<FIELDSET<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public FIELDSET<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public FIELDSET<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<FIELDSET<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public FIELDSET<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<FIELDSET<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public FIELDSET<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<FIELDSET<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public FIELDSET<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<FIELDSET<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public FIELDSET<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<FIELDSET<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<FIELDSET<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<FIELDSET<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<FIELDSET<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<FIELDSET<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<FIELDSET<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public FIELDSET<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<FIELDSET<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<FIELDSET<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public FIELDSET<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  private <T extends __> LEGEND<T> legend_(T e, boolean inline) {
    return new LEGEND<T>("legend", e, opt(true, inline, false)); }

  public class TEXTAREA<T extends __> extends EImp<T> implements HamletSpec.TEXTAREA {
    public TEXTAREA(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public TEXTAREA<T> $name(String value) {
      addAttr("name", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $disabled() {
      addAttr("disabled", null);
      return this;
    }

    @Override
    public TEXTAREA<T> $tabindex(int value) {
      addAttr("tabindex", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $accesskey(String value) {
      addAttr("accesskey", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $onfocus(String value) {
      addAttr("onfocus", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $onblur(String value) {
      addAttr("onblur", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $rows(int value) {
      addAttr("rows", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $cols(int value) {
      addAttr("cols", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $readonly() {
      addAttr("readonly", null);
      return this;
    }

    @Override
    public TEXTAREA<T> $onselect(String value) {
      addAttr("onselect", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $onchange(String value) {
      addAttr("onchange", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public TEXTAREA<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public TEXTAREA<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public TEXTAREA<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }
  }

  public class OPTION<T extends __> extends EImp<T> implements HamletSpec.OPTION {
    public OPTION(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public OPTION<T> $value(String value) {
      addAttr("value", value);
      return this;
    }

    @Override
    public OPTION<T> $disabled() {
      addAttr("disabled", null);
      return this;
    }

    @Override
    public OPTION<T> $selected() {
      addAttr("selected", null);
      return this;
    }

    @Override
    public OPTION<T> $label(String value) {
      addAttr("label", value);
      return this;
    }

    @Override
    public OPTION<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public OPTION<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public OPTION<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public OPTION<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public OPTION<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public OPTION<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public OPTION<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public OPTION<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public OPTION<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public OPTION<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public OPTION<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public OPTION<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public OPTION<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public OPTION<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public OPTION<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public OPTION<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public OPTION<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public OPTION<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }
  }

  public class OPTGROUP<T extends __> extends EImp<T> implements HamletSpec.OPTGROUP {
    public OPTGROUP(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public OPTGROUP<T> $disabled() {
      addAttr("disabled", null);
      return this;
    }

    @Override
    public OPTGROUP<T> $label(String value) {
      addAttr("label", value);
      return this;
    }

    @Override
    public OPTGROUP<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public OPTGROUP<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public OPTGROUP<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public OPTGROUP<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public OPTGROUP<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public OPTGROUP<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public OPTGROUP<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public OPTGROUP<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public OPTGROUP<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public OPTGROUP<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public OPTGROUP<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public OPTGROUP<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public OPTGROUP<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public OPTGROUP<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public OPTGROUP<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public OPTGROUP<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public OPTION<OPTGROUP<T>> option() {
      closeAttrs();
      return option_(this, false);
    }

    @Override
    public OPTGROUP<T> option(String cdata) {
      return option().__(cdata).__();
    }
  }

  private <T extends __> OPTGROUP<T> optgroup_(T e, boolean inline) {
    return new OPTGROUP<T>("optgroup", e, opt(true, inline, false)); }

  public class SELECT<T extends __> extends EImp<T> implements HamletSpec.SELECT {
    public SELECT(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public SELECT<T> $name(String value) {
      addAttr("name", value);
      return this;
    }

    @Override
    public SELECT<T> $disabled() {
      addAttr("disabled", null);
      return this;
    }

    @Override
    public SELECT<T> $tabindex(int value) {
      addAttr("tabindex", value);
      return this;
    }

    @Override
    public SELECT<T> $onfocus(String value) {
      addAttr("onfocus", value);
      return this;
    }

    @Override
    public SELECT<T> $onblur(String value) {
      addAttr("onblur", value);
      return this;
    }

    @Override
    public SELECT<T> $onchange(String value) {
      addAttr("onchange", value);
      return this;
    }

    @Override
    public OPTGROUP<SELECT<T>> optgroup() {
      closeAttrs();
      return optgroup_(this, false);
    }

    @Override
    public SELECT<T> $size(int value) {
      addAttr("size", value);
      return this;
    }

    @Override
    public SELECT<T> $multiple() {
      addAttr("multiple", null);
      return this;
    }

    @Override
    public SELECT<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public SELECT<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public SELECT<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public SELECT<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public SELECT<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public SELECT<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public SELECT<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public SELECT<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public SELECT<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public SELECT<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public SELECT<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public SELECT<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public SELECT<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public SELECT<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public SELECT<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public SELECT<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public OPTION<SELECT<T>> option() {
      closeAttrs();
      return option_(this, false);
    }

    @Override
    public SELECT<T> option(String cdata) {
      return option().__(cdata).__();
    }
  }

  private <T extends __> OPTION<T> option_(T e, boolean inline) {
    return new OPTION<T>("option", e, opt(false, inline, false)); }

  public class INPUT<T extends __> extends EImp<T> implements HamletSpec.INPUT {
    public INPUT(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public INPUT<T> $type(InputType value) {
      addAttr("type", value);
      return this;
    }

    @Override
    public INPUT<T> $src(String value) {
      addAttr("src", value);
      return this;
    }

    @Override
    public INPUT<T> $name(String value) {
      addAttr("name", value);
      return this;
    }

    @Override
    public INPUT<T> $value(String value) {
      addAttr("value", value);
      return this;
    }

    @Override
    public INPUT<T> $disabled() {
      addAttr("disabled", null);
      return this;
    }

    @Override
    public INPUT<T> $tabindex(int value) {
      addAttr("tabindex", value);
      return this;
    }

    @Override
    public INPUT<T> $accesskey(String value) {
      addAttr("accesskey", value);
      return this;
    }

    @Override
    public INPUT<T> $onfocus(String value) {
      addAttr("onfocus", value);
      return this;
    }

    @Override
    public INPUT<T> $onblur(String value) {
      addAttr("onblur", value);
      return this;
    }

    @Override
    public INPUT<T> $readonly() {
      addAttr("readonly", null);
      return this;
    }

    @Override
    public INPUT<T> $onselect(String value) {
      addAttr("onselect", value);
      return this;
    }

    @Override
    public INPUT<T> $onchange(String value) {
      addAttr("onchange", value);
      return this;
    }

    @Override
    public INPUT<T> $size(String value) {
      addAttr("size", value);
      return this;
    }

    @Override
    public INPUT<T> $checked() {
      addAttr("checked", null);
      return this;
    }

    @Override
    public INPUT<T> $maxlength(int value) {
      addAttr("maxlength", value);
      return this;
    }

    @Override
    public INPUT<T> $alt(String value) {
      addAttr("alt", value);
      return this;
    }

    @Override
    public INPUT<T> $ismap() {
      addAttr("ismap", null);
      return this;
    }

    @Override
    public INPUT<T> $accept(String value) {
      addAttr("accept", value);
      return this;
    }

    @Override
    public INPUT<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public INPUT<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public INPUT<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public INPUT<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public INPUT<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public INPUT<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public INPUT<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public INPUT<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public INPUT<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public INPUT<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public INPUT<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public INPUT<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public INPUT<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public INPUT<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public INPUT<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public INPUT<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }
  }

  public class LABEL<T extends __> extends EImp<T> implements HamletSpec.LABEL {
    public LABEL(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public LABEL<T> $accesskey(String value) {
      addAttr("accesskey", value);
      return this;
    }

    @Override
    public LABEL<T> $onfocus(String value) {
      addAttr("onfocus", value);
      return this;
    }

    @Override
    public LABEL<T> $onblur(String value) {
      addAttr("onblur", value);
      return this;
    }

    @Override
    public LABEL<T> $for(String value) {
      addAttr("for", value);
      return this;
    }

    @Override
    public LABEL<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public LABEL<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public LABEL<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public LABEL<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public LABEL<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public LABEL<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public LABEL<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public LABEL<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public LABEL<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public LABEL<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public LABEL<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public LABEL<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public LABEL<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public LABEL<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public LABEL<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public LABEL<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public LABEL<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public LABEL<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<LABEL<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public LABEL<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public LABEL<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<LABEL<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public LABEL<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public LABEL<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<LABEL<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public LABEL<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public LABEL<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public LABEL<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<LABEL<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public LABEL<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<LABEL<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public LABEL<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public LABEL<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<LABEL<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public LABEL<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public LABEL<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<LABEL<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public LABEL<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public LABEL<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public LABEL<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<LABEL<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public LABEL<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<LABEL<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public LABEL<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public LABEL<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<LABEL<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public LABEL<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public LABEL<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<LABEL<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public LABEL<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public LABEL<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<LABEL<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public LABEL<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public LABEL<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<LABEL<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<LABEL<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public LABEL<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public LABEL<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<LABEL<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public LABEL<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<LABEL<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<LABEL<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<LABEL<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public LABEL<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public LABEL<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<LABEL<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public LABEL<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public LABEL<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<LABEL<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<LABEL<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public LABEL<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public LABEL<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<LABEL<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<LABEL<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public LABEL<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<LABEL<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public LABEL<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<LABEL<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public LABEL<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public LABEL<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<LABEL<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public LABEL<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<LABEL<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public LABEL<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<LABEL<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public LABEL<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public INPUT<LABEL<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<LABEL<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<LABEL<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<LABEL<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<LABEL<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<LABEL<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public LABEL<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<LABEL<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<LABEL<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public LABEL<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class FORM<T extends __> extends EImp<T> implements HamletSpec.FORM {
    public FORM(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public FORM<T> $name(String value) {
      addAttr("name", value);
      return this;
    }

    @Override
    public FORM<T> $accept(String value) {
      addAttr("accept", value);
      return this;
    }

    @Override
    public FORM<T> $action(String value) {
      addAttr("action", value);
      return this;
    }

    @Override
    public FORM<T> $method(Method value) {
      addAttr("method", value);
      return this;
    }

    @Override
    public FORM<T> $enctype(String value) {
      addAttr("enctype", value);
      return this;
    }

    @Override
    public FORM<T> $onsubmit(String value) {
      addAttr("onsubmit", value);
      return this;
    }

    @Override
    public FORM<T> $onreset(String value) {
      addAttr("onreset", value);
      return this;
    }

    @Override
    public FORM<T> $accept_charset(String value) {
      addAttr("accept-charset", value);
      return this;
    }

    @Override
    public FORM<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public FORM<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public FORM<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public FORM<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public FORM<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public FORM<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public FORM<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public FORM<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public FORM<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public FORM<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public FORM<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public FORM<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public FORM<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public FORM<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public FORM<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public FORM<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public SCRIPT<FORM<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public FORM<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public TABLE<FORM<T>> table() {
      closeAttrs();
      return table_(this, false);
    }

    @Override
    public TABLE<FORM<T>> table(String selector) {
      return setSelector(table(), selector);
    }

    @Override
    public FORM<T> address(String cdata) {
      return address().__(cdata).__();
    }

    @Override
    public ADDRESS<FORM<T>> address() {
      closeAttrs();
      return address_(this, false);
    }

    @Override
    public P<FORM<T>> p(String selector) {
      return setSelector(p(), selector);
    }

    @Override
    public P<FORM<T>> p() {
      closeAttrs();
      return p_(this, false);
    }

    @Override
    public FORM<T> __(Class<? extends SubView> cls) {
      _v(cls);
      return this;
    }

    @Override
    public HR<FORM<T>> hr() {
      closeAttrs();
      return hr_(this, false);
    }

    @Override
    public FORM<T> hr(String selector) {
      return setSelector(hr(), selector).__();
    }

    @Override
    public DL<FORM<T>> dl(String selector) {
      return setSelector(dl(), selector);
    }

    @Override
    public DL<FORM<T>> dl() {
      closeAttrs();
      return dl_(this, false);
    }

    @Override
    public DIV<FORM<T>> div(String selector) {
      return setSelector(div(), selector);
    }

    @Override
    public DIV<FORM<T>> div() {
      closeAttrs();
      return div_(this, false);
    }

    @Override
    public BLOCKQUOTE<FORM<T>> blockquote() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BLOCKQUOTE<FORM<T>> bq() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public FORM<T> h1(String cdata) {
      return h1().__(cdata).__();
    }

    @Override
    public H1<FORM<T>> h1() {
      closeAttrs();
      return h1_(this, false);
    }

    @Override
    public FORM<T> h1(String selector, String cdata) {
      return setSelector(h1(), selector).__(cdata).__();
    }

    @Override
    public FORM<T> h2(String cdata) {
      return h2().__(cdata).__();
    }

    @Override
    public H2<FORM<T>> h2() {
      closeAttrs();
      return h2_(this, false);
    }

    @Override
    public FORM<T> h2(String selector, String cdata) {
      return setSelector(h2(), selector).__(cdata).__();
    }

    @Override
    public H3<FORM<T>> h3() {
      closeAttrs();
      return h3_(this, false);
    }

    @Override
    public FORM<T> h3(String cdata) {
      return h3().__(cdata).__();
    }

    @Override
    public FORM<T> h3(String selector, String cdata) {
      return setSelector(h3(), selector).__(cdata).__();
    }

    @Override
    public H4<FORM<T>> h4() {
      closeAttrs();
      return h4_(this, false);
    }

    @Override
    public FORM<T> h4(String cdata) {
      return h4().__(cdata).__();
    }

    @Override
    public FORM<T> h4(String selector, String cdata) {
      return setSelector(h4(), selector).__(cdata).__();
    }

    @Override
    public H5<FORM<T>> h5() {
      closeAttrs();
      return h5_(this, false);
    }

    @Override
    public FORM<T> h5(String cdata) {
      return h5().__(cdata).__();
    }

    @Override
    public FORM<T> h5(String selector, String cdata) {
      return setSelector(h5(), selector).__(cdata).__();
    }

    @Override
    public H6<FORM<T>> h6() {
      closeAttrs();
      return h6_(this, false);
    }

    @Override
    public FORM<T> h6(String cdata) {
      return h6().__(cdata).__();
    }

    @Override
    public FORM<T> h6(String selector, String cdata) {
      return setSelector(h6(), selector).__(cdata).__();
    }

    @Override
    public UL<FORM<T>> ul() {
      closeAttrs();
      return ul_(this, false);
    }

    @Override
    public UL<FORM<T>> ul(String selector) {
      return setSelector(ul(), selector);
    }

    @Override
    public OL<FORM<T>> ol() {
      closeAttrs();
      return ol_(this, false);
    }

    @Override
    public OL<FORM<T>> ol(String selector) {
      return setSelector(ol(), selector);
    }

    @Override
    public PRE<FORM<T>> pre() {
      closeAttrs();
      return pre_(this, false);
    }

    @Override
    public PRE<FORM<T>> pre(String selector) {
      return setSelector(pre(), selector);
    }

    @Override
    public FIELDSET<FORM<T>> fieldset() {
      closeAttrs();
      return fieldset_(this, false);
    }

    @Override
    public FIELDSET<FORM<T>> fieldset(String selector) {
      return setSelector(fieldset(), selector);
    }
  }

  public class LI<T extends __> extends EImp<T> implements HamletSpec.LI {
    public LI(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public LI<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public LI<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public LI<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public LI<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public LI<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public LI<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public LI<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public LI<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public LI<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public LI<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public LI<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public LI<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public LI<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public LI<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public LI<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public LI<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public TABLE<LI<T>> table() {
      closeAttrs();
      return table_(this, false);
    }

    @Override
    public TABLE<LI<T>> table(String selector) {
      return setSelector(table(), selector);
    }

    @Override
    public LI<T> address(String cdata) {
      return address().__(cdata).__();
    }

    @Override
    public ADDRESS<LI<T>> address() {
      closeAttrs();
      return address_(this, false);
    }

    @Override
    public P<LI<T>> p(String selector) {
      return setSelector(p(), selector);
    }

    @Override
    public P<LI<T>> p() {
      closeAttrs();
      return p_(this, false);
    }

    @Override
    public LI<T> __(Class<? extends SubView> cls) {
      _v(cls);
      return this;
    }

    @Override
    public HR<LI<T>> hr() {
      closeAttrs();
      return hr_(this, false);
    }

    @Override
    public LI<T> hr(String selector) {
      return setSelector(hr(), selector).__();
    }

    @Override
    public DL<LI<T>> dl(String selector) {
      return setSelector(dl(), selector);
    }

    @Override
    public DL<LI<T>> dl() {
      closeAttrs();
      return dl_(this, false);
    }

    @Override
    public DIV<LI<T>> div(String selector) {
      return setSelector(div(), selector);
    }

    @Override
    public DIV<LI<T>> div() {
      closeAttrs();
      return div_(this, false);
    }

    @Override
    public BLOCKQUOTE<LI<T>> blockquote() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BLOCKQUOTE<LI<T>> bq() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public LI<T> h1(String cdata) {
      return h1().__(cdata).__();
    }

    @Override
    public H1<LI<T>> h1() {
      closeAttrs();
      return h1_(this, false);
    }

    @Override
    public LI<T> h1(String selector, String cdata) {
      return setSelector(h1(), selector).__(cdata).__();
    }

    @Override
    public LI<T> h2(String cdata) {
      return h2().__(cdata).__();
    }

    @Override
    public H2<LI<T>> h2() {
      closeAttrs();
      return h2_(this, false);
    }

    @Override
    public LI<T> h2(String selector, String cdata) {
      return setSelector(h2(), selector).__(cdata).__();
    }

    @Override
    public H3<LI<T>> h3() {
      closeAttrs();
      return h3_(this, false);
    }

    @Override
    public LI<T> h3(String cdata) {
      return h3().__(cdata).__();
    }

    @Override
    public LI<T> h3(String selector, String cdata) {
      return setSelector(h3(), selector).__(cdata).__();
    }

    @Override
    public H4<LI<T>> h4() {
      closeAttrs();
      return h4_(this, false);
    }

    @Override
    public LI<T> h4(String cdata) {
      return h4().__(cdata).__();
    }

    @Override
    public LI<T> h4(String selector, String cdata) {
      return setSelector(h4(), selector).__(cdata).__();
    }

    @Override
    public H5<LI<T>> h5() {
      closeAttrs();
      return h5_(this, false);
    }

    @Override
    public LI<T> h5(String cdata) {
      return h5().__(cdata).__();
    }

    @Override
    public LI<T> h5(String selector, String cdata) {
      return setSelector(h5(), selector).__(cdata).__();
    }

    @Override
    public H6<LI<T>> h6() {
      closeAttrs();
      return h6_(this, false);
    }

    @Override
    public LI<T> h6(String cdata) {
      return h6().__(cdata).__();
    }

    @Override
    public LI<T> h6(String selector, String cdata) {
      return setSelector(h6(), selector).__(cdata).__();
    }

    @Override
    public UL<LI<T>> ul() {
      closeAttrs();
      return ul_(this, false);
    }

    @Override
    public UL<LI<T>> ul(String selector) {
      return setSelector(ul(), selector);
    }

    @Override
    public OL<LI<T>> ol() {
      closeAttrs();
      return ol_(this, false);
    }

    @Override
    public OL<LI<T>> ol(String selector) {
      return setSelector(ol(), selector);
    }

    @Override
    public PRE<LI<T>> pre() {
      closeAttrs();
      return pre_(this, false);
    }

    @Override
    public PRE<LI<T>> pre(String selector) {
      return setSelector(pre(), selector);
    }

    @Override
    public FORM<LI<T>> form() {
      closeAttrs();
      return form_(this, false);
    }

    @Override
    public FORM<LI<T>> form(String selector) {
      return setSelector(form(), selector);
    }

    @Override
    public FIELDSET<LI<T>> fieldset() {
      closeAttrs();
      return fieldset_(this, false);
    }

    @Override
    public FIELDSET<LI<T>> fieldset(String selector) {
      return setSelector(fieldset(), selector);
    }

    @Override
    public LI<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public LI<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<LI<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public LI<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public LI<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<LI<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public LI<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public LI<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<LI<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public LI<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public LI<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public LI<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<LI<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public LI<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<LI<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public LI<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public LI<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<LI<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public LI<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public LI<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<LI<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public LI<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public LI<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public LI<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<LI<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public LI<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<LI<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public LI<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public LI<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<LI<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public LI<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public LI<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<LI<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public LI<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public LI<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<LI<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public LI<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public LI<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<LI<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<LI<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public LI<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public LI<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<LI<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public LI<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<LI<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<LI<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<LI<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public LI<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public LI<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<LI<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public LI<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public LI<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<LI<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<LI<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public LI<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public LI<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<LI<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<LI<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public LI<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<LI<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public LI<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<LI<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public LI<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public LI<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<LI<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public LI<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<LI<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public LI<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<LI<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public LI<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<LI<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public LI<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<LI<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<LI<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<LI<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<LI<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<LI<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<LI<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public LI<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<LI<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<LI<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public LI<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class UL<T extends __> extends EImp<T> implements HamletSpec.UL {
    public UL(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public UL<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public UL<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public UL<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public UL<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public UL<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public UL<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public UL<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public UL<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public UL<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public UL<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public UL<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public UL<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public UL<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public UL<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public UL<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public UL<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public LI<UL<T>> li() {
      closeAttrs();
      return li_(this, false);
    }

    @Override
    public UL<T> li(String cdata) {
      return li().__(cdata).__();
    }
  }

  public class OL<T extends __> extends EImp<T> implements HamletSpec.OL {
    public OL(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public OL<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public OL<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public OL<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public OL<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public OL<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public OL<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public OL<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public OL<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public OL<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public OL<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public OL<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public OL<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public OL<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public OL<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public OL<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public OL<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public LI<OL<T>> li() {
      closeAttrs();
      return li_(this, false);
    }

    @Override
    public OL<T> li(String cdata) {
      return li().__(cdata).__();
    }
  }

  private <T extends __> LI<T> li_(T e, boolean inline) {
    return new LI<T>("li", e, opt(false, inline, false)); }

  public class DD<T extends __> extends EImp<T> implements HamletSpec.DD {
    public DD(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public DD<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public DD<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public DD<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public DD<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public DD<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public DD<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public DD<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public DD<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public DD<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public DD<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public DD<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public DD<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public DD<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public DD<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public DD<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public DD<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public TABLE<DD<T>> table() {
      closeAttrs();
      return table_(this, false);
    }

    @Override
    public TABLE<DD<T>> table(String selector) {
      return setSelector(table(), selector);
    }

    @Override
    public DD<T> address(String cdata) {
      return address().__(cdata).__();
    }

    @Override
    public ADDRESS<DD<T>> address() {
      closeAttrs();
      return address_(this, false);
    }

    @Override
    public P<DD<T>> p(String selector) {
      return setSelector(p(), selector);
    }

    @Override
    public P<DD<T>> p() {
      closeAttrs();
      return p_(this, false);
    }

    @Override
    public DD<T> __(Class<? extends SubView> cls) {
      _v(cls);
      return this;
    }

    @Override
    public HR<DD<T>> hr() {
      closeAttrs();
      return hr_(this, false);
    }

    @Override
    public DD<T> hr(String selector) {
      return setSelector(hr(), selector).__();
    }

    @Override
    public DL<DD<T>> dl(String selector) {
      return setSelector(dl(), selector);
    }

    @Override
    public DL<DD<T>> dl() {
      closeAttrs();
      return dl_(this, false);
    }

    @Override
    public DIV<DD<T>> div(String selector) {
      return setSelector(div(), selector);
    }

    @Override
    public DIV<DD<T>> div() {
      closeAttrs();
      return div_(this, false);
    }

    @Override
    public BLOCKQUOTE<DD<T>> blockquote() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BLOCKQUOTE<DD<T>> bq() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public DD<T> h1(String cdata) {
      return h1().__(cdata).__();
    }

    @Override
    public H1<DD<T>> h1() {
      closeAttrs();
      return h1_(this, false);
    }

    @Override
    public DD<T> h1(String selector, String cdata) {
      return setSelector(h1(), selector).__(cdata).__();
    }

    @Override
    public DD<T> h2(String cdata) {
      return h2().__(cdata).__();
    }

    @Override
    public H2<DD<T>> h2() {
      closeAttrs();
      return h2_(this, false);
    }

    @Override
    public DD<T> h2(String selector, String cdata) {
      return setSelector(h2(), selector).__(cdata).__();
    }

    @Override
    public H3<DD<T>> h3() {
      closeAttrs();
      return h3_(this, false);
    }

    @Override
    public DD<T> h3(String cdata) {
      return h3().__(cdata).__();
    }

    @Override
    public DD<T> h3(String selector, String cdata) {
      return setSelector(h3(), selector).__(cdata).__();
    }

    @Override
    public H4<DD<T>> h4() {
      closeAttrs();
      return h4_(this, false);
    }

    @Override
    public DD<T> h4(String cdata) {
      return h4().__(cdata).__();
    }

    @Override
    public DD<T> h4(String selector, String cdata) {
      return setSelector(h4(), selector).__(cdata).__();
    }

    @Override
    public H5<DD<T>> h5() {
      closeAttrs();
      return h5_(this, false);
    }

    @Override
    public DD<T> h5(String cdata) {
      return h5().__(cdata).__();
    }

    @Override
    public DD<T> h5(String selector, String cdata) {
      return setSelector(h5(), selector).__(cdata).__();
    }

    @Override
    public H6<DD<T>> h6() {
      closeAttrs();
      return h6_(this, false);
    }

    @Override
    public DD<T> h6(String cdata) {
      return h6().__(cdata).__();
    }

    @Override
    public DD<T> h6(String selector, String cdata) {
      return setSelector(h6(), selector).__(cdata).__();
    }

    @Override
    public UL<DD<T>> ul() {
      closeAttrs();
      return ul_(this, false);
    }

    @Override
    public UL<DD<T>> ul(String selector) {
      return setSelector(ul(), selector);
    }

    @Override
    public OL<DD<T>> ol() {
      closeAttrs();
      return ol_(this, false);
    }

    @Override
    public OL<DD<T>> ol(String selector) {
      return setSelector(ol(), selector);
    }

    @Override
    public PRE<DD<T>> pre() {
      closeAttrs();
      return pre_(this, false);
    }

    @Override
    public PRE<DD<T>> pre(String selector) {
      return setSelector(pre(), selector);
    }

    @Override
    public FORM<DD<T>> form() {
      closeAttrs();
      return form_(this, false);
    }

    @Override
    public FORM<DD<T>> form(String selector) {
      return setSelector(form(), selector);
    }

    @Override
    public FIELDSET<DD<T>> fieldset() {
      closeAttrs();
      return fieldset_(this, false);
    }

    @Override
    public FIELDSET<DD<T>> fieldset(String selector) {
      return setSelector(fieldset(), selector);
    }

    @Override
    public DD<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public DD<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<DD<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public DD<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public DD<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<DD<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public DD<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public DD<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<DD<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public DD<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public DD<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public DD<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<DD<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public DD<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<DD<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public DD<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public DD<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<DD<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public DD<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public DD<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<DD<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public DD<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public DD<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public DD<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<DD<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public DD<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<DD<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public DD<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public DD<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<DD<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public DD<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public DD<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<DD<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public DD<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public DD<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<DD<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public DD<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public DD<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<DD<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<DD<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public DD<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public DD<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<DD<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public DD<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<DD<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<DD<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<DD<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public DD<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public DD<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<DD<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public DD<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public DD<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<DD<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<DD<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public DD<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public DD<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<DD<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<DD<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public DD<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<DD<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public DD<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<DD<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public DD<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public DD<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<DD<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public DD<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<DD<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public DD<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<DD<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public DD<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<DD<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public DD<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<DD<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<DD<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<DD<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<DD<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<DD<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<DD<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public DD<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<DD<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<DD<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public DD<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class DT<T extends __> extends EImp<T> implements HamletSpec.DT {
    public DT(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public DT<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public DT<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public DT<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public DT<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public DT<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public DT<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public DT<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public DT<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public DT<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public DT<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public DT<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public DT<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public DT<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public DT<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public DT<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public DT<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public DT<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public DT<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<DT<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public DT<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public DT<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<DT<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public DT<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public DT<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<DT<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public DT<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public DT<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public DT<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<DT<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public DT<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<DT<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public DT<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public DT<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<DT<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public DT<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public DT<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<DT<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public DT<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public DT<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public DT<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<DT<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public DT<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<DT<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public DT<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public DT<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<DT<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public DT<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public DT<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<DT<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public DT<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public DT<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<DT<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public DT<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public DT<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<DT<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<DT<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public DT<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public DT<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<DT<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public DT<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<DT<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<DT<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<DT<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public DT<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public DT<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<DT<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public DT<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public DT<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<DT<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<DT<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public DT<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public DT<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<DT<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<DT<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public DT<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<DT<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public DT<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<DT<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public DT<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public DT<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<DT<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public DT<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<DT<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public DT<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<DT<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public DT<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<DT<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public DT<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<DT<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<DT<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<DT<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<DT<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<DT<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<DT<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public DT<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<DT<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<DT<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public DT<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class DL<T extends __> extends EImp<T> implements HamletSpec.DL {
    public DL(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public DL<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public DL<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public DL<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public DL<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public DL<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public DL<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public DL<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public DL<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public DL<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public DL<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public DL<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public DL<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public DL<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public DL<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public DL<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public DL<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public DT<DL<T>> dt() {
      closeAttrs();
      return dt_(this, false);
    }

    @Override
    public DL<T> dt(String cdata) {
      return dt().__(cdata).__();
    }

    @Override
    public DD<DL<T>> dd() {
      closeAttrs();
      return dd_(this, false);
    }

    @Override
    public DL<T> dd(String cdata) {
      return dd().__(cdata).__();
    }
  }

  private <T extends __> DT<T> dt_(T e, boolean inline) {
    return new DT<T>("dt", e, opt(false, inline, false)); }

  private <T extends __> DD<T> dd_(T e, boolean inline) {
    return new DD<T>("dd", e, opt(false, inline, false)); }

  public class DEL<T extends __> extends EImp<T> implements HamletSpec.DEL {
    public DEL(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public DEL<T> $cite(String value) {
      addAttr("cite", value);
      return this;
    }

    @Override
    public DEL<T> $datetime(String value) {
      addAttr("datetime", value);
      return this;
    }

    @Override
    public DEL<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public DEL<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public DEL<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public DEL<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public DEL<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public DEL<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public DEL<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public DEL<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public DEL<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public DEL<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public DEL<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public DEL<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public DEL<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public DEL<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public DEL<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public DEL<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public TABLE<DEL<T>> table() {
      closeAttrs();
      return table_(this, false);
    }

    @Override
    public TABLE<DEL<T>> table(String selector) {
      return setSelector(table(), selector);
    }

    @Override
    public DEL<T> address(String cdata) {
      return address().__(cdata).__();
    }

    @Override
    public ADDRESS<DEL<T>> address() {
      closeAttrs();
      return address_(this, false);
    }

    @Override
    public P<DEL<T>> p(String selector) {
      return setSelector(p(), selector);
    }

    @Override
    public P<DEL<T>> p() {
      closeAttrs();
      return p_(this, false);
    }

    @Override
    public DEL<T> __(Class<? extends SubView> cls) {
      _v(cls);
      return this;
    }

    @Override
    public HR<DEL<T>> hr() {
      closeAttrs();
      return hr_(this, false);
    }

    @Override
    public DEL<T> hr(String selector) {
      return setSelector(hr(), selector).__();
    }

    @Override
    public DL<DEL<T>> dl(String selector) {
      return setSelector(dl(), selector);
    }

    @Override
    public DL<DEL<T>> dl() {
      closeAttrs();
      return dl_(this, false);
    }

    @Override
    public DIV<DEL<T>> div(String selector) {
      return setSelector(div(), selector);
    }

    @Override
    public DIV<DEL<T>> div() {
      closeAttrs();
      return div_(this, false);
    }

    @Override
    public BLOCKQUOTE<DEL<T>> blockquote() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BLOCKQUOTE<DEL<T>> bq() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public DEL<T> h1(String cdata) {
      return h1().__(cdata).__();
    }

    @Override
    public H1<DEL<T>> h1() {
      closeAttrs();
      return h1_(this, false);
    }

    @Override
    public DEL<T> h1(String selector, String cdata) {
      return setSelector(h1(), selector).__(cdata).__();
    }

    @Override
    public DEL<T> h2(String cdata) {
      return h2().__(cdata).__();
    }

    @Override
    public H2<DEL<T>> h2() {
      closeAttrs();
      return h2_(this, false);
    }

    @Override
    public DEL<T> h2(String selector, String cdata) {
      return setSelector(h2(), selector).__(cdata).__();
    }

    @Override
    public H3<DEL<T>> h3() {
      closeAttrs();
      return h3_(this, false);
    }

    @Override
    public DEL<T> h3(String cdata) {
      return h3().__(cdata).__();
    }

    @Override
    public DEL<T> h3(String selector, String cdata) {
      return setSelector(h3(), selector).__(cdata).__();
    }

    @Override
    public H4<DEL<T>> h4() {
      closeAttrs();
      return h4_(this, false);
    }

    @Override
    public DEL<T> h4(String cdata) {
      return h4().__(cdata).__();
    }

    @Override
    public DEL<T> h4(String selector, String cdata) {
      return setSelector(h4(), selector).__(cdata).__();
    }

    @Override
    public H5<DEL<T>> h5() {
      closeAttrs();
      return h5_(this, false);
    }

    @Override
    public DEL<T> h5(String cdata) {
      return h5().__(cdata).__();
    }

    @Override
    public DEL<T> h5(String selector, String cdata) {
      return setSelector(h5(), selector).__(cdata).__();
    }

    @Override
    public H6<DEL<T>> h6() {
      closeAttrs();
      return h6_(this, false);
    }

    @Override
    public DEL<T> h6(String cdata) {
      return h6().__(cdata).__();
    }

    @Override
    public DEL<T> h6(String selector, String cdata) {
      return setSelector(h6(), selector).__(cdata).__();
    }

    @Override
    public UL<DEL<T>> ul() {
      closeAttrs();
      return ul_(this, false);
    }

    @Override
    public UL<DEL<T>> ul(String selector) {
      return setSelector(ul(), selector);
    }

    @Override
    public OL<DEL<T>> ol() {
      closeAttrs();
      return ol_(this, false);
    }

    @Override
    public OL<DEL<T>> ol(String selector) {
      return setSelector(ol(), selector);
    }

    @Override
    public PRE<DEL<T>> pre() {
      closeAttrs();
      return pre_(this, false);
    }

    @Override
    public PRE<DEL<T>> pre(String selector) {
      return setSelector(pre(), selector);
    }

    @Override
    public FORM<DEL<T>> form() {
      closeAttrs();
      return form_(this, false);
    }

    @Override
    public FORM<DEL<T>> form(String selector) {
      return setSelector(form(), selector);
    }

    @Override
    public FIELDSET<DEL<T>> fieldset() {
      closeAttrs();
      return fieldset_(this, false);
    }

    @Override
    public FIELDSET<DEL<T>> fieldset(String selector) {
      return setSelector(fieldset(), selector);
    }

    @Override
    public DEL<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public DEL<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<DEL<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public DEL<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public DEL<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<DEL<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public DEL<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public DEL<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<DEL<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public DEL<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public DEL<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public DEL<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<DEL<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public DEL<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<DEL<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public DEL<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public DEL<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<DEL<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public DEL<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public DEL<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<DEL<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public DEL<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public DEL<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public DEL<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<DEL<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public DEL<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<DEL<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public DEL<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public DEL<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<DEL<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public DEL<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public DEL<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<DEL<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public DEL<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public DEL<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<DEL<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public DEL<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public DEL<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<DEL<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<DEL<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public DEL<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public DEL<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<DEL<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public DEL<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<DEL<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<DEL<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<DEL<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public DEL<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public DEL<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<DEL<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public DEL<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public DEL<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<DEL<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<DEL<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public DEL<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public DEL<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<DEL<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<DEL<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public DEL<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<DEL<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public DEL<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<DEL<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public DEL<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public DEL<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<DEL<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public DEL<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<DEL<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public DEL<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<DEL<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public DEL<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<DEL<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public DEL<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<DEL<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<DEL<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<DEL<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<DEL<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<DEL<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<DEL<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public DEL<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<DEL<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<DEL<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public DEL<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class INS<T extends __> extends EImp<T> implements HamletSpec.INS {
    public INS(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public INS<T> $cite(String value) {
      addAttr("cite", value);
      return this;
    }

    @Override
    public INS<T> $datetime(String value) {
      addAttr("datetime", value);
      return this;
    }

    @Override
    public INS<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public INS<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public INS<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public INS<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public INS<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public INS<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public INS<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public INS<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public INS<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public INS<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public INS<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public INS<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public INS<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public INS<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public INS<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public INS<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public TABLE<INS<T>> table() {
      closeAttrs();
      return table_(this, false);
    }

    @Override
    public TABLE<INS<T>> table(String selector) {
      return setSelector(table(), selector);
    }

    @Override
    public INS<T> address(String cdata) {
      return address().__(cdata).__();
    }

    @Override
    public ADDRESS<INS<T>> address() {
      closeAttrs();
      return address_(this, false);
    }

    @Override
    public P<INS<T>> p(String selector) {
      return setSelector(p(), selector);
    }

    @Override
    public P<INS<T>> p() {
      closeAttrs();
      return p_(this, false);
    }

    @Override
    public INS<T> __(Class<? extends SubView> cls) {
      _v(cls);
      return this;
    }

    @Override
    public HR<INS<T>> hr() {
      closeAttrs();
      return hr_(this, false);
    }

    @Override
    public INS<T> hr(String selector) {
      return setSelector(hr(), selector).__();
    }

    @Override
    public DL<INS<T>> dl(String selector) {
      return setSelector(dl(), selector);
    }

    @Override
    public DL<INS<T>> dl() {
      closeAttrs();
      return dl_(this, false);
    }

    @Override
    public DIV<INS<T>> div(String selector) {
      return setSelector(div(), selector);
    }

    @Override
    public DIV<INS<T>> div() {
      closeAttrs();
      return div_(this, false);
    }

    @Override
    public BLOCKQUOTE<INS<T>> blockquote() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BLOCKQUOTE<INS<T>> bq() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public INS<T> h1(String cdata) {
      return h1().__(cdata).__();
    }

    @Override
    public H1<INS<T>> h1() {
      closeAttrs();
      return h1_(this, false);
    }

    @Override
    public INS<T> h1(String selector, String cdata) {
      return setSelector(h1(), selector).__(cdata).__();
    }

    @Override
    public INS<T> h2(String cdata) {
      return h2().__(cdata).__();
    }

    @Override
    public H2<INS<T>> h2() {
      closeAttrs();
      return h2_(this, false);
    }

    @Override
    public INS<T> h2(String selector, String cdata) {
      return setSelector(h2(), selector).__(cdata).__();
    }

    @Override
    public H3<INS<T>> h3() {
      closeAttrs();
      return h3_(this, false);
    }

    @Override
    public INS<T> h3(String cdata) {
      return h3().__(cdata).__();
    }

    @Override
    public INS<T> h3(String selector, String cdata) {
      return setSelector(h3(), selector).__(cdata).__();
    }

    @Override
    public H4<INS<T>> h4() {
      closeAttrs();
      return h4_(this, false);
    }

    @Override
    public INS<T> h4(String cdata) {
      return h4().__(cdata).__();
    }

    @Override
    public INS<T> h4(String selector, String cdata) {
      return setSelector(h4(), selector).__(cdata).__();
    }

    @Override
    public H5<INS<T>> h5() {
      closeAttrs();
      return h5_(this, false);
    }

    @Override
    public INS<T> h5(String cdata) {
      return h5().__(cdata).__();
    }

    @Override
    public INS<T> h5(String selector, String cdata) {
      return setSelector(h5(), selector).__(cdata).__();
    }

    @Override
    public H6<INS<T>> h6() {
      closeAttrs();
      return h6_(this, false);
    }

    @Override
    public INS<T> h6(String cdata) {
      return h6().__(cdata).__();
    }

    @Override
    public INS<T> h6(String selector, String cdata) {
      return setSelector(h6(), selector).__(cdata).__();
    }

    @Override
    public UL<INS<T>> ul() {
      closeAttrs();
      return ul_(this, false);
    }

    @Override
    public UL<INS<T>> ul(String selector) {
      return setSelector(ul(), selector);
    }

    @Override
    public OL<INS<T>> ol() {
      closeAttrs();
      return ol_(this, false);
    }

    @Override
    public OL<INS<T>> ol(String selector) {
      return setSelector(ol(), selector);
    }

    @Override
    public PRE<INS<T>> pre() {
      closeAttrs();
      return pre_(this, false);
    }

    @Override
    public PRE<INS<T>> pre(String selector) {
      return setSelector(pre(), selector);
    }

    @Override
    public FORM<INS<T>> form() {
      closeAttrs();
      return form_(this, false);
    }

    @Override
    public FORM<INS<T>> form(String selector) {
      return setSelector(form(), selector);
    }

    @Override
    public FIELDSET<INS<T>> fieldset() {
      closeAttrs();
      return fieldset_(this, false);
    }

    @Override
    public FIELDSET<INS<T>> fieldset(String selector) {
      return setSelector(fieldset(), selector);
    }

    @Override
    public INS<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public INS<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<INS<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public INS<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public INS<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<INS<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public INS<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public INS<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<INS<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public INS<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public INS<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public INS<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<INS<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public INS<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<INS<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public INS<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public INS<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<INS<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public INS<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public INS<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<INS<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public INS<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public INS<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public INS<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<INS<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public INS<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<INS<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public INS<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public INS<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<INS<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public INS<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public INS<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<INS<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public INS<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public INS<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<INS<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public INS<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public INS<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<INS<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<INS<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public INS<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public INS<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<INS<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public INS<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<INS<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<INS<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<INS<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public INS<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public INS<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<INS<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public INS<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public INS<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<INS<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<INS<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public INS<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public INS<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<INS<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<INS<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public INS<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<INS<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public INS<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<INS<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public INS<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public INS<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<INS<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public INS<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<INS<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public INS<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<INS<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public INS<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<INS<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public INS<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<INS<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<INS<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<INS<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<INS<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<INS<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<INS<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public INS<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<INS<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<INS<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public INS<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class BLOCKQUOTE<T extends __> extends EImp<T> implements HamletSpec.BLOCKQUOTE {
    public BLOCKQUOTE(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public BLOCKQUOTE<T> $cite(String value) {
      addAttr("cite", value);
      return this;
    }

    @Override
    public BLOCKQUOTE<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public BLOCKQUOTE<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public BLOCKQUOTE<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public BLOCKQUOTE<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public BLOCKQUOTE<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public BLOCKQUOTE<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public BLOCKQUOTE<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public BLOCKQUOTE<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public BLOCKQUOTE<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public BLOCKQUOTE<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public BLOCKQUOTE<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public BLOCKQUOTE<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public BLOCKQUOTE<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public BLOCKQUOTE<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public BLOCKQUOTE<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public BLOCKQUOTE<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public TABLE<BLOCKQUOTE<T>> table() {
      closeAttrs();
      return table_(this, false);
    }

    @Override
    public TABLE<BLOCKQUOTE<T>> table(String selector) {
      return setSelector(table(), selector);
    }

    @Override
    public BLOCKQUOTE<T> address(String cdata) {
      return address().__(cdata).__();
    }

    @Override
    public ADDRESS<BLOCKQUOTE<T>> address() {
      closeAttrs();
      return address_(this, false);
    }

    @Override
    public P<BLOCKQUOTE<T>> p(String selector) {
      return setSelector(p(), selector);
    }

    @Override
    public P<BLOCKQUOTE<T>> p() {
      closeAttrs();
      return p_(this, false);
    }

    @Override
    public BLOCKQUOTE<T> __(Class<? extends SubView> cls) {
      _v(cls);
      return this;
    }

    @Override
    public HR<BLOCKQUOTE<T>> hr() {
      closeAttrs();
      return hr_(this, false);
    }

    @Override
    public BLOCKQUOTE<T> hr(String selector) {
      return setSelector(hr(), selector).__();
    }

    @Override
    public DL<BLOCKQUOTE<T>> dl(String selector) {
      return setSelector(dl(), selector);
    }

    @Override
    public DL<BLOCKQUOTE<T>> dl() {
      closeAttrs();
      return dl_(this, false);
    }

    @Override
    public DIV<BLOCKQUOTE<T>> div(String selector) {
      return setSelector(div(), selector);
    }

    @Override
    public DIV<BLOCKQUOTE<T>> div() {
      closeAttrs();
      return div_(this, false);
    }

    @Override
    public BLOCKQUOTE<BLOCKQUOTE<T>> blockquote() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BLOCKQUOTE<BLOCKQUOTE<T>> bq() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BLOCKQUOTE<T> h1(String cdata) {
      return h1().__(cdata).__();
    }

    @Override
    public H1<BLOCKQUOTE<T>> h1() {
      closeAttrs();
      return h1_(this, false);
    }

    @Override
    public BLOCKQUOTE<T> h1(String selector, String cdata) {
      return setSelector(h1(), selector).__(cdata).__();
    }

    @Override
    public BLOCKQUOTE<T> h2(String cdata) {
      return h2().__(cdata).__();
    }

    @Override
    public H2<BLOCKQUOTE<T>> h2() {
      closeAttrs();
      return h2_(this, false);
    }

    @Override
    public BLOCKQUOTE<T> h2(String selector, String cdata) {
      return setSelector(h2(), selector).__(cdata).__();
    }

    @Override
    public H3<BLOCKQUOTE<T>> h3() {
      closeAttrs();
      return h3_(this, false);
    }

    @Override
    public BLOCKQUOTE<T> h3(String cdata) {
      return h3().__(cdata).__();
    }

    @Override
    public BLOCKQUOTE<T> h3(String selector, String cdata) {
      return setSelector(h3(), selector).__(cdata).__();
    }

    @Override
    public H4<BLOCKQUOTE<T>> h4() {
      closeAttrs();
      return h4_(this, false);
    }

    @Override
    public BLOCKQUOTE<T> h4(String cdata) {
      return h4().__(cdata).__();
    }

    @Override
    public BLOCKQUOTE<T> h4(String selector, String cdata) {
      return setSelector(h4(), selector).__(cdata).__();
    }

    @Override
    public H5<BLOCKQUOTE<T>> h5() {
      closeAttrs();
      return h5_(this, false);
    }

    @Override
    public BLOCKQUOTE<T> h5(String cdata) {
      return h5().__(cdata).__();
    }

    @Override
    public BLOCKQUOTE<T> h5(String selector, String cdata) {
      return setSelector(h5(), selector).__(cdata).__();
    }

    @Override
    public H6<BLOCKQUOTE<T>> h6() {
      closeAttrs();
      return h6_(this, false);
    }

    @Override
    public BLOCKQUOTE<T> h6(String cdata) {
      return h6().__(cdata).__();
    }

    @Override
    public BLOCKQUOTE<T> h6(String selector, String cdata) {
      return setSelector(h6(), selector).__(cdata).__();
    }

    @Override
    public UL<BLOCKQUOTE<T>> ul() {
      closeAttrs();
      return ul_(this, false);
    }

    @Override
    public UL<BLOCKQUOTE<T>> ul(String selector) {
      return setSelector(ul(), selector);
    }

    @Override
    public OL<BLOCKQUOTE<T>> ol() {
      closeAttrs();
      return ol_(this, false);
    }

    @Override
    public OL<BLOCKQUOTE<T>> ol(String selector) {
      return setSelector(ol(), selector);
    }

    @Override
    public PRE<BLOCKQUOTE<T>> pre() {
      closeAttrs();
      return pre_(this, false);
    }

    @Override
    public PRE<BLOCKQUOTE<T>> pre(String selector) {
      return setSelector(pre(), selector);
    }

    @Override
    public FORM<BLOCKQUOTE<T>> form() {
      closeAttrs();
      return form_(this, false);
    }

    @Override
    public FORM<BLOCKQUOTE<T>> form(String selector) {
      return setSelector(form(), selector);
    }

    @Override
    public FIELDSET<BLOCKQUOTE<T>> fieldset() {
      closeAttrs();
      return fieldset_(this, false);
    }

    @Override
    public FIELDSET<BLOCKQUOTE<T>> fieldset(String selector) {
      return setSelector(fieldset(), selector);
    }

    @Override
    public SCRIPT<BLOCKQUOTE<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public BLOCKQUOTE<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }
  }

  public class Q<T extends __> extends EImp<T> implements HamletSpec.Q {
    public Q(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public Q<T> $cite(String value) {
      addAttr("cite", value);
      return this;
    }

    @Override
    public Q<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public Q<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public Q<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public Q<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public Q<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public Q<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public Q<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public Q<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public Q<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public Q<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public Q<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public Q<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public Q<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public Q<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public Q<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public Q<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public Q<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public Q<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<Q<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public Q<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public Q<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<Q<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public Q<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public Q<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<Q<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public Q<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public Q<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public Q<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<Q<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public Q<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<Q<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public Q<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public Q<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<Q<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public Q<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public Q<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<Q<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public Q<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public Q<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public Q<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<Q<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public Q<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<Q<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public Q<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public Q<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<Q<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public Q<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public Q<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<Q<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public Q<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public Q<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<Q<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public Q<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public Q<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<Q<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<Q<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public Q<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public Q<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<Q<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public Q<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<Q<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<Q<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<Q<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public Q<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public Q<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<Q<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public Q<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public Q<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<Q<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<Q<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public Q<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public Q<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<Q<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<Q<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public Q<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<Q<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public Q<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<Q<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public Q<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public Q<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<Q<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public Q<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<Q<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public Q<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<Q<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public Q<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<Q<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public Q<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<Q<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<Q<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<Q<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<Q<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<Q<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<Q<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public Q<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<Q<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<Q<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public Q<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class PRE<T extends __> extends EImp<T> implements HamletSpec.PRE {
    public PRE(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public PRE<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public PRE<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public PRE<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public PRE<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public PRE<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public PRE<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public PRE<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public PRE<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public PRE<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public PRE<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public PRE<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public PRE<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public PRE<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public PRE<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public PRE<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public PRE<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public PRE<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public PRE<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<PRE<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public PRE<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public PRE<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<PRE<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public PRE<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public PRE<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public PRE<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<PRE<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public PRE<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<PRE<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public PRE<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public PRE<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<PRE<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public PRE<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public PRE<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<PRE<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public PRE<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public PRE<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public PRE<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<PRE<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public PRE<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<PRE<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public PRE<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public PRE<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<PRE<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public PRE<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public PRE<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<PRE<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public PRE<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public PRE<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<PRE<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public PRE<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public PRE<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<PRE<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<PRE<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public PRE<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public PRE<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public MAP<PRE<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<PRE<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public PRE<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public PRE<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<PRE<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<PRE<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public PRE<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<PRE<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public PRE<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<PRE<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public PRE<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public PRE<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<PRE<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public PRE<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<PRE<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public PRE<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<PRE<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public PRE<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<PRE<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public PRE<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<PRE<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<PRE<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<PRE<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<PRE<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<PRE<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<PRE<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public PRE<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<PRE<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<PRE<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public PRE<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class H6<T extends __> extends EImp<T> implements HamletSpec.H6 {
    public H6(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public H6<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public H6<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public H6<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public H6<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public H6<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public H6<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public H6<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public H6<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public H6<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public H6<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public H6<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public H6<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public H6<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public H6<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public H6<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public H6<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public H6<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public H6<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<H6<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public H6<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public H6<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<H6<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public H6<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public H6<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<H6<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public H6<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public H6<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public H6<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<H6<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public H6<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<H6<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public H6<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public H6<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<H6<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public H6<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public H6<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<H6<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public H6<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public H6<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public H6<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<H6<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public H6<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<H6<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public H6<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public H6<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<H6<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public H6<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public H6<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<H6<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public H6<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public H6<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<H6<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public H6<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public H6<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<H6<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<H6<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public H6<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public H6<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<H6<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public H6<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<H6<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<H6<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<H6<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public H6<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public H6<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<H6<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public H6<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public H6<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<H6<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<H6<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public H6<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public H6<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<H6<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<H6<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public H6<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<H6<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public H6<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<H6<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public H6<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public H6<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<H6<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public H6<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<H6<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public H6<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<H6<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public H6<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<H6<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public H6<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<H6<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<H6<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<H6<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<H6<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<H6<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<H6<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public H6<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<H6<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<H6<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public H6<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class H5<T extends __> extends EImp<T> implements HamletSpec.H5 {
    public H5(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public H5<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public H5<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public H5<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public H5<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public H5<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public H5<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public H5<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public H5<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public H5<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public H5<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public H5<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public H5<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public H5<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public H5<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public H5<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public H5<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public H5<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public H5<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<H5<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public H5<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public H5<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<H5<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public H5<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public H5<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<H5<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public H5<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public H5<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public H5<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<H5<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public H5<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<H5<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public H5<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public H5<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<H5<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public H5<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public H5<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<H5<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public H5<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public H5<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public H5<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<H5<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public H5<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<H5<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public H5<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public H5<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<H5<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public H5<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public H5<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<H5<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public H5<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public H5<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<H5<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public H5<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public H5<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<H5<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<H5<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public H5<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public H5<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<H5<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public H5<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<H5<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<H5<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<H5<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public H5<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public H5<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<H5<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public H5<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public H5<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<H5<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<H5<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public H5<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public H5<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<H5<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<H5<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public H5<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<H5<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public H5<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<H5<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public H5<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public H5<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<H5<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public H5<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<H5<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public H5<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<H5<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public H5<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<H5<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public H5<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<H5<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<H5<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<H5<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<H5<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<H5<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<H5<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public H5<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<H5<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<H5<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public H5<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class H4<T extends __> extends EImp<T> implements HamletSpec.H4 {
    public H4(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public H4<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public H4<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public H4<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public H4<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public H4<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public H4<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public H4<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public H4<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public H4<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public H4<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public H4<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public H4<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public H4<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public H4<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public H4<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public H4<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public H4<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public H4<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<H4<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public H4<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public H4<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<H4<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public H4<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public H4<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<H4<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public H4<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public H4<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public H4<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<H4<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public H4<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<H4<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public H4<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public H4<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<H4<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public H4<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public H4<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<H4<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public H4<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public H4<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public H4<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<H4<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public H4<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<H4<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public H4<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public H4<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<H4<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public H4<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public H4<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<H4<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public H4<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public H4<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<H4<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public H4<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public H4<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<H4<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<H4<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public H4<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public H4<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<H4<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public H4<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<H4<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<H4<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<H4<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public H4<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public H4<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<H4<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public H4<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public H4<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<H4<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<H4<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public H4<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public H4<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<H4<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<H4<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public H4<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<H4<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public H4<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<H4<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public H4<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public H4<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<H4<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public H4<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<H4<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public H4<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<H4<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public H4<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<H4<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public H4<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<H4<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<H4<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<H4<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<H4<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<H4<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<H4<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public H4<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<H4<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<H4<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public H4<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class H3<T extends __> extends EImp<T> implements HamletSpec.H3 {
    public H3(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public H3<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public H3<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public H3<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public H3<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public H3<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public H3<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public H3<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public H3<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public H3<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public H3<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public H3<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public H3<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public H3<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public H3<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public H3<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public H3<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public H3<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public H3<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<H3<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public H3<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public H3<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<H3<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public H3<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public H3<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<H3<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public H3<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public H3<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public H3<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<H3<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public H3<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<H3<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public H3<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public H3<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<H3<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public H3<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public H3<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<H3<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public H3<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public H3<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public H3<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<H3<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public H3<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<H3<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public H3<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public H3<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<H3<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public H3<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public H3<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<H3<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public H3<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public H3<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<H3<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public H3<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public H3<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<H3<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<H3<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public H3<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public H3<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<H3<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public H3<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<H3<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<H3<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<H3<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public H3<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public H3<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<H3<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public H3<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public H3<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<H3<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<H3<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public H3<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public H3<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<H3<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<H3<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public H3<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<H3<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public H3<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<H3<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public H3<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public H3<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<H3<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public H3<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<H3<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public H3<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<H3<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public H3<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<H3<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public H3<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<H3<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<H3<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<H3<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<H3<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<H3<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<H3<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public H3<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<H3<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<H3<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public H3<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class H2<T extends __> extends EImp<T> implements HamletSpec.H2 {
    public H2(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public H2<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public H2<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public H2<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public H2<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public H2<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public H2<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public H2<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public H2<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public H2<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public H2<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public H2<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public H2<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public H2<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public H2<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public H2<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public H2<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public H2<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public H2<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<H2<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public H2<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public H2<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<H2<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public H2<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public H2<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<H2<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public H2<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public H2<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public H2<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<H2<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public H2<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<H2<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public H2<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public H2<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<H2<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public H2<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public H2<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<H2<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public H2<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public H2<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public H2<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<H2<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public H2<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<H2<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public H2<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public H2<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<H2<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public H2<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public H2<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<H2<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public H2<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public H2<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<H2<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public H2<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public H2<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<H2<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<H2<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public H2<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public H2<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<H2<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public H2<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<H2<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<H2<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<H2<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public H2<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public H2<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<H2<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public H2<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public H2<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<H2<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<H2<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public H2<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public H2<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<H2<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<H2<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public H2<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<H2<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public H2<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<H2<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public H2<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public H2<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<H2<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public H2<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<H2<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public H2<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<H2<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public H2<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<H2<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public H2<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<H2<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<H2<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<H2<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<H2<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<H2<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<H2<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public H2<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<H2<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<H2<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public H2<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class H1<T extends __> extends EImp<T> implements HamletSpec.H1 {
    public H1(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public H1<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public H1<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public H1<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public H1<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public H1<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public H1<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public H1<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public H1<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public H1<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public H1<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public H1<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public H1<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public H1<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public H1<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public H1<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public H1<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public H1<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public H1<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<H1<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public H1<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public H1<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<H1<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public H1<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public H1<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<H1<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public H1<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public H1<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public H1<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<H1<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public H1<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<H1<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public H1<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public H1<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<H1<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public H1<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public H1<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<H1<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public H1<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public H1<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public H1<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<H1<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public H1<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<H1<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public H1<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public H1<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<H1<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public H1<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public H1<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<H1<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public H1<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public H1<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<H1<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public H1<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public H1<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<H1<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<H1<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public H1<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public H1<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<H1<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public H1<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<H1<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<H1<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<H1<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public H1<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public H1<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<H1<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public H1<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public H1<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<H1<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<H1<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public H1<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public H1<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<H1<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<H1<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public H1<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<H1<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public H1<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<H1<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public H1<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public H1<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<H1<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public H1<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<H1<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public H1<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<H1<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public H1<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<H1<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public H1<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<H1<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<H1<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<H1<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<H1<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<H1<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<H1<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public H1<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<H1<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<H1<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public H1<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class P<T extends __> extends EImp<T> implements HamletSpec.P {
    public P(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public P<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public P<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public P<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public P<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public P<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public P<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public P<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public P<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public P<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public P<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public P<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public P<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public P<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public P<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public P<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public P<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public P<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public P<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<P<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public P<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public P<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<P<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public P<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public P<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<P<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public P<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public P<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public P<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<P<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public P<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<P<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public P<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public P<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<P<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public P<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public P<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<P<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public P<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public P<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public P<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<P<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public P<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<P<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public P<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public P<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<P<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public P<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public P<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<P<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public P<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public P<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<P<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public P<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public P<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<P<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<P<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public P<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public P<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<P<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public P<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<P<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<P<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<P<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public P<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public P<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<P<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public P<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public P<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<P<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<P<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public P<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public P<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<P<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<P<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public P<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<P<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public P<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<P<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public P<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public P<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<P<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public P<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<P<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public P<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<P<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public P<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<P<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public P<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<P<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<P<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<P<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<P<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<P<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<P<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public P<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<P<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<P<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public P<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class HR<T extends __> extends EImp<T> implements HamletSpec.HR {
    public HR(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public HR<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public HR<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public HR<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public HR<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public HR<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public HR<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public HR<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public HR<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public HR<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public HR<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public HR<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public HR<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public HR<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public HR<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public HR<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public HR<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }
  }

  public class PARAM<T extends __> extends EImp<T> implements HamletSpec.PARAM {
    public PARAM(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public PARAM<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public PARAM<T> $name(String value) {
      addAttr("name", value);
      return this;
    }

    @Override
    public PARAM<T> $value(String value) {
      addAttr("value", value);
      return this;
    }
  }

  public class OBJECT<T extends __> extends EImp<T> implements HamletSpec.OBJECT {
    public OBJECT(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public OBJECT<T> $type(String value) {
      addAttr("type", value);
      return this;
    }

    @Override
    public OBJECT<T> $name(String value) {
      addAttr("name", value);
      return this;
    }

    @Override
    public OBJECT<T> $tabindex(int value) {
      addAttr("tabindex", value);
      return this;
    }

    @Override
    public OBJECT<T> $data(String value) {
      addAttr("data", value);
      return this;
    }

    @Override
    public OBJECT<T> $height(String value) {
      addAttr("height", value);
      return this;
    }

    @Override
    public OBJECT<T> $height(int value) {
      addAttr("height", value);
      return this;
    }

    @Override
    public OBJECT<T> $width(int value) {
      addAttr("width", value);
      return this;
    }

    @Override
    public OBJECT<T> $width(String value) {
      addAttr("width", value);
      return this;
    }

    @Override
    public OBJECT<T> $usemap(String value) {
      addAttr("usemap", value);
      return this;
    }

    @Override
    public OBJECT<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public OBJECT<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public OBJECT<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public OBJECT<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public OBJECT<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public OBJECT<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public OBJECT<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public OBJECT<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public OBJECT<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public OBJECT<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public OBJECT<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public OBJECT<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public OBJECT<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public OBJECT<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public OBJECT<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public OBJECT<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public PARAM<OBJECT<T>> param() {
      closeAttrs();
      return param_(this, false);
    }

    @Override
    public OBJECT<T> param(String name, String value) {
      return param().$name(name).$value(value).__();
    }

    @Override
    public TABLE<OBJECT<T>> table() {
      closeAttrs();
      return table_(this, false);
    }

    @Override
    public TABLE<OBJECT<T>> table(String selector) {
      return setSelector(table(), selector);
    }

    @Override
    public OBJECT<T> address(String cdata) {
      return address().__(cdata).__();
    }

    @Override
    public ADDRESS<OBJECT<T>> address() {
      closeAttrs();
      return address_(this, false);
    }

    @Override
    public P<OBJECT<T>> p(String selector) {
      return setSelector(p(), selector);
    }

    @Override
    public P<OBJECT<T>> p() {
      closeAttrs();
      return p_(this, false);
    }

    @Override
    public OBJECT<T> __(Class<? extends SubView> cls) {
      _v(cls);
      return this;
    }

    @Override
    public HR<OBJECT<T>> hr() {
      closeAttrs();
      return hr_(this, false);
    }

    @Override
    public OBJECT<T> hr(String selector) {
      return setSelector(hr(), selector).__();
    }

    @Override
    public DL<OBJECT<T>> dl(String selector) {
      return setSelector(dl(), selector);
    }

    @Override
    public DL<OBJECT<T>> dl() {
      closeAttrs();
      return dl_(this, false);
    }

    @Override
    public DIV<OBJECT<T>> div(String selector) {
      return setSelector(div(), selector);
    }

    @Override
    public DIV<OBJECT<T>> div() {
      closeAttrs();
      return div_(this, false);
    }

    @Override
    public BLOCKQUOTE<OBJECT<T>> blockquote() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BLOCKQUOTE<OBJECT<T>> bq() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public OBJECT<T> h1(String cdata) {
      return h1().__(cdata).__();
    }

    @Override
    public H1<OBJECT<T>> h1() {
      closeAttrs();
      return h1_(this, false);
    }

    @Override
    public OBJECT<T> h1(String selector, String cdata) {
      return setSelector(h1(), selector).__(cdata).__();
    }

    @Override
    public OBJECT<T> h2(String cdata) {
      return h2().__(cdata).__();
    }

    @Override
    public H2<OBJECT<T>> h2() {
      closeAttrs();
      return h2_(this, false);
    }

    @Override
    public OBJECT<T> h2(String selector, String cdata) {
      return setSelector(h2(), selector).__(cdata).__();
    }

    @Override
    public H3<OBJECT<T>> h3() {
      closeAttrs();
      return h3_(this, false);
    }

    @Override
    public OBJECT<T> h3(String cdata) {
      return h3().__(cdata).__();
    }

    @Override
    public OBJECT<T> h3(String selector, String cdata) {
      return setSelector(h3(), selector).__(cdata).__();
    }

    @Override
    public H4<OBJECT<T>> h4() {
      closeAttrs();
      return h4_(this, false);
    }

    @Override
    public OBJECT<T> h4(String cdata) {
      return h4().__(cdata).__();
    }

    @Override
    public OBJECT<T> h4(String selector, String cdata) {
      return setSelector(h4(), selector).__(cdata).__();
    }

    @Override
    public H5<OBJECT<T>> h5() {
      closeAttrs();
      return h5_(this, false);
    }

    @Override
    public OBJECT<T> h5(String cdata) {
      return h5().__(cdata).__();
    }

    @Override
    public OBJECT<T> h5(String selector, String cdata) {
      return setSelector(h5(), selector).__(cdata).__();
    }

    @Override
    public H6<OBJECT<T>> h6() {
      closeAttrs();
      return h6_(this, false);
    }

    @Override
    public OBJECT<T> h6(String cdata) {
      return h6().__(cdata).__();
    }

    @Override
    public OBJECT<T> h6(String selector, String cdata) {
      return setSelector(h6(), selector).__(cdata).__();
    }

    @Override
    public UL<OBJECT<T>> ul() {
      closeAttrs();
      return ul_(this, false);
    }

    @Override
    public UL<OBJECT<T>> ul(String selector) {
      return setSelector(ul(), selector);
    }

    @Override
    public OL<OBJECT<T>> ol() {
      closeAttrs();
      return ol_(this, false);
    }

    @Override
    public OL<OBJECT<T>> ol(String selector) {
      return setSelector(ol(), selector);
    }

    @Override
    public PRE<OBJECT<T>> pre() {
      closeAttrs();
      return pre_(this, false);
    }

    @Override
    public PRE<OBJECT<T>> pre(String selector) {
      return setSelector(pre(), selector);
    }

    @Override
    public FORM<OBJECT<T>> form() {
      closeAttrs();
      return form_(this, false);
    }

    @Override
    public FORM<OBJECT<T>> form(String selector) {
      return setSelector(form(), selector);
    }

    @Override
    public FIELDSET<OBJECT<T>> fieldset() {
      closeAttrs();
      return fieldset_(this, false);
    }

    @Override
    public FIELDSET<OBJECT<T>> fieldset(String selector) {
      return setSelector(fieldset(), selector);
    }

    @Override
    public OBJECT<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public OBJECT<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<OBJECT<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public OBJECT<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public OBJECT<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<OBJECT<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public OBJECT<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public OBJECT<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<OBJECT<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public OBJECT<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public OBJECT<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public OBJECT<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<OBJECT<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public OBJECT<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<OBJECT<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public OBJECT<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public OBJECT<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<OBJECT<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public OBJECT<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public OBJECT<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<OBJECT<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public OBJECT<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public OBJECT<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public OBJECT<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<OBJECT<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public OBJECT<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<OBJECT<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public OBJECT<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public OBJECT<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<OBJECT<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public OBJECT<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public OBJECT<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<OBJECT<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public OBJECT<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public OBJECT<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<OBJECT<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public OBJECT<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public OBJECT<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<OBJECT<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<OBJECT<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public OBJECT<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public OBJECT<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<OBJECT<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public OBJECT<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<OBJECT<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<OBJECT<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<OBJECT<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public OBJECT<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public OBJECT<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<OBJECT<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public OBJECT<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public OBJECT<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<OBJECT<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<OBJECT<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public OBJECT<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public OBJECT<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<OBJECT<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<OBJECT<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public OBJECT<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<OBJECT<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public OBJECT<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<OBJECT<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public OBJECT<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public OBJECT<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<OBJECT<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public OBJECT<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<OBJECT<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public OBJECT<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<OBJECT<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public OBJECT<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<OBJECT<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public OBJECT<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<OBJECT<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<OBJECT<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<OBJECT<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<OBJECT<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<OBJECT<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<OBJECT<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public OBJECT<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<OBJECT<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<OBJECT<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public OBJECT<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  private <T extends __> PARAM<T> param_(T e, boolean inline) {
    return new PARAM<T>("param", e, opt(false, inline, false)); }

  public class IMG<T extends __> extends EImp<T> implements HamletSpec.IMG {
    public IMG(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public IMG<T> $src(String value) {
      addAttr("src", value);
      return this;
    }

    @Override
    public IMG<T> $alt(String value) {
      addAttr("alt", value);
      return this;
    }

    @Override
    public IMG<T> $ismap() {
      addAttr("ismap", null);
      return this;
    }

    @Override
    public IMG<T> $height(String value) {
      addAttr("height", value);
      return this;
    }

    @Override
    public IMG<T> $height(int value) {
      addAttr("height", value);
      return this;
    }

    @Override
    public IMG<T> $width(int value) {
      addAttr("width", value);
      return this;
    }

    @Override
    public IMG<T> $width(String value) {
      addAttr("width", value);
      return this;
    }

    @Override
    public IMG<T> $usemap(String value) {
      addAttr("usemap", value);
      return this;
    }

    @Override
    public IMG<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public IMG<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public IMG<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public IMG<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public IMG<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public IMG<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public IMG<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public IMG<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public IMG<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public IMG<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public IMG<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public IMG<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public IMG<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public IMG<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public IMG<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public IMG<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }
  }

  public class LINK<T extends __> extends EImp<T> implements HamletSpec.LINK {
    public LINK(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public LINK<T> $rel(EnumSet<LinkType> value) {
      addRelAttr("rel", value);
      return this;
    }

    @Override
    public LINK<T> $rel(String value) {
      addAttr("rel", value);
      return this;
    }

    @Override
    public LINK<T> $href(String value) {
      addAttr("href", value);
      return this;
    }

    @Override
    public LINK<T> $type(String value) {
      addAttr("type", value);
      return this;
    }

    @Override
    public LINK<T> $media(EnumSet<Media> value) {
      addMediaAttr("media", value);
      return this;
    }

    @Override
    public LINK<T> $media(String value) {
      addAttr("media", value);
      return this;
    }

    @Override
    public LINK<T> $hreflang(String value) {
      addAttr("hreflang", value);
      return this;
    }

    @Override
    public LINK<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public LINK<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public LINK<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public LINK<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public LINK<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public LINK<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public LINK<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public LINK<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public LINK<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public LINK<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public LINK<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public LINK<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public LINK<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public LINK<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public LINK<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public LINK<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }
  }

  public class AREA<T extends __> extends EImp<T> implements HamletSpec.AREA {
    public AREA(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public AREA<T> $href(String value) {
      addAttr("href", value);
      return this;
    }

    @Override
    public AREA<T> $tabindex(int value) {
      addAttr("tabindex", value);
      return this;
    }

    @Override
    public AREA<T> $accesskey(String value) {
      addAttr("accesskey", value);
      return this;
    }

    @Override
    public AREA<T> $onfocus(String value) {
      addAttr("onfocus", value);
      return this;
    }

    @Override
    public AREA<T> $onblur(String value) {
      addAttr("onblur", value);
      return this;
    }

    @Override
    public AREA<T> $alt(String value) {
      addAttr("alt", value);
      return this;
    }

    @Override
    public AREA<T> $shape(Shape value) {
      addAttr("shape", value);
      return this;
    }

    @Override
    public AREA<T> $coords(String value) {
      addAttr("coords", value);
      return this;
    }

    @Override
    public AREA<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public AREA<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public AREA<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public AREA<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public AREA<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public AREA<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public AREA<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public AREA<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public AREA<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public AREA<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public AREA<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public AREA<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public AREA<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public AREA<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public AREA<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public AREA<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }
  }

  private <T extends __> AREA<T> area_(T e, boolean inline) {
    return new AREA<T>("area", e, opt(false, inline, false)); }

  public class MAP<T extends __> extends EImp<T> implements HamletSpec.MAP {
    public MAP(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public MAP<T> $name(String value) {
      addAttr("name", value);
      return this;
    }

    @Override
    public AREA<MAP<T>> area() {
      closeAttrs();
      return area_(this, false);
    }

    @Override
    public AREA<MAP<T>> area(String selector) {
      return setSelector(area(), selector);
    }

    @Override
    public MAP<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public MAP<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public MAP<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public MAP<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public MAP<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public MAP<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public MAP<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public MAP<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public MAP<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public MAP<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public MAP<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public MAP<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public MAP<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public MAP<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public MAP<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public MAP<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public TABLE<MAP<T>> table() {
      closeAttrs();
      return table_(this, false);
    }

    @Override
    public TABLE<MAP<T>> table(String selector) {
      return setSelector(table(), selector);
    }

    @Override
    public MAP<T> address(String cdata) {
      return address().__(cdata).__();
    }

    @Override
    public ADDRESS<MAP<T>> address() {
      closeAttrs();
      return address_(this, false);
    }

    @Override
    public P<MAP<T>> p(String selector) {
      return setSelector(p(), selector);
    }

    @Override
    public P<MAP<T>> p() {
      closeAttrs();
      return p_(this, false);
    }

    @Override
    public MAP<T> __(Class<? extends SubView> cls) {
      _v(cls);
      return this;
    }

    @Override
    public HR<MAP<T>> hr() {
      closeAttrs();
      return hr_(this, false);
    }

    @Override
    public MAP<T> hr(String selector) {
      return setSelector(hr(), selector).__();
    }

    @Override
    public DL<MAP<T>> dl(String selector) {
      return setSelector(dl(), selector);
    }

    @Override
    public DL<MAP<T>> dl() {
      closeAttrs();
      return dl_(this, false);
    }

    @Override
    public DIV<MAP<T>> div(String selector) {
      return setSelector(div(), selector);
    }

    @Override
    public DIV<MAP<T>> div() {
      closeAttrs();
      return div_(this, false);
    }

    @Override
    public BLOCKQUOTE<MAP<T>> blockquote() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BLOCKQUOTE<MAP<T>> bq() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public MAP<T> h1(String cdata) {
      return h1().__(cdata).__();
    }

    @Override
    public H1<MAP<T>> h1() {
      closeAttrs();
      return h1_(this, false);
    }

    @Override
    public MAP<T> h1(String selector, String cdata) {
      return setSelector(h1(), selector).__(cdata).__();
    }

    @Override
    public MAP<T> h2(String cdata) {
      return h2().__(cdata).__();
    }

    @Override
    public H2<MAP<T>> h2() {
      closeAttrs();
      return h2_(this, false);
    }

    @Override
    public MAP<T> h2(String selector, String cdata) {
      return setSelector(h2(), selector).__(cdata).__();
    }

    @Override
    public H3<MAP<T>> h3() {
      closeAttrs();
      return h3_(this, false);
    }

    @Override
    public MAP<T> h3(String cdata) {
      return h3().__(cdata).__();
    }

    @Override
    public MAP<T> h3(String selector, String cdata) {
      return setSelector(h3(), selector).__(cdata).__();
    }

    @Override
    public H4<MAP<T>> h4() {
      closeAttrs();
      return h4_(this, false);
    }

    @Override
    public MAP<T> h4(String cdata) {
      return h4().__(cdata).__();
    }

    @Override
    public MAP<T> h4(String selector, String cdata) {
      return setSelector(h4(), selector).__(cdata).__();
    }

    @Override
    public H5<MAP<T>> h5() {
      closeAttrs();
      return h5_(this, false);
    }

    @Override
    public MAP<T> h5(String cdata) {
      return h5().__(cdata).__();
    }

    @Override
    public MAP<T> h5(String selector, String cdata) {
      return setSelector(h5(), selector).__(cdata).__();
    }

    @Override
    public H6<MAP<T>> h6() {
      closeAttrs();
      return h6_(this, false);
    }

    @Override
    public MAP<T> h6(String cdata) {
      return h6().__(cdata).__();
    }

    @Override
    public MAP<T> h6(String selector, String cdata) {
      return setSelector(h6(), selector).__(cdata).__();
    }

    @Override
    public UL<MAP<T>> ul() {
      closeAttrs();
      return ul_(this, false);
    }

    @Override
    public UL<MAP<T>> ul(String selector) {
      return setSelector(ul(), selector);
    }

    @Override
    public OL<MAP<T>> ol() {
      closeAttrs();
      return ol_(this, false);
    }

    @Override
    public OL<MAP<T>> ol(String selector) {
      return setSelector(ol(), selector);
    }

    @Override
    public PRE<MAP<T>> pre() {
      closeAttrs();
      return pre_(this, false);
    }

    @Override
    public PRE<MAP<T>> pre(String selector) {
      return setSelector(pre(), selector);
    }

    @Override
    public FORM<MAP<T>> form() {
      closeAttrs();
      return form_(this, false);
    }

    @Override
    public FORM<MAP<T>> form(String selector) {
      return setSelector(form(), selector);
    }

    @Override
    public FIELDSET<MAP<T>> fieldset() {
      closeAttrs();
      return fieldset_(this, false);
    }

    @Override
    public FIELDSET<MAP<T>> fieldset(String selector) {
      return setSelector(fieldset(), selector);
    }
  }

  public class A<T extends __> extends EImp<T> implements HamletSpec.A {
    public A(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public A<T> $rel(EnumSet<LinkType> value) {
      addRelAttr("rel", value);
      return this;
    }

    @Override
    public A<T> $rel(String value) {
      addAttr("rel", value);
      return this;
    }

    @Override
    public A<T> $href(String value) {
      addAttr("href", value);
      return this;
    }

    @Override
    public A<T> $type(String value) {
      addAttr("type", value);
      return this;
    }

    @Override
    public A<T> $tabindex(int value) {
      addAttr("tabindex", value);
      return this;
    }

    @Override
    public A<T> $accesskey(String value) {
      addAttr("accesskey", value);
      return this;
    }

    @Override
    public A<T> $onfocus(String value) {
      addAttr("onfocus", value);
      return this;
    }

    @Override
    public A<T> $onblur(String value) {
      addAttr("onblur", value);
      return this;
    }

    @Override
    public A<T> $hreflang(String value) {
      addAttr("hreflang", value);
      return this;
    }

    @Override
    public A<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public A<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public A<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public A<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public A<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public A<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public A<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public A<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public A<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public A<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public A<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public A<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public A<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public A<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public A<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public A<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public A<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public A<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<A<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public A<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public A<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<A<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public A<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public A<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<A<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public A<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public A<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public A<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<A<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public A<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<A<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public A<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public A<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<A<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public A<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public A<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<A<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public A<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public A<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public A<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<A<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public A<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<A<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public A<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public A<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<A<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public A<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public A<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<A<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public A<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public A<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<A<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public A<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public A<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public IMG<A<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public A<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<A<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<A<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public MAP<A<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<A<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public A<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public A<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<A<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<A<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public A<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<A<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public A<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<A<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public A<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public A<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<A<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public A<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<A<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public A<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<A<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public A<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public SUB<A<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public A<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public A<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<A<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public A<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public A<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public LABEL<A<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public A<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<A<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<A<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<A<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<A<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<A<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<A<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public A<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<A<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<A<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public A<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class DIV<T extends __> extends EImp<T> implements HamletSpec.DIV {
    public DIV(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public DIV<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public DIV<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public DIV<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public DIV<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public DIV<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public DIV<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public DIV<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public DIV<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public DIV<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public DIV<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public DIV<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public DIV<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public DIV<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public DIV<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public DIV<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public DIV<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public TABLE<DIV<T>> table() {
      closeAttrs();
      return table_(this, false);
    }

    @Override
    public TABLE<DIV<T>> table(String selector) {
      return setSelector(table(), selector);
    }

    @Override
    public DIV<T> address(String cdata) {
      return address().__(cdata).__();
    }

    @Override
    public ADDRESS<DIV<T>> address() {
      closeAttrs();
      return address_(this, false);
    }

    @Override
    public P<DIV<T>> p(String selector) {
      return setSelector(p(), selector);
    }

    @Override
    public P<DIV<T>> p() {
      closeAttrs();
      return p_(this, false);
    }

    @Override
    public DIV<T> __(Class<? extends SubView> cls) {
      _v(cls);
      return this;
    }

    @Override
    public HR<DIV<T>> hr() {
      closeAttrs();
      return hr_(this, false);
    }

    @Override
    public DIV<T> hr(String selector) {
      return setSelector(hr(), selector).__();
    }

    @Override
    public DL<DIV<T>> dl(String selector) {
      return setSelector(dl(), selector);
    }

    @Override
    public DL<DIV<T>> dl() {
      closeAttrs();
      return dl_(this, false);
    }

    @Override
    public DIV<DIV<T>> div(String selector) {
      return setSelector(div(), selector);
    }

    @Override
    public DIV<DIV<T>> div() {
      closeAttrs();
      return div_(this, false);
    }

    @Override
    public BLOCKQUOTE<DIV<T>> blockquote() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BLOCKQUOTE<DIV<T>> bq() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public DIV<T> h1(String cdata) {
      return h1().__(cdata).__();
    }

    @Override
    public H1<DIV<T>> h1() {
      closeAttrs();
      return h1_(this, false);
    }

    @Override
    public DIV<T> h1(String selector, String cdata) {
      return setSelector(h1(), selector).__(cdata).__();
    }

    @Override
    public DIV<T> h2(String cdata) {
      return h2().__(cdata).__();
    }

    @Override
    public H2<DIV<T>> h2() {
      closeAttrs();
      return h2_(this, false);
    }

    @Override
    public DIV<T> h2(String selector, String cdata) {
      return setSelector(h2(), selector).__(cdata).__();
    }

    @Override
    public H3<DIV<T>> h3() {
      closeAttrs();
      return h3_(this, false);
    }

    @Override
    public DIV<T> h3(String cdata) {
      return h3().__(cdata).__();
    }

    @Override
    public DIV<T> h3(String selector, String cdata) {
      return setSelector(h3(), selector).__(cdata).__();
    }

    @Override
    public H4<DIV<T>> h4() {
      closeAttrs();
      return h4_(this, false);
    }

    @Override
    public DIV<T> h4(String cdata) {
      return h4().__(cdata).__();
    }

    @Override
    public DIV<T> h4(String selector, String cdata) {
      return setSelector(h4(), selector).__(cdata).__();
    }

    @Override
    public H5<DIV<T>> h5() {
      closeAttrs();
      return h5_(this, false);
    }

    @Override
    public DIV<T> h5(String cdata) {
      return h5().__(cdata).__();
    }

    @Override
    public DIV<T> h5(String selector, String cdata) {
      return setSelector(h5(), selector).__(cdata).__();
    }

    @Override
    public H6<DIV<T>> h6() {
      closeAttrs();
      return h6_(this, false);
    }

    @Override
    public DIV<T> h6(String cdata) {
      return h6().__(cdata).__();
    }

    @Override
    public DIV<T> h6(String selector, String cdata) {
      return setSelector(h6(), selector).__(cdata).__();
    }

    @Override
    public UL<DIV<T>> ul() {
      closeAttrs();
      return ul_(this, false);
    }

    @Override
    public UL<DIV<T>> ul(String selector) {
      return setSelector(ul(), selector);
    }

    @Override
    public OL<DIV<T>> ol() {
      closeAttrs();
      return ol_(this, false);
    }

    @Override
    public OL<DIV<T>> ol(String selector) {
      return setSelector(ol(), selector);
    }

    @Override
    public PRE<DIV<T>> pre() {
      closeAttrs();
      return pre_(this, false);
    }

    @Override
    public PRE<DIV<T>> pre(String selector) {
      return setSelector(pre(), selector);
    }

    @Override
    public FORM<DIV<T>> form() {
      closeAttrs();
      return form_(this, false);
    }

    @Override
    public FORM<DIV<T>> form(String selector) {
      return setSelector(form(), selector);
    }

    @Override
    public FIELDSET<DIV<T>> fieldset() {
      closeAttrs();
      return fieldset_(this, false);
    }

    @Override
    public FIELDSET<DIV<T>> fieldset(String selector) {
      return setSelector(fieldset(), selector);
    }

    @Override
    public DIV<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public DIV<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<DIV<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public DIV<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public DIV<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<DIV<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public DIV<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public DIV<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<DIV<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public DIV<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public DIV<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public DIV<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<DIV<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public DIV<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<DIV<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public DIV<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public DIV<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<DIV<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public DIV<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public DIV<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<DIV<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public DIV<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public DIV<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public DIV<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<DIV<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public DIV<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<DIV<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public DIV<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public DIV<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<DIV<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public DIV<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public DIV<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<DIV<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public DIV<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public DIV<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<DIV<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public DIV<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public DIV<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<DIV<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<DIV<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public DIV<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public DIV<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<DIV<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public DIV<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<DIV<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<DIV<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<DIV<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public DIV<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public DIV<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<DIV<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public DIV<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public DIV<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<DIV<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<DIV<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public DIV<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public DIV<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<DIV<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<DIV<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public DIV<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<DIV<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public DIV<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<DIV<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public DIV<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public DIV<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<DIV<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public DIV<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<DIV<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public DIV<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<DIV<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public DIV<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<DIV<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public DIV<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<DIV<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<DIV<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<DIV<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<DIV<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<DIV<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<DIV<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public DIV<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<DIV<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<DIV<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public DIV<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class ADDRESS<T extends __> extends EImp<T> implements HamletSpec.ADDRESS {
    public ADDRESS(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public ADDRESS<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public ADDRESS<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public ADDRESS<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public ADDRESS<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public ADDRESS<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public ADDRESS<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public ADDRESS<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public ADDRESS<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public ADDRESS<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public ADDRESS<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public ADDRESS<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public ADDRESS<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public ADDRESS<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public ADDRESS<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public ADDRESS<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public ADDRESS<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public ADDRESS<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public ADDRESS<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<ADDRESS<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public ADDRESS<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public ADDRESS<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<ADDRESS<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public ADDRESS<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public ADDRESS<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<ADDRESS<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public ADDRESS<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public ADDRESS<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public ADDRESS<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<ADDRESS<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public ADDRESS<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<ADDRESS<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public ADDRESS<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public ADDRESS<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<ADDRESS<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public ADDRESS<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public ADDRESS<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<ADDRESS<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public ADDRESS<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public ADDRESS<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public ADDRESS<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<ADDRESS<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public ADDRESS<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<ADDRESS<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public ADDRESS<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public ADDRESS<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<ADDRESS<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public ADDRESS<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public ADDRESS<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<ADDRESS<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public ADDRESS<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public ADDRESS<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<ADDRESS<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public ADDRESS<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public ADDRESS<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<ADDRESS<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<ADDRESS<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public ADDRESS<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public ADDRESS<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<ADDRESS<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public ADDRESS<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<ADDRESS<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<ADDRESS<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<ADDRESS<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public ADDRESS<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public ADDRESS<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<ADDRESS<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public ADDRESS<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public ADDRESS<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<ADDRESS<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<ADDRESS<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public ADDRESS<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public ADDRESS<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<ADDRESS<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<ADDRESS<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public ADDRESS<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<ADDRESS<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public ADDRESS<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<ADDRESS<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public ADDRESS<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public ADDRESS<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<ADDRESS<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public ADDRESS<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<ADDRESS<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public ADDRESS<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<ADDRESS<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public ADDRESS<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<ADDRESS<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public ADDRESS<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<ADDRESS<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<ADDRESS<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<ADDRESS<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<ADDRESS<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<ADDRESS<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<ADDRESS<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public ADDRESS<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<ADDRESS<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<ADDRESS<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public ADDRESS<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class BODY<T extends __> extends EImp<T> implements HamletSpec.BODY {
    public BODY(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public BODY<T> $onload(String value) {
      addAttr("onload", value);
      return this;
    }

    @Override
    public BODY<T> $onunload(String value) {
      addAttr("onunload", value);
      return this;
    }

    @Override
    public BODY<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public BODY<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public BODY<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public BODY<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public BODY<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public BODY<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public BODY<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public BODY<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public BODY<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public BODY<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public BODY<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public BODY<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public BODY<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public BODY<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public BODY<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public BODY<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public TABLE<BODY<T>> table() {
      closeAttrs();
      return table_(this, false);
    }

    @Override
    public TABLE<BODY<T>> table(String selector) {
      return setSelector(table(), selector);
    }

    @Override
    public BODY<T> address(String cdata) {
      return address().__(cdata).__();
    }

    @Override
    public ADDRESS<BODY<T>> address() {
      closeAttrs();
      return address_(this, false);
    }

    @Override
    public P<BODY<T>> p(String selector) {
      return setSelector(p(), selector);
    }

    @Override
    public P<BODY<T>> p() {
      closeAttrs();
      return p_(this, false);
    }

    @Override
    public BODY<T> __(Class<? extends SubView> cls) {
      _v(cls);
      return this;
    }

    @Override
    public HR<BODY<T>> hr() {
      closeAttrs();
      return hr_(this, false);
    }

    @Override
    public BODY<T> hr(String selector) {
      return setSelector(hr(), selector).__();
    }

    @Override
    public DL<BODY<T>> dl(String selector) {
      return setSelector(dl(), selector);
    }

    @Override
    public DL<BODY<T>> dl() {
      closeAttrs();
      return dl_(this, false);
    }

    @Override
    public DIV<BODY<T>> div(String selector) {
      return setSelector(div(), selector);
    }

    @Override
    public DIV<BODY<T>> div() {
      closeAttrs();
      return div_(this, false);
    }

    @Override
    public BLOCKQUOTE<BODY<T>> blockquote() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BLOCKQUOTE<BODY<T>> bq() {
      closeAttrs();
      return blockquote_(this, false);
    }

    @Override
    public BODY<T> h1(String cdata) {
      return h1().__(cdata).__();
    }

    @Override
    public H1<BODY<T>> h1() {
      closeAttrs();
      return h1_(this, false);
    }

    @Override
    public BODY<T> h1(String selector, String cdata) {
      return setSelector(h1(), selector).__(cdata).__();
    }

    @Override
    public BODY<T> h2(String cdata) {
      return h2().__(cdata).__();
    }

    @Override
    public H2<BODY<T>> h2() {
      closeAttrs();
      return h2_(this, false);
    }

    @Override
    public BODY<T> h2(String selector, String cdata) {
      return setSelector(h2(), selector).__(cdata).__();
    }

    @Override
    public H3<BODY<T>> h3() {
      closeAttrs();
      return h3_(this, false);
    }

    @Override
    public BODY<T> h3(String cdata) {
      return h3().__(cdata).__();
    }

    @Override
    public BODY<T> h3(String selector, String cdata) {
      return setSelector(h3(), selector).__(cdata).__();
    }

    @Override
    public H4<BODY<T>> h4() {
      closeAttrs();
      return h4_(this, false);
    }

    @Override
    public BODY<T> h4(String cdata) {
      return h4().__(cdata).__();
    }

    @Override
    public BODY<T> h4(String selector, String cdata) {
      return setSelector(h4(), selector).__(cdata).__();
    }

    @Override
    public H5<BODY<T>> h5() {
      closeAttrs();
      return h5_(this, false);
    }

    @Override
    public BODY<T> h5(String cdata) {
      return h5().__(cdata).__();
    }

    @Override
    public BODY<T> h5(String selector, String cdata) {
      return setSelector(h5(), selector).__(cdata).__();
    }

    @Override
    public H6<BODY<T>> h6() {
      closeAttrs();
      return h6_(this, false);
    }

    @Override
    public BODY<T> h6(String cdata) {
      return h6().__(cdata).__();
    }

    @Override
    public BODY<T> h6(String selector, String cdata) {
      return setSelector(h6(), selector).__(cdata).__();
    }

    @Override
    public UL<BODY<T>> ul() {
      closeAttrs();
      return ul_(this, false);
    }

    @Override
    public UL<BODY<T>> ul(String selector) {
      return setSelector(ul(), selector);
    }

    @Override
    public OL<BODY<T>> ol() {
      closeAttrs();
      return ol_(this, false);
    }

    @Override
    public OL<BODY<T>> ol(String selector) {
      return setSelector(ol(), selector);
    }

    @Override
    public PRE<BODY<T>> pre() {
      closeAttrs();
      return pre_(this, false);
    }

    @Override
    public PRE<BODY<T>> pre(String selector) {
      return setSelector(pre(), selector);
    }

    @Override
    public FORM<BODY<T>> form() {
      closeAttrs();
      return form_(this, false);
    }

    @Override
    public FORM<BODY<T>> form(String selector) {
      return setSelector(form(), selector);
    }

    @Override
    public FIELDSET<BODY<T>> fieldset() {
      closeAttrs();
      return fieldset_(this, false);
    }

    @Override
    public FIELDSET<BODY<T>> fieldset(String selector) {
      return setSelector(fieldset(), selector);
    }

    @Override
    public SCRIPT<BODY<T>> script() {
      closeAttrs();
      return script_(this, false);
    }

    @Override
    public BODY<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<BODY<T>> ins() {
      closeAttrs();
      return ins_(this, false);
    }

    @Override
    public BODY<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<BODY<T>> del() {
      closeAttrs();
      return del_(this, false);
    }

    @Override
    public BODY<T> del(String cdata) {
      return del().__(cdata).__();
    }
  }

  private <T extends __> TABLE<T> table_(T e, boolean inline) {
    return new TABLE<T>("table", e, opt(true, inline, false)); }

  private <T extends __> ADDRESS<T> address_(T e, boolean inline) {
    return new ADDRESS<T>("address", e, opt(true, inline, false)); }

  private <T extends __> P<T> p_(T e, boolean inline) {
    return new P<T>("p", e, opt(false, inline, false)); }

  private <T extends __> HR<T> hr_(T e, boolean inline) {
    return new HR<T>("hr", e, opt(false, inline, false)); }

  private <T extends __> DL<T> dl_(T e, boolean inline) {
    return new DL<T>("dl", e, opt(true, inline, false)); }

  private <T extends __> DIV<T> div_(T e, boolean inline) {
    return new DIV<T>("div", e, opt(true, inline, false)); }

  private <T extends __> BLOCKQUOTE<T> blockquote_(T e, boolean inline) {
    return new BLOCKQUOTE<T>("blockquote", e, opt(true, inline, false)); }

  private <T extends __> BLOCKQUOTE<T> bq_(T e, boolean inline) {
    return new BLOCKQUOTE<T>("blockquote", e, opt(true, inline, false)); }

  private <T extends __> FIELDSET<T> fieldset_(T e, boolean inline) {
    return new FIELDSET<T>("fieldset", e, opt(true, inline, false)); }

  private <T extends __> FORM<T> form_(T e, boolean inline) {
    return new FORM<T>("form", e, opt(true, inline, false)); }

  public class BR<T extends __> extends EImp<T> implements HamletSpec.BR {
    public BR(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public BR<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public BR<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public BR<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public BR<T> $style(String value) {
      addAttr("style", value);
      return this;
    }
  }

  public class BDO<T extends __> extends EImp<T> implements HamletSpec.BDO {
    public BDO(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public BDO<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public BDO<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public BDO<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public BDO<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public BDO<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public BDO<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public BDO<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public BDO<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<BDO<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public BDO<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public BDO<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<BDO<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public BDO<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public BDO<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<BDO<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public BDO<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public BDO<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public BDO<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<BDO<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public BDO<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<BDO<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public BDO<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public BDO<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<BDO<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public BDO<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public BDO<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<BDO<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public BDO<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public BDO<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public BDO<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<BDO<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public BDO<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<BDO<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public BDO<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public BDO<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<BDO<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public BDO<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public BDO<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<BDO<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public BDO<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public BDO<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<BDO<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public BDO<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public BDO<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<BDO<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<BDO<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public BDO<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public BDO<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<BDO<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public BDO<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<BDO<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<BDO<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<BDO<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public BDO<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public BDO<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<BDO<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public BDO<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public BDO<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<BDO<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<BDO<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public BDO<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public BDO<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<BDO<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<BDO<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public BDO<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<BDO<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public BDO<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<BDO<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public BDO<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public BDO<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<BDO<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public BDO<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<BDO<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public BDO<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<BDO<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public BDO<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<BDO<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public BDO<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<BDO<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<BDO<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<BDO<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<BDO<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<BDO<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<BDO<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public BDO<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<BDO<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<BDO<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public BDO<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class SPAN<T extends __> extends EImp<T> implements HamletSpec.SPAN {
    public SPAN(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public SPAN<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public SPAN<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public SPAN<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public SPAN<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public SPAN<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public SPAN<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public SPAN<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public SPAN<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public SPAN<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public SPAN<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public SPAN<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public SPAN<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public SPAN<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public SPAN<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public SPAN<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public SPAN<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public SPAN<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public SPAN<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<SPAN<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public SPAN<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public SPAN<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<SPAN<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public SPAN<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public SPAN<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<SPAN<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public SPAN<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public SPAN<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public SPAN<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<SPAN<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public SPAN<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<SPAN<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public SPAN<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public SPAN<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<SPAN<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public SPAN<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public SPAN<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<SPAN<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public SPAN<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public SPAN<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public SPAN<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<SPAN<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public SPAN<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<SPAN<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public SPAN<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public SPAN<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<SPAN<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public SPAN<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public SPAN<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<SPAN<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public SPAN<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public SPAN<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<SPAN<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public SPAN<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public SPAN<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<SPAN<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<SPAN<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public SPAN<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public SPAN<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<SPAN<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public SPAN<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<SPAN<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<SPAN<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<SPAN<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public SPAN<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public SPAN<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<SPAN<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public SPAN<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public SPAN<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<SPAN<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<SPAN<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public SPAN<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public SPAN<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<SPAN<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<SPAN<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public SPAN<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<SPAN<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public SPAN<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<SPAN<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public SPAN<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public SPAN<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<SPAN<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public SPAN<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<SPAN<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public SPAN<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<SPAN<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public SPAN<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<SPAN<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public SPAN<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<SPAN<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<SPAN<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<SPAN<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<SPAN<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<SPAN<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<SPAN<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public SPAN<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<SPAN<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<SPAN<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public SPAN<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class SUP<T extends __> extends EImp<T> implements HamletSpec.SUP {
    public SUP(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public SUP<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public SUP<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public SUP<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public SUP<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public SUP<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public SUP<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public SUP<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public SUP<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public SUP<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public SUP<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public SUP<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public SUP<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public SUP<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public SUP<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public SUP<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public SUP<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public SUP<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public SUP<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<SUP<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public SUP<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public SUP<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<SUP<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public SUP<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public SUP<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<SUP<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public SUP<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public SUP<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public SUP<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<SUP<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public SUP<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<SUP<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public SUP<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public SUP<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<SUP<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public SUP<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public SUP<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<SUP<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public SUP<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public SUP<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public SUP<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<SUP<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public SUP<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<SUP<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public SUP<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public SUP<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<SUP<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public SUP<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public SUP<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<SUP<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public SUP<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public SUP<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<SUP<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public SUP<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public SUP<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<SUP<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<SUP<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public SUP<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public SUP<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<SUP<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public SUP<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<SUP<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<SUP<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<SUP<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public SUP<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public SUP<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<SUP<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public SUP<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public SUP<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<SUP<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<SUP<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public SUP<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public SUP<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<SUP<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<SUP<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public SUP<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<SUP<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public SUP<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<SUP<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public SUP<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public SUP<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<SUP<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public SUP<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<SUP<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public SUP<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<SUP<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public SUP<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<SUP<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public SUP<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<SUP<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<SUP<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<SUP<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<SUP<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<SUP<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<SUP<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public SUP<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<SUP<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<SUP<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public SUP<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class SUB<T extends __> extends EImp<T> implements HamletSpec.SUB {
    public SUB(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public SUB<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public SUB<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public SUB<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public SUB<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public SUB<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public SUB<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public SUB<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public SUB<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public SUB<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public SUB<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public SUB<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public SUB<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public SUB<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public SUB<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public SUB<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public SUB<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public SUB<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public SUB<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<SUB<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public SUB<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public SUB<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<SUB<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public SUB<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public SUB<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<SUB<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public SUB<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public SUB<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public SUB<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<SUB<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public SUB<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<SUB<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public SUB<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public SUB<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<SUB<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public SUB<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public SUB<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<SUB<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public SUB<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public SUB<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public SUB<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<SUB<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public SUB<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<SUB<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public SUB<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public SUB<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<SUB<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public SUB<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public SUB<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<SUB<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public SUB<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public SUB<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<SUB<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public SUB<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public SUB<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<SUB<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<SUB<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public SUB<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public SUB<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<SUB<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public SUB<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<SUB<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<SUB<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<SUB<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public SUB<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public SUB<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<SUB<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public SUB<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public SUB<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<SUB<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<SUB<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public SUB<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public SUB<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<SUB<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<SUB<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public SUB<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<SUB<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public SUB<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<SUB<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public SUB<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public SUB<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<SUB<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public SUB<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<SUB<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public SUB<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<SUB<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public SUB<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<SUB<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public SUB<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<SUB<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<SUB<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<SUB<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<SUB<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<SUB<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<SUB<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public SUB<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<SUB<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<SUB<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public SUB<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class ACRONYM<T extends __> extends EImp<T> implements HamletSpec.ACRONYM {
    public ACRONYM(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public ACRONYM<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public ACRONYM<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public ACRONYM<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public ACRONYM<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public ACRONYM<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public ACRONYM<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public ACRONYM<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public ACRONYM<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public ACRONYM<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public ACRONYM<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public ACRONYM<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public ACRONYM<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public ACRONYM<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public ACRONYM<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public ACRONYM<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public ACRONYM<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public ACRONYM<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public ACRONYM<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<ACRONYM<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public ACRONYM<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public ACRONYM<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<ACRONYM<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public ACRONYM<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public ACRONYM<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<ACRONYM<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public ACRONYM<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public ACRONYM<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public ACRONYM<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<ACRONYM<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public ACRONYM<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<ACRONYM<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public ACRONYM<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public ACRONYM<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<ACRONYM<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public ACRONYM<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public ACRONYM<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<ACRONYM<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public ACRONYM<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public ACRONYM<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public ACRONYM<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<ACRONYM<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public ACRONYM<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<ACRONYM<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public ACRONYM<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public ACRONYM<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<ACRONYM<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public ACRONYM<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public ACRONYM<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<ACRONYM<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public ACRONYM<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public ACRONYM<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<ACRONYM<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public ACRONYM<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public ACRONYM<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<ACRONYM<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<ACRONYM<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public ACRONYM<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public ACRONYM<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<ACRONYM<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public ACRONYM<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<ACRONYM<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<ACRONYM<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<ACRONYM<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public ACRONYM<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public ACRONYM<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<ACRONYM<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public ACRONYM<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public ACRONYM<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<ACRONYM<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<ACRONYM<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public ACRONYM<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public ACRONYM<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<ACRONYM<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<ACRONYM<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public ACRONYM<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<ACRONYM<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public ACRONYM<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<ACRONYM<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public ACRONYM<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public ACRONYM<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<ACRONYM<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public ACRONYM<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<ACRONYM<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public ACRONYM<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<ACRONYM<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public ACRONYM<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<ACRONYM<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public ACRONYM<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<ACRONYM<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<ACRONYM<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<ACRONYM<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<ACRONYM<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<ACRONYM<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<ACRONYM<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public ACRONYM<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<ACRONYM<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<ACRONYM<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public ACRONYM<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class ABBR<T extends __> extends EImp<T> implements HamletSpec.ABBR {
    public ABBR(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public ABBR<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public ABBR<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public ABBR<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public ABBR<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public ABBR<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public ABBR<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public ABBR<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public ABBR<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public ABBR<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public ABBR<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public ABBR<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public ABBR<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public ABBR<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public ABBR<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public ABBR<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public ABBR<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public ABBR<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public ABBR<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<ABBR<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public ABBR<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public ABBR<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<ABBR<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public ABBR<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public ABBR<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<ABBR<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public ABBR<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public ABBR<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public ABBR<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<ABBR<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public ABBR<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<ABBR<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public ABBR<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public ABBR<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<ABBR<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public ABBR<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public ABBR<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<ABBR<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public ABBR<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public ABBR<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public ABBR<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<ABBR<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public ABBR<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<ABBR<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public ABBR<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public ABBR<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<ABBR<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public ABBR<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public ABBR<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<ABBR<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public ABBR<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public ABBR<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<ABBR<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public ABBR<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public ABBR<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<ABBR<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<ABBR<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public ABBR<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public ABBR<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<ABBR<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public ABBR<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<ABBR<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<ABBR<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<ABBR<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public ABBR<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public ABBR<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<ABBR<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public ABBR<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public ABBR<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<ABBR<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<ABBR<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public ABBR<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public ABBR<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<ABBR<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<ABBR<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public ABBR<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<ABBR<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public ABBR<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<ABBR<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public ABBR<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public ABBR<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<ABBR<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public ABBR<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<ABBR<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public ABBR<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<ABBR<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public ABBR<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<ABBR<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public ABBR<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<ABBR<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<ABBR<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<ABBR<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<ABBR<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<ABBR<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<ABBR<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public ABBR<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<ABBR<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<ABBR<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public ABBR<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class CITE<T extends __> extends EImp<T> implements HamletSpec.CITE {
    public CITE(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public CITE<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public CITE<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public CITE<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public CITE<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public CITE<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public CITE<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public CITE<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public CITE<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public CITE<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public CITE<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public CITE<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public CITE<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public CITE<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public CITE<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public CITE<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public CITE<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public CITE<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public CITE<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<CITE<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public CITE<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public CITE<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<CITE<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public CITE<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public CITE<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<CITE<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public CITE<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public CITE<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public CITE<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<CITE<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public CITE<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<CITE<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public CITE<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public CITE<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<CITE<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public CITE<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public CITE<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<CITE<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public CITE<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public CITE<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public CITE<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<CITE<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public CITE<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<CITE<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public CITE<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public CITE<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<CITE<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public CITE<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public CITE<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<CITE<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public CITE<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public CITE<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<CITE<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public CITE<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public CITE<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<CITE<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<CITE<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public CITE<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public CITE<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<CITE<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public CITE<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<CITE<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<CITE<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<CITE<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public CITE<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public CITE<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<CITE<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public CITE<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public CITE<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<CITE<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<CITE<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public CITE<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public CITE<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<CITE<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<CITE<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public CITE<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<CITE<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public CITE<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<CITE<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public CITE<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public CITE<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<CITE<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public CITE<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<CITE<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public CITE<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<CITE<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public CITE<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<CITE<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public CITE<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<CITE<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<CITE<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<CITE<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<CITE<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<CITE<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<CITE<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public CITE<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<CITE<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<CITE<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public CITE<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class VAR<T extends __> extends EImp<T> implements HamletSpec.VAR {
    public VAR(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public VAR<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public VAR<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public VAR<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public VAR<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public VAR<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public VAR<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public VAR<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public VAR<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public VAR<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public VAR<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public VAR<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public VAR<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public VAR<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public VAR<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public VAR<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public VAR<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public VAR<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public VAR<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<VAR<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public VAR<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public VAR<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<VAR<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public VAR<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public VAR<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<VAR<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public VAR<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public VAR<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public VAR<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<VAR<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public VAR<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<VAR<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public VAR<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public VAR<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<VAR<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public VAR<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public VAR<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<VAR<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public VAR<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public VAR<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public VAR<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<VAR<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public VAR<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<VAR<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public VAR<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public VAR<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<VAR<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public VAR<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public VAR<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<VAR<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public VAR<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public VAR<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<VAR<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public VAR<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public VAR<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<VAR<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<VAR<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public VAR<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public VAR<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<VAR<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public VAR<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<VAR<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<VAR<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<VAR<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public VAR<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public VAR<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<VAR<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public VAR<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public VAR<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<VAR<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<VAR<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public VAR<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public VAR<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<VAR<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<VAR<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public VAR<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<VAR<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public VAR<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<VAR<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public VAR<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public VAR<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<VAR<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public VAR<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<VAR<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public VAR<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<VAR<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public VAR<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<VAR<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public VAR<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<VAR<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<VAR<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<VAR<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<VAR<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<VAR<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<VAR<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public VAR<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<VAR<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<VAR<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public VAR<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class KBD<T extends __> extends EImp<T> implements HamletSpec.KBD {
    public KBD(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public KBD<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public KBD<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public KBD<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public KBD<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public KBD<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public KBD<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public KBD<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public KBD<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public KBD<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public KBD<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public KBD<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public KBD<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public KBD<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public KBD<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public KBD<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public KBD<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public KBD<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public KBD<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<KBD<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public KBD<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public KBD<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<KBD<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public KBD<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public KBD<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<KBD<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public KBD<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public KBD<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public KBD<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<KBD<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public KBD<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<KBD<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public KBD<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public KBD<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<KBD<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public KBD<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public KBD<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<KBD<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public KBD<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public KBD<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public KBD<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<KBD<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public KBD<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<KBD<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public KBD<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public KBD<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<KBD<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public KBD<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public KBD<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<KBD<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public KBD<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public KBD<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<KBD<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public KBD<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public KBD<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<KBD<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<KBD<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public KBD<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public KBD<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<KBD<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public KBD<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<KBD<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<KBD<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<KBD<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public KBD<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public KBD<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<KBD<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public KBD<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public KBD<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<KBD<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<KBD<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public KBD<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public KBD<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<KBD<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<KBD<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public KBD<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<KBD<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public KBD<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<KBD<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public KBD<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public KBD<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<KBD<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public KBD<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<KBD<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public KBD<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<KBD<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public KBD<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<KBD<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public KBD<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<KBD<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<KBD<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<KBD<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<KBD<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<KBD<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<KBD<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public KBD<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<KBD<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<KBD<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public KBD<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class SAMP<T extends __> extends EImp<T> implements HamletSpec.SAMP {
    public SAMP(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public SAMP<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public SAMP<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public SAMP<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public SAMP<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public SAMP<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public SAMP<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public SAMP<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public SAMP<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public SAMP<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public SAMP<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public SAMP<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public SAMP<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public SAMP<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public SAMP<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public SAMP<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public SAMP<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public SAMP<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public SAMP<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<SAMP<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public SAMP<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public SAMP<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<SAMP<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public SAMP<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public SAMP<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<SAMP<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public SAMP<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public SAMP<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public SAMP<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<SAMP<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public SAMP<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<SAMP<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public SAMP<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public SAMP<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<SAMP<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public SAMP<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public SAMP<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<SAMP<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public SAMP<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public SAMP<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public SAMP<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<SAMP<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public SAMP<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<SAMP<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public SAMP<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public SAMP<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<SAMP<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public SAMP<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public SAMP<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<SAMP<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public SAMP<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public SAMP<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<SAMP<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public SAMP<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public SAMP<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<SAMP<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<SAMP<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public SAMP<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public SAMP<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<SAMP<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public SAMP<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<SAMP<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<SAMP<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<SAMP<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public SAMP<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public SAMP<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<SAMP<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public SAMP<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public SAMP<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<SAMP<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<SAMP<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public SAMP<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public SAMP<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<SAMP<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<SAMP<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public SAMP<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<SAMP<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public SAMP<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<SAMP<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public SAMP<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public SAMP<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<SAMP<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public SAMP<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<SAMP<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public SAMP<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<SAMP<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public SAMP<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<SAMP<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public SAMP<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<SAMP<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<SAMP<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<SAMP<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<SAMP<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<SAMP<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<SAMP<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public SAMP<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<SAMP<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<SAMP<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public SAMP<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class CODE<T extends __> extends EImp<T> implements HamletSpec.CODE {
    public CODE(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public CODE<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public CODE<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public CODE<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public CODE<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public CODE<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public CODE<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public CODE<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public CODE<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public CODE<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public CODE<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public CODE<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public CODE<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public CODE<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public CODE<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public CODE<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public CODE<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public CODE<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public CODE<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<CODE<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public CODE<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public CODE<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<CODE<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public CODE<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public CODE<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<CODE<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public CODE<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public CODE<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public CODE<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<CODE<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public CODE<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<CODE<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public CODE<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public CODE<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<CODE<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public CODE<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public CODE<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<CODE<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public CODE<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public CODE<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public CODE<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<CODE<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public CODE<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<CODE<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public CODE<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public CODE<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<CODE<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public CODE<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public CODE<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<CODE<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public CODE<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public CODE<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<CODE<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public CODE<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public CODE<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<CODE<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<CODE<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public CODE<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public CODE<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<CODE<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public CODE<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<CODE<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<CODE<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<CODE<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public CODE<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public CODE<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<CODE<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public CODE<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public CODE<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<CODE<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<CODE<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public CODE<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public CODE<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<CODE<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<CODE<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public CODE<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<CODE<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public CODE<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<CODE<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public CODE<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public CODE<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<CODE<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public CODE<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<CODE<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public CODE<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<CODE<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public CODE<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<CODE<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public CODE<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<CODE<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<CODE<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<CODE<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<CODE<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<CODE<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<CODE<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public CODE<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<CODE<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<CODE<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public CODE<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class DFN<T extends __> extends EImp<T> implements HamletSpec.DFN {
    public DFN(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public DFN<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public DFN<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public DFN<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public DFN<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public DFN<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public DFN<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public DFN<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public DFN<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public DFN<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public DFN<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public DFN<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public DFN<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public DFN<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public DFN<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public DFN<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public DFN<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public DFN<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public DFN<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<DFN<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public DFN<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public DFN<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<DFN<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public DFN<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public DFN<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<DFN<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public DFN<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public DFN<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public DFN<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<DFN<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public DFN<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<DFN<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public DFN<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public DFN<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<DFN<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public DFN<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public DFN<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<DFN<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public DFN<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public DFN<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public DFN<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<DFN<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public DFN<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<DFN<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public DFN<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public DFN<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<DFN<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public DFN<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public DFN<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<DFN<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public DFN<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public DFN<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<DFN<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public DFN<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public DFN<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<DFN<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<DFN<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public DFN<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public DFN<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<DFN<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public DFN<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<DFN<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<DFN<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<DFN<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public DFN<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public DFN<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<DFN<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public DFN<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public DFN<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<DFN<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<DFN<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public DFN<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public DFN<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<DFN<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<DFN<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public DFN<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<DFN<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public DFN<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<DFN<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public DFN<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public DFN<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<DFN<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public DFN<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<DFN<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public DFN<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<DFN<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public DFN<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<DFN<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public DFN<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<DFN<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<DFN<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<DFN<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<DFN<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<DFN<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<DFN<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public DFN<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<DFN<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<DFN<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public DFN<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class STRONG<T extends __> extends EImp<T> implements HamletSpec.STRONG {
    public STRONG(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public STRONG<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public STRONG<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public STRONG<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public STRONG<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public STRONG<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public STRONG<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public STRONG<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public STRONG<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public STRONG<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public STRONG<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public STRONG<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public STRONG<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public STRONG<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public STRONG<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public STRONG<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public STRONG<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public STRONG<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public STRONG<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<STRONG<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public STRONG<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public STRONG<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<STRONG<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public STRONG<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public STRONG<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<STRONG<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public STRONG<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public STRONG<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public STRONG<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<STRONG<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public STRONG<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<STRONG<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public STRONG<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public STRONG<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<STRONG<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public STRONG<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public STRONG<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<STRONG<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public STRONG<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public STRONG<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public STRONG<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<STRONG<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public STRONG<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<STRONG<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public STRONG<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public STRONG<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<STRONG<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public STRONG<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public STRONG<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<STRONG<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public STRONG<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public STRONG<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<STRONG<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public STRONG<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public STRONG<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<STRONG<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<STRONG<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public STRONG<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public STRONG<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<STRONG<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public STRONG<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<STRONG<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<STRONG<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<STRONG<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public STRONG<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public STRONG<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<STRONG<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public STRONG<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public STRONG<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<STRONG<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<STRONG<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public STRONG<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public STRONG<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<STRONG<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<STRONG<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public STRONG<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<STRONG<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public STRONG<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<STRONG<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public STRONG<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public STRONG<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<STRONG<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public STRONG<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<STRONG<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public STRONG<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<STRONG<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public STRONG<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<STRONG<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public STRONG<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<STRONG<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<STRONG<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<STRONG<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<STRONG<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<STRONG<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<STRONG<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public STRONG<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<STRONG<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<STRONG<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public STRONG<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class EM<T extends __> extends EImp<T> implements HamletSpec.EM {
    public EM(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public EM<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public EM<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public EM<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public EM<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public EM<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public EM<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public EM<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public EM<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public EM<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public EM<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public EM<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public EM<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public EM<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public EM<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public EM<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public EM<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public EM<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public EM<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<EM<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public EM<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public EM<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<EM<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public EM<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public EM<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<EM<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public EM<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public EM<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public EM<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<EM<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public EM<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<EM<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public EM<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public EM<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<EM<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public EM<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public EM<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<EM<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public EM<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public EM<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public EM<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<EM<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public EM<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<EM<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public EM<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public EM<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<EM<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public EM<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public EM<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<EM<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public EM<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public EM<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<EM<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public EM<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public EM<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<EM<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<EM<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public EM<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public EM<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<EM<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public EM<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<EM<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<EM<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<EM<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public EM<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public EM<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<EM<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public EM<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public EM<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<EM<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<EM<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public EM<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public EM<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<EM<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<EM<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public EM<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<EM<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public EM<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<EM<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public EM<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public EM<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<EM<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public EM<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<EM<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public EM<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<EM<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public EM<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<EM<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public EM<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<EM<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<EM<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<EM<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<EM<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<EM<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<EM<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public EM<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<EM<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<EM<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public EM<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class SMALL<T extends __> extends EImp<T> implements HamletSpec.SMALL {
    public SMALL(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public SMALL<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public SMALL<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public SMALL<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public SMALL<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public SMALL<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public SMALL<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public SMALL<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public SMALL<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public SMALL<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public SMALL<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public SMALL<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public SMALL<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public SMALL<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public SMALL<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public SMALL<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public SMALL<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public SMALL<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public SMALL<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<SMALL<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public SMALL<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public SMALL<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<SMALL<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public SMALL<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public SMALL<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<SMALL<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public SMALL<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public SMALL<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public SMALL<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<SMALL<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public SMALL<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<SMALL<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public SMALL<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public SMALL<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<SMALL<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public SMALL<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public SMALL<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<SMALL<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public SMALL<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public SMALL<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public SMALL<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<SMALL<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public SMALL<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<SMALL<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public SMALL<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public SMALL<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<SMALL<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public SMALL<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public SMALL<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<SMALL<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public SMALL<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public SMALL<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<SMALL<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public SMALL<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public SMALL<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<SMALL<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<SMALL<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public SMALL<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public SMALL<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<SMALL<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public SMALL<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<SMALL<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<SMALL<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<SMALL<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public SMALL<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public SMALL<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<SMALL<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public SMALL<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public SMALL<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<SMALL<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<SMALL<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public SMALL<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public SMALL<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<SMALL<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<SMALL<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public SMALL<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<SMALL<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public SMALL<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<SMALL<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public SMALL<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public SMALL<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<SMALL<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public SMALL<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<SMALL<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public SMALL<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<SMALL<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public SMALL<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<SMALL<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public SMALL<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<SMALL<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<SMALL<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<SMALL<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<SMALL<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<SMALL<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<SMALL<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public SMALL<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<SMALL<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<SMALL<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public SMALL<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class B<T extends __> extends EImp<T> implements HamletSpec.B {
    public B(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public B<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public B<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public B<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public B<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public B<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public B<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public B<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public B<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public B<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public B<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public B<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public B<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public B<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public B<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public B<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public B<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public B<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public B<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<B<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public B<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public B<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<B<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public B<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public B<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<B<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public B<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public B<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public B<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<B<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public B<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<B<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public B<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public B<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<B<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public B<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public B<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<B<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public B<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public B<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public B<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<B<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public B<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<B<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public B<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public B<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<B<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public B<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public B<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<B<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public B<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public B<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<B<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public B<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public B<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<B<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<B<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public B<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public B<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<B<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public B<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<B<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<B<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<B<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public B<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public B<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<B<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public B<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public B<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<B<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<B<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public B<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public B<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<B<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<B<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public B<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<B<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public B<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<B<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public B<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public B<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<B<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public B<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<B<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public B<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<B<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public B<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<B<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public B<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<B<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<B<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<B<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<B<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<B<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<B<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public B<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<B<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<B<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public B<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  public class I<T extends __> extends EImp<T> implements HamletSpec.I {
    public I(String name, T parent, EnumSet<EOpt> opts) {
      super(name, parent, opts);
    }

    @Override
    public I<T> $id(String value) {
      addAttr("id", value);
      return this;
    }

    @Override
    public I<T> $class(String value) {
      addAttr("class", value);
      return this;
    }

    @Override
    public I<T> $title(String value) {
      addAttr("title", value);
      return this;
    }

    @Override
    public I<T> $style(String value) {
      addAttr("style", value);
      return this;
    }

    @Override
    public I<T> $lang(String value) {
      addAttr("lang", value);
      return this;
    }

    @Override
    public I<T> $dir(Dir value) {
      addAttr("dir", value);
      return this;
    }

    @Override
    public I<T> $onclick(String value) {
      addAttr("onclick", value);
      return this;
    }

    @Override
    public I<T> $ondblclick(String value) {
      addAttr("ondblclick", value);
      return this;
    }

    @Override
    public I<T> $onmousedown(String value) {
      addAttr("onmousedown", value);
      return this;
    }

    @Override
    public I<T> $onmouseup(String value) {
      addAttr("onmouseup", value);
      return this;
    }

    @Override
    public I<T> $onmouseover(String value) {
      addAttr("onmouseover", value);
      return this;
    }

    @Override
    public I<T> $onmousemove(String value) {
      addAttr("onmousemove", value);
      return this;
    }

    @Override
    public I<T> $onmouseout(String value) {
      addAttr("onmouseout", value);
      return this;
    }

    @Override
    public I<T> $onkeypress(String value) {
      addAttr("onkeypress", value);
      return this;
    }

    @Override
    public I<T> $onkeydown(String value) {
      addAttr("onkeydown", value);
      return this;
    }

    @Override
    public I<T> $onkeyup(String value) {
      addAttr("onkeyup", value);
      return this;
    }

    @Override
    public I<T> __(Object... lines) {
      _p(true, lines);
      return this;
    }

    @Override
    public I<T> _r(Object... lines) {
      _p(false, lines);
      return this;
    }

    @Override
    public B<I<T>> b() {
      closeAttrs();
      return b_(this, true);
    }

    @Override
    public I<T> b(String cdata) {
      return b().__(cdata).__();
    }

    @Override
    public I<T> b(String selector, String cdata) {
      return setSelector(b(), selector).__(cdata).__();
    }

    @Override
    public I<I<T>> i() {
      closeAttrs();
      return i_(this, true);
    }

    @Override
    public I<T> i(String cdata) {
      return i().__(cdata).__();
    }

    @Override
    public I<T> i(String selector, String cdata) {
      return setSelector(i(), selector).__(cdata).__();
    }

    @Override
    public SMALL<I<T>> small() {
      closeAttrs();
      return small_(this, true);
    }

    @Override
    public I<T> small(String cdata) {
      return small().__(cdata).__();
    }

    @Override
    public I<T> small(String selector, String cdata) {
      return setSelector(small(), selector).__(cdata).__();
    }

    @Override
    public I<T> em(String cdata) {
      return em().__(cdata).__();
    }

    @Override
    public EM<I<T>> em() {
      closeAttrs();
      return em_(this, true);
    }

    @Override
    public I<T> em(String selector, String cdata) {
      return setSelector(em(), selector).__(cdata).__();
    }

    @Override
    public STRONG<I<T>> strong() {
      closeAttrs();
      return strong_(this, true);
    }

    @Override
    public I<T> strong(String cdata) {
      return strong().__(cdata).__();
    }

    @Override
    public I<T> strong(String selector, String cdata) {
      return setSelector(strong(), selector).__(cdata).__();
    }

    @Override
    public DFN<I<T>> dfn() {
      closeAttrs();
      return dfn_(this, true);
    }

    @Override
    public I<T> dfn(String cdata) {
      return dfn().__(cdata).__();
    }

    @Override
    public I<T> dfn(String selector, String cdata) {
      return setSelector(dfn(), selector).__(cdata).__();
    }

    @Override
    public CODE<I<T>> code() {
      closeAttrs();
      return code_(this, true);
    }

    @Override
    public I<T> code(String cdata) {
      return code().__(cdata).__();
    }

    @Override
    public I<T> code(String selector, String cdata) {
      return setSelector(code(), selector).__(cdata).__();
    }

    @Override
    public I<T> samp(String cdata) {
      return samp().__(cdata).__();
    }

    @Override
    public SAMP<I<T>> samp() {
      closeAttrs();
      return samp_(this, true);
    }

    @Override
    public I<T> samp(String selector, String cdata) {
      return setSelector(samp(), selector).__(cdata).__();
    }

    @Override
    public KBD<I<T>> kbd() {
      closeAttrs();
      return kbd_(this, true);
    }

    @Override
    public I<T> kbd(String cdata) {
      return kbd().__(cdata).__();
    }

    @Override
    public I<T> kbd(String selector, String cdata) {
      return setSelector(kbd(), selector).__(cdata).__();
    }

    @Override
    public VAR<I<T>> var() {
      closeAttrs();
      return var_(this, true);
    }

    @Override
    public I<T> var(String cdata) {
      return var().__(cdata).__();
    }

    @Override
    public I<T> var(String selector, String cdata) {
      return setSelector(var(), selector).__(cdata).__();
    }

    @Override
    public CITE<I<T>> cite() {
      closeAttrs();
      return cite_(this, true);
    }

    @Override
    public I<T> cite(String cdata) {
      return cite().__(cdata).__();
    }

    @Override
    public I<T> cite(String selector, String cdata) {
      return setSelector(cite(), selector).__(cdata).__();
    }

    @Override
    public ABBR<I<T>> abbr() {
      closeAttrs();
      return abbr_(this, true);
    }

    @Override
    public I<T> abbr(String cdata) {
      return abbr().__(cdata).__();
    }

    @Override
    public I<T> abbr(String selector, String cdata) {
      return setSelector(abbr(), selector).__(cdata).__();
    }

    @Override
    public A<I<T>> a() {
      closeAttrs();
      return a_(this, true);
    }

    @Override
    public A<I<T>> a(String selector) {
      return setSelector(a(), selector);
    }

    @Override
    public I<T> a(String href, String anchorText) {
      return a().$href(href).__(anchorText).__();
    }

    @Override
    public I<T> a(String selector, String href, String anchorText) {
      return setSelector(a(), selector).$href(href).__(anchorText).__();
    }

    @Override
    public IMG<I<T>> img() {
      closeAttrs();
      return img_(this, true);
    }

    @Override
    public I<T> img(String src) {
      return img().$src(src).__();
    }

    @Override
    public OBJECT<I<T>> object() {
      closeAttrs();
      return object_(this, true);
    }

    @Override
    public OBJECT<I<T>> object(String selector) {
      return setSelector(object(), selector);
    }

    @Override
    public SUB<I<T>> sub() {
      closeAttrs();
      return sub_(this, true);
    }

    @Override
    public I<T> sub(String cdata) {
      return sub().__(cdata).__();
    }

    @Override
    public I<T> sub(String selector, String cdata) {
      return setSelector(sub(), selector).__(cdata).__();
    }

    @Override
    public SUP<I<T>> sup() {
      closeAttrs();
      return sup_(this, true);
    }

    @Override
    public I<T> sup(String cdata) {
      return sup().__(cdata).__();
    }

    @Override
    public I<T> sup(String selector, String cdata) {
      return setSelector(sup(), selector).__(cdata).__();
    }

    @Override
    public MAP<I<T>> map() {
      closeAttrs();
      return map_(this, true);
    }

    @Override
    public MAP<I<T>> map(String selector) {
      return setSelector(map(), selector);
    }

    @Override
    public I<T> q(String cdata) {
      return q().__(cdata).__();
    }

    @Override
    public I<T> q(String selector, String cdata) {
      return setSelector(q(), selector).__(cdata).__();
    }

    @Override
    public Q<I<T>> q() {
      closeAttrs();
      return q_(this, true);
    }

    @Override
    public BR<I<T>> br() {
      closeAttrs();
      return br_(this, true);
    }

    @Override
    public I<T> br(String selector) {
      return setSelector(br(), selector).__();
    }

    @Override
    public BDO<I<T>> bdo() {
      closeAttrs();
      return bdo_(this, true);
    }

    @Override
    public I<T> bdo(Dir dir, String cdata) {
      return bdo().$dir(dir).__(cdata).__();
    }

    @Override
    public SPAN<I<T>> span() {
      closeAttrs();
      return span_(this, true);
    }

    @Override
    public I<T> span(String cdata) {
      return span().__(cdata).__();
    }

    @Override
    public I<T> span(String selector, String cdata) {
      return setSelector(span(), selector).__(cdata).__();
    }

    @Override
    public SCRIPT<I<T>> script() {
      closeAttrs();
      return script_(this, true);
    }

    @Override
    public I<T> script(String src) {
      return setScriptSrc(script(), src).__();
    }

    @Override
    public INS<I<T>> ins() {
      closeAttrs();
      return ins_(this, true);
    }

    @Override
    public I<T> ins(String cdata) {
      return ins().__(cdata).__();
    }

    @Override
    public DEL<I<T>> del() {
      closeAttrs();
      return del_(this, true);
    }

    @Override
    public I<T> del(String cdata) {
      return del().__(cdata).__();
    }

    @Override
    public LABEL<I<T>> label() {
      closeAttrs();
      return label_(this, true);
    }

    @Override
    public I<T> label(String forId, String cdata) {
      return label().$for(forId).__(cdata).__();
    }

    @Override
    public INPUT<I<T>> input(String selector) {
      return setSelector(input(), selector);
    }

    @Override
    public INPUT<I<T>> input() {
      closeAttrs();
      return input_(this, true);
    }

    @Override
    public SELECT<I<T>> select() {
      closeAttrs();
      return select_(this, true);
    }

    @Override
    public SELECT<I<T>> select(String selector) {
      return setSelector(select(), selector);
    }

    @Override
    public TEXTAREA<I<T>> textarea(String selector) {
      return setSelector(textarea(), selector);
    }

    @Override
    public TEXTAREA<I<T>> textarea() {
      closeAttrs();
      return textarea_(this, true);
    }

    @Override
    public I<T> textarea(String selector, String cdata) {
      return setSelector(textarea(), selector).__(cdata).__();
    }

    @Override
    public BUTTON<I<T>> button() {
      closeAttrs();
      return button_(this, true);
    }

    @Override
    public BUTTON<I<T>> button(String selector) {
      return setSelector(button(), selector);
    }

    @Override
    public I<T> button(String selector, String cdata) {
      return setSelector(button(), selector).__(cdata).__();
    }
  }

  private <T extends __> INPUT<T> input_(T e, boolean inline) {
    return new INPUT<T>("input", e, opt(false, inline, false)); }

  private <T extends __> SELECT<T> select_(T e, boolean inline) {
    return new SELECT<T>("select", e, opt(true, inline, false)); }

  private <T extends __> TEXTAREA<T> textarea_(T e, boolean inline) {
    return new TEXTAREA<T>("textarea", e, opt(true, inline, false)); }

  private <T extends __> BUTTON<T> button_(T e, boolean inline) {
    return new BUTTON<T>("button", e, opt(true, inline, false)); }

  private <T extends __> LABEL<T> label_(T e, boolean inline) {
    return new LABEL<T>("label", e, opt(true, inline, false)); }

  private <T extends __> MAP<T> map_(T e, boolean inline) {
    return new MAP<T>("map", e, opt(true, inline, false)); }

  private <T extends __> Q<T> q_(T e, boolean inline) {
    return new Q<T>("q", e, opt(true, inline, false)); }

  private <T extends __> BR<T> br_(T e, boolean inline) {
    return new BR<T>("br", e, opt(false, inline, false)); }

  private <T extends __> BDO<T> bdo_(T e, boolean inline) {
    return new BDO<T>("bdo", e, opt(true, inline, false)); }

  private <T extends __> SPAN<T> span_(T e, boolean inline) {
    return new SPAN<T>("span", e, opt(true, inline, false)); }

  private <T extends __> INS<T> ins_(T e, boolean inline) {
    return new INS<T>("ins", e, opt(true, inline, false)); }

  private <T extends __> DEL<T> del_(T e, boolean inline) {
    return new DEL<T>("del", e, opt(true, inline, false)); }

  private <T extends __> A<T> a_(T e, boolean inline) {
    return new A<T>("a", e, opt(true, inline, false)); }

  private <T extends __> SUB<T> sub_(T e, boolean inline) {
    return new SUB<T>("sub", e, opt(true, inline, false)); }

  private <T extends __> SUP<T> sup_(T e, boolean inline) {
    return new SUP<T>("sup", e, opt(true, inline, false)); }

  private <T extends __> IMG<T> img_(T e, boolean inline) {
    return new IMG<T>("img", e, opt(false, inline, false)); }

  private <T extends __> EM<T> em_(T e, boolean inline) {
    return new EM<T>("em", e, opt(true, inline, false)); }

  private <T extends __> STRONG<T> strong_(T e, boolean inline) {
    return new STRONG<T>("strong", e, opt(true, inline, false)); }

  private <T extends __> DFN<T> dfn_(T e, boolean inline) {
    return new DFN<T>("dfn", e, opt(true, inline, false)); }

  private <T extends __> CODE<T> code_(T e, boolean inline) {
    return new CODE<T>("code", e, opt(true, inline, false)); }

  private <T extends __> SAMP<T> samp_(T e, boolean inline) {
    return new SAMP<T>("samp", e, opt(true, inline, false)); }

  private <T extends __> KBD<T> kbd_(T e, boolean inline) {
    return new KBD<T>("kbd", e, opt(true, inline, false)); }

  private <T extends __> VAR<T> var_(T e, boolean inline) {
    return new VAR<T>("var", e, opt(true, inline, false)); }

  private <T extends __> CITE<T> cite_(T e, boolean inline) {
    return new CITE<T>("cite", e, opt(true, inline, false)); }

  private <T extends __> ABBR<T> abbr_(T e, boolean inline) {
    return new ABBR<T>("abbr", e, opt(true, inline, false)); }

  private <T extends __> B<T> b_(T e, boolean inline) {
    return new B<T>("b", e, opt(true, inline, false)); }

  private <T extends __> I<T> i_(T e, boolean inline) {
    return new I<T>("i", e, opt(true, inline, false)); }

  private <T extends __> SMALL<T> small_(T e, boolean inline) {
    return new SMALL<T>("small", e, opt(true, inline, false)); }

  private <T extends __> PRE<T> pre_(T e, boolean inline) {
    return new PRE<T>("pre", e, opt(true, inline, true)); }

  private <T extends __> UL<T> ul_(T e, boolean inline) {
    return new UL<T>("ul", e, opt(true, inline, false)); }

  private <T extends __> OL<T> ol_(T e, boolean inline) {
    return new OL<T>("ol", e, opt(true, inline, false)); }

  private <T extends __> H1<T> h1_(T e, boolean inline) {
    return new H1<T>("h1", e, opt(true, inline, false)); }

  private <T extends __> H2<T> h2_(T e, boolean inline) {
    return new H2<T>("h2", e, opt(true, inline, false)); }

  private <T extends __> H3<T> h3_(T e, boolean inline) {
    return new H3<T>("h3", e, opt(true, inline, false)); }

  private <T extends __> H4<T> h4_(T e, boolean inline) {
    return new H4<T>("h4", e, opt(true, inline, false)); }

  private <T extends __> H5<T> h5_(T e, boolean inline) {
    return new H5<T>("h5", e, opt(true, inline, false)); }

  private <T extends __> H6<T> h6_(T e, boolean inline) {
    return new H6<T>("h6", e, opt(true, inline, false)); }

  private <T extends __> STYLE<T> style_(T e, boolean inline) {
    return new STYLE<T>("style", e, opt(true, inline, false)); }

  private <T extends __> LINK<T> link_(T e, boolean inline) {
    return new LINK<T>("link", e, opt(false, inline, false)); }

  private <T extends __> META<T> meta_(T e, boolean inline) {
    return new META<T>("meta", e, opt(false, inline, false)); }

  private <T extends __> OBJECT<T> object_(T e, boolean inline) {
    return new OBJECT<T>("object", e, opt(true, inline, false)); }

  private <T extends __> SCRIPT<T> script_(T e, boolean inline) {
    return new SCRIPT<T>("script", e, opt(true, inline, false)); }

  @Override
  public HEAD<Hamlet> head() {
  return head_(this, false);
  }

  @Override
  public BODY<Hamlet> body() {
  return body_(this, false);
  }

  @Override
  public BODY<Hamlet> body(String selector) {
    return setSelector(body(), selector);
  }

  @Override
  public BASE<Hamlet> base() {
  return base_(this, false);
  }

  @Override
  public Hamlet base(String href) {
    return base().$href(href).__();
  }

  @Override
  public TITLE<Hamlet> title() {
  return title_(this, false);
  }

  @Override
  public Hamlet title(String cdata) {
    return title().__(cdata).__();
  }

  @Override
  public STYLE<Hamlet> style() {
  return style_(this, false);
  }

  @Override
  public Hamlet style(Object... lines) {
    return style().$type("text/css").__(lines).__();
  }

  @Override
  public LINK<Hamlet> link() {
  return link_(this, false);
  }

  @Override
  public Hamlet link(String href) {
    return setLinkHref(link(), href).__();
  }

  @Override
  public META<Hamlet> meta() {
  return meta_(this, false);
  }

  @Override
  public Hamlet meta(String name, String content) {
    return meta().$name(name).$content(content).__();
  }

  @Override
  public Hamlet meta_http(String header, String content) {
    return meta().$http_equiv(header).$content(content).__();
  }

  @Override
  public SCRIPT<Hamlet> script() {
  return script_(this, false);
  }

  @Override
  public Hamlet script(String src) {
    return setScriptSrc(script(), src).__();
  }

  @Override
  public OBJECT<Hamlet> object() {
  return object_(this, true);
  }

  @Override
  public OBJECT<Hamlet> object(String selector) {
    return setSelector(object(), selector);
  }

  @Override
  public TABLE<Hamlet> table() {
  return table_(this, false);
  }

  @Override
  public TABLE<Hamlet> table(String selector) {
    return setSelector(table(), selector);
  }

  @Override
  public Hamlet address(String cdata) {
    return address().__(cdata).__();
  }

  @Override
  public ADDRESS<Hamlet> address() {
  return address_(this, false);
  }

  @Override
  public P<Hamlet> p(String selector) {
    return setSelector(p(), selector);
  }

  @Override
  public P<Hamlet> p() {
  return p_(this, false);
  }

  @Override
  public Hamlet __(Class<? extends SubView> cls) {
    subView(cls);
    return this;
  }

  @Override
  public HR<Hamlet> hr() {
  return hr_(this, false);
  }

  @Override
  public Hamlet hr(String selector) {
    return setSelector(hr(), selector).__();
  }

  @Override
  public DL<Hamlet> dl(String selector) {
    return setSelector(dl(), selector);
  }

  @Override
  public DL<Hamlet> dl() {
  return dl_(this, false);
  }

  @Override
  public DIV<Hamlet> div(String selector) {
    return setSelector(div(), selector);
  }

  @Override
  public DIV<Hamlet> div() {
  return div_(this, false);
  }

  @Override
  public BLOCKQUOTE<Hamlet> blockquote() {
  return blockquote_(this, false);
  }

  @Override
  public BLOCKQUOTE<Hamlet> bq() {
  return blockquote_(this, false);
  }

  @Override
  public Hamlet h1(String cdata) {
    return h1().__(cdata).__();
  }

  @Override
  public H1<Hamlet> h1() {
  return h1_(this, false);
  }

  @Override
  public Hamlet h1(String selector, String cdata) {
    return setSelector(h1(), selector).__(cdata).__();
  }

  @Override
  public Hamlet h2(String cdata) {
    return h2().__(cdata).__();
  }

  @Override
  public H2<Hamlet> h2() {
  return h2_(this, false);
  }

  @Override
  public Hamlet h2(String selector, String cdata) {
    return setSelector(h2(), selector).__(cdata).__();
  }

  @Override
  public H3<Hamlet> h3() {
  return h3_(this, false);
  }

  @Override
  public Hamlet h3(String cdata) {
    return h3().__(cdata).__();
  }

  @Override
  public Hamlet h3(String selector, String cdata) {
    return setSelector(h3(), selector).__(cdata).__();
  }

  @Override
  public H4<Hamlet> h4() {
  return h4_(this, false);
  }

  @Override
  public Hamlet h4(String cdata) {
    return h4().__(cdata).__();
  }

  @Override
  public Hamlet h4(String selector, String cdata) {
    return setSelector(h4(), selector).__(cdata).__();
  }

  @Override
  public H5<Hamlet> h5() {
  return h5_(this, false);
  }

  @Override
  public Hamlet h5(String cdata) {
    return h5().__(cdata).__();
  }

  @Override
  public Hamlet h5(String selector, String cdata) {
    return setSelector(h5(), selector).__(cdata).__();
  }

  @Override
  public H6<Hamlet> h6() {
  return h6_(this, false);
  }

  @Override
  public Hamlet h6(String cdata) {
    return h6().__(cdata).__();
  }

  @Override
  public Hamlet h6(String selector, String cdata) {
    return setSelector(h6(), selector).__(cdata).__();
  }

  @Override
  public UL<Hamlet> ul() {
  return ul_(this, false);
  }

  @Override
  public UL<Hamlet> ul(String selector) {
    return setSelector(ul(), selector);
  }

  @Override
  public OL<Hamlet> ol() {
  return ol_(this, false);
  }

  @Override
  public OL<Hamlet> ol(String selector) {
    return setSelector(ol(), selector);
  }

  @Override
  public PRE<Hamlet> pre() {
  return pre_(this, false);
  }

  @Override
  public PRE<Hamlet> pre(String selector) {
    return setSelector(pre(), selector);
  }

  @Override
  public FORM<Hamlet> form() {
  return form_(this, false);
  }

  @Override
  public FORM<Hamlet> form(String selector) {
    return setSelector(form(), selector);
  }

  @Override
  public FIELDSET<Hamlet> fieldset() {
  return fieldset_(this, false);
  }

  @Override
  public FIELDSET<Hamlet> fieldset(String selector) {
    return setSelector(fieldset(), selector);
  }

  @Override
  public INS<Hamlet> ins() {
  return ins_(this, false);
  }

  @Override
  public Hamlet ins(String cdata) {
    return ins().__(cdata).__();
  }

  @Override
  public DEL<Hamlet> del() {
  return del_(this, false);
  }

  @Override
  public Hamlet del(String cdata) {
    return del().__(cdata).__();
  }
}
