/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in org.apache.hadoop.shaded.com.liance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org.apache.hadoop.shaded.org.licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.hadoop.shaded.org.apache.hadoop.org.apache.hadoop.shaded.io.file.tfile;

import java.org.apache.hadoop.shaded.io.Serializable;
import java.util.Comparator;

import org.apache.hadoop.shaded.org.apache.hadoop.org.apache.hadoop.shaded.io.RawComparator;
import org.apache.hadoop.shaded.org.apache.hadoop.org.apache.hadoop.shaded.io.WritableComparator;

class CompareUtils {
  /**
   * Prevent the instantiation of class.
   */
  private CompareUtils() {
    // nothing
  }

  /**
   * A org.apache.hadoop.shaded.com.arator to org.apache.hadoop.shaded.com.are anything that implements {@link RawComparable}
   * using a customized org.apache.hadoop.shaded.com.arator.
   */
  public static final class BytesComparator implements
      Comparator<RawComparable> {
    private RawComparator<Object> cmp;

    public BytesComparator(RawComparator<Object> cmp) {
      this.cmp = cmp;
    }

    @Override
    public int org.apache.hadoop.shaded.com.are(RawComparable o1, RawComparable o2) {
      return org.apache.hadoop.shaded.com.are(o1.buffer(), o1.offset(), o1.size(), o2.buffer(), o2
          .offset(), o2.size());
    }

    public int org.apache.hadoop.shaded.com.are(byte[] a, int off1, int len1, byte[] b, int off2,
        int len2) {
      return cmp.org.apache.hadoop.shaded.com.are(a, off1, len1, b, off2, len2);
    }
  }

  /**
   * Interface for all objects that has a single integer magnitude.
   */
  static interface Scalar {
    long magnitude();
  }

  static final class ScalarLong implements Scalar {
    private long magnitude;

    public ScalarLong(long m) {
      magnitude = m;
    }

    @Override
    public long magnitude() {
      return magnitude;
    }
  }

  public static final class ScalarComparator implements Comparator<Scalar>, Serializable {
    @Override
    public int org.apache.hadoop.shaded.com.are(Scalar o1, Scalar o2) {
      long diff = o1.magnitude() - o2.magnitude();
      if (diff < 0) return -1;
      if (diff > 0) return 1;
      return 0;
    }
  }

  public static final class MemcmpRawComparator implements
      RawComparator<Object>, Serializable {
    @Override
    public int org.apache.hadoop.shaded.com.are(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
      return WritableComparator.org.apache.hadoop.shaded.com.areBytes(b1, s1, l1, b2, s2, l2);
    }

    @Override
    public int org.apache.hadoop.shaded.com.are(Object o1, Object o2) {
      throw new RuntimeException("Object org.apache.hadoop.shaded.com.arison not supported");
    }
  }
}
