/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timelineservice;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class HierarchicalTimelineEntity
extends TimelineEntity {
    public static final String PARENT_INFO_KEY = "SYSTEM_INFO_PARENT_ENTITY";
    public static final String CHILDREN_INFO_KEY = "SYSTEM_INFO_CHILDREN_ENTITY";

    HierarchicalTimelineEntity(TimelineEntity entity) {
        super(entity);
    }

    HierarchicalTimelineEntity(String type) {
        super(type);
    }

    public TimelineEntity.Identifier getParent() {
        Object obj = this.getInfo().get(PARENT_INFO_KEY);
        if (obj != null) {
            if (obj instanceof TimelineEntity.Identifier) {
                return (TimelineEntity.Identifier)obj;
            }
            throw new YarnRuntimeException("Parent info is invalid identifier object");
        }
        return null;
    }

    public void setParent(TimelineEntity.Identifier parent) {
        this.validateParent(parent.getType());
        this.addInfo(PARENT_INFO_KEY, parent);
    }

    public void setParent(String type, String id) {
        this.setParent(new TimelineEntity.Identifier(type, id));
    }

    public Set<TimelineEntity.Identifier> getChildren() {
        Object identifiers = this.getInfo().get(CHILDREN_INFO_KEY);
        if (identifiers == null) {
            return new HashSet<TimelineEntity.Identifier>();
        }
        TimelineEntityType thisType = TimelineEntityType.valueOf(this.getType());
        if (identifiers instanceof Set) {
            for (Object identifier : (Set)identifiers) {
                if (!(identifier instanceof TimelineEntity.Identifier)) {
                    throw new YarnRuntimeException("Children info contains invalid identifier object");
                }
                this.validateChild((TimelineEntity.Identifier)identifier, thisType);
            }
        } else {
            throw new YarnRuntimeException("Children info is invalid identifier set");
        }
        Set children = (Set)identifiers;
        return children;
    }

    public void setChildren(Set<TimelineEntity.Identifier> children) {
        this.addInfo(CHILDREN_INFO_KEY, children);
    }

    public void addChildren(Set<TimelineEntity.Identifier> children) {
        TimelineEntityType thisType = TimelineEntityType.valueOf(this.getType());
        for (TimelineEntity.Identifier child : children) {
            this.validateChild(child, thisType);
        }
        Set<TimelineEntity.Identifier> existingChildren = this.getChildren();
        existingChildren.addAll(children);
        this.setChildren(existingChildren);
    }

    public void addChild(TimelineEntity.Identifier child) {
        this.addChildren(Collections.singleton(child));
    }

    public void addChild(String type, String id) {
        this.addChild(new TimelineEntity.Identifier(type, id));
    }

    private void validateParent(String type) {
        TimelineEntityType parentType = TimelineEntityType.valueOf(type);
        TimelineEntityType thisType = TimelineEntityType.valueOf(this.getType());
        if (!thisType.isParent(parentType)) {
            throw new IllegalArgumentException(type + " is not the acceptable parent of " + this.getType());
        }
    }

    private void validateChild(TimelineEntity.Identifier child, TimelineEntityType thisType) {
        TimelineEntityType childType = TimelineEntityType.valueOf(child.getType());
        if (!thisType.isChild(childType)) {
            throw new IllegalArgumentException(child.getType() + " is not the acceptable child of " + this.getType());
        }
    }
}

