/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.com.google.protobuf.MessageOrBuilder;
import org.apache.hadoop.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.protocolrecords.GetAttributesToNodesRequest;
import org.apache.hadoop.yarn.api.records.NodeAttributeKey;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeAttributeKeyPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GetAttributesToNodesRequestPBImpl
extends GetAttributesToNodesRequest {
    private Set<NodeAttributeKey> nodeAttributes = null;
    private YarnServiceProtos.GetAttributesToNodesRequestProto proto = YarnServiceProtos.GetAttributesToNodesRequestProto.getDefaultInstance();
    private YarnServiceProtos.GetAttributesToNodesRequestProto.Builder builder = null;
    private boolean viaProto = false;

    public GetAttributesToNodesRequestPBImpl() {
        this.builder = YarnServiceProtos.GetAttributesToNodesRequestProto.newBuilder();
    }

    public GetAttributesToNodesRequestPBImpl(YarnServiceProtos.GetAttributesToNodesRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.GetAttributesToNodesRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.nodeAttributes != null) {
            this.addLocalAttributesToProto();
        }
    }

    private void addLocalAttributesToProto() {
        this.maybeInitBuilder();
        this.builder.clearNodeAttributes();
        if (this.nodeAttributes == null) {
            return;
        }
        Iterable iterable = () -> new Iterator<YarnProtos.NodeAttributeKeyProto>(){
            private Iterator iter;
            {
                this.iter = GetAttributesToNodesRequestPBImpl.this.nodeAttributes.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public YarnProtos.NodeAttributeKeyProto next() {
                return GetAttributesToNodesRequestPBImpl.this.convertToProtoFormat((NodeAttributeKey)this.iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        this.builder.addAllNodeAttributes(iterable);
    }

    private NodeAttributeKeyPBImpl convertFromProtoFormat(YarnProtos.NodeAttributeKeyProto p) {
        return new NodeAttributeKeyPBImpl(p);
    }

    private YarnProtos.NodeAttributeKeyProto convertToProtoFormat(NodeAttributeKey t) {
        return ((NodeAttributeKeyPBImpl)t).getProto();
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetAttributesToNodesRequestProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void initNodeAttributes() {
        if (this.nodeAttributes != null) {
            return;
        }
        YarnServiceProtos.GetAttributesToNodesRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.NodeAttributeKeyProto> nodeAttributesList = p.getNodeAttributesList();
        this.nodeAttributes = new HashSet<NodeAttributeKey>();
        nodeAttributesList.forEach(v -> this.nodeAttributes.add(this.convertFromProtoFormat((YarnProtos.NodeAttributeKeyProto)v)));
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((GetAttributesToNodesRequestPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    @Override
    public void setNodeAttributes(Set<NodeAttributeKey> attributes) {
        this.maybeInitBuilder();
        if (this.nodeAttributes == null) {
            this.builder.clearNodeAttributes();
        }
        this.nodeAttributes = attributes;
    }

    @Override
    public Set<NodeAttributeKey> getNodeAttributes() {
        this.initNodeAttributes();
        return this.nodeAttributes;
    }
}

